var Gars = CItem.extend({
    initialize : function(data) { 
        this.api_tag="";
        this.api_elementsTag="gars";
        this.template = "gar-elements-template";
        this.class_element="Gar";
        this.libelleCreate = "une configuration GAR"
        this.getElements(); 
        this.hash="gars"

        this.options = {
            order: [[ 3, "asc" ]]
        }

        this.isWritable = ko.observable(appViewModel.user.isAdmin());

        //this.canCreateElements(appViewModel.user.isAdmin())
        this.libelleListe("Configurations du GAR"); 
        
    }
});

var Gar = CItem.extend({
    initialize : function() { 
        var self=this;
        this.api_tag="gar";

        // Etat par défaut 
        if (!self.data.check) {
            var defaut = {status:"inconnu",message:"---",date:(new Date()).getTime()/1000};
            self.data.check = {
                depot: defaut,
                archive: defaut,
                certificat: defaut,
                samlRes: defaut,
                samlAff: defaut
            }
        }

        self.canRefresh(false);

        self.actif      = ko.observable(self.data.actif=="1");
        self.depot      = ko.observable(self.data.check.depot);
        self.certificat = ko.observable(self.data.check.certificat);
        self.archive    = ko.observable(self.data.check.archive);
        self.samlRes    = ko.observable(self.data.check.samlRes);
        self.samlAff    = ko.observable(self.data.check.samlAff);
        self.log        = ko.observable(self.data.check.log);

        self.certificatIsOk   = ko.computed(function() {return self.data.check.certificat.status=="success";})
        self.depotStatus      = ko.computed(function() {return self.data.check.depot.status;})
        self.archiveStatus    = ko.computed(function() {return self.data.check.archive.status;})
        self.certificatStatus = ko.computed(function() {return self.data.check.certificat.status;})
        self.samlResStatus    = ko.computed(function() {return self.data.check.samlRes.status;})
        self.samlAffStatus    = ko.computed(function() {return self.data.check.samlAff.status;})

        self.STATUS = [self.depot,self.certificat,self.archive,self.samlRes,self.samlAff];

        self.globalStatus = ko.computed(function() {
            let theStatus = null;
            for(var i=0;i<self.STATUS.length;i++) {
                let status = self.STATUS[i];

                if (self.STATUS[i]().status == "error" ) {
                    theStatus = self.STATUS[i];
                }

                if (self.STATUS[i]().status == "waiting" && (theStatus==null || theStatus().status != "error" ) ) {
                    theStatus = self.STATUS[i];
                }

                if (self.STATUS[i]().status == "inconnu" ) {
                    theStatus = self.STATUS[i];
                }


            }

            if (!theStatus) {
                theStatus = self.STATUS[0]
            }

            return theStatus();
        })
    },

    refresh: function(data) {
        this.depot(data.check.depot);
        this.archive(data.check.archive);
        this.certificat(data.check.certificat);
        this.samlRes(data.check.samlRes);
        this.samlAff(data.check.samlAff);

    }




    

})

Gar.prototype.isEditable = function()                  { return this.data.editable;}

Gar.prototype.showLog = function(data,event) {
    if (event) event.stopImmediatePropagation();
    data.url ="api/gar/"+this.id+"/log"
    
    // Pour cache le btn d'enregistrement
    this.onEdit = function() {
        setTimeout(function(){
            $("#myModalLabel").html("");
            $("#modal button.save").hide()
        },100);
    }
    
    this.edit(data);
    
}

Gar.prototype.show = function(data,event) {
    this.accrochage();
}



Gar.prototype.accrochage = function(data,event) {
    
    if (event) event.stopImmediatePropagation();

    this.api_tag    ="accrochage";
    this.template   = "gar-accrochage-template";
    this.api_elementsTag="accrochage";
    this.libelleListe("Checklist d'accrochage"); 

    appViewModel.show(this);
    var self = this

    appViewModel.setHash("gars/"+self.id+"/accrochage");

    setTimeout(function() {

        $("#refreshGar").click(function(){
            var $elt = $(this)
            $elt.html("<i class='fa fa-spin fa-spinner'></i> Actualisation en cours").attr("disabled",true)
            $.ajax({url: "api/gar/accrochage/"+self.id ,
                    headers: {
                        'Cache-Control': 'no-cache', 
                        'Pragma': 'no-cache', 
                        'Expires': '0'
                    },
                    dataTye:"json"})
            .done(function (data) 
            {   
                $elt.html("<i class='fa fa-refresh'></i> Vérifier de nouveau").attr("disabled",false)
                self.refresh(data);
            });
        })
        
        $(".btn-file").click(function(event){
            event.stopImmediatePropagation();
            $($(this).attr("target")).trigger('click');
        })

        $('#pem').on("change", function(event){ 
            if (!$("#pem").val()) {
                return;
            }
            var fileUp = $("#pem").serialize();
            var data = new FormData();
            $.each($('#pem')[0].files, function(i, file) {
                data.append('file-'+i, file);
            });
            $.ajax({ 
                type: "POST",
                contentType: false,
                processData: false,
                cache: false,
                url: self.urlOfElements()+"/pem", 
                data: data, 
                success: function( data ) { 
                    if (data && data.success) {
                        $("#pemOK").removeClass("hidden");
                        $(".btn-file").remove();
                        self.certificatIsOk(true)
                    } else {
                        self.certificatIsOk(false)
                    }
                } 
            }); 
        });

    },1000);
    

    this.api_tag    = "gar";
    
    
    
    
};

