// ===== Catalogues =========================================
var Libraries = CItem.extend({
    initialize : function(data) {
        this.api_tag="";
        this.api_elementsTag="libraries";
        this.class_element="Library";
        this.menu="library";
        this.getElements();
        this.hash="libraries"

        this.libelleCreate("une bibliothèque");
        this.libelleListe("Liste des bibliothèques");

        this.isWritable = function() { return appViewModel.user.canCreateLibrary();}

    }
});

Libraries.prototype.countChecked = function()  {
    this.hasChecked(false)
}

Libraries.prototype.filterRessources=function(search) {
    var elts=this.getElements();
    for (var l in elts) {
        var lib=elts[l];
        lib.filterRessources(search);
    }
}

Libraries.prototype.check=function(value) {}
Libraries.prototype.toogle=function(value) {}

var Library = CItem.extend({
    initialize : function(data) {
        var self=this;
        this.api_tag="library";
        this.api_elementsTag="instances";
        this.class_element="Instance";

        this.template="library-elements-template"

        this.libelleListe("Ressources présentes dans ");

        this.isChecked=ko.observable(true);


        if (this.data.instances) {
            self.elements=[];
            for (var i=0;i<this.data.instances.length;i++)
            {
                var element=this.createElement(this.data.instances[i]);
                self.elements[element.id]=element;
                self.children.push(element);
            }
            self.children.sort(function(left, right)
                        { return left.categoryName.localeCompare(right.categoryName) }
            )
        }

        this.check=function(val) {
            this.isChecked(val);
            this.isFiltered(val);
            this.filterAll(val);
        }

        this.toogle=function(data,event) {

            event.stopPropagation();
            this.isChecked(! this.isChecked());
            this.isFiltered(! this.isFiltered());
            this.filterAll(this.isFiltered());
            appViewModel.showRessources("ressources3-template");

        }

        this.xToogle=function(data,event) {

            if (event) event.stopPropagation();

            var elts=this.parent.elements;
            for ( e in elts ) {
                elts[e].isFiltered(false);
                elts[e].isChecked(false);
                elts[e].filterAll(false);
            }
            this.isFiltered(true);
            this.isChecked(true);
            this.filterAll(true);
            appViewModel.showRessources("ressources3-template");

        }

        self.currentCatalogue=ko.observable(null)
    },

});

Library.prototype.sortItem = function()                     { return this.data.order}
Library.prototype.isContextual = function()                 { return this.data.contextual  }

Library.prototype.filterRessources=function(search) {
    var self=this;
    var elts=self.getElements();

    $(".row.content").removeHighlight();

    for (var e in elts) {
        var instance=elts[e];
        if ((search=="" ||
            instance.data.name.toLowerCase().indexOf(search)!=-1 ||
            instance.data.description.toLowerCase().indexOf(search)!=-1) &&
            ((!instance.category) || (instance.category && instance.category.isChecked()))
           ) instance.isFiltered(true);
        else instance.isFiltered(false);
    }

    $(".row.content").highlight(search);
}

Library.prototype.showElementsForCurrentCatalogue = function() {

    var id=$('#modal select option:selected').val();
    var catalogue=appViewModel.getCatalogue(id);
    if (catalogue==undefined) return;

    this.currentCatalogue(catalogue)
    catalogue.allSelected(false);
    ko.cleanNode($("#modal .elements")[0]);
    $("#modal .elements").html('<div class="table-responsive" data-bind="template: { name: \'select-ressources-template\' }"></div>')
    ko.applyBindings(catalogue,$("#modal .elements")[0]);

    initDatatable();
}

// Suppression des instances
Library.prototype.actionChecked = function(elt,event) {
    if (event) event.stopPropagation();
    var self=this;
    var data={instances: this.getSelectedElementsId()}
    if (data.instances.length==0) {return;}
    $.ajax({url: "api/"+self.api_tag+"/"+self.id+"/delete",method:"delete",data: data}).success(function() {
        // On va enlever les instances de la lib globale
        for (var i=0;i<data.instances.length;i++)
        {
            appViewModel.AllInstances.removeElement(data.instances[i])
            self.removeElement(data.instances[i])
        }
        self.show();
        appViewModel.buildHome();
    });
}

Library.prototype.gerer = function() {
    appViewModel.gerer();
    this.show();
}

// Ajout d'un élément
Library.prototype.createNewRessource = function(data,event) {
    appViewModel.createRessource(this,event);
}

Library.prototype.selectRessources = function() {

        var self=this;
        var $target=$("#modal")

        $("#myModalLabel").html("Ajouter une ressource dans <b>"+self.data.name+"<b>");
        $.ajax({url: "api/"+self.api_tag+"/"+self.id+"/select"}).done(function (content) {
            $target.find(".modal-body").html(content);
            $select=$target.find("select");
            appViewModel.whCatalogues.fillSelect($select)
            $select.change(function() {
                self.showElementsForCurrentCatalogue()
            });

            self.showElementsForCurrentCatalogue()
            $("#modal button.save").show();
            EConnect.showModal();

            // Sauvegarde des modifications
            $target.find(".modal-footer button.save").click(function(e) {

                if (!EConnect.validate()) return;

                // Récupération des éventuels paramètres
                parameters={}
                $target.find(".modal-body input.param[required]").each(function() {
                    var libelle=$(this).attr("name");
                    var ressid=$(this).attr("ressourceid");
                    if (parameters[ressid]==undefined) {
                        parameters[ressid]=[]
                    }
                    parameters[ressid].push({libelle:libelle,valeur:$(this).val()})
                });

                var data={ressources: appViewModel.whCatalogues.getSelectedRessources(),parameters:parameters}
                if (data.ressources.length==0) {alert("Vous devez selectionner au moins une ressource"); return;}

                $.ajax({url: "api/"+self.api_tag+"/"+self.id+"/add",method:"post",data: data}).done(function() {
                    appViewModel.whCatalogues.unSelectRessources()
                    self.clear();
                   // self.getElements();
                    EConnect.closeModal();
                    if (appViewModel.currentElement()==self) self.show();
                });
            })


        })

}


// ===================================================================================
// Gestion des Instances, une Instance est une mise à disposition d'une ressource
// dans une library
//====================================================================================
var Instance = CItem.extend({
    initialize : function(data) {

        var self=this;
        this.api_tag="instance";
        this.api_elementsTag="";

        this.libraryId=ko.observableArray([this.data.library])

        // Gestion du catalogue associé, si il y en a un
        this.catalogue=appViewModel.getCatalogue(this.data.catalogue)
        if (this.catalogue)
            this.catalogueName=this.catalogue.data.name
        else
            this.catalogueName="n/a"

        if (appViewModel.whLibraries) {
            this.library=appViewModel.getLibrarie(this.data.library);
            if (this.library) {
                this.library.addElement(this);
                this.notpersonnal=(this.library.data.personnal!=true)?1:0
            }
        }

        if (this.data.garOrigin) {
            this.notpersonnal=true;
        }



        this.category=appViewModel.getCategory(this.data.category)
        if (this.category) {
             this.category.addElement(this);
             this.categoryName=this.category.data.name
        } else{
             this.categoryName="";
             this.category=appViewModel.DEFAULT_CATEGORY;
        }

        appViewModel.ressIns[this.data.ress]=true;
        appViewModel.AllInstances.addElement(this);

        self.ressource = null;

        self.score=ko.observable(self.data.points/self.data.count);

        self.count=ko.observable(self.data.count);
        self.access=ko.observable(self.data.access);

        self.bgImageUrlStyle = ko.computed(function() {
            return "url(" + self.data.logo + ")";
        });

        self.isFiltered=ko.observable(true);

    },

});

Instance.prototype.sortItem = function()                    { return this.categoryName}
Instance.prototype.getLibrary=function() {
    if (!this.library) {
        this.library=appViewModel.getLibrarie(this.data.library)
    }
    return this.library;
}

Instance.prototype.isLibraryVisible=function() {
    if (!this.library) {
        this.library=appViewModel.getLibrarie(this.data.library)
    }
    return this.library.isChecked();
}

Instance.prototype.showLib=function(data,event) {
    if (event) event.stopPropagation();
    if (!this.library) {
        this.library=appViewModel.getLibrarie(this.data.library)
    }
    this.library.xToogle();

}

Instance.prototype.hasParams = function() {
    return this.data.params!=undefined && this.data.params.length!=0;
}

Instance.prototype.params = function() {
    if (!this.hasParams()) return []
    return this.data.params;
}

Instance.prototype.onModalData=function(data) {
    data.params=[]
    $("#modal input.param").each(function() {
       var $param=$(this);
       data.params.push({libelle:$param.attr("label"),valeur:$param.val()});
    })
}


Instance.prototype.edit = function() {
    var self=this;

    // Ressource sans catalogue
    if (!this.catalogue) {
        // Edition de la ressource associée
        $.ajax({url: "api/ressource/"+this.data.ress+"/json"}).done(function(data) {
            ressource=new Ressource(data);
            var libId=self.libraryId()[0];
            ressource.setLibrary(appViewModel.getLibrarie(libId));
            ressource.edit();
        })
    } else
    {
        this._edit()
    }



}

// Lors du clique sur un lien
Instance.prototype.display = function(data,event) {

    var self=this;

    if (event.ctrlKey)
    {
       self.edit();
       return;
    }

    var urlStats =  "api/"+self.api_tag+"/"+self.id+"/access"
    if (self.data.garInstance) {
        urlStats =  "api/gar/instance/"+self.data.garInstance+"/access"
    }

    // Comptablise l'accès à la ressource
    $.ajax({url: urlStats,method:"post"}).done(function(data) {
        self.access(data.access);
        self.data.access=data.acces;
        appViewModel.buildHome();
    })

    //ref: # 14303 , ajout d'une sonde piwik sur l'accès aux ressources
   setTimeout(function() {EnvolePiwikLancerLesSondes("econnect/"+self.name());},1000);

    if (self.data.ressource_urlaccess && !self.ressourceLoaded)
    {
        $('body').block({
            message: '<i class="fa fa-spinner fa-spin"></i> Chargement de la ressource...',
            css:{border: "1px solid white","border-radius":"5px","padding":"10px","top":"20px"},
            timeout: 10*1000, // Max 10s
            onUnblock:function(element, options) {self.ressourceLoaded=true;self.window.location.href=self.data.urlaccess;   }
        });
        self.window=window.open("waiting.html");
        var $iframe=$("<iframe>").load(function() {
            $('body').unblock();
            self.ressourceLoaded=true;
            self.window.location.href=self.data.urlaccess;
        }).css("display","none").attr("src",self.data.ressource_urlaccess);
        $("body").append($iframe)
    } else
    {
        console.log(self.data.urlaccess)
        window.open(self.data.urlaccess);
    }



}

Instance.prototype.showComments= function(data,event) {
    this.evaluate(data,event,true);
}

// Ouvre une boite de dialogue proposant a l'utilisateur d'évaluer
// la ressource
Instance.prototype.evaluate = function(data,event,bComments) {
  event.stopPropagation();
  var self=this;
  self.data.vote=self.data.vote || 0;
  $.ajax({url: "api/"+self.api_tag+"/"+self.id+"/eval"}).done(function (content) {

        // Suppression du binding en cours
        ko.cleanNode($("#modal")[0]);

        // Affiche la boite de dialogue d'instanciation
        $("#modal").find(".modal-body").html(content);
        $("#myModalLabel").html("Evaluation");

        // Aply viewModel bindings
        ko.applyBindings(self,$("#modal")[0]);

        // Met a jour un rating par défaut
        $("#modal .star").raty({ score: self.data.vote,width:200})

        // Affiche la boite de dialogue
        EConnect.showModal();

        // Onglet
        if (!bComments)
            $('#modal .nav-tabs a:first').tab('show')
        else
            $('#modal .nav-tabs a:last').tab('show')

        // Chargement des commentaires
        $.ajax({url: "api/"+self.api_tag+"/"+self.id+"/evals"}).done(function (response) {
            var el={evals:response}
            $("#comments").html('<div class="" data-bind="template: { name: \'evals-elements-template\' }"></div>');
            ko.cleanNode($("#comments")[0]);
            ko.applyBindings(el,$("#comments")[0]);

            $('#comments .toolinfo').each(function() {
                $(this).raty({ readOnly: true,score: $(this).attr("score"),
                                width:130,size:12});
            })
        });

        // Sauvegarde des modifications
        $("#modal .modal-footer button.save").click(function(e) {
            data=self.modalData($("#modal"));
            data.vote=$("#modal input[name='score']").val();
            $.ajax({url: "api/"+self.api_tag+"/"+self.id+"/eval",method:"post",data: data})
             .done(function(response)
            {
                // En réponse nous avons l'instance
                self.count(response.count);
                $("#instance-rating-"+self.id).raty('score',response.points/response.count);
                EConnect.closeModal();
            });
    })

})
}

Instance.prototype.hasRessource = function() {
  return this.data.ressource_name != "" && this.data.ressource_name != undefined
}


Instance.prototype.showCatalogue = function() {
  if (this.catalogue)  this.catalogue.show();
}

Instance.prototype.remove = function() {

}

Instance.prototype.setCatalogue = function(library_id) {
    this.libraryId.removeAll()
    this.libraryId.push(library_id);
}
// ========================================================================

// ============ Evaluation
var Evaluation = CItem.extend( {initialize : function(data){
    var self=this;
    this.api_tag="eval";
    this.api_elementsTag="";
}
})
