ko.observableArray.fn.filterByProperty = function(propName, matchValue) {
    return ko.computed(function() {
        var allItems = this(), matchingItems = [];
        for (var i = 0; i < allItems.length; i++) {
            var current = allItems[i];
            if (ko.unwrap(current[propName]()) === matchValue)
                matchingItems.push(current);
        }
        return matchingItems;
    }, this);
}

function AppViewModel() {
    var self = this;
    self.GROUPEBY_NONE=0;
    self.GROUPEBY_LIBRARIES=1;
    self.GROUPEBY_CATEGORIES=2;
    self.GROUPEBY_LIBELLE=["Ne pas grouper","Grouper par bibliothèques","Grouper par thématiques"];
    
    self.ORDERBY_NAME=0;
    self.ORDERBY_RATE=1;
    self.ORDERBY_VIEW=2;
    self.ORDERBY_DATE=3;
    self.ORDERBY_LIBELLE=["Trié par nom","Trié par votes","Trié par visites","Trié par date"];
    
    self.libelleListe=ko.observable("");
    
    
    self.hasParent=function() {return false;}
    self.canCreateElements=ko.observable(false)
    self.canInstantiate=ko.observable(false)
    self.isInstantiable=ko.observable(false)
    self.isWritable=ko.observable(false)
    self.countChecked=ko.observable(0);
    self.hasChecked=ko.observable(false);
    self.addElement=function()      {self.currentElement().add()}
    self.createRessource=function(data,event) {
        
        if (event) event.stopPropagation();
        
        ressource=new Ressource();
        ressource.data.writable=true;
        ressource.data.deletable=true;
        ressource.data.editable=true;
        ressource.setCatalogue(-1);
        
        if (data.api_tag!="library") {
            data=appViewModel.currentElement();
            if (data.api_tag!="library") {
                alert("Oups: l'objet selectionné n'est pas une bibliothèque");   
            } else
            {
                
            }
        }
        ressource.setLibrary(data);
        ressource.edit();
    }
    self.refreshList=function()     {self.currentElement().refresh()}
    self.currentElement=function()  {self.currentElement()}
    self.siblings=function()        {return []}
    self.arrAutorisations=[];
    
    self.tableHeaders=function()    {self.currentElement().headers}
    
    self.sortByName=function(a,b){return a.name().localeCompare(b.name())};
    self.sortByRate=function(a,b){return b.data.rate-a.data.rate};
    self.sortByView=function(a,b){return b.data.access-a.data.access};
    self.sortByDate=function(a,b){return b.data.timestamp-a.data.timestamp};
    
    self.computeLatest=function(target,fn,attr) {
        self.AllInstances.children.sort(fn)
        var timestamp  = (new Date()).getTime()/1000 - 3600*24;
        var timestamp2 = (new Date()).getTime()/1000 - 3600*48;
        target.removeAll();
        var arr=appViewModel.AllInstances.children();
        for (var i=0;i<arr.length;i++ ){
            // Nouveautés 
            if (attr=="notpersonnal") {
                if (arr[i].getLibrary().data.personnal) continue    
                // Nouceauté GAR = GarRessource moins de 24 heures
                //console.log(timestamp,arr[i]["data"]["timestamp"])
                if (arr[i]["data"]["garOrigin"] && arr[i]["data"]["timestamp"]  < timestamp) continue
                // Autres ressources, nouveau si < a 48h
                if (! arr[i]["data"]["garOrigin"] && arr[i]["data"]["timestamp"]  < timestamp2) continue

            }

            // Pas de notion de dernier abonnement (nouveauté) sur le GAR"
            /*if (arr[i]["data"]["garOrigin"]) {
                continue;
            }*/
            
            // Filtre sur l'attribut passé en paramètre (si == 0, on ne l'affiche pas)
            if (attr && arr[i]["data"][attr]==0) continue;
            // Si fait parti des dernières ressources évaluées , donc déja affichée
            if (arr[i].lastEvals) continue;
            
            target.push(arr[i]);
            
            // Max 4 instances
            if (target().length>4) break;
        }   
    }
    
    // Tous les entrepot de données (warehouse)
    self.init=function() {
        
        self.DEFAULT_CATEGORY=new Category({id:-1,color:"rgba(0,0,0,0)",name:"Aucune"});
        
        self.ressIns={} // Liste des Ressources ayant une instance
        self.AllInstances=new AllInstances();
        
        self.whCategories=new Categories();  
        self.whCatalogues=new Catalogues();
        self.whLibraries=new Libraries();
        // Le chargelment des contexts ( Etablissements ) est fait à la demande
        // lors du clique sur Etablissements , sinon même en différant avec un timeout 
        // l'affichage se fige ( sans doute restriction de lib ko qui est utilisée) 
          
        // Raccourci pour accéder directement
        self.libraries=self.whLibraries.children;
        self.categories=self.whCategories.children;
        self.catalogues=self.whCatalogues.children;
        
        self.cataloguesWritable = self.catalogues.filterByProperty("isWritable", true);
        self.librariesWritable = self.libraries.filterByProperty("isWritable", true);
        self.librariesContextual = self.libraries.filterByProperty("isContextual", true);
        self.librariesVisible= self.libraries.filterByProperty("isChecked", true);
        self.categoriesVisible= self.categories.filterByProperty("isChecked", true);
        self.whMain=ko.observableArray([]);
        
        // Récupération des informations sur l'utilisateurs
        $.ajax({url: "api/me",dataTye:"json",async:false}).done(function (data) 
                                                                {
                                                                    self.user=new User(data);
                                                                })
        
        if (self.user.canAdmin()) {
            self.whProfils=new Profils();
            self.profils=self.whProfils.children;
        } else{
            self.whProfils=null;
            self.profils=ko.observableArray([]);
        }

        self.whGars=new Gars();
        
        self.lastEvals=ko.observableArray([])
        self.lastInstances=ko.observableArray([])
        self.bestRating=ko.observableArray([])
        self.topView=ko.observableArray([])
        
        self.hasLastInstances=ko.computed(function() {return self.lastInstances().length!=0});

        
        // == Gestion du mode de groupe =================================
        self.groupeBy=ko.observable(self.GROUPEBY_LIBRARIES);
        self.groupeByLibelle=ko.computed(function() {return self.GROUPEBY_LIBELLE[self.groupeBy()];})
        
        self.isGroupedByLibraries=ko.computed(function()    {return self.groupeBy()==self.GROUPEBY_LIBRARIES})
        self.isGroupedByCategories=ko.computed(function()   {return self.groupeBy()==self.GROUPEBY_CATEGORIES})
        self.isGroupedByNone=ko.computed(function()         {return self.groupeBy()==self.GROUPEBY_NONE})
        
        self.byLibraries=function()     {
            self.groupeBy(self.GROUPEBY_LIBRARIES);
            self.whMain.removeAll();
            var arr=self.whLibraries.children();
            for(var i=0;i<arr.length;i++)
            {
                self.whMain.push(arr[i]);
            }
            self.showRessources("ressources3-template")
            $("#menuLibraries").addClass("active");$("#menuLibraries ul").addClass("in").css("height","auto");
            //$("#menuCategories").removeClass("active");$("#menuCategories ul").removeClass("in");
        }
        self.byCategories=function()    {
            self.groupeBy(self.GROUPEBY_CATEGORIES);
            self.whMain.removeAll();
            var arr=self.whCategories.children();
            for(var i=0;i<arr.length;i++)
            {
                self.whMain.push(arr[i]);
            }
            self.showRessources("ressources3-template")
            $("#menuCategories").addClass("active");$("#menuCategories ul").addClass("in").css("height","auto");
            //$("#menuLibraries").removeClass("active");$("#menuLibraries ul").removeClass("in");
        }
        self.byNone=function()    {
            self.groupeBy(self.GROUPEBY_NONE); 
            self.whMain.removeAll();
            var category=new Category({name:"",id:0})
            var arr=self.whLibraries.children();
            for(var i=0;i<arr.length;i++) {
                for (var e in arr[i].elements) {
                    category.addElement(arr[i].elements[e]);
                }
            }
            self.whMain.push(category);
            self.showRessources("ressources3-template")
            
        }
        self.closeGestion=function() {
            self.showRessources("ressources3-template")
        }
        // ==============================================================
        
        // == Gestion du mode de classement =================================
        self.orderBy=ko.observable(self.ORDERBY_NAME);
        self.orderByLibelle=ko.computed(function() {return self.ORDERBY_LIBELLE[self.orderBy()];})
        
        self.isOrderedByName=ko.computed(function()    {return self.orderBy()==self.ORDERBY_NAME})
        self.isOrderedByRate=ko.computed(function()    {return self.orderBy()==self.ORDERBY_RATE})
        self.isOrderedByView=ko.computed(function()    {return self.orderBy()==self.ORDERBY_VIEW})
        self.isOrderedByDate=ko.computed(function()    {return self.orderBy()==self.ORDERBY_DATE})
        
        self.byName=function()    {
            self.orderBy(self.ORDERBY_NAME);
            self.lastCompareFunc=self.sortByName
            self.showRessources("ressources3-template");
        }
        
        self.byRate=function()    {
            self.orderBy(self.ORDERBY_RATE); 
            self.lastCompareFunc=self.sortByRate
            self.showRessources("ressources3-template");
        }
        
        self.byView=function()    {
            self.orderBy(self.ORDERBY_VIEW);   
            self.lastCompareFunc=self.sortByView
            self.showRessources("ressources3-template");
        }
        
        self.byDate=function()    {
            self.orderBy(self.ORDERBY_DATE);   
            self.lastCompareFunc=self.sortByDate
            self.showRessources("ressources3-template");
        }
        
        self.orderCompute =function()    {
            var arr=self.whMain();
            for (var i=0;i<arr.length;i++)
            {
                arr[i].children.sort(self.lastCompareFunc)
            }
        }
        
        // ================================================================
        
        self.buildHome();
        
        if (self.user.isAdmin())
        {
            self.whParameters=new Parameters();  
        }

        self.hasGarAdmin = ko.computed(function(){return self.user.data.garActif && self.user.data.garAdmin })
        self.hasGar      = ko.computed(function(){return self.user.data.garActif })
        self.username=ko.computed(function(){ return self.user.data.fullname;})
        self.availableContext=ko.computed(function()   {return self.user.data.context})
        self.hasMultipleContext=ko.computed(function() {return self.user.data.context.length>1})
        
        self.ressources=ko.computed(function() {
            return self.whCatalogues.getRessources();    
        })
        
        
        
        self.mode=ko.observable("icon")
        
        ko.applyBindings(appViewModel); 
            
    }
    
    self.buildHome = function() {
        
        $.ajax({url: "api/home",dataTye:"json",async:false}).done(function (response) 
        {
            self.lastEvals.removeAll();
            for(var i=0;i<response["evals"].length;i++) {
                var instance=new Instance(response["evals"][i]);
                self.lastEvals.push(instance);
                instance.lastEvals=true;
            }

            self.garCode     = ko.observable(response["gar"]["code"])
            self.garAcademie = ko.observable(response["gar"]["academie"])
            // ref #29553 //Ajout lien vers "mentions informatives RGPD du GAR"
            self.RGPDLink    = ko.observable(response["rgpd_link"])
            self.RGPDText    = ko.observable(response["rgpd_text"])


        })   
        
        self.computeLatest(self.lastInstances,self.sortByDate,"notpersonnal")
        for(var i=0;i<self.lastInstances().length;i++) {self.lastInstances()[i].lastInstance=true;}

        //console.log(response)
        
        self.computeLatest(self.bestRating,self.sortByRate,"rate")
        self.computeLatest(self.topView,self.sortByView,"access")        
    }
    
    self.actionChecked = function() {
        
    }
    
    self.getCatalogue=function(id) {
        return self.whCatalogues.getElement(id);   
    }
    
    self.getLibrarie=function(id) {
        return self.whLibraries.getElement(id);   
    }
    
    self.getCategory=function(id) {
        var c=self.whCategories.getElement(id); 
        if (!c) return self.DEFAULT_CATEGORY;
        return c 
    }
    
    self.showAllLibraries=function() {
       self.whLibraries.checkAll(); 
       self.showRessources("ressources3-template");
    }
    
    self.showAllCategories=function() {
       self.whCategories.checkAll(); 
       self.showRessources("ressources3-template");
    }
    
    self.addParam=function(data,event) {
        if (event) event.stopPropagation();
        
        if (!self.user.isAdmin()) return;
        param=new Param();
        param.data.editable=true;
        param.data.name=data;
        param.edit(null,null,function() {
          self.whParameters.clear();
          self.whParameters.getElements();
          self.currentElement().refresh();  
        });
    }
    
    
    
    self.iconMode=function()  {self.mode("icon")}
    self.largeMode=function() {self.mode("large")}
    self.listMode=function()  {self.mode("list")}
    
    
    
   
    self.home=function()            {self.showRessources("home-template")}
    
    self.template="home-template";
    
    self.showCatalogues=function()  { self.show(self.whCatalogues); }
    self.showContexts=function()  { 

        if (!self.whContexts) {
            self.isWaitingForLoading(true)
            setTimeout(function(){
                self.whContexts=new Contexts();
                self.contexts=self.whContexts.children;
                self.isWaitingForLoading(false)
                self.show(self.whContexts); 
            },500); 
        } else {
            self.show(self.whContexts); 
        }
        
        
    
    }
    self.showProfils=function()     { self.show(self.whProfils);}
    self.showLibraries=function()   { self.show(self.whLibraries);}
    self.showUser=function()        { self.user.edit();}
    self.showParameters=function()  { self.show(self.whParameters);}
    self.showGars=function()        { 
        self.show(self.whGars);
        setTimeout(function() {
            $("#btnConfigureGar").click(function(event){
                event.stopPropagation();
                var code        = $("#garParamCode").val();
                var academie    = $("#garParamAcademie").val();

                var re = new RegExp("^[A-Z,0-9]{2}$");
                if (!code || ! re.test(code) ) {
                    $.growlUI('Code projet ENT, incorrect')
                    return;
                }

                if (!academie) {
                    $.growlUI('Veuillez indiquer votre académie')
                    return;
                }

                $.ajax({ 
                    type: "POST",
                    cache: false,
                    url: "api/gar/params", 
                    data: "code="+code+"&academie="+academie
                }).success(function( data ) { 
                    if (data && data.success) {
                        self.garCode(code);
                    } else {
                        $.growlUI(data.message)
                    } 
                }); 

            })
        },1000);

    }
    
    
    self.isNotAccueil=ko.observable(false)
    self.isAccueil=ko.computed(function() {return !self.isNotAccueil();})
    self.isWaitingForLoading=ko.observable(false)
 
    
    self.getProfilName=function(profileid) {
        if (profileid=="0") return "Tout le monde";
        var e=self.whProfils.getElement(profileid);
        if (e) return e.name();
        return "--";
    }
    
    self.profilExists=function(profileid) {
        if (profileid=="0") return true;
        var e=self.whProfils.getElement(profileid);
        if (e) return true
        return false
    }
    
    self.back=function() {
        if ( self.currentElement().hasParent() )
        {
            self.show(self.currentElement().parent);
        }
    }
    
    
    self.instantiate=function() {
        if (self.currentElement().api_tag!="ressource" )  return false;         
    }
    
    // Ajustement du DOM, avec du jquery
    self.adjustDOM=function() {
        
        // Rating
        $('.star').each(function() {
              $(this).raty({ readOnly: true,score: $(this).attr("score"),
                            width:54,size:12,
                             click: function(score, evt) {
                                    evt.stopPropagation();
                                    var id=$(this).attr('id');
                                }});  
            })
        
        // Time ago
        $(".timeago").timeago();

        // Suppression des éléments ne contenant pas de ressource
        $(".ressources").each(function() {
            if ($(this).find("li").length==0) {
               $(this).parent().hide(); 
            } else{
               $(this).parent().show();   
            }
        }) 
        
        // On cache la zone de proposition des catalogues si aucune ressource 
        if ($(".ressource").length==0) {
            $("#catalogues-intro").hide()   
            $("#catalogues-ressources").hide()   
        } else{
            $("#catalogues-intro").show()  
            $("#catalogues-ressources").show()   
        }
        
        $('.infos span.toolinfo').tooltip();
        $('ul.light li tr .icone').tooltip();
        $('html, body').animate({scrollTop:0}, 'fast');
        
      $('.carousel').carousel({
          interval: 10000
        })

        $('.carousel .item').each(function(){
          var next = $(this).next();
          if (!next.length) {
            next = $(this).siblings(':first');
          }
          next.children(':first-child').clone().appendTo($(this));

          if (next.next().length>0) {
            next.next().children(':first-child').clone().appendTo($(this));
          }
          else {
            $(this).siblings(':first').children(':first-child').clone().appendTo($(this));
          }
        });
    }
    
    self.showRessources=function(tmpl) {
        
        self.orderCompute();
        
        if (self.template==tmpl && !self.modeGestion()) {
            self.adjustDOM();
            return;
        }
        
        if (tmpl) {
            self.template=tmpl
            self.isNotAccueil(self.template!="home-template");
        }
        
        $("body").removeClass("gerer");  
        self.libelleListe("");
        self.modeGestion(false)
        self.isInstantiable(false)
        $("li.gestion ul").removeClass("in");
        
        if ($("#og-grid").length==0 || tmpl)
        {
            if ($("#kkk").length!=0) ko.cleanNode($("#kkk")[0]);
            self.currentElement(self);
            $(".row.content").empty();
            $(".row.content").attr("id","kkk");
            $(".row.content").html('<div class="" data-bind="template: { name: \''+self.template+'\' }"></div>')
            ko.applyBindings(self,$("#kkk")[0]);
        }
        
        self.adjustDOM();
        
        
        
       
        
       /* $(".categorie").each(function() {
            if ($(this).find("li").length==0) {
                $(this).hide()
                 $(this).prev().hide()
            }
            else {
                $(this).show()
                $(this).prev().show()
            }
        })*/
        
        
    }
    
    self.is=function(val) {
     return self.currentElement().menu==val
    }
    
    

    self.modeGestion=ko.observable(false);
    self.gerer=function() {
        $("body").addClass("gerer"); 
        this.modeGestion(true)
    }
    
   /* self.showRessources=function() {
        this.show(appViewModel)
    }*/
    
    self.selectRessources=function() {
        this.currentElement().selectRessources(function() {this.currentElement().show()}); 
    }

    self.setHash=function(hash) {
        if (!hash) return;

        if(history.pushState) {
            history.pushState(null, null, '#'+hash);
        }
        else {
            location.hash = '#'+hash;
        }
    }
    
    self.show=function(element) {

        this.setHash(element.hash);

        if (element!=self) {
          $("body").addClass("gerer");   
          self.modeGestion(true)
        } else
        {
            $("body").removeClass("gerer");  
            self.modeGestion(false)
        }
        self.currentElement(element);
        self.canCreateElements(element.isWritable())
        self.canInstantiate(appViewModel.user.canInstantiate())
        self.isInstantiable(element.api_tag=="library" && element.isWritable())
        element._show();
        $('html, body').animate({scrollTop:0}, 'fast');
    }
    
    self.currentElement=ko.observable(this);
    self.currentTitle=ko.computed(function(){return self.currentElement().api_elementsTag})
}

var appViewModel=new AppViewModel();

$.blockUI.defaults.growlCSS= { 
        width:    '350px', 
        top:      '10px', 
        left:     '', 
        right:    '10px', 
        border:   'none', 
        padding:  '5px', 
        opacity:   1.0, 
        cursor:    null, 
        color:    '#fff', 
        backgroundColor: '#000',
        zIndex:100000,
        '-webkit-border-radius': '10px', 
        '-moz-border-radius':    '10px' 
}

window.alert=function(message) {
 // Bote de dialog de confirmation
                 bootbox.dialog({
                  message: message,
                  title: "Message",
                  buttons: {
                    main: {
                      label: "Fermer",className: "btn-default",
                      callback: function() {}
                    }
                  }
                });
    
}

$(function() {
    
    var options={
        
         beforeSend: function(xhr, ajaxOptions) {
             
             // Toutes les requetes "DELETE" demandent confirmation
             if ((ajaxOptions.method) && (ajaxOptions.method.toLowerCase()=="delete") && !ajaxOptions.confirm) {
                 
                 // Bote de dialog de confirmation
                 bootbox.dialog({
                  message: "Etes-vous certains de vouloir supprimer ?<br> cette opération sera irréversible.",
                  title: "Suppression",
                  buttons: {
                    success: {
                      label: "Oui, je confirme",className: "btn-danger",
                      callback: function() {
                        ajaxOptions.confirm=true;
                        $.ajax(ajaxOptions).done(function() {appViewModel.refreshList();});
                      }
                    },
                    main: {
                      label: "Non",className: "btn-default",
                      callback: function() {}
                    }
                  }
                });
                 
                // return false, annule l'évent
                // lors de la confirmation on rejoue la requete en positionnant confirm=true
                return false;
             }
             
             if (ajaxOptions.button) {
                ajaxOptions.button.button("loading");        
             }
                 
         },
         complete: function(xhr, status) {
           
         },
         error:function (xhr, ajaxOptions, thrownError) {
                
                if ($("#modal").is(":visible") ) {
                    $(".alert-danger div").html(xhr.responseText);
                    $(".alert-danger").fadeIn();
                    $("#modal").find(".modal-footer button.save").button("reset");
                } else{
                    $.growlUI('Une erreur est survenue', xhr.responseText); 
                }
          }
        };
        
        if (typeof(TOKEN) != "undefined") {
            options.data={token:TOKEN}   
        }
        $.ajaxSetup(options)

    

    $(window).load(function() {
        progress(50);
        appViewModel.init();
        progress(70);
        appViewModel.byLibraries();


        // Gestion du HASH
        window.onhashchange = function() {
            var hash = location.hash.substr(1);
            try {
                $("#"+hash).trigger("click");
                $("#myGestion").addClass("active");
                $("#myGestion ul.nav").addClass("in").css("height","auto")
                $("#myGestion li.selected").removeClass("selected")
                $("#"+hash).closest("li").addClass("selected")
            } catch( e) { }
        }

        var hash = location.hash.substr(1);
        if (hash) {
            var data = hash.split("/");
            try {
                var page = data[0];

                // Selection de la page
                $("#"+page).trigger("click");
                $("#myGestion").addClass("active");
                $("#myGestion ul.nav").addClass("in").css("height","auto")
                $("#"+page).closest("li").addClass("selected");

                if (data.length>2) {
                    var id     = data[1]
                    var action = data[2]
                    var elt    = appViewModel.currentElement().getElement(id)

                    if (elt) {
                        setTimeout(function() {elt[action]()},500);
                    }
                }


            } catch( e) {
                console.log(e)
                appViewModel.home()
                appViewModel.showRessources();
            }
        } else {
            appViewModel.home()
            appViewModel.showRessources();
        }



        
        
        $('.btn-group button').tooltip();
        
        // On étend aussi le menu des catégories
        $("#menuCategories").addClass("active");
        $("#menuCategories ul").addClass("in");
        
        $(".navbar-fixed-top").autoHidingNavbar({animationDuration:500})
        
        // binding permettant d'inclure un template avec la syntax <!-- template: NAME -->
        ko.bindingProvider.instance.preprocessNode = function(node) {
            // Only react if this is a comment node of the form <!-- template: ... -->
            if (node.nodeType == 8) {
                var match = node.nodeValue.match(/^\s*(template\s*:[\s\S]+)/);
                if (match) {
                    // Create a pair of comments to replace the single comment
                    var c1 = document.createComment("ko " + match[1]),
                        c2 = document.createComment("/ko");
                    node.parentNode.insertBefore(c1, node);
                    node.parentNode.replaceChild(c2, node);

                    // Tell Knockout about the new nodes so that it can apply bindings to them
                    return [c1, c2];
                }
            }
        }
        
        $("#btnShowCategories").popover({content:showCategories,trigger:'click',container:'body'})
                                /*.on("mouseenter", function () {
                                    var _this = this;
                                    $(this).popover("show");
                                    $(this).siblings(".popover").on("mouseleave", function () {
                                        $(_this).popover('hide');
                                    });
                                }).on("mouseleave", function () {
                                    var _this = this;
                                    setTimeout(function () {
                                        if (!$(".popover-content:hover").length) {
                                            $(_this).popover("hide")
                                        }
                                    }, 5000);
                                })*/.on('shown.bs.popover', function () {
                                   // $(".popover-content").append($("#categories"));
                                    ko.cleanNode($(".popover-content")[0]);
                                    $(".popover-content").html('<div id="categories" data-bind="template: { name: \''+"categories-template"+'\' }"></div>');
                                    ko.applyBindings(appViewModel,$(".popover-content")[0]);
                                
                                }).on('hide.bs.popover', function () {
                                   /* $("#categories-content").append($("#categories"));*/
                                })

        
        
        resize();
        progress(100);
      
    });
    
    $("#inputSearch").keyup(function() {
     var search=$(this).val();
     appViewModel.whLibraries.filterRessources(search);
    })
    
    
    $(window).resize(function() {
       resize();
    });
    
    $('#side-menu').metisMenu({toggle: false});

});

function showCategories() {
    return "<div style='width:300px;'></div>";   
}

function resize() {
    var h=$(window).height();
    $("#side-menu").height(h);
}

function initDatatable(item) {
    var options = {
				"sPaginationType": "bs_normal",
                "bFilter": item?(!item.isBig()):true,
                "bDestroy":true,
                "oLanguage": {
                    "sProcessing":     "Traitement en cours...",
                    "sSearch":         "Rechercher&nbsp;:",
                    "sLengthMenu":     "Afficher _MENU_ &eacute;l&eacute;ments",
                    "sInfo":           "Affichage de l'&eacute;lement _START_ &agrave; _END_ sur _TOTAL_ &eacute;l&eacute;ments",
                    "sInfoEmpty":      "Affichage de l'&eacute;lement 0 &agrave; 0 sur 0 &eacute;l&eacute;ments",
                    "sInfoFiltered":   "(filtr&eacute; de _MAX_ &eacute;l&eacute;ments au total)",
                    "sInfoPostFix":    "",
                    "sLoadingRecords": "Chargement en cours...",
                    "sZeroRecords":    "Aucun &eacute;l&eacute;ment &agrave; afficher",
                    "sEmptyTable":     "Aucune donn&eacute;e disponible dans le tableau",
                    "oPaginate": {
                        "sFirst":      "Premier",
                        "sPrevious":   "Pr&eacute;c&eacute;dent",
                        "sNext":       "Suivant",
                        "sLast":       "Dernier"
                    },
                    "oAria": {
                        "sSortAscending":  ": activer pour trier la colonne par ordre croissant",
                        "sSortDescending": ": activer pour trier la colonne par ordre décroissant"
                    }
                }
	}

    if (item && item.options) {
        options = $.extend({}, options, item.options);
    }


    var table=$('.datatable').DataTable(options);	
	$('.datatable').each(function(){
				var datatable = $(this);
				// SEARCH - Add the placeholder for Search and Turn this into in-line form control
				var search_input = datatable.closest('.dataTables_wrapper').find('div[id$=_filter] input');
				search_input.attr('placeholder', 'Search');
				search_input.addClass('form-control input-sm');
				// LENGTH - Inline-Form control
				var length_sel = datatable.closest('.dataTables_wrapper').find('div[id$=_length] select');
				length_sel.addClass('form-control input-sm');
                datatable.bind('page', function(e){
                    window.console && console.log('pagination event:', e) //this event must be fired whenever you paginate
                });
	}); 
    
    $('.datatable th[dt-visible="hide"]').each(function(index) {
        var column = table.column(index);
        column.visible( false );
    })
    
    return table;
}


//Ldoads the correct sidebar on window load,
//collapses the sidebar on window resize.
$(function() {
    $(window).bind("load resize", function() {
        width = (this.window.innerWidth > 0) ? this.window.innerWidth : this.screen.width;
        if (width < 768) {
            $('div.sidebar-collapse').addClass('collapse')
        } else {
            $('div.sidebar-collapse').removeClass('collapse')
        }
    })
})

!function(a,b,c,d){function e(b,c){this.element=a(b),this.settings=a.extend({},w,c),this._defaults=w,this._name=m,this.init()}function f(b){v&&(b.element.addClass("navbar-hidden").animate({top:-b.element.height()},{queue:!1,duration:b.settings.animationDuration}),a(".dropdown.open .dropdown-toggle",b.element).dropdown("toggle"),v=!1)}function g(a){v||(a.element.removeClass("navbar-hidden").animate({top:0},{queue:!1,duration:a.settings.animationDuration}),v=!0)}function h(a){var b=n.scrollTop(),c=b-t;if(t=b,0>c){if(v)return;(a.settings.showOnUpscroll||l>=b)&&g(a)}else if(c>0){if(!v)return void(a.settings.showOnBottom&&b+u===o.height()&&g(a));b>=l&&f(a)}}function i(a){a.settings.disableAutohide||(s=(new Date).getTime(),h(a))}function j(a){o.on("scroll."+m,function(){(new Date).getTime()-s>r?i(a):(clearTimeout(p),p=setTimeout(function(){i(a)},r))}),n.on("resize."+m,function(){clearTimeout(q),q=setTimeout(function(){u=n.height()},r)})}function k(){o.off("."+m),n.off("."+m)}var l,m="autoHidingNavbar",n=a(b),o=a(c),p=null,q=null,r=70,s=0,t=null,u=n.height(),v=!0,w={disableAutohide:!1,showOnUpscroll:!0,showOnBottom:!0,hideOffset:"auto",animationDuration:200};e.prototype={init:function(){return this.elements={navbar:this.element},this.setDisableAutohide(this.settings.disableAutohide),this.setShowOnUpscroll(this.settings.showOnUpscroll),this.setShowOnBottom(this.settings.showOnBottom),this.setHideOffset(this.settings.hideOffset),this.setAnimationDuration(this.settings.animationDuration),l="auto"===this.settings.hideOffset?this.element.height():this.settings.hideOffset,j(this),this.element},setDisableAutohide:function(a){return this.settings.disableAutohide=a,this.element},setShowOnUpscroll:function(a){return this.settings.showOnUpscroll=a,this.element},setShowOnBottom:function(a){return this.settings.showOnBottom=a,this.element},setHideOffset:function(a){return this.settings.hideOffset=a,this.element},setAnimationDuration:function(a){return this.settings.animationDuration=a,this.element},show:function(){return g(this),this.element},hide:function(){return f(this),this.element},destroy:function(){return k(this),g(this),a.data(this,"plugin_"+m,null),this.element}},a.fn[m]=function(b){var c=arguments;if(b===d||"object"==typeof b)return this.each(function(){a.data(this,"plugin_"+m)||a.data(this,"plugin_"+m,new e(this,b))});if("string"==typeof b&&"_"!==b[0]&&"init"!==b){var f;return this.each(function(){var d=a.data(this,"plugin_"+m);d instanceof e&&"function"==typeof d[b]&&(f=d[b].apply(d,Array.prototype.slice.call(c,1)))}),f!==d?f:this}}}(jQuery,window,document);

/*! Lazy Load 1.9.3 - MIT license - Copyright 2010-2013 Mika Tuupola */
!function(a,b,c,d){var e=a(b);a.fn.lazyload=function(f){function g(){var b=0;i.each(function(){var c=a(this);if(!j.skip_invisible||c.is(":visible"))if(a.abovethetop(this,j)||a.leftofbegin(this,j));else if(a.belowthefold(this,j)||a.rightoffold(this,j)){if(++b>j.failure_limit)return!1}else c.trigger("appear"),b=0})}var h,i=this,j={threshold:0,failure_limit:0,event:"scroll",effect:"show",container:b,data_attribute:"original",skip_invisible:!0,appear:null,load:null,placeholder:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsQAAA7EAZUrDhsAAAANSURBVBhXYzh8+PB/AAffA0nNPuCLAAAAAElFTkSuQmCC"};return f&&(d!==f.failurelimit&&(f.failure_limit=f.failurelimit,delete f.failurelimit),d!==f.effectspeed&&(f.effect_speed=f.effectspeed,delete f.effectspeed),a.extend(j,f)),h=j.container===d||j.container===b?e:a(j.container),0===j.event.indexOf("scroll")&&h.bind(j.event,function(){return g()}),this.each(function(){var b=this,c=a(b);b.loaded=!1,(c.attr("src")===d||c.attr("src")===!1)&&c.is("img")&&c.attr("src",j.placeholder),c.one("appear",function(){if(!this.loaded){if(j.appear){var d=i.length;j.appear.call(b,d,j)}a("<img />").bind("load",function(){var d=c.attr("data-"+j.data_attribute);c.hide(),c.is("img")?c.attr("src",d):c.css("background-image","url('"+d+"')"),c[j.effect](j.effect_speed),b.loaded=!0;var e=a.grep(i,function(a){return!a.loaded});if(i=a(e),j.load){var f=i.length;j.load.call(b,f,j)}}).attr("src",c.attr("data-"+j.data_attribute))}}),0!==j.event.indexOf("scroll")&&c.bind(j.event,function(){b.loaded||c.trigger("appear")})}),e.bind("resize",function(){g()}),/(?:iphone|ipod|ipad).*os 5/gi.test(navigator.appVersion)&&e.bind("pageshow",function(b){b.originalEvent&&b.originalEvent.persisted&&i.each(function(){a(this).trigger("appear")})}),a(c).ready(function(){g()}),this},a.belowthefold=function(c,f){var g;return g=f.container===d||f.container===b?(b.innerHeight?b.innerHeight:e.height())+e.scrollTop():a(f.container).offset().top+a(f.container).height(),g<=a(c).offset().top-f.threshold},a.rightoffold=function(c,f){var g;return g=f.container===d||f.container===b?e.width()+e.scrollLeft():a(f.container).offset().left+a(f.container).width(),g<=a(c).offset().left-f.threshold},a.abovethetop=function(c,f){var g;return g=f.container===d||f.container===b?e.scrollTop():a(f.container).offset().top,g>=a(c).offset().top+f.threshold+a(c).height()},a.leftofbegin=function(c,f){var g;return g=f.container===d||f.container===b?e.scrollLeft():a(f.container).offset().left,g>=a(c).offset().left+f.threshold+a(c).width()},a.inviewport=function(b,c){return!(a.rightoffold(b,c)||a.leftofbegin(b,c)||a.belowthefold(b,c)||a.abovethetop(b,c))},a.extend(a.expr[":"],{"below-the-fold":function(b){return a.belowthefold(b,{threshold:0})},"above-the-top":function(b){return!a.belowthefold(b,{threshold:0})},"right-of-screen":function(b){return a.rightoffold(b,{threshold:0})},"left-of-screen":function(b){return!a.rightoffold(b,{threshold:0})},"in-viewport":function(b){return a.inviewport(b,{threshold:0})},"above-the-fold":function(b){return!a.belowthefold(b,{threshold:0})},"right-of-fold":function(b){return a.rightoffold(b,{threshold:0})},"left-of-fold":function(b){return!a.rightoffold(b,{threshold:0})}})}(jQuery,window,document);

jQuery.fn.highlight = function(pat) {
 function innerHighlight(node, pat) {
  var skip = 0;
  if (node.nodeType == 3) {
   var pos = node.data.toUpperCase().indexOf(pat);
   if (pos >= 0) {
    var spannode = document.createElement('span');
    spannode.className = 'highlight';
    var middlebit = node.splitText(pos);
    var endbit = middlebit.splitText(pat.length);
    var middleclone = middlebit.cloneNode(true);
    spannode.appendChild(middleclone);
    middlebit.parentNode.replaceChild(spannode, middlebit);
    skip = 1;
   }
  }
  else if (node.nodeType == 1 && node.childNodes && !/(script|style)/i.test(node.tagName)) {
   for (var i = 0; i < node.childNodes.length; ++i) {
    i += innerHighlight(node.childNodes[i], pat);
   }
  }
  return skip;
 }
 return this.length && pat && pat.length ? this.each(function() {
  innerHighlight(this, pat.toUpperCase());
 }) : this;
};

jQuery.fn.removeHighlight = function() {
 return this.find("span.highlight").each(function() {
  this.parentNode.firstChild.nodeName;
  with (this.parentNode) {
   replaceChild(this.firstChild, this);
   normalize();
  }
 }).end();
};


