// ===== Ressource =========================================
var Ressource = CItem.extend({
    initialize : function(data) { 
        var self=this;
        this.data.catalogue_id=this.data.catalogue_id || 0
        this.data.ressource_id=this.data.ressource_id || 0
        this.catalogue=appViewModel.whCatalogues.getElement(this.data.catalogue_id)
        this.api_tag="ressource";
        this.menu="library";
        this.catalogueId=ko.observableArray([this.data.catalogue_id])
        this.ressourceId=ko.observableArray([this.data.ressource_id])
        this.categoryId=ko.observableArray([this.data.category_id])
        this.libraryName=ko.observable("");
        
        this.params=ko.observableArray(Ressource.getMatches(this.data.urlaccess))
        
        this.category=appViewModel.getCategory(this.categoryId())
        if (this.category) {
             this.categoryName=this.category.data.name
        } else{
             this.categoryName="";
        }
        
        if (this.catalogue) {
             this.catalogueName=this.catalogue.data.name
        } else{
             this.catalogueName="n/a";
        }
        
        self.rate=ko.observable(self.data.rate);
        self.count=ko.observable(self.data.count);
        
        if (self.data.actif==undefined) self.data.actif=true;
        
        self.actif=ko.observable(JSON.parse(self.data.actif));
        
        self.required = ko.computed(function() {
            return self.isChecked()?"required":null
        });
       /* this.class_element="Catalogue";*/ 
    },
    
});

Ressource.prototype.check=function(value)  {
    // Ressource non active ou en erreur, impossible de la selectionner
    if (!this.actif() || this.data.error) value=false;
    this.isChecked(value);
    if (this.parent) this.parent.countChecked(  )
}

Ressource.prototype.showCatalogue = function() {
    if (this.parent) this.parent.show();
}

Ressource.prototype.activate = function(data,event) {
     
     if (!(this.data.editable)) {return;}
    
     event.stopPropagation();
     var self=this;
     $.ajax({url: "api/ressource/"+this.id+"/activate",data:{actif:true},type:"POST"}).done(function (content) {
        self.actif(JSON.parse(content))   
     }).always(function() {
        
     })
}

Ressource.prototype.desactivate = function(data,event) {
    
     if (!(this.data.editable)) {return;}
    
     event.stopPropagation();
     var self=this;
     $.ajax({url: "api/ressource/"+this.id+"/activate",data:{actif:false},type:"POST"}).done(function (content) {
        self.actif(JSON.parse(content))   
     }).always(function() {
        
     })
}

// Est-ce que la ressource peut être proposée 
Ressource.prototype.isProposable = function() {
    
    // En erreur et je ne suis pas admin -> on n'affiche pas
    if (this.data.error && !appViewModel.user.isAdmin()) return false;
    
    if (appViewModel.ressIns[this.id]) return false;
    
    if (appViewModel.ressIns[this.id]) return false;
    
    // Plus de 15 jours, on affiche pas la ressource 
    if (new Date().getTime()-this.timestamp > 3*24*60*60*1000) return false;
      
    return true;
    
}

Ressource.prototype.setCatalogue = function(catalogue_id) {
    this.catalogueId.removeAll()
    this.catalogueId.push(catalogue_id);
    this.data.catalogue_id=catalogue_id;
}

Ressource.prototype.setLibrary = function(library) {
    this.data.library_id=library.id;
    this.libraryName(library.data.name);
    this.library=library
}

Ressource.prototype.hasLibrary=function() {
    return (this.library!=undefined);
}

var imageSearch;
function searchComplete() {
        console.log("searchComplete");
        // Check that we got results
        if (imageSearch.results && imageSearch.results.length > 0) {
            console.log(imageSearch.results)
            
            var $img=$("<img>").attr("src",imageSearch.results[0].tbUrl);
            onImage($img[0])
        }
}

function onImage(img) {
    $("#modal td.logo .img").empty();
    $("#modal td.logo .img").append(img);
    $("#modal td.logo .img img").attr("id","preview")
    var canvas = document.getElementById("myCanvas");
    var ctx = canvas.getContext("2d");
    var img = document.getElementById("preview");
    canvas.width=img.width;
    canvas.height=img.height;

    ctx.drawImage(img, 0, 0,img.width,img.height);
    
    // Modifie la valeur du champ imput
    $("input[field='logo']").val(canvas.toDataURL());
}

Ressource.prototype.fetch_logo = function() {
    
    if (!appViewModel.user.data.canfetchimage) return;
    
    var btn = $("#fetching-logo-btn")
    btn.button("loading");
    
    var url=$(".form-control.url").val();
    var matches = url.match(/^https?\:\/\/([^\/?#]+)(?:[\/?#]|$)/i);
    domaine=matches && matches[1]
    
    // Max 10s:
    setTimeout(function() { btn.button("reset");},10*1000);
    
    var $img=$("<img>").load(function() {
        onImage(this)   
        btn.button("reset");
    }).attr("src","api/ressource/fetch/"+encodeURIComponent(domaine)+"/image");   
}

Ressource.prototype.fetch = function(library) {
    var self=this;
    var btn = $("#fetching-btn")
    btn.button('loading')
    
    var url=$(".form-control.url").val();
    var matches = url.match(/^https?\:\/\/([^\/?#]+)(?:[\/?#]|$)/i);
    domaine=matches && matches[1]
    
    self.fetch_logo();
    
    $.ajax({url: "api/ressource/fetch/"+encodeURIComponent(domaine)+"/meta"}).done(function (content) {
        // Temps dépassé, on ne fait rien
        if (content.title) $(".form-control.name").val(content.title); 
        if (content.description) $(".form-control.description").val(content.description); 
    }).always(function() {
        $("#fetching-btn").button("reset");
    })
    
    
}

Ressource.getMatches=function(string, index) {
    regex=/\((.*?)\)/g
    index || (index = 1); // default to the first capturing group
    var matches = [];
    var match;
    while (match = regex.exec(string)) {
        matches.push(match[index]);
    }
    return matches;
}



Ressource.prototype.hasParams = function() {return this.params().length!=0}

Ressource.prototype.access=function(data,event) {
    if (event) event.stopPropagation();
    window.open(this.data.url);   
}

Ressource.prototype.depends = function() {
    if (! this.data.ressource_urlaccess ) return "";
    return " (via " +this.data.ressource_name +")";
}

Ressource.prototype.ressource_url = function() {
    if (! this.data.ressource_urlaccess ) return this.data.url;
    return this.data.ressource_url;
}

Ressource.prototype.onUrlAccessChange=function(data,event)
{
    var self=this;
    var url=$("#modal .urlaccess").val();  
    
    var matches = Ressource.getMatches(url);
    self.params([])
    for (var i=0;i<matches.length;i++)
    {
        self.params.push(matches[i])
    }
}

Ressource.prototype.logoUrl = function() {
    return "api/ressource/logo/"+this.id+"/"+this.timestamp;
}

Ressource.prototype.bgUrl = function() {
    return "url("+"api/ressource/logo/"+this.id+"/"+this.timestamp+")";
}


Ressource.prototype.onModalData = function (data) {
    data.urlaccess=$("#modal .urlaccess").val(); 
}


Ressource.prototype.onSave = function(response) {

    // Lorsque l'on sauvegarde une ressource
    try {
        var r=response[0]; 
        // Si le catalogue a changé, on efface le contenu du nouveau catalogue
        // Pour récupérer les nouveaux éléments
        if (r.catalogue_id!=this.data.catalogue_id) {
            var c=appViewModel.whCatalogues.getElement(r.catalogue_id) ;
            if (c) {
                c.clear();
                c.getElements();
            }
        }
    } catch (e) {
    }
    
    this.recent=true
}

Ressource.prototype.apercu = function() {
    window.open($("#url").val());
}

Ressource.prototype.onEdit = function(target) {
        // Récupération du logo
        $img=$("<img>").attr("src", this.logoUrl()).load(function() {
            onImage(this);   
        }).addClass("logo");
        $("#modal td.logo .img").append($img);
    
        if (this.data.catalogue_id==-1) {
          $("#select_catalogue").hide();    
        }
    
        $('#modal .nav-tabs a:first').tab('show')
    
        // preview du logo
        $('#fileupload').change ( function (e) {
            
            var file, img;
            if ((file = e.target.files[0])) {
                img = new Image();
                img.onload = function () {
                    if (this.width>128 || this.height > 128) {
                        alert("La taille maximal d'une image est de 128x128px.<br> Votre image fait "+this.width+"x"+this.height+"px");
                        return;
                    }
                    loadImage(
                        e.target.files[0],
                        onImage,
                        {maxWidth: 124} // Options
                    );
                };
                img.src = (window.URL || window.webkitURL).createObjectURL(file);
            }
        });   
}

// Instanciation d'une ressource : Ie ajout dans une bibliotheque
Ressource.prototype.instantiate = function(data,event) {

    if (event) event.stopPropagation();
    
    var $target=$("#modal")
    var self=this;

    $.ajax({url: "api/ressource/instantiate/"+self.id}).done(function (content) {
     
        // Suppression du binding en cours
        ko.cleanNode($("#modal")[0]);
        
        // Affiche la boite de dialogue d'instanciation
        $target.find(".modal-body").html(content);
        $("#myModalLabel").html("Ajouter à une bibliothèque");

        // Récupération du logo
        $img=$("<img>").attr("src", self.logoUrl()).addClass("logo");
        $("#modal td.logo .img").append($img);

        // Aply viewModel bindings
        ko.applyBindings(self,$("#modal")[0]);

        // Affiche la boite de dialogue
        EConnect.showModal();
        
        $("#modal").find(".modal-footer button.save").show();

        // Sauvegarde des modifications
        $target.find(".modal-footer button.save").click(function() {
            
            if (!EConnect.validate()) return;
            
            var data = EConnect.modalData($target);
            data.params=[]
            
            $("#modal input.param").each(function() {
                var $param=$(this);
                data.params.push({libelle:$param.attr("label"),valeur:$param.val()});
            })
            $.ajax({url: "api/ressource/instantiate/"+self.id,method:"post",data: data }).success(function(data) {
                
                var instance=new Instance(data);
                appViewModel.buildHome();
                EConnect.closeModal();
                
            });         
        })

    })          


}



