var User = CItem.extend({
    initialize : function(data) { 
        var self=this;
        this.api_tag="user";
        this.userProfilEdit=ko.observable();
        self.context=ko.observableArray([]);
        
        this.canCreateCatalogue=function() {
            return this.isAdmin() || this.isAdminLocal();   
        }
        
        this.canCreateLibrary=function() {
            return this.isAdmin() || this.isAdminLocal();   
        }
        
        this.canInstantiate=function() {
            return this.isAdmin() || this.isAdminLocal();   
        }
        
        this.canCreateProfil=function() {
            return this.isAdmin() || this.isAdminLocal();   
        }
        
        this.mainProfil=function() {
            if (self.isAdmin()) return "Administrateur"; 
            if (self.isAdminLocal()) return "Administrateur Local";  
            if (self.data.profils && self.data.profils.length>1) return self.data.profils[1];
            if (self.data.profils && self.data.profils.length==1) return self.data.profils[0];
            return "--";
            
        }

        this.garAdmin            = ko.observable(this.data.garAdmin);
        this.garAvailable        = ko.observable(this.data.garAvailable);
        
        this.garPossibleUser = this.profil != "Eleve" && this.profil != "Responsable"
        
        this.isAdmin=function()         {return this.data.admin}
        this.isAdminLocal=function()    {return this.data.adminlocal}
        this.isGestAcad=function()      {return this.data.gestacad}
        this.isDir=function()           {return this.data.dir}

        this.isGarOk= function()      {return this.data.garStatus=="200"}
        
        this.canAdmin=function() {return this.isAdmin() || this.isAdminLocal()  }

        this.canSetGarAdmin = ko.computed(function() {
            // Il y a que Admin et le Dir qui peuvent positionner les responsable d'affectation
            if (!appViewModel.user) return false;

            // Impossible de modidier le resp. affec si c'est un DIR
            return !self.isDir() && ( appViewModel.user.isAdmin() || appViewModel.user.isDir())
        })

        
        this.profils=ko.computed(function()
        {
            if (!self.data.profils) return "";
            var ret=""
            for ( var i=0;i<self.data.profils.length;i++)
            {
                ret=ret+self.data.profils[i].toLowerCase().replace(" ","")+" "
            }
            if (self.isAdmin()) ret=ret+"admin"+" ";
            if (self.isAdminLocal()) ret=ret+"adminlocal"+" ";
            return ret
        })

        this.garAffectationLinks =  ko.observableArray([]);
        
        var hashConfig = {}
        for ( var i=0;i<self.data.context.length;i++)
        {
            c=new Context(self.data.context[i])
            self.context.push(c);
            // Le context est bien activé au niveau du GAR ?
            if (!hashConfig[c.data.garConfig] && c.data.garConfig && c.garActif() && parseInt(c.garStep()) == 1) {
                hashConfig[c.data.garConfig] = true
                self.garAffectationLinks.push({link: "api/gar/"+c.data.garConfig+"/affectations", name: c.data.garConfig});
            }
        }
    }
});

User.prototype.onEdit=function()
{
    
}

User.prototype.edit = function(data, event,callback) {
   if (this.id!=appViewModel.user.id) {
       return;
   }
   this._edit(data, event,callback); 
 }


User.prototype.activate = function(data,event) {
    
    event.stopPropagation();
    
    var self=this;
    $.ajax({url: "api/context/"+this.parent.id +"/user/"+ this.id +"/activate",data:{actif:true},type:"POST"}).done(function (content) {
       self.garAdmin(JSON.parse(content))   
    }).always(function() {
       
    })
}

User.prototype.nothing = function(data,event) {  
    event.stopPropagation();
}

User.prototype.desactivate = function(data,event) {
   
    event.stopPropagation();

    var self=this;
    $.ajax({url: "api/context/"+this.parent.id +"/user/"+ this.id +"/activate",data:{actif:false},type:"POST"}).done(function (content) {
       self.garAdmin(JSON.parse(content))   
    }).always(function() {
       
    })
}
