<?php

    require 'api/include/include.php';
    require 'api/include/init.php';

    // Mode reload ?
    if (!isset($_GET["reload"])) {unset($_SESSION["reload"]);} else {$_SESSION["reload"] = "yes";}

?>
<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="icon" type="image/jpeg" href="logos/favicon32.png" />

    <title>econnect: Envole Connecteur</title>

    <!-- Core CSS - Include with every page -->
    <link href="assets/bootstrap/3.1.1/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <link href="assets/css/jquery.fileupload-ui.css" rel="stylesheet">
    <link href="assets/css/chosen.css" rel="stylesheet">


    <!-- econnect main CSS - Include with every page -->
    <link href="client/css/main.css" rel="stylesheet">
    <link href="client/css/econnect.css" rel="stylesheet">
    <link href="client/css/wall.css" rel="stylesheet">
    <link href="assets/css/datatables.css" rel="stylesheet">
    <link href="client/css/ribbon.css" rel="stylesheet">

    <?php if (file_exists("client/css/local.css")) { ?>
    <link href="client/css/local.css" rel="stylesheet">
    <?php } ?>


    <!-- Core Scripts - Include with every page -->
    <script src="assets/jquery-1.9.1.min.js"></script>

    <script src="assets/load-image.min.js"></script>



</head>

<body>

    <div id="wrapper">

        <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="margin-bottom: 0">
            <div class="navbar-header">
                <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".sidebar-collapse">
                    <span class="sr-only">Toggle navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                <a class="econnect" href="?reload">
                <img src="logos/logo-econnect-182X50.png"/>
                </a>
            </div>
            <!-- /.navbar-header -->
            <ul class="nav navbar-top-links navbar-right">


                <li>
                    <form class="navbar-form navbar-left  pull-right">

                        <span data-bind="visible: ! modeGestion() && appViewModel.isNotAccueil() " class="pull-right ">

                            <div class="form-group">
                                <input type="text" class="form-control" placeholder="Rechercher" id="inputSearch">
                            </div>
                            <!-- <button type="submit" class="btn btn-default">
                                <span class="glyphicon glyphicon-search"></span>
                            </button>-->

                            <!-- <button  type="button" class="btn btn-default btn-sm refresh"
                                data-bind="click: refreshList">
                            <i class="fa fa-refresh"></i>
                            </button>-->

                            <!--<button id="btnShowCategories" type="button" class="btn btn-default btn-sm"
                                    data-container="body" data-toggle="popover"  data-html="true"
                                    data-title="Veuillez choisir les thématiques"
                                    data-placement="bottom" >
                              <i class="fa fa-filter"></i>
                            </button> -->



                        </span>

                        </form>
                </li>

                <!-- /.dropdown -->
                <li data-bind="css: appViewModel.user.profils" >

                    <div style="margin-top:10px;text-align:right">
                        <a data-bind="click: showUser" class="dropdown-toggle" data-toggle="dropdown" href="#" id="user">
                            <i class="fa fa-user fa-fw"></i><span data-bind="text: username"></span>
                        </a>
                        &nbsp;
                        <button class="btn btn-link btn-xs" id="refresh" data-url="?reload">
                            <i class='fa fa-refresh'></i> 
                            Actualiser</button>
                        <a href="api/logout">
                            [ <i class="fa fa-sign-out"></i> 
                            ]
                        </a>
                    </div>
                    
                    <div class="text-right">
                            <!-- ko if: appViewModel.user.isGestAcad() -->
                            <small> Vue academique</small>
                            <!-- /ko -->

                            <!-- ko ifnot: appViewModel.user.isGestAcad() -->
                            <small data-bind="text: appViewModel.user.mainProfil()"></small>
                            <!-- /ko -->

                            
                            <!-- ko if: appViewModel.user.garAdmin -->
                            <small> / Resp. Affectation GAR</small>
                            <!-- /ko -->

                            |

                            <!-- ko if: appViewModel.RGPDLink -->
                            <small> 
                            <a data-bind="attr:{href: appViewModel.RGPDLink}" target="_blank">
                                <span data-bind="text: appViewModel.RGPDText"></span>
                            </a>
                            </small>
                            / 
                            <!-- /ko -->

                            
                            <small> 
                            <a href="docs/econnect.pdf" target="_blank"> documentation</a>
                            </small>

                            
                            
        
                        
                    </div>
                </li>

            </ul>


            <!-- /.navbar-top-links -->

            <div class="navbar-default sidebar-nav navbar-static-side" role="navigation" >
                <div class="sidebar-collapse">
                    <ul class="nav" id="side-menu" >

                        <li data-bind="css: {  selected:! appViewModel.isNotAccueil() && ! modeGestion()}">
                          <a href="#" data-bind="click: appViewModel.home">
                              &nbsp;<i class="fa fa-home"></i> Accueil</a>
                        </li>

                        <li id='myGestion' class="gestion" data-bind="visible: appViewModel.user.canAdmin() || appViewModel.user.isGestAcad() || appViewModel.user.isDir() ">
                            <a href="#"><i class="fa fa-wrench fa-fw"></i> Administrer<span class="fa arrow"></span></a>
                            <ul class="nav">

                                <li data-bind="visible: appViewModel.user.isAdmin(),
                                               css: {  selected: appViewModel.is('gar')}">
                                    <a href="#gars" id="gars" data-bind="click: showGars" class='action' action='contexts'><i class="fa fa-archive fa-fw"></i>Gestion du GAR</a>
                                </li>

                                <li data-bind="visible: appViewModel.user.canAdmin() || appViewModel.user.isDir() || appViewModel.user.isGestAcad(),
                                               css: {  selected: appViewModel.is('context')}">
                                    <a href="#contexts" id="contexts" data-bind="click: showContexts" class='action' action='contexts'><i class="fa fa-building-o fa-fw"></i>Etablissements</a>
                                </li>

                                <li data-bind="visible: appViewModel.user.canAdmin(),
                                               css: {  selected: appViewModel.is('catalogue')}">
                                    <a href="#catalogues" id="catalogues"  data-bind="click: showCatalogues" class='action' action='catalogues'><i class="fa fa-suitcase fa-fw"></i>Catalogues</a>
                                </li>
                                <li data-bind="css: {  selected: appViewModel.is('library')}">
                                    <a href="#libraries" id="libraries" data-bind="click: showLibraries"  class='action' action='libraries'><i class="fa fa-book fa-fw"></i>Bibliothèques</a>
                                </li>
                                <li data-bind="visible: appViewModel.user.canAdmin(),
                                               css: {  selected: appViewModel.is('profil')}">
                                    <a href="#profils" id="profils" data-bind="click: showProfils"  class='action' action='profils'>
                                        <i class="fa fa-users fa-fw"></i>Profils
                                    </a>
                                </li>
                                <li data-bind="visible: appViewModel.user.isAdmin(),
                                               css: {  selected: appViewModel.is('parameter')}">
                                    <a href="#parameters" id="parameters" data-bind="click: showParameters"  class='action' action='parameters'>
                                        <i class="fa fa-cogs fa-fw"></i>Paramètres
                                    </a>
                                </li>

                            </ul>
                        </li>

                        <li id="menuLibraries">
                            <a href="#"><i class="fa fa-book fa-fw"></i> Bibliothèques<span class="fa arrow"></span></a>
                            <!-- MENU GAUCHE TOUTES LES LIBS -->
                            <ul class="nav " id='mylibraries'>

                                <div data-bind="foreach: libraries">
                                    <li data-bind="css: {  unchecked:!isChecked()}">
                                        <div data-bind="click: xToogle">
                                            <span class="fa-stack fa-lg" data-bind="click: toogle" >
                                              <i class="fa fa-circle-o fa-stack-2x"></i>
                                              <i data-bind="visible: isChecked" class="fa fa-check fa-stack-1x"></i>
                                            </span>

                                            <span data-bind="text: count, visible: count() != 0 " class="badge pull-right"></span>
                                            <span class="capitalize" data-bind="text: displayName()"></span>




                                        </div>

                                   </li>
                               </div>

                                 <div>
                                 <li data-bind="click:appViewModel.showAllLibraries">
                                    <div class='showall'>
                                        <span class='name'>Voir toutes les bibliothèques</span>
                                        <span></span>
                                    </div>
                                  </li>
                               </div>

                            </ul>
                        </li>


                        <li id="menuCategories" data-bind="visible:appViewModel.categories().length!=1 && appViewModel.AllInstances.children().length!=0">
                            <a href="#"><i class="fa fa-square fa-fw"></i> Thématiques<span class="fa arrow"></span></a>
                            <ul class="nav ">


                                 <div data-bind="foreach: appViewModel.whCategories.children">
                                    <li data-bind="css: {  unchecked:!isChecked()},visible: count() != 0">
                                        <div data-bind="click: xToogle">
                                              <i class="fa fa-square-o inactive"
                                                 data-bind="click: toogle,visible: ! isChecked()">
                                              </i>
                                              <i data-bind="visible: isChecked,style: { color: color},click: toogle"
                                                 class="fa fa-square active" ></i>

                                            <span data-bind="text: count, visible: count() != 0 " class="badge pull-right"></span>
                                            <span class='name' data-bind="text: data.name"></span>

                                        </div>

                                   </li>
                                </div>


                                 <div>
                                 <li data-bind="click:appViewModel.showAllCategories">
                                    <div class='showall'>
                                        <span class='name'>Activer tous les thèmes</span>
                                        <span></span>
                                    </div>
                                  </li>
                               </div>

                            </ul>

                        </li>

                            <!-- ============================ -->
                    </ul>
                    <!-- /#side-menu -->
                </div>
                <!-- /.sidebar-collapse -->
            </div>
            <!-- /.navbar-static-side -->
        </nav>


        <div id="page-wrapper" data-bind="css: { full : ! appViewModel.isNotAccueil()}">

            <div class="loading" data-bind="visible: appViewModel.isWaitingForLoading()">
                <br><br>
                <div class="text-center fa-4x">Veuillez patienter, <br> chargement en cours....</div>
            </div>

            <div class="row" data-bind="visible: !appViewModel.isWaitingForLoading() && (appViewModel.isNotAccueil() || appViewModel.modeGestion()) ">
                <div class="col-lg-12">
                    <h1 class="page-header">

                        <button type="button" class="btn  btn-sm pull-left"
                                data-bind="visible: currentElement().hasParent(), click: back">
                            <i class="fa fa-angle-left"></i>
                        </button>

                        <div data-bind="visible: ! modeGestion() " class="btn-toolbar">
                            <div class="btn-group pull-right">

                            <div class="btn-group btn-group-sm">

                                <button type="button"
                                         class="btn btn-default"
                                         data-toggle="tooltip" data-placement="bottom"
                                         title="Grouper par bibliothèques"
                                         data-bind="click: appViewModel.byLibraries">
                                         <i class="fa fa-book"></i>
                                  </button>
                                  <button type="button"
                                          class="btn btn-default"
                                          data-toggle="tooltip" data-placement="bottom"
                                         title="Grouper par thèmes"
                                         data-bind="click: appViewModel.byCategories">
                                         <i class="fa fa-square"></i>
                                  </button>
                                  <button type="button"
                                          class="btn btn-default"
                                          data-toggle="tooltip" data-placement="bottom"
                                         title="Ne pas grouper"
                                         data-bind="click: appViewModel.byNone">
                                         <i class="fa fa-ban"></i>
                                  </button>

                                <!--
                                  <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                                     <span data-bind="text:appViewModel.groupeByLibelle"></span>  <span class="caret"></span>
                                  </button>
                                  <ul class="dropdown-menu" role="menu">
                                      <li data-bind="click: appViewModel.byLibraries,
                                                    visible: ! appViewModel.isGroupedByLibraries()">
                                          <a href="#">bibliothèques</a>
                                      </li>
                                      <li data-bind="click: appViewModel.byCategories,
                                                     visible: ! appViewModel.isGroupedByCategories()">
                                          <a href="#">thèmatiques</a>
                                      </li>
                                      <li data-bind="click: appViewModel.byNone,
                                                     visible: ! appViewModel.isGroupedByNone()">
                                          <a href="#">Ne pas grouper</a>
                                      </li>
                                  </ul>-->


                            </div>

                            <div class="btn-group btn-group-sm">

                                <button type="button"
                                          class="btn btn-default"
                                        data-toggle="tooltip" data-placement="bottom"
                                         title="Trier par nom"
                                         data-bind="click: appViewModel.byName">
                                         <i class="fa fa-sort-alpha-asc"></i>
                                  </button>
                                  <button type="button"
                                          class="btn btn-default"
                                          data-toggle="tooltip" data-placement="bottom"
                                         title="TRier par note"
                                         data-bind="click: appViewModel.byRate">
                                         <i class="fa fa-star"></i>
                                  </button>
                                  <button type="button"
                                          class="btn btn-default"
                                          data-toggle="tooltip" data-placement="bottom"
                                         title="Trier par nombre d'accès    "
                                         data-bind="click: appViewModel.byView">
                                         <i class="fa fa-eye"></i>
                                  </button>

                                 <!-- <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                                    <span data-bind="text:appViewModel.orderByLibelle"></span> <span class="caret"></span>
                                  </button>
                                  <ul class="dropdown-menu" role="menu">
                                      <li data-bind="click: appViewModel.byName,
                                                    visible: ! appViewModel.isOrderedByName()">
                                          <a href="#">nom</a>
                                      </li>
                                      <li data-bind="click: appViewModel.byRate,
                                                     visible: ! appViewModel.isOrderedByRate()">
                                          <a href="#">votes</a>
                                      </li>
                                      <li data-bind="click: appViewModel.byView,
                                                     visible: ! appViewModel.isOrderedByView()">
                                          <a href="#">visites</a>
                                      </li>
                                  </ul>-->
                            </div>

                            <div class="btn-group btn-group-sm" >
                                  <button type="button"
                                          class="btn btn-default"
                                         data-bind="click: appViewModel.iconMode">
                                         <i class="fa fa-th"></i>
                                  </button>
                                  <button type="button"
                                          class="btn btn-default"
                                         data-bind="click: appViewModel.largeMode">
                                         <i class="fa fa-th-large"></i>
                                  </button>
                                  <button type="button"
                                          class="btn btn-default"
                                         data-bind="click: appViewModel.listeMode">
                                         <i class="fa fa-th-list"></i>
                                  </button>
                            </div>
                           </div>
                        </div>

                        <button data-bind="visible: modeGestion() && currentElement().canRefresh ,click: refreshList " type="button" class="btn btn-default pull-left btn-sm refresh">
                            <i class="fa fa-refresh"></i>
                        </button>

                        <span data-bind="text: currentElement().libelleListe"></span>

                        <select field="context" data-bind="visible: currentElement().hasParent()" ></select>

                        <span data-bind="visible: modeGestion">
                            <button type="button" class="btn btn-info btn-sm pull-right add"
                                     data-bind="click: appViewModel.closeGestion">
                                <i class="fa fa-times-circle-o"></i> Fermer
                            </button>
                        </span>

                        <span data-bind="visible: ! isInstantiable() && modeGestion()">
                            <button type="button" class="btn btn-success btn-sm pull-right add"
                                     data-bind="visible: canCreateElements, click: addElement">
                                <i class="fa fa-plus-circle"></i> Créer <span data-bind="text: currentElement().libelleCreate"></span>
                            </button>
                        </span>


                        <span data-bind="visible: isInstantiable()">
                            <div class="btn-group pull-right" >
                                <button type="button" data-toggle="dropdown"
                                                    class="dropdown-toggle btn btn-primary btn-sm pull-right add" >
                                    <i class="fa fa-plus"> Ajouter une ressource</i>
                                </button>
                                <ul class="dropdown-menu" role="menu">
                                    <li><a href="#" data-bind="click: selectRessources">
                                        <i class="fa fa-plus"></i> Depuis un catalogue
                                        </a>
                                    </li>
                                    <li><a href="#" data-bind="click: createRessource">
                                        <i class="fa fa-star"></i> Créer nouvelle ressource
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </span>

                        <span data-bind="visible: currentElement().hasChecked">
                            <button type="button" class="btn btn-danger btn-sm pull-right add"
                                     data-bind="click: currentElement().actionChecked()">
                                <i class="fa fa-trash-o"></i> Supprimer
                            </button>
                        </span>



                        <div></div> <!-- garder cette ligne pour l'ombrage -->

                    </h1>

                </div>
            </div>

            <div class="row content">
               <!-- <div class="" data-bind="template: { name: 'home-template' }"></div>    -->
            </div>




        </div>
        <!-- /#page-wrapper -->

    </div>
    <!-- /#wrapper -->


    <div id="loading">

        <div>
            <div class="modal-header">
                <h1><img src="logos/logo-econnect-182X50.png"/><br>
                    <small>Vos ressources numériques</small>
                </h1>
                <h4>Chargement en cours...</h4>
            </div>

                <div class="progress progress-striped active">
                       <div class="progress-bar  progress-bar-info"  role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%">

  </div>
                </div>

        </div>
    </div>



     <! -- Définition d'une boite de dialogue -->
     <div id="modal" class="modal fade" tabindex="-1">
              <div class="modal-dialog modal-lg">
                <div class="modal-content">
                  <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="myModalLabel">Modal title</h4>
                    <div class="alert alert-danger" style='display:none'>

                        <div></div>
                    </div>
                  </div>
                  <div class="modal-body">
                    ...
                  </div>
                  <div class="modal-footer">

                    <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-primary save"
                            data-loading-text="<i class='fa fa-spinner fa-spin'></i> veuillez patienter">Enregistrer</button>
                  </div>
                </div>
              </div>
    </div>



    <script src="assets/bootstrap/3.1.1/js/bootstrap.js"></script>
    <script>
        function progress(valeur) {
         $('#loading .progress-bar').css('width', valeur+'%').attr('aria-valuenow', valeur);
         if (valeur==100) {
           setTimeout(function() {$("#loading").fadeOut(1000)},100);
         }
        }
    </script>

    <script>
        $("#refresh").click(function(){
            var url=$(this).attr("data-url")
            window.location.href=url;
        })

        var url =window.location.href.replace("?reload","");
        window.history.replaceState({}, document.title, url);
    </script>

    <script>progress(10)</script>
    <script src="assets/knockout-3.1.0.js"></script>
    <script src="assets/jquery.tablednd.js"></script>
    <script src="assets/jquery.metisMenu.js"></script>
    <script src="assets/jquery.dataTables.min.js"></script>
    <script src="assets/js/datatables.js"></script>
    <script src="assets/jquery.blockUI.js"></script>
    <script src="assets/jquery.raty.js"></script>
    <script src="assets/jquery.chosen.min.js"></script>
    <script src="assets/jquery.timeago.js"></script>
    <script src="assets/jqBootstrapValidation.js"></script>
    <script src="assets/bootbox.min.js"></script>
    <script>progress(25)</script>

    <?php include_once("templates.php") ?>

    <!-- SB Admin Scripts - Include with every page -->
    <script src="client/js/classes.js"></script>
    <script src="client/js/catalogue.js"></script>
    <script src="client/js/library.js"></script>
    <script src="client/js/ressource.js"></script>
    <script src="client/js/contexte.js"></script>
    <script src="client/js/gar.js"></script>
    <script src="client/js/profil.js"></script>
    <script src="client/js/user.js"></script>
    <script src="client/js/rights.js"></script>
    <script src="client/js/main.js?_v=28154"></script>
    <script src="client/js/expressbuilder.js"></script>

    <script>progress(45)</script>


    <div class="growlUI" style="display: none;">
            <h1>Growl Notification</h1>
            <h2>Have a nice day!</h2>
    </div>

    <?php
        if (isset($token)) {
            echo "<script>var TOKEN='$token'</script>";
        }

    ?>

    <script>
        /* Actualisation en arrière plan des ressources */
        setTimeout(
            function() {$.ajax({url:"api/libraries?reload=yes"});}
            ,1000*60*Math.floor(Math.random() * 5 + 1) // Refresh entre 1 et 5mn
        )
    </script>

    <?php
    // fixes: #14303, ajout de sonde piwik
    if(file_exists('/var/www/html/sondepiwik/envoleTrackeur.js.php')) {
        include "/var/www/html/sondepiwik/envoleProfil.php";
        echo "<script defer=true src='/sondepiwik/envoleTrackeur.js.php?appli=econnect&profil=".GetProfil()."'></script>";
    }
    elseif(file_exists('/var/www/html/piwik/envoleTrackeur.js.php')) {
        include "/var/www/html/piwik/envoleProfil.php";
        echo "<script defer=true src='/piwik/envoleTrackeur.js.php?appli=econnect&amp;profil=".GetProfil()."'></script>";
    }
    ?>



</body>

</html>
