<script id="carousel-template" type="text.html">

<div class="col-md-12">
    <div class="carousel slide">
      <div class="carousel-inner" data-bind="foreach: {data:catalogue.children , as: 'ressource'}">
        <div class="item active">
          <div class="col-md-4">
            <a href="#">
                <div class="ressource" data-bind="template: { name: 'ressource-template', data: ressource }"></div>  
            </a>
          </div>
        </div>
      </div>
      <a class="left carousel-control" href="#myCarousel" data-slide="prev"><i class="glyphicon glyphicon-chevron-left"></i></a>
      <a class="right carousel-control" href="#myCarousel" data-slide="next"><i class="glyphicon glyphicon-chevron-right"></i></a>
    </div>
</div>
</script>

<script id="home-template" type="text/html">

        <div class="" data-bind="visible: !appViewModel.isWaitingForLoading()">

        <!-- ko if: appViewModel.user.garAvailable -->
            <!-- ko ifnot:  appViewModel.user.isGarOk() -->
            <!-- ko if:   appViewModel.user.data.garStatus --> 
            <div class="panel panel-danger">
                <div class="panel-body text-danger">
                
                <i class="fa fa-exclamation-triangle fa-2x"></i> Erreur d'accès aux ressources du GAR : <span data-bind="html:appViewModel.user.data.garStatus"></span>
                <br>
               
                <!-- ko if: appViewModel.hasGarAdmin  -->
                Veuillez contacter le support GAR
                <!--   /ko  -->
                </div>
            </div>
             <!--   /ko  -->
            <!--   /ko  -->
        <!--   /ko  -->

        <!-- ko if: appViewModel.hasGarAdmin  -->
        
        <div class="panel panel-info">
            
            <div class="panel-body">
                
                <!-- ko if: appViewModel.user.garAvailable -->
                <div data-bind="foreach: { data: appViewModel.user.garAffectationLinks}">
                    <div>
                    <img data-bind="attr: { src: 'logos/gar-' + name + '.png' }" class="gar">
                    <a data-bind="attr: { href: link }" target="_blank">
                        Accéder au module d'affectation des ressources du GAR
                    </a>
                    </div>
                </div>

                <!-- ko if: appViewModel.user.garAffectationLinks().length == 0 -->
                <div class="text-primary"><i class="fa fa-info fa-2x"></i> Le GAR est en cours d'activation pour au moins un de vos établissements ou il est pour le moment désactivé</div>
                <!-- /ko -->
                
                <!-- /ko -->

                <!-- ko ifnot:  appViewModel.user.garAvailable -->
                <div>
                    <i class="fa fa-exclamation-triangle text-danger"></i> <b>Information sur le Gestionnaire d'Accès aux Ressources (GAR)</b>
                    <div data-bind="foreach: { data: appViewModel.user.context}">
                        <ul>
                            <li><b><span data-bind="text:data.name"></span> : </b> <span data-bind="text:data.garStatus"></span> </li>
                        </ul>
                    </div>
                </div>
                
                <!-- /ko -->

            </div>
            
        </div>
        <!-- /ko -->

    <div class="row">
    
    
        <!--- -- -- -- CATALOGUES -- -- -- ---- -- --->
        <!-- ko if: appViewModel.catalogues().length!=0 -->
        <div id="catalogues-intro" class="col-xs-12 col-sm-12 col-lg-12">
            <h2>Catalogues</h2>
            <p>Vous disposez de <span data-bind="text:appViewModel.catalogues().length"></span> catalogue<span data-bind="visible:appViewModel.catalogues().length>1">s</span> pour compléter vos bibliothèques.</p>
            <p>Voici les <b>dernières</b> ressources qui ont été ajoutées. Cliquez sur le bouton 
            <button type="button" class="btn btn-primary btn-xs ">
                                        <i class="fa fa-plus-circle"/>
                </button> 
            pour les
            ajouter dans les bibliothèques.</p>
        </div>
        
        <div id="catalogues-ressources" data-bind="foreach: { data: appViewModel.catalogues, as: 'catalogue'}">
        <!-- Catalogue -->
        <div class="col-xs-12 col-sm-12 col-lg-12 list-group" >
              <div href="#" class="list-group-item catalogue">
                <h4 class="list-group-item-heading">
                    <i class="fa fa-suitcase fa-fw"></i>
                    <span data-bind="text:data.name"></span> 
                    <button type="button" class="btn btn-success btn-sm pull-right" 
                                     data-bind="click:catalogue.show">
                                    <i class="fa fa-plus-XX"/>Tout voir
                    </button>  
                </h4>
                <p class="list-group-item-text">
                    <small data-bind="html:data.description"></small>
                </p>
                
                <!-- <div xdata-bind="template: { name: 'carousel-template'}"></div> --> 
                
                 <ul  class="ressources rig columns-5" 
                     data-bind="foreach: {data:catalogue.children , as: 'ressource'}">

                    <!-- ko if:  ressource.isProposable() && ressource.actif() && $index() <4 -->
                    <li class="ressource" data-bind="template: { name: 'ressource-template', data: ressource }"></li> 
                    <!-- /ko -->
                </ul>

              </div>
        </div> <!-- fin catalogue -->
        </div>    
 
        <!-- /ko -->
        <!--- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --->
    
        <!--- -- -- -- DERNIERS COMMENTAIRES -- -- -- -- -->
        <div class="col-xs-12 col-sm-6 col-lg-4 lastevals" data-bind="visible:appViewModel.lastEvals().length!=0">
        <div class="col-inner">
            <h2>Derniers commentaires</h2>

            <!-- ko if: appViewModel.lastEvals().length!=0 -->
            <p>
                
                <ul  class="categorie rig columns-5" 
                     data-bind="foreach: {data:appViewModel.lastEvals , as: 'instance'}">

                    <li data-bind="attr: {class: instance.data.idType } ,template: { name: 'instance-template', data: instance }"></li> 
                </ul>
            </p>
            <!-- /ko -->
        </div>
        </div>
        <!--- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --->
        
        <!--- -- -- -- DERNIERS AJOUTS -- -- -- ---- -- - -->
        <div class="col-xs-12 col-sm-6 col-lg-8 lastinstances" 
                    data-bind="visible:appViewModel.hasLastInstances">
            <div class="col-inner">
            <h2>
                <span class="fa-stack fa-lg puce">
                  <i class="fa fa-circle fa-stack-2x"></i>
                  <i class="fa fa-clock-o fa-stack-1x fa-inverse"></i>
                </span>
                Nouveautés
                <button type="button" class="btn btn-success btn-sm pull-right" 
                                     data-bind="click:appViewModel.byDate">
                                    <i class="fa fa-plus-XX"/>Tout voir
                </button>  
            </h2>
            
            <ul  class="categorie rig columns-5" 
                     data-bind="foreach: {data:appViewModel.lastInstances , as: 'instance'}">

                    
                    <li data-bind="attr: {class: instance.data.idType } ,template: { name: 'instance-template', data: instance }"></li> 
            </ul>
            
          </div> 
        </div>
        <!--- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --->
        
        <!-- --- --- -- -- BIBLIOTHEQUES CONTEXTUELLES -- -- -- -->
        
        <div id="libraries-context" 
             data-bind="foreach: { data: appViewModel.librariesContextual}">
            <!-- Library -->
            <div class="col-xs-12 col-sm-12 col-lg-12 list-group" >
                  <div href="#" class="list-group-item library">
                    <h4 class="list-group-item-heading">
                        <i class="fa fa-book fa-fw"></i>
                        <span data-bind="text:data.name"></span> 
                    </h4>
                    <p class="list-group-item-text">
                        <small data-bind="html:data.description"></small>
                    </p>

                     <ul  class="instances rig columns-5 light" 
                         data-bind="foreach: {data:children , as: 'instance'}">
                        
                        <li data-bind="attr: {class: instance.data.idType } , template: { name: 'instance-template', data: instance } "></li> 
                        

                    </ul>
                    
                    <!-- ko if: children().length==0 -->
                        Il n'y a aucune ressource actuellement dans cette bibliothèque.
                        <span data-bind="visible: ! isWritable()">Veuillez contacter l'administrateur de l'établissement pour y ajouter des ressources</span>
                        <div data-bind="visible:  isWritable()">
                            Vous pouvez y ajouter des ressources soit
                            <ul>
                                <li data-bind="click:selectRessources"><a href="#">depuis un catalogue</a></li>
                                <li data-bind="click:createNewRessource"><a href="#">ou créer une nouvelle ressource</a></li>
                            </ul>
                        </div>
                    <!-- /ko -->

                  </div>
            </div> <!-- fin Library -->
        </div> 
        <!--- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --->
        
        
        
        
        <!--- -- -- -- MIEUX NOTES -- -- -- ---- -- --->
        <div style="display:none">
        <div class="col-xs-12 col-sm-6 col-lg-8 bestrating" data-bind="visible:appViewModel.bestRating().length!=0">
         <div class="col-inner">
            <h2>
                <span class="fa-stack fa-lg puce">
                  <i class="fa fa-circle fa-stack-2x"></i>
                  <i class="fa fa-star fa-stack-1x fa-inverse"></i>
                </span>
                Les mieux notées
                <button type="button" class="btn btn-success btn-sm pull-right" 
                                     data-bind="click:appViewModel.byRate">
                                    <i class="fa fa-plus-XX"/>Tout voir
                </button> 
            </h2>
            
            <ul  class="categorie rig columns-5 light" 
                     data-bind="foreach: {data:appViewModel.bestRating , as: 'instance'}">

                    <li data-bind="attr: {class: instance.data.idType } ,template: { name: 'instance-template', data: instance }"></li> 
            </ul>
            
            <!-- <i class="fa fa-hand-o-right"></i> 
                <a href="#" 
                   data-bind="click:appViewModel.byRate" >Voir toutes les ressources, classées par leur notation</a>-->
                
          </div> 
        </div>
        </div>
        <!--- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --->
        
        <!--- -- -- -- TOP VIEW -- -- -- ---- -- --->
        <div class="col-xs-12 col-sm-6 col-lg-8 topview" data-bind="visible:appViewModel.topView().length!=0">
         <div class="col-inner">
            <h2>
                <span class="fa-stack fa-lg puce">
                  <i class="fa fa-circle fa-stack-2x"></i>
                  <i class="fa fa-eye fa-stack-1x fa-inverse"></i>
                </span>
                Les plus visitées
                <button type="button" class="btn btn-success btn-sm pull-right" 
                                     data-bind="click:appViewModel.byView">
                                    <i class="fa fa-plus-XX"/>Tout voir
                </button> 
            </h2>
            
            <ul  class="categorie rig columns-5 light" 
                     data-bind="foreach: {data:appViewModel.topView , as: 'instance'}">

                    <li data-bind="attr: {class: instance.data.idType } ,template: { name: 'instance-template', data: instance }"></li> 
            </ul>
            
            <!-- <i class="fa fa-hand-o-right"></i> 
                <a href="#" 
                   data-bind="click:appViewModel.byView" >Voir toutes les ressources, des plus visitées au moins visitées</a>-->
            
          </div> 
        </div>
        <!--- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --->
        
        <div class="col-xs-12 col-sm-12 col-lg-12">
        </div>

        <!--- -- -- -- BIBLIOTHEQUES -- -- -- ---- -- --->
        <div class="col-xs-12 col-sm-6 col-lg-6" data-bind="visible:appViewModel.AllInstances.children().length!=0">
            <h2>Bibliothèques</h2>
            <p>Vous disposez de <span data-bind="text:appViewModel.libraries().length"></span> bibliothèque<span data-bind="visible:appViewModel.libraries().length>0">s</span>, cliquez sur l'une d'entre elle pour voir les ressources</p>

            <ul data-bind="foreach: { data: appViewModel.libraries, as: 'library'}">
                <li>
                    <div>
                        <a href="#" data-bind="text:library.data.name,click: library.xToogle"></a>
                        <span data-bind="text: library.count, visible: count() != 0 " class="badge"></span>

                    </div>
                    <!-- <span>&nbsp;&nbsp;</span>
                    <small data-bind="text:library.data.description"></small> -->
                </li>
            </ul>
            <i class="fa fa-hand-o-right"></i><a href="#" data-bind="click:appViewModel.byLibraries" >Voir toutes les bibliothèques</a>
        </div>
        <!--- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --->
        
        <!--- -- -- -- CATEGORIES / THEMES -- -- -- ---- -- --->
        <div class="col-xs-12 col-sm-6 col-lg-6" data-bind="visible:appViewModel.categories().length!=1 && appViewModel.AllInstances.children().length!=0 ">
            <h2>Thématiques</h2>
            <p>Les ressources sont classées par thème. Voici, la liste des thèmes</p>

            <ul class="nav" data-bind="foreach: { data: appViewModel.categories, as: 'category'}">
                <li data-bind="visible: category.count() != 0">
                    <div>
                        <i class="fa fa-circle" 
                           data-bind="style: { color: category.color}"></i>
                        <a href="#" data-bind="text:category.data.name,click: category.xToogle"></a>
                        &nbsp;<span data-bind="text: category.count, visible: category.count() != 0 " 
                              class="badge"></span>

                    </div>
                </li>
            </ul>
            <br>
            <i class="fa fa-hand-o-right"></i><a href="#" data-bind="click:appViewModel.byCategories" >Voir toutes les thèmatiques</a>
           
        </div>
        <!--- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --->

        

        
    </div>
    </div>

</script>

<script id="categories-template" type="text/html">
        <!-- <div class="tool">
            <span>Tous</span>
            <span>Aucun</span>
            <span>Inverser</span>
        </div> -->
        <ul class="nav" data-bind="foreach: appViewModel.whCategories.children">
            <li data-bind="css: {  unchecked:!isChecked()},visible: count() != 0">
                <div data-bind="click: xToogle">
                    <span class="fa-stack fa-lg" data-bind="click: toogle">
                      <i class="fa fa-square-o fa-stack-2x"></i>
                      <i data-bind="visible: isChecked" class="fa fa-square"></i>
                      <i data-bind="visible: ! isChecked()" class="fa fa-square-o"></i>
                    </span>
                    <span class='name' data-bind="text: data.name"></span>
                     <span data-bind="text: count, visible: count() != 0 " class="badge pull-right"></span>
                </div>

           </li>
        
        </ul>
</script>

<script id="ressource-template" type="text/html">
        <div data-bind="style: { borderColor: ressource.category.color}">
        <i class="fa fa-square flag" data-bind="style: { color: ressource.category.color}">
        </i>
        <table xdata-bind="click: edit">
        
        <tr>
            <td class="libelle"  data-bind="text: ressource.data.name">

            </td>
        </tr>
        
        
        <tr>
            <td>
            <div class="icone" data-bind="style: { backgroundImage: ressource.bgUrl()}">
                
            </div>

            </td>
        <td class="titre">

        <h3>
        
            
        
            <span data-bind="text: ressource.data.name"></span>
            <button type="button" class="btn btn-primary btn-xs pull-right" 
                                     data-bind="click: ressource.instantiate,visible: ! data.error">
                                        <i class="fa fa-plus-circle"/>
            </button> 
            
            <span data-bind="visible:  data.error,click: ressource.showCatalogue" class="pull-right" style="color:red">
                <i class="fa fa-warning"/>
            <span>

        </h3>
        <p data-bind="html: ressource.data.description"></p>
        </td>
        </tr>
        <tr>
           <td colspan="3" >
                
                <div class="subscribe alert-warning" data-bind="visible:data.subscribe">
                    <span class="fa-stack fa-lg">
                      <i class="fa fa-circle fa-stack-2x"></i>
                      <i class="fa fa-eur fa-stack-1x fa-inverse"></i>
                    </span>
                    Abonnement nécessaire&nbsp;
                    <span data-bind="text: depends()"></span>
                </div>
           
                <button type="button" class="btn btn-default btn-xs pull-right" 
                                     data-bind="click: ressource.access,visible: ! data.error">
                                        Visiter
                </button>
            </td>
        
        </tr>
        
        <tr class="bydate" >
            <td colspan="3" >
                 par <b data-bind="text:data.user.fullname"></b>
                  <span class="timeago" data-bind="attr:{ title: ressource.data.iso8601}"></span>
            </td>
        </tr>
            
        <tr>
            <td colspan="3" class="infos">
                <span >
                     <span class="star toolinfo"
                          data-bind="attr:  { id: 'instance-rating-'+data.id, score: ressource.rate }">
                     </span>

                    <!-- 
                    <span class="pull-right"
                          data-bind="visible: count()!=0,click: ressource.showComments" >
                        <span data-bind="text: count"></span><i class="fa fa-comment-o"></i>
                    </span>
                    -->
                </span>

            </td>
        </tr>
        
       
        </table>


    </div>
</script>


<script id="instance-template" type="text/html">
        <div data-bind="style: { borderColor: category.color}">
        <i class="fa fa-square flag" data-bind="style: { color: category.color}">
        </i>
        <table data-bind="click: display,attr:{'data-name':data.name}" style="width:100%">
        
        <tr>
            <td class="libelle"  data-bind="text: data.name">

            </td>

        </tr>
        
        <tr>
            <td>
            <div class="icone" data-bind="style: { backgroundImage: bgImageUrlStyle}, attr:{title:data.description}"  data-toggle="tooltip" data-placement="bottom">
                
                <!-- ko if: hasRessource() -->
                <div class="ribbon-wrapper-green">
                    <div class="ribbon-green" data-bind="text:data.ressource_name"></div>
                </div>
                <!-- /ko -->
            </div>

            </td>
        <td class="titre">

        <h3><a  target="_blank" data-bind="attr: {href: data.url}, text: data.name"></a></h3>
        <p data-bind="text: data.description"></p>
        </td>
        </tr>
    
        
        <!-- ko if: ! data.garOrigin -->
        <tr class="bydate" >
            <td colspan="3" >
                 par <b data-bind="text:data.user.fullname"></b>
                 <span data-bind="visible: ! appViewModel.isGroupedByLibraries() ||  appViewModel.isAccueil()">dans <a data-bind="click:instance.showLib, text:instance.data.libraryName"></a></span>, <span class="timeago" data-bind="attr:{ title: instance.data.iso8601}"></span>
            </td>
        </tr>
        <!-- /ko -->

         <!-- ko if:  data.garOrigin -->
         <tr class="bydate" >
            <td colspan="3" >
                 <b data-bind="text:data.nomSourceEtiquetteGar"></b>
            </td>
        </tr>
        <!-- /ko -->
       
        
        <!-- ko if: ! data.garOrigin || true -->
        <tr>
            <!-- ko if: data.eval == undefined -->
            <td colspan="3" class="infos">
                <div >

                    <!-- ko if: data.idRessource  -->
                    
                    <div class="idRessource" data-bind="visible:true , text:data.idRessource, attr:{title:data.idRessource  }"></div>

                    <!-- /ko -->

                    <!-- 
                     <span class="star toolinfo" data-container='body'
                          data-toggle="tooltip" data-placement="bottom" 
                          title="Cliquer pour noter cette ressource" 
                          data-bind="click: instance.evaluate, 
                                     attr:  { id: 'instance-rating-'+data.id, score: instance.score }">
                     </span>
                    -->

                     <span class="pull-right" data-bind="visible: access()!=0 && !data.idRessource">
                        <span data-bind="text: access"></span><i class="fa fa-eye"></i>
                     </span>

                    <!-- 
                    <span class="pull-right"
                          data-bind="visible: count()!=0,click: showComments" >
                        <span data-bind="text: count"></span><i class="fa fa-comment-o"></i>
                    </span>
                    -->
                </div>

            </td>
            <!-- /ko -->
        </tr>
        <!-- /ko -->
        
    
        <!-- ko if: data.eval != undefined -->
        <tr>
            <td colspan="3" data-bind="with:instance.data.eval">
                <blockquote class="">
                    <!-- 
                  <small>
                    <span data-bind="text:user"></span>
                    ,<span data-bind="text:created"></span>
                   </small>
                   <span class="star toolinfo" 
                      data-bind="attr: { score: vote }">
                    </span>
                    
                  <div data-bind="text:comment"></div> -->

                   
                  
                </blockquote>
            </td>
        </tr>
        <!-- /ko -->

        

        </table>


    </div>
</script>

<script id="ressources-by-categories-template" type="text/html">

    <div  id="og-grid">
       <div  data-bind="foreach: { data: appViewModel.categoriesVisible, as: 'category'}">  
          <!-- ko if: category.filteredChildren().length != 0 -->     
              <span data-bind="text:category.name"></span>
              <ul  class="categorie rig columns-5" data-bind="foreach: { data: category.filteredChildren, as: 'instance'},
                                                      css: { light: appViewModel.mode()=='icon'},
                                                      visible: category.children().length>0">
                 <!-- ko if: instance.isLibraryVisible() -->                                      
                 <li data-bind="attr: {class: instance.data.idType } ,template: { name: 'instance-template', data: instance }"></li>                                            <!-- /ko -->
              </ul>
          <!-- /ko -->
       </div>
    </div>
    

</script>

<!-- LISTE DES RESSOURCES -->
<script id="ressources3-template" type="text/html">

<div  id="og-grid">

    <div data-bind="foreach: { data: appViewModel.whMain, as: 'group'}" >
        
        <div class="divgroup" data-bind="visible: group.filteredChildren().length>0 || (group.isWritable()&&isChecked())">
            <span  data-bind="text: group.data.name"></span>

            <!-- Block de gestion -->
            
            
            <div class="btn-group pull-left" 
                 data-bind="visible: group.isWritable()">


                <!-- Bouton de gestion de la library -->
                <button type="button" class="btn btn-primary btn-sm pull-right add" data-bind="click:group.gerer" >
                   <i class="fa fa-wrench"></i> 
                </button>&nbsp;

                <!-- Menu de gestion de la library -->
                <!-- <ul class="dropdown-menu" role="menu">
                        <li>
                            <a href="#" data-bind="click:group.selectRessources">
                                <i class="fa fa-plus"></i> Depuis un catalogue
                            </a>
                        </li>
                        <li>
                            <a href="#" data-bind="click: appViewModel.createRessource">
                                <i class="fa fa-star"></i> Créer nouvelle ressource
                            </a>
                        </li>
                        <li class="divider"></li>
                        <li>
                            <a href="#" data-bind="click:group.gerer">
                                <i class="fa fa-wrench"></i> Gérer
                            </a>
                        </li>
                </ul> -->

            </div>
            <!-- Fin du block de gestion -->
        </div>
        
        <ul  class="rig columns-5" data-bind="foreach: { data: group.filteredChildren, as: 'instance'},
                                                  css: { light: appViewModel.mode()=='icon'},
                                                  visible: group.children().length>0">
                        
            <li data-bind="attr: {class: instance.data.idType } ,template: { name: 'instance-template', data: instance },visible:instance.isFiltered"></li>

            <!-- xko if: group.isWritable() && $index()==group.filteredChildren().length -1 -->
           <!-- <li>
                <div style="border-color:white">
                <i class="fa fa-square flag" style="color:white">
                </i>
                <table data-bind=""> 
                    <tr>
                        <td class="libelle">
                            Ajouter
                        </td>
                    </tr>
                    <tr>
                        <td>
                          <a href="#" data-bind="click:group.selectRessources">
                                        <i class="fa fa-plus"></i> Depuis un catalogue
                           </a>  
                           <br>
                           <a href="#" data-bind="click: appViewModel.createRessource">
                                        <i class="fa fa-star"></i> Créer nouvelle ressource
                           </a>
                        </td>
                    </tr>
                </table>
               
            </li> -->
            <!-- /xko -->

        </ul>

         <div  data-bind="visible: group.filteredChildren().length==0 && group.isWritable() && group.isChecked()" class="noressource">
            <br>
            Aucune ressource à afficher dans cette rubrique
            <br>
            <br>
         </div>
    
    </div>

</div>

</script>

<!-- LISTE DES RESSOURCES -->
<script id="ressources2-template" type="text/html">
        <div  id="og-grid">	
        <!--  Pour chaque library -->
        <div data-bind="foreach: { data: librariesVisible, as: 'library'}">
        
            <div class="main" data-bind="visible: library.children().length>0 || library.isWritable()">
                
                <!-- Entete de la lib -->
                <div class="libraryname">
                
                    <i class="fa fa-book"/>
                    <span  data-bind="text: library.name"></span>
                    
                    <!-- Block de gestion -->
                    <div class="btn-group pull-right" 
                         data-bind="visible:library.children().length>0 && library.isWritable()">
                        
                        <!-- Bouton de gestion de la library -->
                        <button type="button" data-toggle="dropdown" 
                                                class="dropdown-toggle btn btn-primary btn-sm pull-right add" >
                           <i class="fa fa-align-justify"></i> 
                        </button>
                        
                        <!-- Menu de gestion de la library -->
                        <ul class="dropdown-menu" role="menu">
                                <li>
                                    <a href="#" data-bind="click:library.selectRessources">
                                        <i class="fa fa-plus"></i> Depuis un catalogue
                                    </a>
                                </li>
                                <li>
                                    <a href="#" data-bind="click: appViewModel.createRessource">
                                        <i class="fa fa-star"></i> Créer nouvelle ressource
                                    </a>
                                </li>
                                <li class="divider"></li>
                                <li>
                                    <a href="#" data-bind="click:library.gerer">
                                        <i class="fa fa-wrench"></i> Gérer
                                    </a>
                                </li>
                        </ul>
                        
                    </div>
                    <!-- Fin du block de gestion -->
                        
                </div>
                <!-- Fin de l'entête -->
                
                <!-- Cadre indiquant q'aucune ressource n'est présente dans la lib -->
                <div data-bind="visible:library.children().length==0 && library.isWritable()">
                    <div class="alert alert-info">Vous ne disposez d'aucune ressource dans cette bibliothèque, cliquer sur   
                        <div class="btn-group" data-bind="visible: isWritable()">
                            <button type="button" data-toggle="dropdown" 
                                                    class="dropdown-toggle btn btn-primary btn-sm add" >
                               <i class="fa fa-plus"> Ajouter</i> 
                            </button>
                        
                            <ul class="dropdown-menu" role="menu">
                                    <li data-bind="css: { disabled: appViewModel.catalogues().length==0}">
                                        <a href="#" data-bind="click:library.selectRessources">
                                            <i class="fa fa-plus"></i> Depuis un catalogue
                                        </a>
                                    </li>
                                    <li><a href="#" data-bind="click: appViewModel.createRessource">
                                        <i class="fa fa-star"></i> Créer nouvelle ressource
                                        </a>
                                    </li>
                            </ul>
                        </div>
                        pour en ajouter.
        
                    </div>
                </div> 
                <!-- fin du cadre -->
                
                <ul  class="rig columns-5" data-bind="foreach: { data: library.filteredChildren, as: 'instance'},
                                                  css: { light: appViewModel.mode()=='icon'},
                                                  visible: library.children().length>0">
                                                  
                   
                                                  
                    <li data-bind="attr: {class: instance.data.idType } ,template: { name: 'instance-template', data: instance }"></li>
            </ul>
            </div>
        </div>
        </div>
    
    </script>

    <script id="evals-elements-template" type="text/html">
        <div class="list-group" data-bind="foreach: evals">
          <a href="#" class="list-group-item">
            <h4 class="list-group-item-heading">
                <span data-bind="text:user"></span>
                <span>, <small data-bind="text: created"></small></span>
                <span class="star toolinfo pull-right" 
                      data-bind="attr: { score: vote }">
                </span>
                
            </h4>
            <blockquote>
            <p class="list-group-item-text" data-bind="text: comment"></p>
            </blockquote>
          </a>
        </div>
    </script>
    
    <!-- Template d'affichage d'une liste d'éléménts simple -->
    <script id="select-ressources-template" type="text/html">
        <table cellpadding="0" cellspacing="0" border="0" class="datatable table table-striped table-bordered">
            <thead>
                <tr>
                    <th></th>
                    <th>Nom</th>
                    <th>Description</th>
                    <th>
                        <div data-bind="template: { name: 'check-elements-template'}" class="check" ></div>
                    </th>
                </tr>
            </thead>
            <tbody data-bind="foreach: children">
                <tr data-bind="attr: { 'data-id': data.id }, visible: ! data.error && actif()">
                    <td><img data-bind="attr: {src: logoUrl()}" class="logo"/></td>
                    <td data-bind="text: data.name"></td>
                    <td>
                        <div  data-bind="text: data.description"></div>
                        <div class="subscribe alert-warning" data-bind="visible:data.subscribe">
                            <span class="fa-stack fa-lg">
                              <i class="fa fa-circle fa-stack-2x"></i>
                              <i class="fa fa-eur fa-stack-1x fa-inverse"></i>
                            </span>
                            Abonnement nécessaire&nbsp;
                            <span data-bind="text: depends()"></span>
                        </div>
                        
                        <div class="form-group" data-bind="visible: hasParams()">
                            <br>
                            <!-- <label for="description" class="col-sm-2 control-label">Paramètres</label> -->
                            
                            <div class="col-sm-10" data-bind="visible: isChecked()">
                              <table data-bind="foreach: params" class="table-striped">
                                <tr>
                                    <td data-bind="text: $data"></td>
                                    <td>&nbsp;&nbsp;</td>
                                    <td><input type="text" type="text" class="form-control param"  
                                                data-bind="attr: {label:$data,name:$data,required:$parent.required,ressourceid:$parent.id}" 
                                                data-validation-required-message="paramètre obligatoire"><p class="help-block"></p>
                                    </td>
                                </tr>
                              </table>
                            </div>
                          </div>
                
                    </td>
                    <td>
                       <div data-bind="template: { name: 'check-element-template'}" class="check" ></div>       
                    </td>
                    
                </tr>
            </tbody>
        </table>      
    </script> 
    
    <!-- Template d'affichage d'une liste d'éléménts simple -->
    <script id="simple-elements-template" type="text/html">
        <table class="datatable table table-striped table-bordered">
            <thead>
                <tr>
                    <th></th>
                    <th>Nom</th>
                    <th>Description</th>
                    <th>Nombre d'éléments</th>
                    <th>Propriétaire</th>
                    <th data-bind="visible: appViewModel.hasMultipleContext">Établissement</th>
                    <th></th>
                </tr>
            </thead>
            <tbody data-bind="foreach: children">
                <tr data-bind="attr: { 'data-id': data.id }">
                    <td>
                       <i data-bind="visible: !isOwner() && isWritable()" class="fa fa-unlock" title=""/> 
                       <i data-bind="visible: !isOwner() && !isWritable()" class="fa fa-lock" title="Accès restreint"/> 
                    </td>
                    <td data-bind="text: name"></td>
                    <td data-bind="html: description"></td>
                    <td data-bind="text: total"></td> 
                    <td data-bind="text: user"></td>
                    <td data-bind="visible: appViewModel.hasMultipleContext, text: displayContext"></td>
                    <td>
                        <i data-bind="click: edit ,visible: isEditable()"  class='fa fa-edit action' action='edit'/>
                        <i data-bind="click: trash,visible: isDeletable()"  class='fa fa-trash-o action' action='trash'/>
                    </td>
                    
                </tr>
            </tbody>
        </table>      
    </script>
    
    <!-- Template d'affichage d'une liste d'éléménts simple -->
    <script id="parameter-elements-template" type="text/html">
        <table class="datatable table table-striped table-bordered">
            <thead>
                <tr>
                    <th>Nom</th>
                    <th>Valeur</th>
                    <th></th>
                </tr>
            </thead>
            <tbody data-bind="foreach: children">
                <tr data-bind="attr: { 'data-id': data.id }">
                    <td data-bind="text: data.name"></td>
                    <td data-bind="text: data.value"></td>
                    <td>
                        <i data-bind="click: edit ,visible: isEditable()"  class='fa fa-edit action' action='edit'/>
                        <i data-bind="click: trash,visible: isDeletable()"  class='fa fa-trash-o action' action='trash'/>
                    </td>
                </tr>
            </tbody>
        </table>      
    </script>    
 
    <!-- Template d'affichage d'une liste d'éléménts simple -->
    <script id="profil-elements-template" type="text/html">
        <table class="datatable table table-striped table-bordered">
            <thead>
                <tr>
                    <th>Nom</th>
                    <th>Conditions</th>
                    <th></th>
                </tr>
            </thead>
            <tbody data-bind="foreach: children">
                <tr data-bind="attr: { 'data-id': data.id },click: edit">
                    <td data-bind="text: data.name"></td>
                    <td data-bind="html: data.human"></td>
                    <td>
                        <i data-bind="click: edit ,visible: isEditable()"  class='fa fa-edit action' action='edit'/>
                        <i data-bind="click: trash,visible: isDeletable()"  class='fa fa-trash-o action' action='trash'/>
                    </td>
                </tr>
            </tbody>
        </table>      
    </script>
    
    <!-- Template d'affichage d'une liste de ressource -->
    <script id="catalogue-elements-template" type="text/html">
        <div data-bind="html:description" class="description"></div>
        
        <!-- CATALOGUE VOLUMINEUX -->
        <div data-bind="visible:isBig" class="big alert-info">
            Ce catalogue contient <b><span data-bind="text:total"></span></b> ressources. <span data-bind="visible: ! filter">Seulement les <b><span data-bind="text:children().length"></span> dernières</b> ressources sont affichées.<br /> Pour affiner l'affichage veuillez utiliser la zone de recherche.</span>
            <span data-bind="visible: filter"><b><span data-bind="text:children().length"></span></b> ressources trouvées</span><br />
            
            <div class="input-group">
                 <input data-bind="value:filter" type="text" class="form-control search" placeholder="rechercher par nom, description, url..." id="query" name="query" value="">
                <div class="input-group-btn">
                    
                    <button type="submit" class="btn btn-success go">
                        <span class="glyphicon glyphicon-search"></span> <span data-bind="visible:! filter">Rechercher</span>
                    </button>
                    <!-- ko if: filter -->
                    <button type="submit" class="btn btn-danger cancel">
                        <span class="glyphicon glyphicon glyphicon-remove"></span>
                    </button>
                    <!-- /ko -->
                </div>
			</div>
        </div>
        <!-- -- -- --- -- --- -- --- -- -- -->
    
        <table class="datatable table table-striped table-bordered catalogue-elements">
            <thead>
                <tr>
                    <th dt-visible="hide"></th>
                    <th></th>
                    <th>Nom</th>
                    <th>Description</th>
                    <th>Proposée par</th>
                    <th>Actif ?</th>
                    <th>Edition</th>
                    <th class='action'>Action</th>
                </tr>
            </thead>
            <tbody data-bind="foreach: { data: children}">
                <tr data-bind="attr: { 'data-id': data.id } , click: edit">
                    <td  data-bind="text:data.since"></td>
                    <td><img data-bind="attr: {'data-original': logoUrl()}" class="logo lazy"/></td>
                    <td><a href="#" data-bind="text: data.name,click: access" ></a></td>
                    <td>
                        <div data-bind="html: data.description"></div>
                        <div><a target="_blank" data-bind="attr: { 'href': data.url }, html: data.url  "></a></div>
                    
                        <div class="subscribe alert-warning" data-bind="visible:data.subscribe">
                            <span class="fa-stack fa-lg">
                              <i class="fa fa-circle fa-stack-2x"></i>
                              <i class="fa fa-eur fa-stack-1x fa-inverse"></i>
                            </span>
                            Abonnement nécessaire&nbsp;
                            <span data-bind="text: depends()"></span>
                        </div>
                        <div class="alert alert-danger" data-bind="visible: data.error">
                            L'url ne peut être correctement évaluée, car les paramètres suivants sont manquants:
                            <ul data-bind="foreach: { data: data.code_in_error, as : 'code'}">
                                <li>
                                    <span data-bind="text:code"></span>
                                    : <a data-bind="visible: appViewModel.user.isAdmin(),click: appViewModel.addParam">Créer</a>
                                    <span data-bind="visible: ! appViewModel.user.isAdmin()">Veuillez contacter l'administrateur</span>
                                </li>
                            </ul>
                            
                        </div>
                    </td>
                    <td data-bind="text: data.user.fullname"></td>
                    
                    <td>
                        <i class="fa fa-check-square fa-2x" 
                            data-bind="click: $data.desactivate, visible: actif() && ! data.error" ></i>
                        <i class="fa fa-square-o fa-2x" 
                            data-bind="click: $data.activate, visible: ! actif() && ! data.error" ></i>
                    </td>
                    
                    <td>
                        <i data-bind="click: trash,visible: isDeletable()"  class='fa fa-trash-o action' action='trash'/>
                         <i data-bind="click: edit ,visible: isEditable()"  class='fa fa-edit action' action='edit'/>
                    </td>
                    
                    <td>
                        <button type="button" data-toggle="tooltip" data-placement="bottom" title="Ajouter à une bibliothèque" class="btn btn-primary btn-sm add" 
                                     data-bind="click: instantiate,visible: ! data.error && actif()">
                                <i class="fa fa-cloud-download"></i>
                        </button>
                        
                    </td>
                </tr>
            </tbody>
        </table>      
    </script>    

    <!-- Template d'affichage d'une liste de ressource -->
    <script id="t2" type="text/html">
        <div data-bind="html:description" class="description"></div>
    
        <table class="datatable table table-striped table-bordered catalogue-elements">
            <thead>
                <tr>
                    <th></th>
                    <th>Nom</th>
                    <th>Description</th>
                    <th>Proposée par</th>
                    <th></th>
                    <th>Actif ?</th>
                    <th class='action'></th>
                </tr>
            </thead>
            <tbody data-bind="foreach: { data: children}">
                <tr data-bind="attr: { 'data-id': data.id } , click: edit">
                   <td><img data-bind="attr: {'data-original': logoUrl()}" class="logo lazy"/></td>
                   <td></td>
                   <td></td>
                   <td></td>
                   <td></td>
                   <td></td>
                   <td></td>
                </tr>
            </tbody>
        </table>      
    </script>    
    
    <script id="check-element-template" type="text/html">
        <div data-bind="click: toogle">
            <span class="fa-stack fa-lg" >
                <i class="fa fa-circle-o fa-stack-2x"></i>
                <i data-bind="visible: isChecked" class="fa fa-check fa-stack-1x"></i>
            </span>
        </div>   
    </script>
    
    <script id="check-elements-template" type="text/html">
        <div>
        <span class="fa-stack fa-lg" data-bind="click: toogleAll" >
            <i class="fa fa-circle-o fa-stack-2x"></i>
            <i data-bind="visible: allSelected" class="fa fa-check fa-stack-1x"></i>
        </span>   
        </div>
    </script>


 
    <!-- Template d'affichage d'une liste de ressource -->
    <script id="library-elements-template" type="text/html">
        <table class="datatable table table-striped table-bordered">
            <thead>
                <tr>
                    <th></th>
                    <th>Nom</th>
                    <th>Description</th>
                    <th>Catalogue</th>
                    <th>Ajouté par</th>
                    <th></th>
                    <th>
                        <div data-bind="template: { name: 'check-elements-template'}" class="check" ></div>
                    </th>
                </tr>
            </thead>
            <tbody data-bind="foreach: children">
                <tr data-bind="attr: { 'data-id': data.id }">
                    <td><img data-bind="attr: {src: data.logo}" class="logo"/></td>
                    <td data-bind="text: data.name"></td>
                    <td>
                        <div data-bind="text: data.description"></div>
                        <a target="_blank" data-bind="attr: { 'href': data.url }, html: data.url  "></a>
                    </td>
                    <td><a data-bind="click: showCatalogue,
                                      text: catalogueName,
                                      visible: catalogue">
                        </a>
                    </td>
                    <td data-bind="text: owner()"></td>
                    <td>
                        <i data-bind="click: edit ,visible: isEditable()"  class='fa fa-edit action' action='edit'/>
                    </td>
                    <td>
                       <div data-bind="visible: isDeletable() ,template: { name: 'check-element-template'}" class="check" ></div>        
                    </td>
                </tr>
            </tbody>
        </table>      
    </script> 

 <script id="etablissement-elements-template" type="text/html">
       
        
       <table class="datatable table table-striped table-bordered etablissement-elements">
           <thead>
               <tr>
                   <th dt-visible="hide"></th>
                  
                   <th>UAJ</th>
                   <th>Nom</th>
                   <th>Nb Utilisateurs</th>

                    <!-- ko if:  appViewModel.garCode -->
                        <!-- ko if:  appViewModel.user.isAdmin()  -->
                        <th>Activer le GAR ?</th>
                        <!-- /ko -->
                   <th>Etat du GAR</th>
                   <!-- <th>Ressources GAR</th> -->
                   <!-- /ko -->
                   

                   <th class='action'>Action</th>
               </tr>
           </thead>
           <tbody data-bind="foreach: { data: children}">
               <tr data-bind="attr: { 'data-id': data.id }">
                  <td></td>
                 
                  <td data-bind="text: data.tag"></td>
                  <td >
                    <!-- ko if:  appViewModel.garCode -->
                       <!-- ko if: actif -->
                       <i  data-bind="attr: {class:  'fa '+ data.garIcon  }"></i> 
                       <!-- /ko -->
                     
                        <!-- ko ifnot: actif -->
                        <i  data-bind="attr: {class:  'fa '+ data.garIcon  }" style="opacity: 0.08"></i> 
                        <!-- /ko -->
                    <!-- /ko -->

                    <span data-bind="text: data.name"></span>
  
                  </td>
                  <td data-bind="text: data.nbusers" ></td>
                  
                   <!-- ko if:  appViewModel.garCode -->

                    <!-- ko if:  appViewModel.user.isAdmin()   -->
                    <!-- CE CODE NE MARCHE PAS data-bind="attr: {'data-order': actif()?'AOUI':'BNON'}" -->
                    <td >
                        
                            <!-- ko if: data.activable -->
                            <i class="fa fa-check-square fa-2x"
                                data-bind="click: $data.desactivate, visible: actif() && ! loading() && ! data.error, attr:{title: 'Cliquer ici pour désactiver le GAR de '+data.garConfig }" >
                            </i>
                            <i class="fa fa-square-o fa-2x" 
                                data-bind="click: $data.activate, visible: !  actif() && ! loading() && ! data.error, attr:{title: 'Cliquer ici pour activer le GAR de '+data.garConfig }" >
                            </i>
                            <i class="fa  fa-2x fa-spin fa-spinner" data-bind="visible: loading()"></i>
                            <!-- /ko -->

                    </td>
                    <!-- /ko -->
                    <td data-bind="html: garStatus"></td>
                    <!-- <td>

                        <span data-bind="html:data.garRessources + ' ressource(s)', visible: actif()"></span>
                    </td>
                    -->
                  <!-- /ko -->

                  <td>

                    
                    <button type="button" data-toggle="tooltip" data-placement="bottom" 
                    title="Gérer les Responsables d'affectations" class="btn btn-primary btn-sm add" 
                                data-bind="click: showUsers,visible: ! data.error">
                            <i class="fa fa-user-plus"></i>
                    </button>

                    <button type="button" data-toggle="tooltip" data-placement="bottom" 
                    title="Voir les ressources" class="btn btn-primary btn-sm" 
                                data-bind="click: ressources,visible: ! data.error">
                            <i class="fa fa-book"></i> 
                    </button>

                    <!-- ko if:  appViewModel.user.isAdmin() -->
                    <button type="button" data-toggle="tooltip" data-placement="bottom" 
                    title="Edition" class="btn btn-default btn-sm add" 
                                data-bind="click: edit,visible: ! data.error">
                            <i class="fa fa-edit"></i>
                    </button>
                    <!-- /ko -->

                    </td>
                  

               </tr>
           </tbody>
       </table>      

</script>

    <script id="users-template" type="text/html">
            <div>
                Liste des personnes qu'il est possible de désigner <b>'Responsable d'affectation'</b>des ressources du GAR<br>
                <b>NOTE</b> Il est nécessaire que les personnes se soient déjà connectées au moins une fois à eConnect pour qu'elles apparaissent dans cette liste.
            </div>
            <br>
            <table class="datatable table table-striped table-bordered users-elements">
           <thead>
               <tr>
                   <th dt-visible="hide"></th>
                   <th></th>
                   <th>NOM Prénom</th>
                   <th>Profil</th>
                   <th>Resp. Affectation GAR ?</th>
                   <th class='action'>Action</th>
               </tr>
           </thead>
           <tbody data-bind="foreach: { data: children}">
               <tr data-bind="attr: { 'data-id': data.id } , click: edit">
                  <td></td>
                  <td></td>
                  <td data-bind="text: data.fullname"></td>
                  <td data-bind="text: data.profil"></td>
                  <!-- data-bind="attr: {'data-order': garAdmin()?'AOUI':'BNON'}" -->
                  <td>
                    <!-- ko if: canSetGarAdmin() -->
                        <!-- ko if: garPossibleUser -->
                        <i class="fa fa-check-square fa-2x" 
                            data-bind="click: $data.desactivate, visible: garAdmin() && ! data.error" >
                        </i>
                        <i class="fa fa-square-o fa-2x" 
                            data-bind="click: $data.activate, visible: !  garAdmin() && ! data.error" >
                        </i>
                        <!-- /ko -->
                    <!-- /ko -->

                    <!-- ko ifnot: canSetGarAdmin()  -->
                        <i class="fa fa-check-square fa-2x text-muted" 
                            data-bind="click: $data.nothing , visible: garAdmin() && ! data.error" >
                        </i>
                        <i class="fa fa-square-o fa-2x text-muted" 
                            data-bind="click: $data.nothing ,visible: ! garAdmin() && ! data.error" >
                        </i>
                    <!-- /ko -->

                  </td>
                  <td>
                  

                  </td>
               </tr>
           </tbody>
       </table>      
</script>

 <script id="gar-accrochage-template" type="text/html">

    <h1 class="title">Guide et vérification de l'accrochage avec <span data-bind="html: '\''+data.description+'\''" class="exergue"></span> </h1>

    <p>


    </p>

    <h2>Actions à mener</h2>
    <hr>
    <ul class="checklist">
        <li>Remplir le dossier d'inscription</li>
        <li>
            Prendre connaissance de la documentation et notamment du Référentiel techinique, fonctionnel et de sécurité (RTFS).
            <a href="https://gar.education.fr/medias/fichier/gar-rtfs-informations-generales-v4-0_1522757991639-pdf" target="_blank">
            RTFS V4.0 - Référentiel Technique et Fonctionnel de Sécurité
            </a>
        </li>
        <li>Communiquer à Renater (via Mantis ) les prérequis qui se trouvent plus bas</li>
        <li>Intégrer le certificat reçu par Renater (voir plus bas, <b>Certificat pour interrogation du WebService</b>)</li>
        <li>
            Configurer le serveur SSO <br>
            Voici la commande à lancer sur le serveur SSO
            <br>
            <code class="block">
            bash <(curl -sF token=<span data-bind="text:appViewModel.user.data.gar.token"></span> \<br>
            <span data-bind="text:appViewModel.user.data.gar.api"></span><span data-bind="text:data.tag"></span>/setup/sso ) <br>
            </code>
            </code>
        </li>
        
        <!-- 
        <li>
            Déposer les fichiers GAR sur le dépôt sftp
            <br>
            <code class="block">
            curl  <span data-bind="text:appViewModel.user.data.gar.api"></span><span data-bind="text:data.tag"></span>/archive \<br>
-F token=<span data-bind="text:appViewModel.user.data.gar.token"></span> \<br>
-F md5=&lt;md5_de_l_archive&gt; \<br>
-F log=@&lt;log_construction_archive.xml&gt; \<br>
-F archive=@&lt;nom_de_l_archive.tar.gz&gt;<br>
            </code>
            <br>
            <br>
            <code>
                <b>NOTE:</b> <br>
                    &lt;nom_de_l_archive.tar.gz&gt; est à remplacer par le nom de votre archive GAR (cf RTFS)<br>
                    &lt;md5_de_l_archive&gt; est à remplacer par le md5 de votre archive GAR<br>
                    &lt;log_construction_archive.xml&gt; est à remplacer par le fichier log du script aaf2gar.sh<br>
            </code>
        </li>
-->
        <li>
            AAF2GAR
            <br>
            <code class="block">
            bash <(curl -sF token=<span data-bind="text:appViewModel.user.data.gar.token"></span> \<br>
            <span data-bind="text:appViewModel.user.data.gar.api"></span><span data-bind="text:data.tag"></span>/setup/aaf2gar.sh ) <br>
            </code>
            <br><br>
            <code class="block">
            cd aaf2gar-<span data-bind="text:data.tag"></span>
            </code>
            <br></br>
            <code class="block">
            ./aaf2gar.sh <span style='color:#ABABAB'>[--aaf-path=/appli/aaf/extraction/ENT2D/]</span> \<br>
            <span style='color:#ABABAB'>[--tmp-path=/tmp/GAR/TMP/] [--gar-path=/tmp/GAR/XML/]</span>
            </code>


        </li>
    </ul>

    
    <h2>Prérequis à fournir par le projet ENT à RENATER</h2>
    <hr>

    <!-- ko if: data.public -->
    <dl class="dl-horizontal">
        <dt>URL des métadonnées SAML</dt>
        <dd>
            <a data-bind="attr: { 'href': data.public.metadata }, html: data.public.metadata " target="_blank"></a>
        </dd>
        <dt>CSR (Certificate Signing Request)</dt>
        <dd>
            <a data-bind="attr: { 'href': data.public.csr }, html: data.public.csr " target="_blank"></a>
        </dd>
        <dt>Clé publique SSH pour accès au SFTP </dt>
        <dd>
            <a data-bind="attr: { 'href': data.public.pubkey }, html: data.public.pubkey " target="_blank"></a>
        </dd>
    </dl>
    <!-- /ko -->

    <!-- ko if: data.renater -->
    <h2>Prérequis fournis par RENATER </h2>
    <hr>

    <dl class="dl-horizontal">
        <dt>URL des métadonnées SAML pour l’accès aux ressources</dt>
        <dd>
            <a data-bind="attr: { 'href': data.renater.samlRes }, html: data.renater.samlRes " target="_blank"></a><br>
            <span class="text-muted">entityID=<span data-bind="html: data.renater.samlResEntityID"></span> </span>
        </dd>
        <dt>URL des métadonnées SAML pour le module d'affectation</dt>
        <dd>
            <a data-bind="attr: { 'href': data.renater.samlAff }, html: data.renater.samlAff " target="_blank"></a><br>
            <span class="text-muted">entityID=<span data-bind="html: data.renater.samlAffEntityID"></span> </span>
        </dd>

        <dt>Certificat pour interrogation du WebService </dt>
        <dd  data-bind="css: certificatStatus">
            
                <!-- ko if: data.renater.pem -->
                    <!-- ko if: certificatIsOk -->
                        <span id="pemOK" class="success"> Certificat intégré </span>
                        <a data-bind='{ attr: {href: appViewModel.user.data.gar.publicapi + data.tag +"/pem"} }' target="_blank">[télécharger]</a>
                    <!-- /ko -->
                    
                    <!-- ko ifnot:certificatIsOk -->
                    <span id="pemOK" class="error"> Certificat incorrect </span>
                    <button class="btn-primary btn-file" target="#pem">
                        <span>Renseigner un autre certificat</span>
                    </button>
                    <!-- /ko -->
                <!-- /ko -->

                <!-- ko ifnot: data.renater.pem -->
                <span id="pemOK" class="hidden success"> Certificat intégré </span>
                <button class="btn-success btn-file" target="#pem">
                    <span>Ajouter le certificat .PEM donné par Renater</span>
                </button>
                
                <!-- /ko -->

                <input id="pem" accept="application/x-pem-file" type="file"  class="hidden" ></input>
            
            
        </dd>
      
    </dl>
    <!-- /ko -->

    <!-- ko if: data.check -->
    <h2>
        Vérification de l'accrochage
        <button class="btn btn-default" id="refreshGar"><i class="fa fa-refresh"></i> Vérifier de nouveau </button>
    </h2>
    <hr>

    <dl class="dl-horizontal">
        <dt>
            Accès au dépôt de fichier
        </dt>
        <dd data-bind="css: depot().status">
            <span data-bind="html: depot().message, css: depot().status "></span> 
            (<span data-bind="html: data.renater.depot"></span>)
            <div data-bind="html: 'Vérifié le ' +  new Date(depot().date*1000) " class="small text-muted"></div> 
        </dd>

        <dt>
            Intégration des fichiers
        </dt>
        <dd data-bind="css: archive().status">
            <!-- ko if:  ! archive()['aaf2gar-error'] -->
            <span data-bind="html: archive().message, css: archive().status "></span> 
            <!-- /ko -->

            <!-- ko if: archive().status == "waiting"  -->
            <br>
            <!-- /ko -->

            <!-- ko if: archive().name && ! archive()['aaf2gar-error']  -->
            <!-- (<a data-bind="html: archive().name  "></span>) -->
            (<a data-bind='{ attr: {href: "upload/"+ data.id +"/ERREUR/" + archive().name},  html: archive().name   }' target="_blank"></a> )
            <!-- /ko -->
            <!-- ko if: archive().status != "inconnu" && log().name == archive().name  && ! archive()['aaf2gar-error'] -->
            <button class="btn btn-default" data-bind="click: showLog"><i class="fa fa-list"></i> Voir le log de génération des fichiers GAR</button>
            <!-- /ko -->

             <!-- ko if:  archive()['aaf2gar-error'] -->
             <button class="btn btn-danger btn-xs" data-bind="click: showLog">
                <i class="fa fa-exclamation-triangle"></i> 
                <span data-bind="html: archive().message  + ', <br> consulter le log du ' + new Date(archive().date*1000)  "></span>
            </button>
            <!-- /ko -->

            <!-- ko if:  ! archive()['aaf2gar-error']  && ! archive().status == "waiting" -->
            <div data-bind="html: 'Vérifié le ' + new Date(archive().date*1000) " class="small text-muted"></div> 
            <!-- /ko -->

            

        </dd>

        <dt>
            Vérification du certificat
        </dt>
        <dd data-bind="css: certificat().status">
            <span data-bind="html: certificat().message, css: certificat().status "></span> 
        </dd>

        <dt>
            Intégration des métadonnées RENATER pour l’accès aux ressources
        </dt>
        <dd data-bind="css: samlRes().status">
            <span data-bind="html: samlRes().message, css: samlRes().status "></span> 
            <div class="small text-muted"><span data-bind="html: samlRes().infos"></span> </div>
        </dd>

        <dt>
            Intégration des métadonnées RENATER pour le module d'affectation
        </dt>
        <dd data-bind="css: samlAff().status">
            <span data-bind="html: samlAff().message, css: samlAff().status "></span> 
            <div class="small text-muted"><span data-bind="html: samlAff().infos"></span> </div>
        </dd>

        <!-- 
        <dt>
            Heure du serveur SSO
        </dt>
        <dd data-bind="css: certificatStatus">
            <span data-bind="html: data.check.certificat.message, css: certificatStatus "></span> 
        </dd>
        -->


    </dl>
    <!-- /ko -->

    <h2>API eConnect </h2>
    <hr>
    <dl class="dl-horizontal">
        <dt class="big">Liste des UAJ activés</dt>
        <dd class="big">
            <a data-bind='{ attr: {href: appViewModel.user.data.gar.api + data.tag +"/uajs"},  html: appViewModel.user.data.gar.api + data.tag +"/uajs"  }' target="_blank"></a>
        
            <br>
            Accès via CURL<br>
            <code class="block">
            curl  <span data-bind="text:appViewModel.user.data.gar.api + data.tag + '/uajs' " ></span> \<br>
-F token=<span data-bind="text:appViewModel.user.data.gar.token"></span>
            </code>

        </dd>
        <dt class="big">Liste des responsables d'affectations</dt>
        <dd class="big">
            <a data-bind='{ attr: {href: appViewModel.user.data.gar.api + data.tag +"/respAff"},  html: appViewModel.user.data.gar.api + data.tag +"/respAff"  }' target="_blank"></a>
            
            <br>
            Accès via CURL<br>
            <code class="block">
            curl  <span data-bind="text:appViewModel.user.data.gar.api + data.tag + '/respAff' " ></span> \<br>
    -F token=<span data-bind="text:appViewModel.user.data.gar.token"></span>
            </code>

        </dd>
        <dt class="big">Vérification de l'état du GAR</dt>
        <dd class="big">
            <a data-bind='{ attr: {href: appViewModel.user.data.gar.api + data.tag +"/check"},  html: appViewModel.user.data.gar.api + data.tag +"/check"  }' target="_blank">
            </a>
        </dd>

    </dl>

    <br><br><br>



 </script>

 <script id="gar-elements-template" type="text/html">

            <!-- ko if: appViewModel.garCode -->
            <div>
                Code projet ENT : <span data-bind="text: appViewModel.garCode"></span> (Académie <span data-bind="text: appViewModel.garAcademie"></span>)
                <br>
                <hr>

            </div>

            <table class="datatable table table-striped table-bordered users-elements">
           <thead>
               <tr>
                   <th dt-visible="hide"></th>
                   <th></th>
                   <th>NOM</th>
                   <th>Description</th>
                   <th>Etat d'accrochage</th>
                   <th class='action'>Action</th>
               </tr>
           </thead>
           <tbody data-bind="foreach: { data: children}">
               <tr data-bind="attr: { 'data-id': data.id } ">
                  <td></td>
                  <td>
                    <i data-bind="attr: {class : 'fa '+data.icon}"></i> 
                  </td>
                  <td data-bind="text: data.tag"></td>
                  <td data-bind="text: data.description"></td>
                  <!-- ko if: actif()  -->
                  <td>
                        <!-- ko if: globalStatus().status == "success" -->
                            <i class="fa fa-2x fa-check-circle text-success"></i> 
                            <span class=" text-success">pas de problème détecté</span>
                        <!-- /ko -->

                        <!-- ko if: globalStatus().status == "waiting" -->
                            <i class="fa fa-2x fa-clock-o text-warning"></i> 
                            <span class="text-warning" data-bind="html:globalStatus().message"></span>
                            <!-- ko if: globalStatus().name -->
                            <div class="text-muted small" data-bind="html:globalStatus().name"></div>
                            <!-- /ko -->
                        <!-- /ko -->

                        <!-- ko if: globalStatus().status == "error" -->
                            <i class="fa fa-2x fa-times text-danger"></i> 
                            <span class="error" data-bind="html:globalStatus().message"></span>
                            <!-- ko if: globalStatus().name -->
                            <div data-bind="html:globalStatus().name"></div>
                            <!-- /ko -->
                        <!-- /ko -->

                        <!-- ko if: globalStatus().status == "inconnu" -->
                            <i class="fa fa-2x fa-exclamation inconnu"></i> 
                            <span data-bind="html:globalStatus().message" class="text-muted"></span>
                        <!-- /ko -->

                  </td>
                  <!-- /ko -->
                  <!-- ko if: !actif()  -->
                  <td>
                    Non actif
                  </td>
                  <!-- /ko -->
                  <td>
                        <!-- ko if:  appViewModel.user.isAdmin() -->
                        <button type="button" data-toggle="tooltip" data-placement="bottom" 
                           class="btn btn-primary" data-bind="click: accrochage, visible: ! data.error, attr:{ href:'#gars/'+ data.id + '/accrochage'  }">
                                Voir la checklist d'accrochage
                        </button>
                        <!-- /ko -->

                        <!-- ko if:  appViewModel.user.isAdmin() -->
                        <button type="button" data-toggle="tooltip" data-placement="bottom" 
                          title="Edition" class="btn btn-link add" 
                                     data-bind="click: edit, visible: ! data.error">
                                <i class="fa fa-edit"></i>
                        </button>
                        <!-- /ko -->
                        
                  </td>
               </tr>
           </tbody>
       </table>   
        <!-- /ko -->

        <!-- ko ifnot: appViewModel.garCode -->
        <h2>Bienvenue dans la configuration de votre accès au GAR</h2>
        <hr>
        <div>
            <h3>LE GAR, C’EST QUOI ?</h3>
            <p>
            Le <b>G</b>estionnaire d’<b>A</b>ccès aux <b>R</b>essources accompagne le développement des usages des ressources numériques à l’École. <br>
            Il garantit la protection des données à caractère personnel des élèves et des enseignants.
            </p>
            <ul>
                <li>C’est un service gratuit proposé par le Ministère de l’Éducation nationale et opéré par RENATER.</li>
                <li>Il mobilise l’ensemble des acteurs dans un cadre juridique simplifié pour les établissements.</li>
            </ul>
            <br>
            Plus d'informations sur le site <a href="https://gar.education.fr/" target="_blank">https://gar.education.fr/</a>

            <h3>Et eConnect dans tout ça ?</h3>
            <p>
            eConnect va permettre de faciliter 
            <ul>
            <li>L'interconnexion avec le GAR. Et notament le paramétrage de l'authentification unifiée (SSO)</li>
            <li>Le transfert des données (elèves/enseignants/structures), dans un cadre de confiance</li>
            <li>La présentation des ressources aux usagers ( Le Médiacentre )</li>
            </ul>

            <h3>Comment avoir accès au GAR au travers de eConnect</h3>
            <p>
                La mise en oeuvre de l'interconnexion du GAR avec eConnect est réalisée dans le cadre de la mutualisation <a href="https://ent-envole.com/" target="_blank">Envole</a>.<br>
                Pour mettre en place le service GAR, les porteurs de projet de votre ENT (collectivités, académies) doivent prendre l'attache de la Direction du numérique pour l'éducation (DNE).<br>
                Après validation du principe d'intégration au GAR, les porteurs de projet ENT recevrons un dossier administratif d’inscription à remplir et à renvoyer à la DNE<br>
                Après validation de ce dossier administratif, veuillez renseigner les paramètres suivants (paramètres à renseigner dans le dossier administratif).
                
                <form class="form-horizontal" role="form">

                    <div class="form-group">        
                        <label for="name" class="col-sm-2 control-label">Code projet ENT</label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="Veuillez renseigner le code de votre projet ENT" required  id="garParamCode" pattern="[A-Z,0-9]{2}" class="form-control">   
                            <span class="text-muted">
                            <i class="fa fa-exclamation"></i>  Chaque projet ENT est identifié par le code du porteur de projet correspondant. 
                            Ce code est défini par le SDET, il est de la forme une lettre et un chiffre ( Ex: W4 )</span> 
                        </div>
                    </div>

                    <div class="form-group">        
                        <label for="name" class="col-sm-2 control-label">Votre académie</label>
                        <div class="col-sm-10">
                            <select class="form-control" id="garParamAcademie">
                                <option value="">Veuillez choisiz votre académie</option>
                                <option value="Academie d'Aix-Marseille">Aix-Marseille</option>
                                <option value="Academie de Besançon">Besançon</option>
                                <option value="Academie de Créteil">Créteil</option>
                                <option value="Academie de Dijon">Dijon</option>
                                <option value="Academie de La Réunion">La Réunion</option>
                                <option value="Academie d'Orléans-Tours">Orléans-Tours</option>
                                <option value="Academie de Poitiers">Poitiers</option>
                                <option value="Academie de Reims">Reims</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="name" class="col-sm-2 control-label"></label>
                        <div class="col-sm-10">
                            <span class="text-danger"><i class="fa fa-exclamation-triangle"></i> 
                                Attention ces paramètres seront utilisés pour l'initialisation du GAR dans eConnect (Certificats, clefs sftp, SSO... ) <br> 
                                ils ne pourront être modifiés par la suite</span>
                        </div>
                    </div>

                    <div class="text-right">
                        <button class="btn btn-primary" id="btnConfigureGar"> Valider ces paramètres d'initialisation</button>
                    </div>

                </form>

            </p>

        </div>
        <!-- /ko -->

</script>

<script id="context-ressources-template" type="text/html">
<table class="datatable table table-striped table-bordered users-elements">
           <thead>
               <tr>
                   <th dt-visible="hide"></th>
                   <th></th>
                   <th>Nom</th>
                   <th>Description</th>
                   <th>Nb click 
                    <span data-bind="visible: appViewModel.user.canAdmin() || appViewModel.user.isGestAcad()">
                    (etab / académique )
                    </span>
                   </th>
               </tr>
           </thead>
           <tbody data-bind="foreach: { data: children}">
               <tr>
                  <td></td>
                  <td>
                  <div class="icone" data-bind="style: { 'height': '70px', 'backgroundImage': 'url('+data.logo+')'}"></div>
                  </td>
                  <td data-bind="text: data.name"></td>
                  <td data-bind="text: data.description"></td>
                  
                  <td>
                    <span data-bind="text: data. accessContext"></span> 
                    <span data-bind="visible: appViewModel.user.canAdmin() || appViewModel.user.isGestAcad()">
                        / <span data-bind="text: data. accessTotal"></span>
                    </span>

                  </td>
               </tr>
           </tbody>
       </table>      
</script>