<!DOCTYPE html>
<html>

	<? require_once dirname(__FILE__).'/head.php'; ?>	

	<body>
		<div class="container">
			<div class="row">
				<? require_once dirname(__FILE__).'/sidebar.php'; ?>

				<div class="col-lg-10">
					<h1>Migration Owncloud vers Nextcloud</h1>
					<p class="lead">Migration des fichiers stockés d'Owncloud vers Nextcloud</p>
					<div class="alert alert-info">
						<p><strong>Important !</strong></p>
						<span>Cet outil de migration permet de copier les fichiers d'Owncloud vers Nextcloud.</span><br/>
						<span>Les partages ainsi que les calendriers ne seront pas prises en compte dans cette migration.</span><br/>
						<span>Si un utilisateur posséde déjà des fichiers sur Nextcloud ces derniers seront supprimés par ceux d'Owncloud.</span><br/>
						<span>Vous devez disposer de suffisament de place pour réaliser une copie du répertoire /home/www-data/var/www/html/owncloud</span><br/>
						<span>Il est vivement conseillé d'effectuer les traitements en respectant l'ordre ci-dessous</span>

					</div>
					<div style="padding-left: 1.2rem;border-left: 5px solid #0069D9;">
						<div class="row">
							<div class="col-4 center-wrapper col-blue">
								<button type="button" class="btn btn-primary" id="btn-cronowncloud" data-mig="mig-cronowncloud">Cron Owncloud</button>
							</div>
							<div class="col-8 col-blue">
								<ul class="fa-ul" id="ul-mig-cronowncloud">
									<li><i class="fa-li fa fa-square"></i>Execution tâches planifiées Owncloud</li>
								</ul>
							</div>
						</div>
						<div class="row">
							<div class="col-4 center-wrapper col-blue">
								<button type="button" class="btn btn-primary" id="btn-cronnextcloud" data-mig="mig-cronnextcloud">Cron Nextcloud</button>
							</div>
							<div class="col-8 col-blue">
								<ul class="fa-ul" id="ul-mig-cronnextcloud">
									<li><i class="fa-li fa fa-square"></i>Execution tâches planifiées Nextcloud</li>
								</ul>
							</div>
						</div>	

						<div class="row">
							<div class="col-4 center-wrapper col-blue">
								<button type="button" class="btn btn-primary" id="btn-movenextcloud" data-mig="mig-movenextcloud">Move</button>
							</div>
							<div class="col-8 col-blue">
								<ul class="fa-ul" id="ul-mig-movenextcloud">
									<li><i class="fa-li fa fa-square"></i>Déplacement des fichiers d'Owncloud vers Nextcloud</li>
								</ul>
							</div>
						</div>						

						<div class="row">
							<div class="col-4 center-wrapper col-blue">
								<button type="button" class="btn btn-primary" id="btn-purgeowncloud" data-mig="mig-purgeowncloud">Purge</button>
							</div>
							<div class="col-8 col-blue">
								<ul class="fa-ul" id="ul-mig-purgeowncloud">
									<li><i class="fa-li fa fa-square"></i>Purge les fichiers d'Owncloud </li>
								</ul>
							</div>
						</div>						

						<div class="row">
							<div class="col-4 center-wrapper col-blue">
								<button type="button" class="btn btn-primary" id="btn-scanowncloud" data-mig="mig-scanowncloud">Scan Owncloud</button>
							</div>
							<div class="col-8 col-blue">
								<ul class="fa-ul" id="ul-mig-scanowncloud">
									<li><i class="fa-li fa fa-square"></i>Scan les fichiers d'Owncloud </li>
								</ul>
							</div>
						</div>

						<div class="row">
							<div class="col-4 center-wrapper col-blue">
								<button type="button" class="btn btn-primary" id="btn-scannextcloud" data-mig="mig-scannextcloud">Scan Nextcloud</button>
							</div>
							<div class="col-8 col-blue">
								<ul class="fa-ul" id="ul-mig-scannextcloud">
									<li><i class="fa-li fa fa-square"></i>Scan les fichiers de Nextcloud </li>
								</ul>
							</div>
						</div>
					</div>
				</div>			
			</div>
		</div>

		<div class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" id="resultMigration">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Résultats de la migration</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
					</div>
					<div class="modal-body">
						<p></p>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
					</div>
				</div>
			</div>
	  	</div>
		<script src="js/jquery.min.js"></script>
		<script src="js/popper.js"></script>
		<script src="js/bootstrap.min.js"></script>
		<script>
		$(document).ready(function() {			

			$( "button[id^='btn-']" ).click(function() {
				var $this = $(this);
				var old_text = $this.html();

				$('.modal-body').html("");
				$this.html('<i class="fa fa-cog fa-spin fa-lg fa-fw"></i> '+old_text);

				$("button[id^='btn-']").each(function(index) {
					$(this).prop("disabled",true);
				});

				var dataMig = $this.data("mig");			
				
				$.post("trt-owncloud.php", { action: dataMig })
				.done(function(data) {
                    console.log(data);
					var parsedData = $.parseJSON(data);
					if(parsedData.error == 0) {
						$("#ul-"+dataMig+" li i.fa-square").each(function( index ) {
							$(this).toggleClass('fa-square fa-check-square');
						});
					}
					$('.modal-body').html("<p>"+parsedData.msg+"</p>");
					$('#resultMigration').modal('show');
					$this.html(old_text);

					$("button[id^='btn-']").each(function(index) {						
						$(this).prop("disabled",false);
					});
				})
				.fail(function(xhr, status, error) {
					console.log(xhr);
					console.log(status);
					console.log(error);
				});
			});
		});
		</script>
	</body>
</html>