<?php
require_once dirname(__FILE__).'/config/config-db-poshprofil.php';
require_once dirname(__FILE__).'/config/config-db-eportail.php';
require_once dirname(__FILE__).'/config/config-db-posh.php';
require_once dirname(__FILE__).'/config/config.php';
require_once dirname(__FILE__).'/sql-poshprofil.php';
require_once dirname(__FILE__).'/sql-eportail.php';
require_once dirname(__FILE__).'/sql-posh.php';
?>
<!DOCTYPE html>
<html>

	<? require_once dirname(__FILE__).'/head.php'; ?>	

	<body>
		<div class="container">
			<div class="row">
				<? require_once dirname(__FILE__).'/sidebar.php'; ?>

				<div class="col-lg-10">
					<h1>Migration Posh vers ePortail</h1>
					<p class="lead">Copie et manipulation des données de posh + posh-profil pour retrouver son environnement dans ePortail.</p>
					<div class="alert alert-info">
						<p><strong>Important !</strong></p>
						<span>Cet outil de migration permet de copier les données de posh-profil et de posh pour les insérer dans ePortail.</span><br/>
						<span>Cette migration s'effectue sur un ePortail vierge, indispensable pour éviter les doublons d'id. Chaque traitement est précédé d'une purge de la table qui va reçevoir les données.</span><br/>
						<span>Les tables de posh-profil et de posh ne seront pas alterées.</span><br/>
						<span>Certains traitements (ex : posh - Onglets / Pages) peuvent durer plusieurs minutes en fonction de la quantité de données à migrer (la mémoire allouée à PHP est forcée à 256M et le timeout des scripts d'exécution à 300 secondes dans la page de traitement).</span><br/>
						<span>Vous pouvez consulter la console de votre navigateur pour voir d'éventuelles erreurs.</span><br/>
						<span>Il est vivement conseillé d'effectuer les traitements en respectant l'ordre ci-dessous :</span>
					</div>
					<div class="alert alert-info">
						<p><strong>Paramètres</strong></p>
						<span>Dossier e-portail : <?php echo dirname(getcwd()).'/'.$eportail_folder;?></span><br/>
						<span>Dossier posh : <?php echo dirname(getcwd()).'/'.$posh_folder;?></span><br/>
						<span>Proxy :
						<?php
						if($proxy_adresse != '' && $proxy_port != '') {
							echo $proxy_adresse.":".$proxy_port;
						} else {
							echo 'Aucun proxy configuré.';
						}
						?></span><br/>
						<span>Base de données posh : <?php if($bdd_posh instanceof PDO) { echo "<span style='color:green;'>OK</span>"; } else { echo "<span style='color:red;'>KO</span>"; } ?></span><br/>
						<span>Base de données e-portail : <?php if($bdd_eportail instanceof PDO) { echo "<span style='color:green;'>OK</span>"; } else { echo "<span style='color:red;'>KO</span>"; } ?></span><br/>
						<span>Base de données posh-profil : <?php if($bdd_poshprofil instanceof PDO) { echo "<span style='color:green;'>OK</span>"; } else { echo "<span style='color:red;'>KO</span>"; } ?></span>
					</div>
					<div style="padding-left: 1.2rem;border-left: 5px solid #0069D9;">
						<div class="row">
							<div class="col-12">
								<span style="font-size:22px;color:#0069D9;">posh-profil</span>
							</div>
						</div>
						<div class="row">
							<div class="col-4 center-wrapper col-blue">
								<button type="button" class="btn btn-primary" id="btn-profil" data-mig="mig-profil">Profils</button>
							</div>
							<div class="col-8 col-blue">
								<ul class="fa-ul" id="ul-mig-profil">
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_sso_profil</li>
									<li><i class="fa-li fa fa-square"></i>Migration des données poshprofile.profile <i class="fa fa-arrow-right"></i> eportail.env_sso_profil</li>
								</ul>
							</div>
						</div>
						<div class="row">
							<div class="col-4 center-wrapper col-blue">
								<button type="button" class="btn btn-primary" id="btn-onglet-pprofil" data-mig="mig-onglet-pprofil">Onglets / Pages</button>
							</div>
							<div class="col-8 col-blue">
								<ul class="fa-ul" id="ul-mig-onglet-pprofil">
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_panel concernant exclusivement posh-profil</li>
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_panel_sso_profil</li>
									<li><i class="fa-li fa fa-square"></i>Migration des données poshprofile.thumb <i class="fa fa-arrow-right"></i> eportail.env_panel</li>
									<li><i class="fa-li fa fa-square"></i>Migration des données poshprofile.profilethumb <i class="fa fa-arrow-right"></i> eportail.env_panel_sso_profil</li>
								</ul>
							</div>
						</div>
						<div class="row">
							<div class="col-4 center-wrapper col-blue">
								<button type="button" class="btn btn-primary" id="btn-attr" data-mig="mig-attr">Attributs</button>
							</div>
							<div class="col-8 col-blue">
								<ul class="fa-ul" id="ul-mig-attr">
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_sso_attribut</li>
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_sso_profil_attribut</li>
									<li><i class="fa-li fa fa-square"></i>Migration des données poshprofile.userattr <i class="fa fa-arrow-right"></i> eportail.env_sso_attribut</li>
									<li><i class="fa-li fa fa-square"></i>Migration des données poshprofile.userattrprofile <i class="fa fa-arrow-right"></i> eportail.env_sso_profil_attribut</li>
								</ul>
							</div>
						</div>
						<div class="row">
							<div class="col-4 center-wrapper col-blue">
								<button type="button" class="btn btn-primary" id="btn-flux" data-mig="mig-flux">Articles / Flux</button>
							</div>
							<div class="col-8 col-blue">
								<ul class="fa-ul" id="ul-mig-flux">
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_flux</li>
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_fluxmsg</li>
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_flux_sso_profil</li>
									<li><i class="fa-li fa fa-square"></i>Migration des données poshprofile.alert <i class="fa fa-arrow-right"></i> eportail.env_flux</li>
									<li><i class="fa-li fa fa-square"></i>Migration des données poshprofile.alertmsg <i class="fa fa-arrow-right"></i> eportail.env_fluxmsg</li>
									<li><i class="fa-li fa fa-square"></i>Migration des données poshprofile.alertmsg <i class="fa fa-arrow-right"></i> eportail.env_flux_sso_profil</li>
								</ul>
							</div>
						</div>
						<div class="row">
							<div class="col-4 center-wrapper col-blue">
								<button type="button" class="btn btn-primary" id="btn-item" data-mig="mig-item">Items / Catégories</button>
							</div>
							<div class="col-8 col-blue">
								<ul class="fa-ul" id="ul-mig-item">
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_application_categorie</li>
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_application</li>
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_application_sso_profil</li>
									<li><i class="fa-li fa fa-square"></i>Migration des données poshprofile.catitem <i class="fa fa-arrow-right"></i> eportail.env_application_categorie</li>
									<li><i class="fa-li fa fa-square"></i>Migration des données poshprofile.desktopitem <i class="fa fa-arrow-right"></i> eportail.env_application</li>
									<li><i class="fa-li fa fa-square"></i>Migration des données poshprofile.profiledesktopitem <i class="fa fa-arrow-right"></i> eportail.env_application_sso_profil</li>
									<li><i class="fa-li fa fa-square"></i>Migration des icônes des items posh-profil <i class="fa fa-plus"></i> posh <i class="fa fa-arrow-right"></i> eportail</li>
								</ul>
							</div>
						</div>
						<div class="row">
							<div class="col-4 center-wrapper col-blue">
								<button type="button" class="btn btn-primary" id="btn-fav" data-mig="mig-fav">Favoris</button>
							</div>
							<div class="col-8 col-blue">
								<ul class="fa-ul" id="ul-mig-fav">
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_panel_widget_bookmark concernant exclusivement posh-profil</li>
									<li><i class="fa-li fa fa-square"></i>Migration des données poshprofile.bookmark <i class="fa fa-arrow-right"></i> eportail.env_panel_widget_bookmark</li>
									<li><i class="fa-li fa fa-square"></i>Migration des icônes des favoris posh-profil <i class="fa fa-arrow-right"></i> eportail</li>
								</ul>
							</div>
						</div>
					</div>
					<div style="padding-left: 1.2rem;border-left: 5px solid #32CD32;">
						<div class="row">
							<div class="col-12">
								<span style="font-size:22px;color:#32CD32;">posh</span>
							</div>
						</div>
						<div class="row">
							<div class="col-4 center-wrapper col-green">
								<button type="button" class="btn btn-success" id="btn-user" data-mig="mig-user">Utilisateurs</button>
							</div>
							<div class="col-8 col-green">
								<ul class="fa-ul" id="ul-mig-user">
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_user</li>
									<li><i class="fa-li fa fa-square"></i>Migration des données posh.users <i class="fa fa-arrow-right"></i> eportail.env_user</li>
									<li><i class="fa-li fa fa-square"></i>Migration des avatars posh <i class="fa fa-arrow-right"></i> eportail</li>
								</ul>
							</div>
						</div>
						<div class="row">
							<div class="col-4 center-wrapper col-green">
								<button type="button" class="btn btn-success" id="btn-onglet-posh" data-mig="mig-onglet-posh">Onglets / Pages</button>
							</div>
							<div class="col-8 col-green">
								<ul class="fa-ul" id="ul-mig-onglet-posh">
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_panel concernant exclusivement posh</li>
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_panel_widget</li>
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_panel_widget_bookmark concernant exclusivement posh</li>
									<li><i class="fa-li fa fa-square"></i>Purge eportail.env_widget</li>
									<li><i class="fa-li fa fa-square"></i>Migration des données posh.profile <i class="fa fa-arrow-right"></i> eportail.env_panel</li>
									<li><i class="fa-li fa fa-square"></i>Migration des données posh.module <i class="fa fa-arrow-right"></i> eportail.env_panel_widget</li>
									<li><i class="fa-li fa fa-square"></i>Création des widgets dans la bibliothèque de widgets eportail.env_widget</li>
									<li><i class="fa-li fa fa-square"></i>Migration des données posh.users_favorites <i class="fa fa-arrow-right"></i> eportail.env_panel_widget_bookmark</li>
								</ul>
							</div>
						</div>
					</div>			
				</div>
			</div>
		</div>

		<div class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" id="resultMigration">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Résultats de la migration</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
					</div>
					<div class="modal-body">
						<p></p>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
					</div>
				</div>
			</div>
	  	</div>
		<script src="js/jquery.min.js"></script>
		<script src="js/popper.js"></script>
		<script src="js/bootstrap.min.js"></script>
		<script>
		$(document).ready(function() {			

			$( "button[id^='btn-']" ).click(function() {
				var $this = $(this);
				var old_text = $this.html();

				$('.modal-body').html("");
				$this.html('<i class="fa fa-cog fa-spin fa-lg fa-fw"></i> '+old_text);

				$("button[id^='btn-']").each(function(index) {
					$(this).prop("disabled",true);
				});

				var dataMig = $this.data("mig");			
				
				$.post("trt-eportail.php", { action: dataMig })
				.done(function(data) {
                    console.log(data);
					var parsedData = $.parseJSON(data);
					if(parsedData.error == 0) {

						if(parsedData.purge > 0)
							$('.modal-body').html("<p>Éléments supprimés : <strong>"+parsedData.purge+"</strong></p>");

						if(parsedData.ajout > 0)
							$('.modal-body').append("<p>Éléments ajoutés : <strong>"+parsedData.ajout+"</strong></p>");

						if(parsedData.icon > 0)
							$('.modal-body').append("<p>Icônes migrées : <strong>"+parsedData.icon+"</strong></p>");

						$('#resultMigration').modal('show');

						$("#ul-"+dataMig+" li i.fa-square").each(function( index ) {
							$(this).toggleClass('fa-square fa-check-square');
						});
					}
					$this.html(old_text);

					$("button[id^='btn-']").each(function(index) {						
						$(this).prop("disabled",false);
					});
				})
				.fail(function(xhr, status, error) {
					console.log(xhr);
					console.log(status);
					console.log(error);
				});
			});
		});
		</script>
	</body>
</html>