#!/bin/bash

#######################################################################
# Script qui permet de passer moodle de la version 2.5 à la version 3 #
#######################################################################

#1 : forcer le passage de la release

VERSION="20160101"

#===========================================================================================================================================
#== FONCTION ===============================================================================================================================
#===========================================================================================================================================

BigTitle(){
    ligne=`perl -E 'say "=" x 117'`
    nb=${#1}
    nbchar=$((117 - $nb - 4)) 

    finligne=""
    for i in $(eval echo "{1..$nbchar}")
    do    
        finligne+="="
    done
    
    for i in {1..30}
    do
        echo
    done
    
    clear
    EchoVert $ligne
    EchoVert "== $1 $finligne" 
    EchoVert $ligne
}

        
Title(){
    ligne=`perl -E 'say "=" x 117'`
    nb=${#1}
    nbchar=$((117 - $nb - 4)) 

    finligne=""
    for i in $(eval echo "{1..$nbchar}")
    do    
        finligne+="="
    done
    
    echo
    EchoCyan $ligne
    EchoCyan "== $1 $finligne" 
    EchoCyan $ligne
}












#===========================================================================================================================================
#== MOODLE =================================================================================================================================
#===========================================================================================================================================

moodle(){
    # On force le mot de passe root
    Title "Modification password root apache"
	mysql_pwd.py 123456 root
	
	
	SourceD="$container_path_web/var/www/html"

    # Supprimer le repertoire de l'application s'il existe déjà
    if [ -d "$SourceD/moodle" ]
    then
        # Vérification de la version du moodle restaurée
        moodleversion=$(mysql -uroot -p123456 -h localhost --batch --skip-column-names -Dmoodle -e "select value from mdl_config where name='version'")
        echo "Version du moodle en cours = $moodleversion"
        
        
        if [[ "${moodleversion}" == "2013051402.11" ]]
        then
            Title "Moodle Release"
            echo
            EchoRouge "Passage obligatoire par la version de moodle 2.9 avant de pouvoir mettre à jour moodle dans la version acuelle d'Envole"
            
            echo "Suppression du repertoire html existant de l'application avant restauration"
	        rm -rf "$SourceD/moodle"
            
            # On place la version 2.9 sur le html
            echo "Copie des sources de moodle 2.9.2"
            rsync --recursive  "release/moodle29/moodle-2.9.2/" "$SourceD/moodle"
            cp -f release/moodle29/moodle-config.php /var/www/html/moodle/config.php
            
            echo "Exécuter la mise à jour"
            chmod +x release/moodle29/20-moodle
            release/moodle29/20-moodle

	        echo "Installation du dernier paquet de l'application"
	        apt-get -y install --reinstall eole-moodle-update
            apt-get -y install --reinstall moodle-update-apps
            
            Title "Reconfigure"
            Question_ouinon "Souhaitez-vous exécuter un reconfigure" $interactive "oui" "warn"
            if [ "$?" = 0 ]
            then
                reconfigure
            else
                EchoRouge "Pensez à faire un reconfigure"
            fi            
        else
            EchoVert "Moodle est déjà dans la bonne release"
        fi
    else
        EchoVert "Moodle n'est pas installé, il n'est pas besoin de le releaser avant son installation"
    fi        
}



#===========================================================================================================================================
#== MAIN ===================================================================================================================================
#===========================================================================================================================================

# version 2.4/2.5
if [ -f /usr/lib/eole/ihm.sh ];then
    . /usr/lib/eole/ihm.sh
    numero_etab=$(CreoleGet numero_etab)
    interactive='True'
else
    EchoRouge "Script executable depuis EOLE 2.4 et 2.5 uniquement"
    exit 1        
fi

if [ -z "$numero_etab" ]
then
    EchoRouge "Récupération du numéro d'établissement impossible !"
    exit 1
fi

# Vérifier sur quelle version d'eole 
if [ -f /etc/eole/release ]
then
    . /etc/eole/release
    version="$EOLE_MODULE-$EOLE_VERSION"

    if [ "$EOLE_MODULE" = "scribe" ];then
        BigTitle "RELEASE MOODLE"

        moodle $1


    else
        EchoRouge "Module EOLE incompatible"
        exit 1
    fi
else
    EchoRouge "Détection du module impossible !"
    exit 1
fi




echo
exit 0
