<?php
/*
 * Profils
 */
function ajouter_env_sso_profil($sso_profil_id, $sso_profil_label, $sso_profil_fgban, $sso_profil_share, $sso_profil_community)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("INSERT INTO env_sso_profil (sso_profil_id, sso_profil_label, sso_profil_fgban, sso_profil_share, sso_profil_community) 
										   VALUES (:sso_profil_id, :sso_profil_label, :sso_profil_fgban, :sso_profil_share, :sso_profil_community)");
		$reponse -> bindParam(':sso_profil_id', $sso_profil_id);
		$reponse -> bindParam(':sso_profil_label', $sso_profil_label);
		$reponse -> bindParam(':sso_profil_fgban', $sso_profil_fgban);
		$reponse -> bindParam(':sso_profil_share', $sso_profil_share);
		$reponse -> bindParam(':sso_profil_community', $sso_profil_community);
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}
}
function purger_env_sso_profil()
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("DELETE FROM env_sso_profil WHERE sso_profil_id >= 0");
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $reponse->rowCount();
}
/*
 * Onglets / Pages
 */
function ajouter_env_panel($panel_id, $panel_label, $panel_url, $panel_order, $panel_user, $panel_type, $panel_template)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("INSERT INTO env_panel (panel_id, panel_label, panel_url, panel_order, panel_user, panel_type, panel_template)
										   VALUES (:panel_id, :panel_label, :panel_url, :panel_order, :panel_user, :panel_type, :panel_template)");
		$reponse -> bindParam(':panel_id', $panel_id);
		$reponse -> bindParam(':panel_label', $panel_label);
		$reponse -> bindParam(':panel_url', $panel_url);
		$reponse -> bindParam(':panel_order', $panel_order);
		$reponse -> bindParam(':panel_user', $panel_user);
		$reponse -> bindParam(':panel_type', $panel_type);
		$reponse -> bindParam(':panel_template', $panel_template);
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $bdd_eportail->lastInsertId();
}
function purger_env_panel_pour_poshprofil()
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("DELETE FROM env_panel WHERE panel_id >= 0 AND panel_user = -1");
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $reponse->rowCount();
}
function purger_env_panel_pour_posh()
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("DELETE FROM env_panel WHERE panel_id >= 0 AND panel_user != -1");
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $reponse->rowCount();
}
function ajouter_env_panel_sso_profil($panel_sso_profil_panel, $panel_sso_profil_sso_profil, $panel_sso_profil_mode)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("INSERT INTO env_panel_sso_profil (panel_sso_profil_panel, panel_sso_profil_sso_profil, panel_sso_profil_mode) 
										   VALUES (:panel_sso_profil_panel, :panel_sso_profil_sso_profil, :panel_sso_profil_mode)");
		$reponse -> bindParam(':panel_sso_profil_panel', $panel_sso_profil_panel);
		$reponse -> bindParam(':panel_sso_profil_sso_profil', $panel_sso_profil_sso_profil);
		$reponse -> bindParam(':panel_sso_profil_mode', $panel_sso_profil_mode);
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}
}
function purger_env_panel_sso_profil()
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("DELETE FROM env_panel_sso_profil WHERE panel_sso_profil_panel >= 0");
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $reponse->rowCount();
}
function ajouter_env_panel_widget($panel_widget_loc, $panel_widget_order, $panel_widget_label, $panel_widget_style, $panel_widget_widget, $panel_widget_panel, $panel_widget_url, $panel_widget_nbarticle, $panel_widget_html)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("INSERT INTO env_panel_widget (panel_widget_loc, panel_widget_order, panel_widget_label, panel_widget_style, panel_widget_widget, panel_widget_panel, panel_widget_url, panel_widget_height, panel_widget_centerlabel, panel_widget_colorbodylabel, panel_widget_nbarticle, panel_widget_html)
										   VALUES (:panel_widget_loc, :panel_widget_order, :panel_widget_label, :panel_widget_style, :panel_widget_widget, :panel_widget_panel, :panel_widget_url, 300, 0, 0, :panel_widget_nbarticle, :panel_widget_html)");
		$reponse -> bindParam(':panel_widget_loc', $panel_widget_loc);
		$reponse -> bindParam(':panel_widget_order', $panel_widget_order);
		$reponse -> bindParam(':panel_widget_label', $panel_widget_label);
		$reponse -> bindParam(':panel_widget_style', $panel_widget_style);
		$reponse -> bindParam(':panel_widget_widget', $panel_widget_widget);
		$reponse -> bindParam(':panel_widget_panel', $panel_widget_panel);
		$reponse -> bindParam(':panel_widget_url', $panel_widget_url);
        $reponse -> bindParam(':panel_widget_nbarticle', $panel_widget_nbarticle);
		$reponse -> bindParam(':panel_widget_html', $panel_widget_html);
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $bdd_eportail->lastInsertId();
}
function purger_env_panel_widget()
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("DELETE FROM env_panel_widget WHERE panel_widget_id >= 0");
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $reponse->rowCount();
}
/*
 * Attributs
 */
function ajouter_env_sso_attribut($sso_attribut_id, $sso_attribut_name, $sso_attribut_value)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("INSERT INTO env_sso_attribut (sso_attribut_id, sso_attribut_name, sso_attribut_value) 
										   VALUES (:sso_attribut_id, :sso_attribut_name, :sso_attribut_value)");
		$reponse -> bindParam(':sso_attribut_id', $sso_attribut_id);
		$reponse -> bindParam(':sso_attribut_name', $sso_attribut_name);
		$reponse -> bindParam(':sso_attribut_value', $sso_attribut_value);
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}
}
function purger_env_sso_attribut()
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("DELETE FROM env_sso_attribut WHERE sso_attribut_id >= 0");
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $reponse->rowCount();
}
function ajouter_env_sso_profil_attribut($sso_profil_attribut_attribut, $sso_profil_attribut_profil)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("INSERT INTO env_sso_profil_attribut (sso_profil_attribut_profil, sso_profil_attribut_attribut) 
										   VALUES ( :sso_profil_attribut_profil, :sso_profil_attribut_attribut)");
		$reponse -> bindParam(':sso_profil_attribut_profil', $sso_profil_attribut_profil);
		$reponse -> bindParam(':sso_profil_attribut_attribut', $sso_profil_attribut_attribut);
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}
}
function purger_env_sso_profil_attribut()
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("DELETE FROM env_sso_profil_attribut WHERE sso_profil_attribut_profil >= 0");
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $reponse->rowCount();
}
/*
 * Alertes / Flux
 */
function ajouter_env_flux($flux_id, $flux_name, $flux_type, $flux_url, $flux_order, $flux_number, $flux_color, $flux_style)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("INSERT INTO env_flux (flux_id, flux_name, flux_type, flux_url, flux_order, flux_number, flux_color, flux_style) 
										VALUES (:flux_id, :flux_name, :flux_type, :flux_url, :flux_order, :flux_number, :flux_color, :flux_style)");
		$reponse -> bindParam(':flux_id', $flux_id);
		$reponse -> bindParam(':flux_name', $flux_name);
		$reponse -> bindParam(':flux_type', $flux_type);
		$reponse -> bindParam(':flux_url', $flux_url);
		$reponse -> bindParam(':flux_order', $flux_order);
		$reponse -> bindParam(':flux_number', $flux_number);
		$reponse -> bindParam(':flux_color', $flux_color);
		$reponse -> bindParam(':flux_style', $flux_style);
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}
}
function purger_env_flux()
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("DELETE FROM env_flux WHERE flux_id >= 0");
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $reponse->rowCount();
}
function ajouter_env_fluxmsg($fluxmsg_id, $fluxmsg_name, $fluxmsg_date, $fluxmsg_description, $fluxmsg_html, $fluxmsg_flux)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("INSERT INTO env_fluxmsg (fluxmsg_id, fluxmsg_name, fluxmsg_date, fluxmsg_description, fluxmsg_html, fluxmsg_flux) 
										VALUES (:fluxmsg_id, :fluxmsg_name, :fluxmsg_date, :fluxmsg_description, :fluxmsg_html, :fluxmsg_flux)");
		$reponse -> bindParam(':fluxmsg_id', $fluxmsg_id);
		$reponse -> bindParam(':fluxmsg_name', $fluxmsg_name);
		$reponse -> bindParam(':fluxmsg_date', $fluxmsg_date);
		$reponse -> bindParam(':fluxmsg_description', $fluxmsg_description);
		$reponse -> bindParam(':fluxmsg_html', $fluxmsg_html);
		$reponse -> bindParam(':fluxmsg_flux', $fluxmsg_flux);
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}
}
function purger_env_fluxmsg()
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("DELETE FROM env_fluxmsg WHERE fluxmsg_id >= 0");
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $reponse->rowCount();
}
function ajouter_env_flux_sso_profil($flux_sso_profil_flux, $flux_sso_profil_profil, $flux_sso_profil_edition)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("INSERT INTO env_flux_sso_profil (flux_sso_profil_flux, flux_sso_profil_profil, flux_sso_profil_edition) 
										VALUES (:flux_sso_profil_flux, :flux_sso_profil_profil, :flux_sso_profil_edition)");
		$reponse -> bindParam(':flux_sso_profil_flux', $flux_sso_profil_flux);
		$reponse -> bindParam(':flux_sso_profil_profil', $flux_sso_profil_profil);
		$reponse -> bindParam(':flux_sso_profil_edition', $flux_sso_profil_edition);
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}
}
function purger_env_flux_sso_profil()
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("DELETE FROM env_flux_sso_profil WHERE flux_sso_profil_flux >= 0");
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $reponse->rowCount();
}
/*
 * Items / Categories
 */
function ajouter_env_application_categorie($application_categorie_id, $application_categorie_label, $application_categorie_order, $application_categorie_color)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("INSERT INTO env_application_categorie (application_categorie_id, application_categorie_label, application_categorie_order, application_categorie_color) 
										VALUES (:application_categorie_id, :application_categorie_label, :application_categorie_order, :application_categorie_color)");
		$reponse -> bindParam(':application_categorie_id', $application_categorie_id);
		$reponse -> bindParam(':application_categorie_label', $application_categorie_label);
		$reponse -> bindParam(':application_categorie_order', $application_categorie_order);
		$reponse -> bindParam(':application_categorie_color', $application_categorie_color);
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}
}
function purger_env_application_categorie()
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("DELETE FROM env_application_categorie WHERE application_categorie_id >= 0");
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $reponse->rowCount();
}
function ajouter_env_application_sso_profil($application_sso_profil_application, $application_sso_profil_sso_profil)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("INSERT INTO env_application_sso_profil (application_sso_profil_application, application_sso_profil_sso_profil) 
										VALUES (:application_sso_profil_application, :application_sso_profil_sso_profil)");
		$reponse -> bindParam(':application_sso_profil_application', $application_sso_profil_application);
		$reponse -> bindParam(':application_sso_profil_sso_profil', $application_sso_profil_sso_profil);
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}
}
function purger_env_application_sso_profil()
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("DELETE FROM env_application_sso_profil WHERE application_sso_profil_application >= 0");
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $reponse->rowCount();
}
function ajouter_env_application($application_id, $application_name, $application_label, $application_description, $application_order, $application_url, $application_open, $application_color, $application_badge, $application_callback, $application_callbackmsg, $application_icon, $application_categorie)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("INSERT INTO env_application (application_id, application_name, application_label, application_description, application_order, application_url, application_open, application_color, application_badge, application_callback, application_callbackmsg, application_icon, application_categorie) 
										VALUES (:application_id, :application_name, :application_label, :application_description, :application_order, :application_url, :application_open, :application_color, :application_badge, :application_callback, :application_callbackmsg, :application_icon, :application_categorie)");
		$reponse -> bindParam(':application_id', $application_id);
		$reponse -> bindParam(':application_name', $application_name);
		$reponse -> bindParam(':application_label', $application_label);
		$reponse -> bindParam(':application_description', $application_description);
		$reponse -> bindParam(':application_order', $application_order);
		$reponse -> bindParam(':application_url', $application_url);
		$reponse -> bindParam(':application_open', $application_open);
		$reponse -> bindParam(':application_color', $application_color);
		$reponse -> bindParam(':application_badge', $application_badge);
		$reponse -> bindParam(':application_callback', $application_callback);
		$reponse -> bindParam(':application_callbackmsg', $application_callbackmsg);
		$reponse -> bindParam(':application_icon', $application_icon);
		$reponse -> bindParam(':application_categorie', $application_categorie);
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}
}
function recuperer_env_application_description($name)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("SELECT application_description FROM env_application WHERE application_name = :name AND application_description != ''");
		$reponse -> bindParam(':name', $name);
		$reponse -> execute();
		$env_application_description = $reponse -> fetchAll(PDO::FETCH_ASSOC);
		$reponse -> closeCursor();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $env_application_description;
}
function purger_env_application()
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("DELETE FROM env_application WHERE application_id >= 0");
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $reponse->rowCount();
}
function ajouter_env_icon($icon_url, $icon_user)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("INSERT INTO env_icon (icon_url, icon_user) 
										VALUES (:icon_url, :icon_user)");
		$reponse -> bindParam(':icon_url', $icon_url);
		$reponse -> bindParam(':icon_user', $icon_user);
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $bdd_eportail->lastInsertId();
}
function purger_env_icon()
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("DELETE FROM env_icon WHERE icon_id >= 0");
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $reponse->rowCount();
}
function recuperer_env_icon_unique($icon_url)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("SELECT * FROM env_icon WHERE icon_url = :icon_url");
		$reponse -> bindParam(':icon_url', $icon_url);
		$reponse -> execute();
		$env_icon = $reponse -> fetchAll(PDO::FETCH_ASSOC);
		$reponse -> closeCursor();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $env_icon;
}
/*
 * Users
 */
function ajouter_env_user($user_id, $user_login, $user_password, $user_lastname, $user_firstname, $user_pseudo, $user_avatar, $user_email, $user_profil)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("INSERT IGNORE INTO env_user (user_id, user_login, user_password, user_lastname, user_firstname, user_pseudo, user_avatar, user_email, user_profil)
										VALUES (:user_id, :user_login, :user_password, :user_lastname, :user_firstname, :user_pseudo, :user_avatar, :user_email, :user_profil)");
		$reponse -> bindParam(':user_id', $user_id);
		$reponse -> bindParam(':user_login', $user_login);
		$reponse -> bindParam(':user_password', $user_password);
		$reponse -> bindParam(':user_lastname', $user_lastname);
		$reponse -> bindParam(':user_firstname', $user_firstname);
		$reponse -> bindParam(':user_pseudo', $user_pseudo);
		$reponse -> bindParam(':user_avatar', $user_avatar);
		$reponse -> bindParam(':user_email', $user_email);
		$reponse -> bindParam(':user_profil', $user_profil);
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}
}
function purger_env_user()
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("DELETE FROM env_user WHERE user_id >= 2");
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $reponse->rowCount();
}
/*
 * Favoris / Bookmarks
 */
function ajouter_env_panel_widget_bookmark($panel_widget_bookmark_id, $panel_widget_bookmark_name, $panel_widget_bookmark_icon, $panel_widget_bookmark_url, $panel_widget_bookmark_open, $panel_widget_bookmark_color, $panel_widget_bookmark_user, $panel_widget_bookmark_widget)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("INSERT INTO env_panel_widget_bookmark (panel_widget_bookmark_id, panel_widget_bookmark_name, panel_widget_bookmark_icon, panel_widget_bookmark_url, panel_widget_bookmark_open, panel_widget_bookmark_color, panel_widget_bookmark_user, panel_widget_bookmark_widget)
										VALUES (:panel_widget_bookmark_id, :panel_widget_bookmark_name, :panel_widget_bookmark_icon, :panel_widget_bookmark_url, :panel_widget_bookmark_open, :panel_widget_bookmark_color, :panel_widget_bookmark_user, :panel_widget_bookmark_widget)");
		$reponse -> bindParam(':panel_widget_bookmark_id', $panel_widget_bookmark_id);
		$reponse -> bindParam(':panel_widget_bookmark_name', $panel_widget_bookmark_name);
		$reponse -> bindParam(':panel_widget_bookmark_icon', $panel_widget_bookmark_icon);
		$reponse -> bindParam(':panel_widget_bookmark_url', $panel_widget_bookmark_url);
		$reponse -> bindParam(':panel_widget_bookmark_open', $panel_widget_bookmark_open);
		$reponse -> bindParam(':panel_widget_bookmark_color', $panel_widget_bookmark_color);
		$reponse -> bindParam(':panel_widget_bookmark_user', $panel_widget_bookmark_user);
		$reponse -> bindParam(':panel_widget_bookmark_widget', $panel_widget_bookmark_widget);
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}
 }
function purger_env_panel_widget_bookmark_poshprofil()
{
    global $bdd_eportail;

    try {
        $reponse = $bdd_eportail->prepare("DELETE FROM env_panel_widget_bookmark WHERE panel_widget_bookmark_id >= 0 AND panel_widget_bookmark_widget = 0");
        $reponse -> execute();
    } catch (Exception $e) {
        die('Erreur : ' . $e->getMessage());
    }

    return $reponse->rowCount();
}
function purger_env_panel_widget_bookmark_posh()
{
    global $bdd_eportail;

    try {
        $reponse = $bdd_eportail->prepare("DELETE FROM env_panel_widget_bookmark WHERE panel_widget_bookmark_id >= 0 AND panel_widget_bookmark_widget > 0");
        $reponse -> execute();
    } catch (Exception $e) {
        die('Erreur : ' . $e->getMessage());
    }

    return $reponse->rowCount();
}
/*
 * Bibliothèque de widgets
 */
function ajouter_env_widget(
	$widget_name, 
	$widget_label, 
	$widget_icon, 
	$widget_url,
	$widget_code,
	$widget_actif,
	$widget_adjust,
	$widget_height,
	$widget_style,
	$widget_type,
	$widget_mode,
	$widget_categorie
)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("INSERT INTO env_widget (widget_name, widget_label, widget_icon, widget_url, widget_code, widget_actif, widget_adjust, widget_height, widget_iconlabel, widget_color, widget_colorlabel, widget_colorbody, widget_centerlabel, widget_colorbodylabel, widget_nbarticle, widget_style, widget_type, widget_mode, widget_categorie) 
                                    VALUES (:widget_name, :widget_label, :widget_icon, :widget_url, :widget_code, :widget_actif, :widget_adjust, :widget_height, null, null, null, null, null, null, null, :widget_style, :widget_type, :widget_mode, :widget_categorie)");
		$reponse -> bindParam(':widget_name', $widget_name);
		$reponse -> bindParam(':widget_label', $widget_label);
		$reponse -> bindParam(':widget_icon', $widget_icon);
		$reponse -> bindParam(':widget_url', $widget_url);		
		$reponse -> bindParam(':widget_code', $widget_code);
		$reponse -> bindParam(':widget_actif', $widget_actif);
		$reponse -> bindParam(':widget_adjust', $widget_adjust);
		$reponse -> bindParam(':widget_height', $widget_height);
		$reponse -> bindParam(':widget_style', $widget_style);
		$reponse -> bindParam(':widget_type', $widget_type);
		$reponse -> bindParam(':widget_mode', $widget_mode);
		$reponse -> bindParam(':widget_categorie', $widget_categorie);
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $bdd_eportail->lastInsertId();
}
function purger_env_widget()
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("DELETE FROM env_widget WHERE widget_id >= 0");
		$reponse -> execute();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $reponse->rowCount();
}
function recuperer_env_widget($widget_url)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("SELECT * FROM env_widget WHERE widget_url = :widget_url");
		$reponse -> bindParam(':widget_url', $widget_url);
		$reponse -> execute();
		$env_widget = $reponse -> fetchAll(PDO::FETCH_ASSOC);
		$reponse -> closeCursor();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $env_widget;
}
function recuperer_env_widget_byname($widget_name)
{
	global $bdd_eportail;

	try {
		$reponse = $bdd_eportail->prepare("SELECT * FROM env_widget WHERE widget_name = :widget_name");
		$reponse -> bindParam(':widget_name', $widget_name);
		$reponse -> execute();
		$env_widget = $reponse -> fetchAll(PDO::FETCH_ASSOC);
		$reponse -> closeCursor();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $env_widget;
}