<?php
/*
 * Users
 */
function recuperer_users()
{
	global $bdd_posh;

	try {
		$reponse = $bdd_posh->prepare("SELECT id, username, md5pass, long_name, typ, picture, email FROM users WHERE id >= 2 AND typ != 'N' ORDER BY id");
		$reponse -> execute();
		$users = $reponse -> fetchAll(PDO::FETCH_ASSOC);
		$reponse -> closeCursor();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $users;
}
function recuperer_user($uid)
{
	global $bdd_posh;

	try {
		$reponse = $bdd_posh->prepare("SELECT id FROM users WHERE username = :uid");
		$reponse -> bindParam(':uid', $uid);
		$reponse -> execute();
		$user = $reponse -> fetchAll(PDO::FETCH_ASSOC);
		$reponse -> closeCursor();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $user;
}
/*
 * Onglets / Pages
 */
function recuperer_profile_posh()
{
	global $bdd_posh;

	try {
		$reponse = $bdd_posh->prepare("SELECT id, user_id, name, param, seq, type FROM profile WHERE name != 'Accueil' AND (pass IS NULL OR pass = '') ORDER BY id");
		$reponse -> execute();
		$profile = $reponse -> fetchAll(PDO::FETCH_ASSOC);
		$reponse -> closeCursor();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $profile;
}
function compter_profile_posh()
{
	global $bdd_posh;

	try{
		$reponse = $bdd_posh->prepare("SELECT count(*) AS cpt_profile FROM profile WHERE pass IS NULL OR pass = ''");
        $reponse -> execute();
        $profiles = $reponse -> fetch();
		$reponse -> closeCursor();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}
	return $profiles['cpt_profile'];
}
function recuperer_modules($profile_id, $user_id)
{
	global $bdd_posh;

	try {
		$reponse = $bdd_posh->prepare("SELECT id, name, url, variables, posx, posy, posj, user_id FROM module, dir_item WHERE module.item_id = dir_item.id AND profile_id = :profile_id AND user_id = :user_id");
		$reponse -> bindParam(':profile_id', $profile_id);
		$reponse -> bindParam(':user_id', $user_id);
		$reponse -> execute();
		$modules = $reponse -> fetchAll(PDO::FETCH_ASSOC);
		$reponse -> closeCursor();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $modules;
}
function recuperer_dir_item_external($item_id)
{
    global $bdd_posh;

    try {
        $reponse = $bdd_posh->prepare("SELECT source FROM dir_item_external WHERE item_id = :item_id AND source != '' AND view = 'home'");
        $reponse -> bindParam(':item_id', $item_id);
        $reponse -> execute();
        $dir_item_external = $reponse -> fetchAll(PDO::FETCH_ASSOC);
        $reponse -> closeCursor();
    } catch (Exception $e) {
        die('Erreur : ' . $e->getMessage());
    }

    return $dir_item_external;
}
function recuperer_note($note_id)
{
	global $bdd_posh;

	try {
		$reponse = $bdd_posh->prepare("SELECT notes FROM users_notes WHERE id = :note_id");
		$reponse -> bindParam(':note_id', $note_id);
		$reponse -> execute();
		$note = $reponse -> fetchAll(PDO::FETCH_ASSOC);
		$reponse -> closeCursor();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $note;
}
function recuperer_favoris($fav_id)
{
	global $bdd_posh;

	try {
		$reponse = $bdd_posh->prepare("SELECT name, url FROM users_favorites WHERE id = :fav_id");
		$reponse -> bindParam(':fav_id', $fav_id);
		$reponse -> execute();
		$favoris = $reponse -> fetchAll(PDO::FETCH_ASSOC);
		$reponse -> closeCursor();
	} catch (Exception $e) {
		die('Erreur : ' . $e->getMessage());
	}

	return $favoris;
}