<?php
ini_set('memory_limit','256M');
ini_set('max_execution_time', 300);
require_once dirname(__FILE__).'/config/config-db-poshprofil.php';
require_once dirname(__FILE__).'/config/config-db-eportail.php';
require_once dirname(__FILE__).'/config/config-db-posh.php';
require_once dirname(__FILE__).'/config/config.php';
require_once dirname(__FILE__).'/sql-poshprofil.php';
require_once dirname(__FILE__).'/sql-eportail.php';
require_once dirname(__FILE__).'/sql-posh.php';

$action = $_POST['action'];
$allowed_action = array('mig-profil','mig-onglet-pprofil','mig-attr','mig-flux','mig-item','mig-user','mig-fav','mig-onglet-posh');

$counter = array(
	"purge" => 0,
	"ajout" => 0,
	"icon"  => 0,
	"error" => 0
);

if(in_array($action, $allowed_action)) {
	
	$curent_parent_path = dirname(getcwd());

	if($proxy_adresse != '' && $proxy_port != '') {
		$proxy = $proxy_adresse.":".$proxy_port;
	} else {
		$proxy = null;
	}

	# Seulement utilisé pour widgegest, application à Dijon qui permet de gérer des widgets en dehors de posh et de les intégrer dedans
	if($_SERVER['REMOTE_ADDR'] == '127.0.0.1') {
		$posh_url = 'http://pia.ac-dijon.fr/envole/portal/';
	} else {
		$posh_url = 'http://'.$_SERVER['HTTP_HOST'].'/envole/portal/';
	}

	switch ($action) {
		/*
		* Profils
		*/
		case 'mig-profil':
			$counter['purge'] = purger_env_sso_profil();
			$poshprofil_profile = recuperer_profile();
			foreach ($poshprofil_profile as $key => $profile) {
				# NULL n'est plus autorisé dans eportail pour ces champs
				$profile_ban = $profile['ban'];
				$profileName = $profile['name'];
				if($profile_ban == NULL) {
					$profile_ban = 0;
				}
				if($profile['name'] == 'main_user') {
					$profileName = 'Tout le monde';
				}
				ajouter_env_sso_profil($profile['profileid'], $profileName, $profile_ban, 0, -1);
				$counter['ajout']++;
			}
			break;
		/*
		* Onglets / Pages de posh-profil
		*/
		case 'mig-onglet-pprofil':
			$counter['purge'] = purger_env_panel_pour_poshprofil();
			$poshprofil_thumb = recuperer_thumb();
			foreach ($poshprofil_thumb as $key => $thumb) {
				# Posh : widget : type = 1 / URL : type = 2
				# ePortail : widget : type = 4 / URL : type = 1
				$page_type = 1;	
				$panel_template = '';
                if ($thumb['poshtype'] == 1) {
                    $page_type = 4;
                    $panel_url = 'view/user/widget.php';
                    $panel_template = 1;
                } else {
                	$panel_url = $thumb['url'];
                }
				ajouter_env_panel($thumb['thumbid'], $thumb['description'], $panel_url, $thumb['indice'], -1, $page_type, $panel_template);
				$counter['ajout']++;
			}
			$counter['purge'] += purger_env_panel_sso_profil();
			$poshprofil_profilethumb = recuperer_profilethumb();
			foreach ($poshprofil_profilethumb as $key => $profilethumb) {
				ajouter_env_panel_sso_profil($profilethumb['thumbid'], $profilethumb['profileid'], 0);
				$counter['ajout']++;
			}
			break;
		/*
		* Attributs
		*/
		case 'mig-attr':
			$counter['purge'] = purger_env_sso_attribut();
			$poshprofil_userattr = recuperer_userattr();
			foreach ($poshprofil_userattr as $key => $userattr) {
				ajouter_env_sso_attribut($userattr['userattrid'], $userattr['attrname'], $userattr['attrvalue']);
				$counter['ajout']++;
			}

			$counter['purge'] += purger_env_sso_profil_attribut();
			$poshprofil_userattrprofile = recuperer_userattrprofile();
			foreach ($poshprofil_userattrprofile as $key => $userattrprofile) {
				ajouter_env_sso_profil_attribut($userattrprofile['userattrid'], $userattrprofile['profileid']);
				$counter['ajout']++;
			}
			break;
		/*
		* Alertes / Flux
		*/
		case 'mig-flux':
			$counter['purge'] = purger_env_flux();
			$poshprofil_alert = recuperer_alert();
			foreach ($poshprofil_alert as $key => $alert) {
				ajouter_env_flux($alert['idalert'], $alert['titrealert'], $alert['typealert'], $alert['rssalert'], $alert['orderalert'], $alert['nbalert'], $alert['color'], 1);
				$counter['ajout']++;
			}

			$counter['purge'] += purger_env_fluxmsg();
			$poshprofil_alertmsg = recuperer_alertmsg();
			foreach ($poshprofil_alertmsg as $key => $alertmsg) {
				ajouter_env_fluxmsg($alertmsg['idmsg'], $alertmsg['titrealert'], $alertmsg['datealert'], $alertmsg['titrealert'], $alertmsg['textalert'], $alertmsg['idalert']);
				$counter['ajout']++;
			}

			$counter['purge'] += purger_env_flux_sso_profil();
			$poshprofil_profilealert = recuperer_profilealert();
			foreach ($poshprofil_profilealert as $key => $profilealert) {
				ajouter_env_flux_sso_profil($profilealert['alertid'], $profilealert['profileid'], 0);
				$counter['ajout']++;
			}
			break;
		/*
		* Items / Categories
		*/
		case 'mig-item':
			$counter['purge'] = purger_env_application_categorie();
			$poshprofil_catitem = recuperer_catitem();
			foreach ($poshprofil_catitem as $key => $catitem) {
			    if(!empty($catitem['color'])) {
                    $cat_color = str_replace('#', '', $catitem['color']);
                } else {
			        $cat_color = '';
                }
				ajouter_env_application_categorie($catitem['id'], $catitem['name'], $catitem['order'], $cat_color);
				$counter['ajout']++;
			}

			$counter['purge'] += purger_env_application_sso_profil();
			$poshprofil_profiledesktopitem = recuperer_profiledesktopitem();
			foreach ($poshprofil_profiledesktopitem as $key => $profiledesktopitem) {
				ajouter_env_application_sso_profil($profiledesktopitem['desktopid'], $profiledesktopitem['profileid']);
				$counter['ajout']++;
			}

			$counter['purge'] += purger_env_application();

			$poshprofil_desktopitem = recuperer_desktopitem();
			foreach ($poshprofil_desktopitem as $key => $desktopitem) {
				# NULL n'est plus autorisé dans eportail pour ces champs
				$desktopitem_indice = $desktopitem['indice'];
				if($desktopitem_indice == NULL) {
					$desktopitem_indice = 0;
				}
				$desktopitem_mode = $desktopitem['mode'];
				if($desktopitem_mode == NULL) {
					$desktopitem_mode = 0;
				}
				# La catégorie id -110 est remplacée par la catégorie -99 (Administration)
				$desktopitem_categorie = $desktopitem['categorie'];
				if($desktopitem_categorie == -110) {
					$desktopitem_categorie = -99;
				}
				/*
				 * Migration des icônes
				 */
				# Sur poshprofile, l'url est directement dans la table des items
				# Sur eportail, il y a un table de liaison entre les items et les icônes (table env_icon)
				# Il faut aussi migrer les icônes de posh vers eportail
				$current_filename = basename($desktopitem['icon']);
				$eportail_icon_path = $curent_parent_path.'/'.$eportail_folder.'/local/images/icon/'.$current_filename;
				# icône par défaut si échec de la copie (url plus valide, fichier supprimé, etc.)
				$last_icon_id = -472;
				# Gestion des icônes en URI ou URL
				if(substr($desktopitem['icon'], 0, 4) == 'http') {
					$icon_to_copy = $desktopitem['icon'];
				} else {
					$icon_to_copy = $curent_parent_path.$desktopitem['icon'];
				}
				# Si l'icône n'existe pas déjà
				if(!file_exists($eportail_icon_path)){
					# Si c'est une icône distante (via http) on utilisera curl pour pouvoir définir un proxy et télécharger l'icône
					if(substr(trim($icon_to_copy), 0, 4) == 'http') {
						if(copy_via_curl($icon_to_copy,$eportail_icon_path,$proxy)) {
							$last_icon_id = ajouter_env_icon($current_filename, -1);
							$counter['icon']++;
						}
					# Sinon c'est jutse une icône en local à déplacer
					} else {
						if(file_exists($icon_to_copy)) {
							# Copie du fichier image s'il n'existe pas déjà
							if(copy($icon_to_copy, $eportail_icon_path)) {
								$last_icon_id = ajouter_env_icon($current_filename, -1);
								$counter['icon']++;
							}
						}
					}
				} else {
					# Si l'icone existe déjà sur le serveur, on vérifie qu'il est en base on récupère juste son id pour le lier à note item
					$env_icon_exist = recuperer_env_icon_unique($current_filename);
					if(!empty($env_icon_exist[0])) {
						$last_icon_id = $env_icon_exist[0]['icon_id'];
					}
				}
				/*
				 * FIN Migration des icônes
				 */

                if(!empty($desktopitem['color'])) {
                    $desktopitem_color = str_replace('#', '', $desktopitem['color']);
                } else {
                    $desktopitem_color = '';
                }

				# Vérification si une description existe
				$application_description = '';
				$desktopitem_description = recuperer_env_application_description($desktopitem['name']);
				if(!empty($desktopitem_description[0])) {
					$application_description = $desktopitem_description[0]['application_description'];
				}

				ajouter_env_application($desktopitem['desktopid'], $desktopitem['name'], $desktopitem['libelle'], $application_description, $desktopitem_indice, $desktopitem['url'], $desktopitem_mode, $desktopitem_color, $desktopitem['badge_url'], $desktopitem['badge_type'], $desktopitem['badge_message'], $last_icon_id, $desktopitem_categorie);
				$counter['ajout']++;
			}
			break;		
		/*
		* Favoris / Bookmarks
		*/
		case 'mig-fav':
			$counter['purge'] = purger_env_panel_widget_bookmark_poshprofil();
			$poshprofil_bookmark = recuperer_bookmark();
			foreach ($poshprofil_bookmark as $key => $bookmark) {
				# Sur poshprofile, l'uid est directement dans la table des favoris
				# Sur eportail, la liaison se fait par l'id de l'uid de la table env_user
				# Il nous faut donc récuperer l'id de l'utilisateur
				$user = recuperer_user($bookmark['login']);
				/*
				 * Migration des icônes
				 */
				# Sur poshprofile, l'url est directement dans la table des favoris
				# Sur eportail, il y a un table de liaison entre les favoris et les icônes (table env_icon)
				$current_filename = basename($bookmark['icon']);
				$eportail_icon_path = $curent_parent_path.'/'.$eportail_folder.'/local/images/icon/'.$current_filename;
				# icône par défaut si échec de la copie (url plus valide, fichier supprimé, etc.)
				$last_icon_id = -472;
				# Gestion des icônes en URI ou URL
				if(substr($bookmark['icon'], 0, 4) == 'http') {
					$icon_to_copy = $bookmark['icon'];
				} else {
					$icon_to_copy = $curent_parent_path.$bookmark['icon'];
				}				
				# Si l'icône n'existe pas déjà
				if(!file_exists($eportail_icon_path)){
					# Si c'est une icône distante (via http) on utilisera curl pour pouvoir définir un proxy et télécharger l'icône
					if(substr(trim($icon_to_copy), 0, 4) == 'http') {
						if(copy_via_curl($icon_to_copy,$eportail_icon_path,$proxy)) {
							$last_icon_id = ajouter_env_icon($current_filename, -1);
							$counter['icon']++;
						}
					# Sinon c'est jutse une icône en local à déplacer
					} else {
						if(file_exists($icon_to_copy)) {
							# Copie du fichier image s'il n'existe pas déjà
							if(copy($icon_to_copy, $eportail_icon_path)) {
								$last_icon_id = ajouter_env_icon($current_filename, -1);
								$counter['icon']++;
							}
						}
					}
				} else {
					# Si l'icone existe déjà sur le serveur, on vérifie qu'il est en base on récupère juste son id pour le lier à note item
					$env_icon_exist = recuperer_env_icon_unique($current_filename);
					if(!empty($env_icon_exist[0])) {
						$last_icon_id = $env_icon_exist[0]['icon_id'];
					}
				}
				/*
				 * FIN Migration des icônes
				 */

				if(!empty($user[0]['id'])) {
					ajouter_env_panel_widget_bookmark($bookmark['bookmarkid'], $bookmark['libelle'], $last_icon_id, $bookmark['url'], 0, 'db0000', $user[0]['id'], 0);
					$counter['ajout']++;
				}
			}
			break;
		/*
		* Users
		*/
		case 'mig-user':
			$counter['purge'] = purger_env_user();
			$posh_users = recuperer_users();
			foreach ($posh_users as $key => $user) {
				# Dans posh, profil est un alphabétique
				# Dans eportail, profil est un integer
				$user_profil = 50;
				if($user['typ'] == 'A') {
					$user_profil = 1;
				}
				# NULL n'est plus autorisé dans eportail pour ces champs
				$user_email = $user['email'];
				if($user_email == NULL) {
					$user_email = 'email@non_renseignee';
				}
				$user_picture = 'system.jpg';
				if($user['picture'] != NULL) {
					$user_picture_full = explode('?', basename($user['picture']));
					if($user_picture_full[0] != '') {
						$user_picture = $user_picture_full[0];
					}
				}
				/*
				 * Migration des avatars
				 */
				$eportail_avatar_path = $curent_parent_path.'/'.$eportail_folder.'/local/images/avatar/'.$user_picture;
				$avatar_to_copy = $curent_parent_path.'/'.$posh_folder.'/upload/profile/'.$user_picture;

				if(!file_exists($eportail_avatar_path) && file_exists($avatar_to_copy)){
					# Copie du fichier image s'il n'existe pas déjà
					if(copy($avatar_to_copy, $eportail_avatar_path)) {
						$counter['icon']++;
					}
				} else {
					$user_picture = 'system.jpg';
				}

				ajouter_env_user($user['id'], $user['username'], $user['md5pass'], $user['long_name'], $user['long_name'], $user['username'], $user_picture, $user_email, $user_profil);
				$counter['ajout']++;
			}
			break;
		/*
		* Onglets / Pages de posh
		*/
		case 'mig-onglet-posh':
			
				$counter['purge'] = purger_env_panel_pour_posh();
				$counter['purge'] += purger_env_panel_widget();
				$counter['purge'] += purger_env_widget();
				$counter['purge'] += purger_env_panel_widget_bookmark_posh();

			$posh_profile = recuperer_profile_posh();
			foreach ($posh_profile as $key => $profile) {

			    # Exclusion du l'onglet Accueil qui existe déjà dans eportail
			    if($profile['name'] != 'Accueil') {

                    # Posh : widget : type = 1 / URL : type = 2
                    # ePortail : widget : type = 4 / URL : type = 1
                    $page_type = 1;
                    $panel_template = '';
                    if ($profile['type'] == 1) {
                        $page_type = 4;
                        $panel_url = 'view/user/widget.php';
                        $panel_template = 1;
                    } else {
                    	$panel_url = $profile['param'];
                    }
                    # Il nous faut éviter les doublons d'id avec les onglets importés de posh-profil.
                    # On va donc les recréer
                    $oldId = $profile['id'];
                    $newId = ajouter_env_panel('', $profile['name'], $panel_url, $profile['seq'], $profile['user_id'], $page_type, $panel_template);
                    # migration des widgets associés
                    $modules = recuperer_modules($oldId, $profile['user_id']);
                    foreach ($modules as $key => $module) {
                        # Paramètres par défaut
                        $widgetLabel = $module['name'];
                        $widgetUrl = '';
                        $widgetHtml = '';
                        $widgetNbarticle = 0;
                        $save_widget = false;

                        # Gestion des widgets RSS
                        if (strpos($module['url'], 'modules/p_rss.php')) {
                            if (!empty($module['variables']) && strpos($module['variables'], 'rssurl')) {
                                parse_str($module['variables'], $query);
                                $widgetUrl = $query['rssurl'];
                                $widgetId = -499;
                                $widgetNbarticle = 1;
                                $save_widget = true;
                            }
                        } # Gestion des widgets Horloge
                        elseif (strpos($module['url'], 'modules/clock.html') || strpos($module['url'], 'modules/ptime.html')) {
                            $widgetId = -461;
                            $save_widget = true;
                        } # Gestion des widgets Calculatrice
                        elseif (strpos($module['url'], 'modules/pcalc.html')) {
                            $widgetId = -458;
                            $save_widget = true;
                        } # Gestion des widgets Bloc-notes
                        elseif (strpos($module['url'], 'modules/p_notes.php')) {
                            if (!empty($module['variables'])) {
                                parse_str($module['variables'], $query);
                                # Extraction de l'id de la note
                                $noteId = $query['noteid'];
                                if (is_numeric($noteId) && $noteId > 0) {
                                    $note = recuperer_note($noteId);
                                    if (!empty($note[0]['notes']) && $note[0]['notes']!='') {
                                        $widgetHtml = $note[0]['notes'];
                                        $widgetId = -498;
                                        $save_widget = true;
                                    }
                                }
                            }
                        } # Gestion des Widget personnalisables (Dijon)
                        elseif (strpos($module['url'], 'modules/module10006.php') && $module['name'] == 'Widget personnalisable') {
                            if (!empty($module['variables']) && strpos($module['variables'], 'myUrl')) {
                                parse_str($module['variables'], $query);
                                $widgetUrl = $query['myUrl'];
                                if (!empty($query['ptitl'])) {
                                    $widgetLabel = utf8_decode($query['ptitl']);
                                    $widgetId = -500;
                                    $save_widget = true;
                                }
                            }
                        } # Gestion des Favoris
                        elseif (strpos($module['url'], 'modules/p_links.php')) {
                            if (!empty($module['variables']) && strpos($module['variables'], 'linkid')) {
                                parse_str($module['variables'], $query);
                                $favId = $query['linkid'];
                                $favoris = recuperer_favoris($favId);
                                $widgetId = -495;
                                # Exceptionnellement on va créer le panel ici car on a besoin de son ID pour les favoris
                                $panelWidgetId = ajouter_env_panel_widget('C' . $module['posx'] . 'R' . $module['posy'], $module['posj'], $widgetLabel, 1, $widgetId, $newId, $widgetUrl, $widgetNbarticle, $widgetHtml);
                                # Récupération des favoris pour les ajouter dans eportail
                                foreach ($favoris as $key => $favori) {
                                    ajouter_env_panel_widget_bookmark('', $favori['name'], -1004, $favori['url'], 0, 'db0000', $module['user_id'], $panelWidgetId);
									$counter['ajout']++;
								}
                                # Le panel est déjà créé, pas besoin de le recréer plus tard
								$counter['ajout']++;
								$save_widget = false;
                            }
                        } # Gestion des Widget external (bibliothèque de widget)
                        elseif (strpos($module['url'], 'modules/xml_getwidget.php')) {
							$dir_item_external = recuperer_dir_item_external($module['id']);
							if(!empty($dir_item_external[0])) {
								# s'il existe une url dans le code source du widget
								if(strpos($dir_item_external[0]['source'], '<a href="http')) {
									$widgetBiblioUrl = get_string_between($dir_item_external[0]['source'], '<a href="', '"');
									$widgetBiblio = recuperer_env_widget($widgetBiblioUrl);
									# s'il n'existe pas de widget dans la bibliothèque de widget, on va le créer
									if(empty($widgetBiblio)) {
										if(!empty($widgetBiblioUrl) && $widgetBiblioUrl != '') {
											$widgetId = ajouter_env_widget($widgetLabel, $widgetLabel, -498, $widgetBiblioUrl, '', 1, 0, 300, 1, 1, 1, 0);
										} else {
											$widgetId = ajouter_env_widget($widgetLabel, $widgetLabel, -498, $widgetLabel, '', 1, 0, 300, 1, 1, 1, 0);
										}
										$counter['ajout']++;
									} else {
										$widgetId = $widgetBiblio[0]['widget_id'];
									}
									$save_widget = true;
								# si c'est un widget en lien avec widgetgest (Dijon)
								} elseif(strpos($dir_item_external[0]['source'], 'widgetAcad.php?wid=')) {
									# nom du widget
									$widgetBiblioName = get_string_between($dir_item_external[0]['source'], 'widgetAcad.php?wid=', "'");
									if(!empty($widgetBiblioName) && $widgetBiblioName !='') {
										$widgetBiblio = recuperer_env_widget_byname($widgetBiblioName);
										# s'il n'existe pas de widget dans la bibliothèque de widget, on va le créer
										if(empty($widgetBiblio)) {
											# widgetgest nous renvois sous format XML les params du widget demandé
											$widgetXML = simplexml_load_file($posh_url.'widgetAcad.php?wid='.$widgetBiblioName);
											$widgetBiblioUrl = $widgetXML->wid->url;
											
											/*
											* Migration des icônes
											*/
											$current_filename = basename($widgetXML->wid->urlimage);
											$eportail_icon_path = $curent_parent_path.'/'.$eportail_folder.'/local/images/icon/'.$current_filename;
											# icône par défaut si échec de la copie (url plus valide, fichier supprimé, etc.)
											$last_icon_id = -498;
											# Gestion des icônes en URI ou URL
											if(substr($widgetXML->wid->urlimage, 0, 4) == 'http') {
												$icon_to_copy = $widgetXML->wid->urlimage;
											} else {
												# les url des icones widgetAcad sont en envole/ alors que sur notre serveur le chemin est posh/
												$widgetUrlImage = str_replace("envole/",$posh_folder."/",$widgetXML->wid->urlimage);
												$icon_to_copy = $curent_parent_path.$widgetUrlImage;
											}
											# Si l'icône n'existe pas déjà
											if(!file_exists($eportail_icon_path)){
												# Si c'est une icône distante (via http) on utilisera curl pour pouvoir définir un proxy et télécharger l'icône
												if(substr(trim($icon_to_copy), 0, 4) == 'http') {
													if(copy_via_curl($icon_to_copy,$eportail_icon_path,$proxy)) {
														$last_icon_id = ajouter_env_icon($current_filename, -1);
														$counter['icon']++;
													}
												# Sinon c'est jutse une icône en local à déplacer
												} else {
													if(file_exists($icon_to_copy)) {
														# Copie du fichier image s'il n'existe pas déjà
														if(copy($icon_to_copy, $eportail_icon_path)) {
															$last_icon_id = ajouter_env_icon($current_filename, -1);
															$counter['icon']++;
														}
													}
												}
											} else {
												# Si l'icone existe déjà sur le serveur, on vérifie qu'il est en base on récupère juste son id pour le lier à note item
												$env_icon_exist = recuperer_env_icon_unique($current_filename);
												if(!empty($env_icon_exist[0])) {
													$last_icon_id = $env_icon_exist[0]['icon_id'];
												}
											}
											/*
											 * FIN Migration des icônes
											 */
											
											if(!empty($widgetBiblioUrl) && $widgetBiblioUrl != '') {
												$widgetId = ajouter_env_widget($widgetBiblioName, $widgetBiblioName, $last_icon_id, trim($widgetBiblioUrl), '', 1, 0, 300, 1, 1, 1, 0);
											} else {
												$widgetId = ajouter_env_widget($widgetBiblioName, $widgetBiblioName, $last_icon_id, trim($widgetBiblioName), '', 1, 0, 300, 1, 1, 1, 0);
											}
											$counter['ajout']++;
										} else {
											$widgetId = $widgetBiblio[0]['widget_id'];
										}
										$save_widget = true;
									}
								}
							}
                        }

						if($save_widget) {
							ajouter_env_panel_widget('C' . $module['posx'] . 'R' . $module['posy'], $module['posj'], $widgetLabel, 1, $widgetId, $newId, $widgetUrl, $widgetNbarticle, $widgetHtml);
							$counter['ajout']++;
						}
                    }
                    $counter['ajout']++;
                }
			}
			break;
		default:
			# code...
			break;
	}
	echo json_encode($counter);
} else {
	$counter['error'] = 1;
	echo json_encode($counter);
}

function get_string_between($string, $start, $end){
    $string = ' ' . $string;
    $ini = strpos($string, $start);
    if ($ini == 0) return '';
    $ini += strlen($start);
    $len = strpos($string, $end, $ini) - $ini;
    return substr($string, $ini, $len);
}

function copy_via_curl($icon_to_copy,$eportail_icon_path,$proxy) {
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSLVERSION,3);
	curl_setopt($ch, CURLOPT_URL, $icon_to_copy);
	if($proxy != null) {
		curl_setopt($ch, CURLOPT_PROXY, $proxy);
	}
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	$data = curl_exec ($ch);
	curl_close ($ch);

	$file = fopen($eportail_icon_path, "w+");
	fputs($file, $data);
	fclose($file);

	return true;
}