<?php
ini_set('memory_limit','256M');
ini_set('max_execution_time', 300);

function recurse_copy($src,$dst) { 
    $dir = opendir($src); 
    @mkdir($dst); 
    while(false !== ( $file = readdir($dir)) ) { 
        if (( $file != '.' ) && ( $file != '..' )) { 
            if ( is_dir($src . '/' . $file) ) { 
                recurse_copy($src . '/' . $file,$dst . '/' . $file); 
            } 
            else { 
                copy($src . '/' . $file,$dst . '/' . $file); 
            } 
        } 
    } 
    closedir($dir); 
}

function deleteDir($dirPath) {
    if (! is_dir($dirPath)) {
        throw new InvalidArgumentException("$dirPath must be a directory");
    }
    if (substr($dirPath, strlen($dirPath) - 1, 1) != '/') {
        $dirPath .= '/';
    }
    $files = glob($dirPath . '*', GLOB_MARK);
    foreach ($files as $file) {
        if (is_dir($file)) {
            deleteDir($file);
        } else {
            unlink($file);
        }
    }
    rmdir($dirPath);
}

$action = $_POST['action'];
$allowed_action = array('mig-cronowncloud','mig-cronnextcloud','mig-movenextcloud','mig-purgeowncloud','mig-scanowncloud','mig-scannextcloud');

$return = array(
	"msg" => "",
	"error" => 0
);

if(in_array($action, $allowed_action)) {

	$curent_parent_path = dirname(getcwd());

	switch ($action) {
		/*
		* Cron Owncloud
		*/
		case 'mig-cronowncloud':
			$output=shell_exec("php -f /var/www/html/owncloud/cron.php");
			if($output=="") {
				$return['error'] = 0;
				$return['msg'] = "Cron Owncloud passé avec succès";
			}
			else {
				$return['error'] = 1;
				$return['msg'] = nl2br($output);
			}
		break;

		/*
		* Cron Nextcloud
		*/
		case 'mig-cronnextcloud':
			$output=shell_exec("php -f /var/www/html/nextcloud/cron.php");
			if($output=="") {
				$return['error'] = 0;
				$return['msg'] = "Cron Nextcloud passé avec succès";
			}			
			else {
				$return['error'] = 1;
				$return['msg'] = nl2br($output);;
			}
			
		break;

		/*
		* Move to Nextcloud
		*/
		case 'mig-movenextcloud':
			$files = scandir ( "/home/www-data/var/www/html/owncloud");
			$return['msg'] .= "Déplacement des répertoires utilisateurs d'Owncloud vers Nextcloud :<br>";
			foreach($files as $file) {
				if(is_dir("/home/www-data/var/www/html/owncloud/".$file)&&$file!="."&&$file!=".."&&$file!="files_external") {
					deleteDir("/home/www-data/var/www/html/nextcloud/".$file);
					recurse_copy("/home/www-data/var/www/html/owncloud/".$file,"/home/www-data/var/www/html/nextcloud/".$file);
					$return['msg'] .= $file."<br>";
				}
					
			}
			$return['error'] = 0;
		break;

		/*
		* Purge to Owncloud
		*/
		case 'mig-purgeowncloud':
			$files = scandir ( "/home/www-data/var/www/html/owncloud");
			$return['msg'] .= "Purge des répertoires utilisateurs d'Owncloud :<br>";
			foreach($files as $file) {
				if(is_dir("/home/www-data/var/www/html/owncloud/".$file)&&$file!="."&&$file!=".."&&$file!="files_external") {
					deleteDir("/home/www-data/var/www/html/owncloud/".$file);
					$return['msg'] .= $file."<br>";
				}
					
			}
			$return['error'] = 0;
		break;

		/*
		* Scan file Owncloud
		*/
		case 'mig-scanowncloud':
		$return['error'] = 0;
		$output=shell_exec("cd /var/www/html/owncloud; php occ files:cleanup");
			if(!$output) {
				$return['error'] = 1;
			}
			$return['msg'] = nl2br($output);

			$output=shell_exec("cd /var/www/html/owncloud; php occ files:scan --all");
			if(!$output) {
				$return['error'] = 1;
			}
			$return['msg'] .= nl2br($output);			
			
		break;

		
		/*
		* Scan file Nextcloud
		*/
		case 'mig-scannextcloud':
		$return['error'] = 0;
		$output=shell_exec("cd /var/www/html/nextcloud; php occ files:cleanup");
			if(!$output) {
				$return['error'] = 1;
			}
			$return['msg'] = nl2br($output);

			$output=shell_exec("cd /var/www/html/nextcloud; php occ files:scan --all");
			if(!$output) {
				$return['error'] = 1;
			}
			$return['msg'] .= nl2br($output);			
			
		break;

		default:
		break;
	}
	echo json_encode($return);
} else {
	$return['error'] = 1;
	echo json_encode($return);
}