<?php 
/*
 * Provide navigation sidebar functionality to Dokuwiki Templates
 *
 * This is not currently part of the official Dokuwiki release
 *
 * @link   http://wiki.jalakai.co.uk/dokuwiki/doku.php?id=tutorials:dev:navigation_sidebar
 * @author Christopher Smith <chris@knowledge.tv>
 */
 
$conf['navigate']    = 'navigate';        //name of navigation page
 
// recursive function to establish best navigate file to be used
function getNavigateFN($ns, $file) {
 
	// check for wiki page = $ns:$file (or $file where no namespace)
	$nsFile = ($ns) ? "$ns:$file" : $file;
	if (file_exists(wikiFN($nsFile))) return $nsFile;
 
// remove deepest namespace level and call function recursively
 
	// no namespace left, exit with no file found	
	if (!$ns) return '';
 
	$i = strrpos($ns, ":");
	$ns = ($i) ? substr($ns, 0, $i) : false;	
	return getNavigateFN($ns, $file);
}
 
function html_navigate() {
	global $ID;
	global $REV;
	global $conf;
 
	// save globals
	$saveID = $ID;
	$saveREV = $REV;
 
	// discover file to be displayed in navigation sidebar	
	$fileNavigate = '';
 
	if (isset($conf['navigate'])) {
		$fileNavigate = getNavigateFN(getNS($ID), $conf['navigate']);
	}
 
	// determine what to display
	if ($fileNavigate) {
		$ID = $fileNavigate;
		$REV = '';
		print p_wiki_xhtml($ID,$REV,false);
	}
	else {
		html_index('.');
	}
 
	// close navigate <div>	and restore globals
	$ID = $saveID;
	$REV = $saveREV;
}
 
?>
