\r eportail
SET character_set_client = utf8;

-- UPGRADE 3.00 TO 3.01-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 300to301;
DELIMITER |
CREATE PROCEDURE 300to301()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0' THEN

		-- Gestion du partage de page
		CREATE TABLE  env_profil_share (
			profil_share_id INT( 11 ) NOT NULL ,
			profil_share_label VARCHAR( 255 ) NOT NULL ,
			PRIMARY KEY (profil_share_id)
		) ENGINE = MYISAM ;

		ALTER TABLE  env_ldap_profil ADD ldap_profil_share INT( 11 ) NOT NULL AFTER ldap_profil_filter;
		ALTER TABLE  env_sso_profil ADD sso_profil_share INT( 11 ) NOT NULL AFTER sso_profil_label;

		-- Update permission de partage pour profil admin
		UPDATE env_ldap_profil SET ldap_profil_share = 99 WHERE ldap_profil_id = -500;

		-- Gestion des groupes
		ALTER TABLE env_group ADD group_user INT( 11 ) NOT NULL AFTER group_mode;
		ALTER TABLE env_group CHANGE group_mode group_type INT( 11 ) NOT NULL;
		ALTER TABLE env_group_user DROP group_user_profil;

		-- Gestion du type de groupe
		CREATE TABLE  env_group_type (
			group_type_id INT( 11 ) NOT NULL ,
			group_type_label VARCHAR( 255 ) NOT NULL ,
			PRIMARY KEY (group_type_id)
		) ENGINE = MYISAM ;

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.1' WHERE  config_appli =  'core' AND  config_key =  'version';

	END IF;
END|
DELIMITER ;

CALL 300to301();
DROP PROCEDURE 300to301;

-- UPGRADE 3.01 TO 3.02-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 301to3002;
DELIMITER |
CREATE PROCEDURE 301to3002()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.1' THEN
		-- Création champs badget et callback
		ALTER TABLE `env_application`
			ADD  `application_badge` VARCHAR( 255 ) NOT NULL AFTER  `application_color` ,
			ADD  `application_callback` VARCHAR( 255 ) NOT NULL AFTER  `application_badge`,
			ADD  `application_callbackmsg` LONGTEXT NOT NULL AFTER  `application_callback`;

            UPDATE  env_panel SET panel_url='view/envole/index.php' WHERE panel_id=-500;

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.02' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;
END|
DELIMITER ;

CALL 301to3002();
DROP PROCEDURE 301to3002;


-- UPGRADE 3.02 TO 3.0.03-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3002to3003;
DELIMITER |
CREATE PROCEDURE 3002to3003()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.02' THEN
		ALTER TABLE  `env_panel`
			ADD  `panel_icon` VARCHAR( 255 ) NULL AFTER  `panel_order`,
			ADD  `panel_color` VARCHAR( 255 ) NULL AFTER  `panel_icon` ,
			ADD  `panel_colorlabel` VARCHAR( 255 ) NULL AFTER  `panel_color`;

		ALTER TABLE  `env_widget`
			ADD  `widget_iconlabel` VARCHAR( 255 ) NULL AFTER  `widget_height`,
			ADD  `widget_color` VARCHAR( 255 ) NULL AFTER  `widget_iconlabel` ,
			ADD  `widget_colorlabel` VARCHAR( 255 ) NULL AFTER  `widget_color`,
			ADD  `widget_colorbody` VARCHAR( 255 ) NULL AFTER  `widget_colorlabel`,
			ADD  `widget_centerlabel` TINYINT(1) NULL AFTER  `widget_colorbody`,
			ADD  `widget_colorbodylabel` VARCHAR( 255 ) NULL AFTER  `widget_centerlabel`,
			ADD  `widget_nbarticle` INT( 11 ) NULL AFTER  `widget_colorbodylabel`;


		ALTER TABLE  `env_panel_widget`
			ADD  `panel_widget_iconlabel` VARCHAR( 255 ) NULL AFTER  `panel_widget_height`,
			ADD  `panel_widget_colorlabel` VARCHAR( 255 ) NULL AFTER  `panel_widget_color`,
			ADD  `panel_widget_colorbody` VARCHAR( 255 ) NULL AFTER  `panel_widget_colorlabel`,
			ADD  `panel_widget_centerlabel` TINYINT(1) NULL AFTER  `panel_widget_colorbody`,
			ADD  `panel_widget_colorbodylabel` VARCHAR( 255 ) NULL AFTER  `panel_widget_centerlabel`,
			ADD  `panel_widget_nbarticle` INT( 11 ) NULL AFTER  `panel_widget_colorbodylabel`;

		UPDATE env_panel_widget, env_widget  SET panel_widget_nbarticle=5 WHERE panel_widget_widget=widget_id AND widget_type=2;
		UPDATE env_widget SET widget_nbarticle=5 WHERE widget_type=2;

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.03' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;
END|
DELIMITER ;

CALL 3002to3003();
DROP PROCEDURE 3002to3003;



-- UPGRADE 3.0.03 TO 3.0.04-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3003to3004;
DELIMITER |
CREATE PROCEDURE 3003to3004()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.03' THEN
        ALTER TABLE  `env_flux_ldap_profil` ADD  `flux_ldap_profil_edition` BOOLEAN NOT NULL;
        ALTER TABLE  `env_flux_profil` ADD  `flux_profil_edition` BOOLEAN NOT NULL;
        ALTER TABLE  `env_flux_sso_profil` ADD  `flux_sso_profil_edition` BOOLEAN NOT NULL;

        CREATE TABLE IF NOT EXISTS `env_postit` (
          `postit_id` int(11) NOT NULL AUTO_INCREMENT,
          `postit_start` date NOT NULL,
          `postit_end` date NOT NULL,
          `postit_title` varchar(255) NOT NULL,
          `postit_icon` varchar(255) DEFAULT NULL,
          `postit_message` longtext NOT NULL,
          `postit_canclose` tinyint(1) NOT NULL,
          PRIMARY KEY (`postit_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

        CREATE TABLE IF NOT EXISTS `env_postit_profil` (
          `postit_profil_postit` int(11) NOT NULL,
          `postit_profil_profil` int(11) NOT NULL,
          PRIMARY KEY (`postit_profil_postit`,`postit_profil_profil`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

        CREATE TABLE IF NOT EXISTS `env_postit_sso_profil` (
          `postit_sso_profil_postit` int(11) NOT NULL,
          `postit_sso_profil_profil` int(11) NOT NULL,
          PRIMARY KEY (`postit_sso_profil_postit`,`postit_sso_profil_profil`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

        CREATE TABLE IF NOT EXISTS `env_postit_ldap_profil` (
          `postit_ldap_profil_postit` int(11) NOT NULL,
          `postit_ldap_profil_profil` int(11) NOT NULL,
          PRIMARY KEY (`postit_ldap_profil_postit`,`postit_ldap_profil_profil`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

        CREATE TABLE IF NOT EXISTS `env_postit_user` (
          `postit_user_postit` int(11) NOT NULL,
          `postit_user_user` int(11) NOT NULL,
          `postit_user_view` date DEFAULT NULL,
          `postit_user_close` date DEFAULT NULL,
          PRIMARY KEY (`postit_user_postit`,`postit_user_user`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

		ALTER TABLE  `env_widget` ADD  `widget_actif` BOOLEAN NOT NULL AFTER  `widget_code`;
		UPDATE env_widget SET widget_actif=1 WHERE widget_id!=-460;

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.04' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;
END|
DELIMITER ;

CALL 3003to3004();
DROP PROCEDURE 3003to3004;



-- UPGRADE 3.0.04 TO 3.0.05-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3004to3005;
DELIMITER |
CREATE PROCEDURE 3004to3005()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.04' THEN
        CREATE TABLE IF NOT EXISTS `env_application_group` (
          `application_group_application` int(11) NOT NULL,
          `application_group_group` int(11) NOT NULL,
          UNIQUE KEY `application_group_application_application_group_group` (`application_group_application`,`application_group_group`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

        CREATE TABLE IF NOT EXISTS `env_flux_group` (
          `flux_group_flux` int(11) NOT NULL,
          `flux_group_group` int(11) NOT NULL,
          `flux_group_edition` tinyint(4) NOT NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

        CREATE TABLE IF NOT EXISTS `env_panel_group` (
          `panel_group_panel` int(11) NOT NULL,
          `panel_group_group` int(11) NOT NULL,
          UNIQUE KEY `panel_group_panel_panel_group_group` (`panel_group_panel`,`panel_group_group`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

        CREATE TABLE IF NOT EXISTS `env_postit_group` (
          `postit_group_postit` int(11) NOT NULL,
          `postit_group_group` int(11) NOT NULL,
          UNIQUE KEY `postit_group_postit_postit_group_group` (`postit_group_postit`,`postit_group_group`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.05' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;
END|
DELIMITER ;

CALL 3004to3005();
DROP PROCEDURE 3004to3005;

-- UPGRADE 3.0.05 TO 3.0.06-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3005to3006;
DELIMITER |
CREATE PROCEDURE 3005to3006()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.05' THEN
        CREATE TABLE `env_panel_widget_task` (
          `panel_widget_task_id` int(11) NOT NULL AUTO_INCREMENT,
          `panel_widget_task_priority` int(11) NOT NULL,
          `panel_widget_task_title` int(11) NOT NULL,
          `panel_widget_task_description` longtext NOT NULL,
          `panel_widget_task_date` date NOT NULL,
          `panel_widget_task_do` int(11) NOT NULL,
          `panel_widget_task_writeprofil` smallint(6) NOT NULL,
          `panel_widget_task_widget` int(11) NOT NULL,
          PRIMARY KEY (`panel_widget_task_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.06' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;
END|
DELIMITER ;

CALL 3005to3006();
DROP PROCEDURE 3005to3006;


-- UPGRADE 3.0.06 TO 3.0.07-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3006to3007;
DELIMITER |
CREATE PROCEDURE 3006to3007()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.06' THEN
        ALTER TABLE `env_panel_widget_task` CHANGE  `panel_widget_task_title`  `panel_widget_task_title` VARCHAR( 250 ) NOT NULL ;

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.07' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;
END|
DELIMITER ;

CALL 3006to3007();
DROP PROCEDURE 3006to3007;


-- UPGRADE 3.0.07 TO 3.0.08-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3007to3008;
DELIMITER |
CREATE PROCEDURE 3007to3008()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.07' THEN
        CREATE TABLE IF NOT EXISTS `env_calendar` (
          `calendar_id` int(11) NOT NULL AUTO_INCREMENT,
          `calendar_name` varchar(250) DEFAULT NULL,
          `calendar_color` varchar(250) DEFAULT NULL,
          `calendar_user` int(11) DEFAULT NULL,
          PRIMARY KEY (`calendar_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

        CREATE TABLE IF NOT EXISTS `env_calendar_event` (
          `calendar_event_id` int(11) NOT NULL AUTO_INCREMENT,
          `calendar_event_label` varchar(250) DEFAULT NULL,
          `calendar_event_descritif` longtext,
          `calendar_event_start` datetime DEFAULT NULL,
          `calendar_event_end` datetime DEFAULT NULL,
          `calendar_event_allday` bigint(20) DEFAULT NULL,
          `calendar_event_repeat` int(11) DEFAULT NULL,
          `calendar_event_calendar` int(11) DEFAULT NULL,
          PRIMARY KEY (`calendar_event_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

        CREATE TABLE IF NOT EXISTS `env_calendar_group` (
          `calendar_group_calendar` int(11) NOT NULL,
          `calendar_group_group` int(11) NOT NULL,
          PRIMARY KEY (`calendar_group_calendar`,`calendar_group_group`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

        CREATE TABLE IF NOT EXISTS `env_calendar_ldap_profil` (
          `calendar_ldap_profil_calendar` int(11) NOT NULL,
          `calendar_ldap_profil_ldap_profil` int(11) NOT NULL,
          PRIMARY KEY (`calendar_ldap_profil_calendar`,`calendar_ldap_profil_ldap_profil`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

        CREATE TABLE IF NOT EXISTS `env_calendar_profil` (
          `calendar_profil_calendar` int(11) NOT NULL,
          `calendar_profil_profil` int(11) NOT NULL,
          PRIMARY KEY (`calendar_profil_calendar`,`calendar_profil_profil`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;


        CREATE TABLE IF NOT EXISTS `env_calendar_sso_profil` (
          `calendar_sso_profil_calendar` int(11) NOT NULL,
          `calendar_sso_profil_sso_profil` int(11) NOT NULL,
          PRIMARY KEY (`calendar_sso_profil_calendar`,`calendar_sso_profil_sso_profil`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.08' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;
END|
DELIMITER ;

CALL 3007to3008();
DROP PROCEDURE 3007to3008;


-- UPGRADE 3.0.08 TO 3.0.09-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3008to3009;
DELIMITER |
CREATE PROCEDURE 3008to3009()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.08' THEN
        ALTER TABLE  `env_panel_widget_task` ADD  `panel_widget_task_user` INT( 11 ) NULL AFTER  `panel_widget_task_writeprofil`;

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.09' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;
END|
DELIMITER ;

CALL 3008to3009();
DROP PROCEDURE 3008to3009;

-- UPGRADE 3.0.09 TO 3.0.10-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3009to3010;
DELIMITER |
CREATE PROCEDURE 3009to3010()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.09' THEN
        ALTER TABLE `env_panel_widget` CHANGE  `panel_widget_url`  `panel_widget_url` VARCHAR( 1000 ) NOT NULL ;
        ALTER TABLE `env_flux` CHANGE  `flux_url`  `flux_url` VARCHAR( 1000 ) NOT NULL ;

        ALTER TABLE  `env_panel_group` ADD  `panel_group_mode` BOOLEAN NOT NULL;
        ALTER TABLE  `env_panel_ldap_profil` ADD  `panel_ldap_profil_mode` BOOLEAN NOT NULL;
        ALTER TABLE  `env_panel_profil` ADD  `panel_profil_mode` BOOLEAN NOT NULL;
        ALTER TABLE  `env_panel_sso_profil` ADD  `panel_sso_profil_mode` BOOLEAN NOT NULL;

        ALTER TABLE  `env_panel` ADD  `panel_master` INT( 11 );

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.10' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;
END|
DELIMITER ;

CALL 3009to3010();
DROP PROCEDURE 3009to3010;


-- UPGRADE 3.0.10 TO 3.0.11-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3010to3011;
DELIMITER |
CREATE PROCEDURE 3010to3011()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.10' THEN
        ALTER TABLE  `env_icon` ADD  `icon_user` INT ( 11 );
        CREATE INDEX icon_user ON env_icon (icon_user);

        ALTER TABLE  `env_profil` ADD  `profil_fgban` BOOLEAN NOT NULL AFTER `profil_label`;
        ALTER TABLE  `env_ldap_profil` ADD  `ldap_profil_fgban` BOOLEAN NOT NULL AFTER `ldap_profil_label`;
        ALTER TABLE  `env_sso_profil` ADD  `sso_profil_fgban` BOOLEAN NOT NULL AFTER `sso_profil_label`;

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.11' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;
END|
DELIMITER ;

CALL 3010to3011();
DROP PROCEDURE 3010to3011;



-- UPGRADE 3.0.11 TO 3.0.12-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3011to3012;
DELIMITER |
CREATE PROCEDURE 3011to3012()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.11' THEN
		CREATE TABLE  env_profil_moderation (
		    profil_moderation_order INT ( 11 ) NOT NULL ,
		    profil_moderation_label VARCHAR( 255 ) NOT NULL ,
		    profil_moderation_url VARCHAR( 255 ) NOT NULL ,
			profil_moderation_fgperm  BOOLEAN NOT NULL ,
			PRIMARY KEY (profil_moderation_url)
		) ENGINE = MYISAM ;

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.12' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;
END|
DELIMITER ;

CALL 3011to3012();
DROP PROCEDURE 3011to3012;



-- UPGRADE 3.0.12 TO 3.0.13-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3012to3013;
DELIMITER |
CREATE PROCEDURE 3012to3013()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.12' THEN
        ALTER TABLE `env_application` CHANGE  `application_url`  `application_url` VARCHAR( 1000 ) NOT NULL ;
        ALTER TABLE `env_panel` CHANGE  `panel_url`  `panel_url` VARCHAR( 1000 ) NOT NULL ;
        ALTER TABLE `env_panel_widget_bookmark` CHANGE  `panel_widget_bookmark_url`  `panel_widget_bookmark_url` VARCHAR( 1000 ) NOT NULL ;
        ALTER TABLE `env_panel_widget_carousel` CHANGE  `panel_widget_carousel_url`  `panel_widget_carousel_url` VARCHAR( 1000 ) NOT NULL ;

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.13' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;
END|
DELIMITER ;

CALL 3012to3013();
DROP PROCEDURE 3012to3013;

-- UPGRADE 3.0.13 TO 3.0.14-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3013to3014;
DELIMITER |
CREATE PROCEDURE 3013to3014()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.13' THEN
		ALTER TABLE `env_application` ADD `application_colorfont` VARCHAR(10) NOT NULL AFTER `application_color`;

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.14' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;
END|
DELIMITER ;

CALL 3013to3014();
DROP PROCEDURE 3013to3014;

-- UPGRADE 3.0.14 TO 3.0.15-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3014to3015;
DELIMITER |
CREATE PROCEDURE 3014to3015()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.14' THEN
		CREATE TABLE `env_charte` (
		  `charte_id` int(11) NOT NULL,
		  `charte_name` varchar(255) NOT NULL,
		  `charte_html` longtext NOT NULL,
		  `charte_mustread` tinyint(1) NOT NULL
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

		CREATE TABLE `env_charte_group` (
		  `charte_group_charte` int(11) NOT NULL,
		  `charte_group_group` int(11) NOT NULL
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

		CREATE TABLE `env_charte_ldap_profil` (
		  `charte_ldap_profil_charte` int(11) NOT NULL,
		  `charte_ldap_profil_ldap_profil` int(11) NOT NULL
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

		CREATE TABLE `env_charte_profil` (
		  `charte_profil_charte` int(11) NOT NULL,
		  `charte_profil_profil` int(11) NOT NULL
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

		CREATE TABLE `env_charte_sso_profil` (
		  `charte_sso_profil_charte` int(11) NOT NULL,
		  `charte_sso_profil_sso_profil` int(11) NOT NULL
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

		CREATE TABLE `env_charte_user` (
		  `charte_user_charte` int(11) NOT NULL,
		  `charte_user_user` int(11) NOT NULL,
		  `charte_user_view` datetime DEFAULT NULL
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

		ALTER TABLE `env_charte` ADD PRIMARY KEY (`charte_id`);
		ALTER TABLE `env_charte_group` ADD UNIQUE KEY `unique` (`charte_group_charte`,`charte_group_group`);
		ALTER TABLE `env_charte_ldap_profil` ADD UNIQUE KEY `unique` (`charte_ldap_profil_charte`,`charte_ldap_profil_ldap_profil`);
		ALTER TABLE `env_charte_profil` ADD UNIQUE KEY `unique` (`charte_profil_charte`,`charte_profil_profil`);
		ALTER TABLE `env_charte_sso_profil` ADD UNIQUE KEY `unique` (`charte_sso_profil_charte`,`charte_sso_profil_sso_profil`);
		ALTER TABLE `env_charte_user` ADD PRIMARY KEY (`charte_user_charte`,`charte_user_user`);
		ALTER TABLE `env_charte` MODIFY `charte_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.15' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;
END|
DELIMITER ;

CALL 3014to3015();
DROP PROCEDURE 3014to3015;

-- UPGRADE 3.0.15 TO 3.0.16-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3015to3016;
DELIMITER |
CREATE PROCEDURE 3015to3016()
BEGIN
	DECLARE version VARCHAR(100);
	
	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.15' THEN
		ALTER TABLE  `env_user` ADD  `user_lastaction` DATETIME NULL AFTER  `user_email`;
        
		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.16' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;		
END|
DELIMITER ;

CALL 3015to3016();
DROP PROCEDURE 3015to3016;  


-- UPGRADE 3.0.16 TO 3.0.17-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3016to3017;
DELIMITER |
CREATE PROCEDURE 3016to3017()
BEGIN
	DECLARE version VARCHAR(100);
	
	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.16' THEN
		CREATE TABLE `env_notif` (
		  `notif_id` int(11) NOT NULL,
		  `notif_user` int(11) NOT NULL,
		  `notif_label` VARCHAR( 255 )  DEFAULT NULL,
		  `notif_description` longtext  DEFAULT NULL,
		  `notif_submit` datetime DEFAULT NULL, 
		  `notif_view` datetime DEFAULT NULL
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;
        
		ALTER TABLE `env_notif` ADD PRIMARY KEY (`notif_id`);
		ALTER TABLE `env_notif` MODIFY `notif_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
		ALTER TABLE `env_notif` ADD KEY (`notif_user`);

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.17' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;		
END|
DELIMITER ;

CALL 3016to3017();
DROP PROCEDURE 3016to3017;  

-- UPGRADE 3.0.17 TO 3.0.18-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3017to3018;
DELIMITER |
CREATE PROCEDURE 3017to3018()
BEGIN
	DECLARE version VARCHAR(100);
	
	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.17' THEN
		CREATE TABLE `env_plugin` (
		  `plugin_id` int(11) NOT NULL,
		  `plugin_idname` VARCHAR( 255 ) NOT NULL,
		  `plugin_actif` tinyint(1) NOT NULL
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;
        
		ALTER TABLE `env_plugin` ADD PRIMARY KEY (`plugin_id`);
		ALTER TABLE `env_plugin` MODIFY `plugin_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
		ALTER TABLE `env_plugin` ADD UNIQUE `plugin_idname` (`plugin_idname`);

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.18' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;		
END|
DELIMITER ;

CALL 3017to3018();
DROP PROCEDURE 3017to3018;  


-- UPGRADE 3.0.18 TO 3.0.19-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3018to3019;
DELIMITER |
CREATE PROCEDURE 3018to3019()
BEGIN
	DECLARE version VARCHAR(100);
	
	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.18' THEN
		ALTER TABLE `env_panel_widget` ADD `panel_widget_icon` INT(11) NOT NULL DEFAULT '-1127' AFTER `panel_widget_html`;

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.19' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;		
END|
DELIMITER ;

CALL 3018to3019();
DROP PROCEDURE 3018to3019;  

-- UPGRADE 3.0.19 TO 3.0.20-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3019to3020;
DELIMITER |
CREATE PROCEDURE 3019to3020()
BEGIN
	DECLARE version VARCHAR(100);
	
	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.19' THEN
		ALTER TABLE `env_panel` ADD `panel_open` INT(11) NOT NULL DEFAULT '0' AFTER `panel_type`;
		
		ALTER TABLE `env_calendar` ADD `calendar_type` INT(11) NOT NULL DEFAULT '0' AFTER `calendar_user`;
		ALTER TABLE `env_calendar` ADD `calendar_url` VARCHAR(1000)	NULL DEFAULT NULL AFTER `calendar_type`;
		ALTER TABLE `env_calendar` ADD `calendar_login` VARCHAR(250) NULL DEFAULT NULL AFTER `calendar_url`;
		ALTER TABLE `env_calendar` ADD `calendar_pwd` VARCHAR(250) NULL DEFAULT NULL AFTER `calendar_login`;
		
		ALTER TABLE `env_calendar_event` ADD `calendar_event_uid` VARCHAR(250) NULL DEFAULT NULL AFTER `calendar_event_repeat`;
		CREATE INDEX calendar_event_uid ON env_calendar_event (calendar_event_calendar, calendar_event_uid);

		CREATE TABLE `env_calendar_event_group` (
		  `calendar_event_group_event` int(11) NOT NULL,
		  `calendar_event_group_group` int(11) NOT NULL
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

		CREATE TABLE `env_calendar_event_ldap_profil` (
		  `calendar_event_ldap_profil_event` int(11) NOT NULL,
		  `calendar_event_ldap_profil_ldap_profil` int(11) NOT NULL
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

		CREATE TABLE `env_calendar_event_profil` (
		  `calendar_event_profil_event` int(11) NOT NULL,
		  `calendar_event_profil_profil` int(11) NOT NULL
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

		CREATE TABLE `env_calendar_event_sso_profil` (
		  `calendar_event_sso_profil_event` int(11) NOT NULL,
		  `calendar_event_sso_profil_sso_profil` int(11) NOT NULL
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

		ALTER TABLE `env_calendar_event_group` ADD UNIQUE KEY `unique` (`calendar_event_group_event`,`calendar_event_group_group`);
		ALTER TABLE `env_calendar_event_ldap_profil` ADD UNIQUE KEY `unique` (`calendar_event_ldap_profil_event`,`calendar_event_ldap_profil_ldap_profil`);
		ALTER TABLE `env_calendar_event_profil` ADD UNIQUE KEY `unique` (`calendar_event_profil_event`,`calendar_event_profil_profil`);
		ALTER TABLE `env_calendar_event_sso_profil` ADD UNIQUE KEY `unique` (`calendar_event_sso_profil_event`,`calendar_event_sso_profil_sso_profil`);

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.20' WHERE  config_appli =  'core' AND  config_key =  'version';
		
	END IF;		
END|
DELIMITER ;

CALL 3019to3020();
DROP PROCEDURE 3019to3020;  

-- UPGRADE 3.0.20 TO 3.0.21-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3020to3021;
DELIMITER |
CREATE PROCEDURE 3020to3021()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.20' THEN
        ALTER TABLE  `env_profil` ADD  `profil_fgannu` BOOLEAN NOT NULL AFTER `profil_fgban`;
        ALTER TABLE  `env_ldap_profil` ADD  `ldap_profil_fgannu` BOOLEAN NOT NULL AFTER `ldap_profil_fgban`;
        ALTER TABLE  `env_sso_profil` ADD  `sso_profil_fgannu` BOOLEAN NOT NULL AFTER `sso_profil_fgban`;

		-- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.21' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;
END|
DELIMITER ;

CALL 3020to3021();
DROP PROCEDURE 3020to3021;

-- UPGRADE 3.0.21 TO 3.0.22-- ------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS 3021to3022;
DELIMITER |
CREATE PROCEDURE 3021to3022()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT config_value INTO version FROM env_config WHERE config_appli = 'core' AND  config_key = 'version';

	IF version = '3.0.21' THEN
		CREATE TABLE `env_rgpd` (
		  `rgpd_id` int(11) NOT NULL,
		  `rgpd_html` longtext  DEFAULT NULL
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;
        
        INSERT IGNORE INTO `env_rgpd` (`rgpd_id`) VALUES (1);
		
        -- Mise à jour de la version applicative
		UPDATE  env_config SET  config_value =  '3.0.22' WHERE  config_appli =  'core' AND  config_key =  'version';
	END IF;
END|
DELIMITER ;

CALL 3021to3022();
DROP PROCEDURE 3021to3022;