<?
require_once('include/config.php');
include_once("include/mysql.php");
require_once('lib/php/jsonRPCClient.php');

define( 'LS_BASEURL', 'https://'.$config["host"].'/limesurvey/index.php');  // adjust this one to your actual LimeSurvey URL
define( 'LS_USER', 'restuser' );
define( 'LS_PASSWORD', 'apikeyenvole' );

function rrmdir($dir) {
    if (is_dir($dir)) {
      $objects = scandir($dir);
      foreach ($objects as $object) {
        if ($object != "." && $object != "..") {
          if (filetype($dir."/".$object) == "dir"){
             rrmdir($dir."/".$object);
          }else{ 
             unlink($dir."/".$object);
          }
        }
      }
      reset($objects);
      rmdir($dir);
   }
 }

// instantiate a new client
$myJSONRPCClient = new JsonRPCClient( LS_BASEURL.'/admin/remotecontrol' );

// receive session key
$sessionKey= $myJSONRPCClient->get_session_key( LS_USER, LS_PASSWORD );

// On purge les fichiers tempo des survey user pour les regen complètement
if(is_dir($config['localdirectory']."/local/limesurvey"))
    rrmdir($config['localdirectory']."/local/limesurvey");
    
mkdir($config['localdirectory']."/local/limesurvey");

// list des surveys
$surveys= $myJSONRPCClient->list_surveys($sessionKey);

foreach($surveys as $survey) {
    if(!is_array($survey)) continue;

    if($survey["active"]=="Y") {
        $insurvey=false;
        $survey_id=$survey["sid"];
        $users = $myJSONRPCClient->list_participants($sessionKey, $survey_id, 0, 10000);
        $token="";
        
        foreach($users as $user) {
            if(isset($user["participant_info"]["email"]) && $user["participant_info"]["email"]!="") {
                $q = "SELECT * FROM ".$config["dbprefixe"]."user WHERE user_email=?";
                $query=$bdd01->prepare($q);
                if(isset($user["participant_info"]["email"])) {
                    $query->execute(array($user["participant_info"]["email"]));
                    if($row=$query->fetch()){	
                        $myfile = fopen($config['localdirectory']."/local/limesurvey/".$row["user_id"].".html", "a");
                        $token=$user["token"];
                        $url=LS_BASEURL."/".$survey_id;
                        if($token!="")
                            $url.="?token=".$token;
                    
                        fwrite($myfile,"<a href='".$url."' target='blank'>".$survey["surveyls_title"]."</a><br>");
                        fclose($myfile);

                    }
                }
            }
        }
    }
}


// release the session key
$myJSONRPCClient->release_session_key( $sessionKey );

echo "</div>";