<?php
/**
 * Created by PhpStorm.
 * User: mathieu
 * Date: 04/04/18
 * Time: 10:02
 */

/**
 * Class CasProxyPronote
 *
 * Gère la connexion et la récupération du XML issu de pronote
 */
class CasProxyPronote
{
    private $pronoteUrl;
    private $reverseProxyAddr;
    private $ssoUrl;

    public function __construct($ssoUrl, $pronoteUrl, $reverseProxyAddr = null)
    {
        $this->ssoUrl = $ssoUrl;
        $this->pronoteUrl = $pronoteUrl;
        $this->reverseProxyAddr = $reverseProxyAddr;
    }

    protected function createProxyTicket($fromPGT)
    {
        $ch = curl_init();

        //TODO : implement eolesso params
        curl_setopt($ch, CURLOPT_URL, sprintf("%s/proxy?targetService=%s&pgt=%s", $this->ssoUrl, $this->pronoteUrl, $fromPGT));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $resp = curl_exec($ch);
        if (!resp) {
            throw new Exception('Une erreur est survenue lors du contact du serveur SSO');
        }
        $pt = null;
        $ptx = simplexml_load_string($resp, "SimpleXMLElement", 0, "cas", true);
        $pt = (string)$ptx->proxySuccess->proxyTicket;
        if (!$pt || is_null($pt)) {
            throw new Exception('Une erreur est survenue lors de la génération du ticket proxy');
        }
        curl_close($ch);

        return $pt;
    }

    //"172.18.99.254:3128"
    public function getPronoteInfos($fromPGT)
    {
        $pt = $this->createProxyTicket($fromPGT);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, sprintf("%s?ticket=%s&method=proxyValidate", $this->pronoteUrl, $pt));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        if ($this->reverseProxyAddr != null) {
            curl_setopt($ch, CURLOPT_PROXY, $this->reverseProxyAddr);
        }
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Length: 0'));
        $resp = curl_exec($ch);
        if (!resp) {
            throw new Exception('Une erreur est survenue lors du contact de pronote');
        }
        $xml = simplexml_load_string($resp);

        //$xml = simplexml_load_file("test.xml");

        return $xml;
    }
}


/**
 * Class ParentWidget
 * Gère le parsing et l'affichage du xml pour les parents
 */
class ParentWidget implements WidgetInterface
{

    public function getWidgetContent($xml)
    {
        $stdCount = 0;
        $output = "<div class='student-holder'>";
        foreach ($xml->Eleve as $eleve) {
            $output .= "<input name='student-choice' type='radio' class='student-choice' value='student-$stdCount' id='radio-student-$stdCount'";
            $output .= $stdCount == 0 ? "checked='true'" : "";
            $output .= ">";
            $output .= "<label for='radio-student-$stdCount'>";
            $output .= "<i class='fa fa-user-circle'> </i>  $eleve->Nom $eleve->Prenom</label>";
            $output .= "<div class='student-content'>";
            $output .= $this->getEleveContent($eleve);
            $output .= "</div>";

            $stdCount++;
        }
        $output .= "</div>";

        return $output;
    }

    protected function getEleveContent($xml)
    {
        /**
         * Start of the widget, we first display absences
         */
        $output = <<<EOF
<section>
<h3>Absences non-justifiées</h3>
EOF;

        $pageVieScolaire = $xml->PageVieScolaire;
        $abnj = array();
        foreach ($pageVieScolaire->Absence as $absence) {
            if ((bool)$absence->Justifie) {
                continue;
            }
            $a = new StdClass();
            $a->DateDebut = new DateTime((string)$absence->DateDebut);
            $a->DateFin = new DateTime((string)$absence->DateFin);
            $abnj[] = $a;
        }

        $output .= "<ul class='list-unstyled'>";
        if (count($abnj) > 0) {
            foreach ($abnj as $abs) {
                $output .= sprintf("<li>Du %s au %s</li>", $abs->DateDebut->format("d/m/y à H\hi"), $abs->DateFin->format("d/m/y à H\hi"));
            }
        } else {
            $output .= "<li>-</li>";
        }
        $output .= "</ul>";
        $output .= "</section>";
        /**
         * End of absences, beginning of notes
         */
        /**
         * Relevé de notes
         */
        $pageReleveDeNote = $xml->PageReleveDeNotes;
        $output .= "<section><h3>Dernières notes</h3><ul class='list-unstyled'>";
        $notes = array();
        foreach ($pageReleveDeNote->Devoir as $devoir) {
            $n = new StdClass();
            $n->Note = (float)str_replace(",", ".", $devoir->Note[0]);
            $n->Bareme = (int)$devoir->Bareme;
            $n->Matiere = (string)$devoir->Matiere;
            $n->Date = new DateTime((string)$devoir->Date);

            $notes[] = $n;
        }
        if (count($notes) > 0) {
            foreach (array_reverse($notes) as $devoir) {
                $output .= sprintf("<li>%s sur %s en %s le %s</li>", $devoir->Note, $devoir->Bareme, $devoir->Matiere, $devoir->Date->format('d/m/Y'));
            }
        } else {
            $output .= "<li>Aucune</li>";
        }
        $output .= "</ul>";
        $output .= "</section>";
        /**
         * End of notes, beginning of homeworks
         */

        $cdt = $xml->PageCahierDeTextes;
        $output .= "<section><h3>Devoirs à faire</h3>";
        $tafs = array();
        $todayDT = new DateTime();
        $today = $todayDT->format('Y-m-d');

        $tomorrowDT = new DateTime('tomorrow');
        $tomorrow = $tomorrowDT->format('Y-m-d');

        foreach ($cdt->CahierDeTextes as $cahier) {
            foreach ($cahier->TravailAFaire as $taf) {
                $date = (string)$taf->PourLe;
                $matiere = (string)$cahier->Matiere;
                $d = new DateTime($date);
                if ($d <= new DateTime('yesterday')) {
                    continue;
                }
                $oTaf = new StdClass();
                $oTaf->aFaire = strip_tags($taf->Descriptif);
                $oTaf->lien = $taf->SiteInternet ? $taf->SiteInternet : null;
                $oTaf->pj = $taf->PieceJointe ? (string)$taf->PieceJointe : null;

                if (!array_key_exists($date, $tafs)) {
                    $tafs[$date] = array();
                }
                if (!array_key_exists($matiere, $tafs[$date])) {
                    $tafs[$date][$matiere] = array();
                }
                $tafs[$date][$matiere][] = $oTaf;
            }
        }
        ksort($tafs);

        date_default_timezone_set('Europe/Paris');
// --- La setlocale() fonctionnne pour strftime mais pas pour DateTime->format()
        setlocale(LC_TIME, 'fr_FR.utf8', 'fra');
        foreach ($tafs as $key => $mat) {
            $output .= "<dl><dt class='target-time'>";
            if ($key == $today) {
                $output .= "Pour aujourd'hui";
            } elseif ($key == $tomorrow) {
                $output .= "Pour demain :";
            } else {
                $d = new DateTime($key);
                $output .= "Pour le " . strftime("%A %e %B", $d->getTimestamp());
            }
            $output .= "</dt>";
            $output .= "<dd>";
            foreach ($mat as $key2 => $arr) {
                $output .= "<dl>";
                $output .= "<dt>" . $key2 . "</dt>";
                $output .= "<dd><ul class='list-unstyled'>";
                foreach ($arr as $obj) {
                    $output .= "<li>" . $obj->aFaire;
                    if ($obj->lien) {
                        $output .= "<a href='$obj->lien'>$obj->lien</a>";
                    }
                    if ($obj->pj) {
                        $names = explode("/", $obj->pj);
                        $name = $names[count($names) - 1];
                        $output .= "<a href='" . PRONOTE_URL . $obj->pj . "'>$name</a>";
                    }
                    $output .= "</li>";
                }
                $output .= "</ul></dd>";
                $output .= "</dl>";
            }
            $output .= "</dd>";
            $output .= "</dl>";
        }
        $output .= "</section>";

        return $output;
    }
}


/**
 * Class StudentWidget
 * Gère le parsing et l'affichage des infos élève
 */
class StudentWidget implements WidgetInterface
{

    public function getWidgetContent($xml)
    {
        /**
         * Start of the widget, we first display absences
         */
        $output = "<div class='student-holder'>";
        $output .= "<input name='student-choice' type='radio' class='student-choice' value='student' id='radio-student' checked";
        $output .= ">";
        $output .= "<label for='radio-student'>";
        $output .= "<i class='fa fa-user-circle'> </i>  Mes informations</label>";
        $output .= "<div class='student-content'>";
        $output .= <<<EOF
<section>
<h3>Absences non-justifiées</h3>
EOF;

        $pageVieScolaire = $xml->PageVieScolaire;
        $abnj = array();
        foreach ($pageVieScolaire->Absence as $absence) {
            if ((bool)$absence->Justifie) {
                continue;
            }
            $a = new StdClass();
            $a->DateDebut = new DateTime((string)$absence->DateDebut);
            $a->DateFin = new DateTime((string)$absence->DateFin);
            $abnj[] = $a;
        }

        $output .= "<ul class='list-unstyled'>";
        if (count($abnj) > 0) {
            foreach ($abnj as $abs) {
                $output .= sprintf("<li>Du %s au %s</li>", $abs->DateDebut->format("d/m/y à H\hi"), $abs->DateFin->format("d/m/y à H\hi"));
            }
        } else {
            $output .= "<li>Aucune</li>";
        }
        $output .= "</ul>";
        $output .= "</section>";
        /**
         * End of absences, beginning of notes
         */
        /**
         * Relevé de notes
         */
        $pageReleveDeNote = $xml->PageReleveDeNotes;
        $output .= "<section><h3>Dernières notes</h3><ul class='list-unstyled'>";
        $notes = array();
        foreach ($pageReleveDeNote->Devoir as $devoir) {
            $n = new StdClass();
            $n->Note = (float)str_replace(",", ".", $devoir->Note[0]);
            $n->Bareme = (int)$devoir->Bareme;
            $n->Matiere = (string)$devoir->Matiere;
            $n->Date = new DateTime((string)$devoir->Date);

            $notes[] = $n;
        }
        if (count($notes) > 0) {
            foreach (array_reverse($notes) as $devoir) {
                $output .= sprintf("<li>%s sur %s en %s le %s</li>", $devoir->Note, $devoir->Bareme, $devoir->Matiere, $devoir->Date->format('d/m/Y'));
            }
        } else {
            $output .= "<li>Aucune</li>";
        }
        $output .= "</ul>";
        $output .= "</section>";
        /**
         * End of notes, beginning of homeworks
         */

        $cdt = $xml->PageCahierDeTextes;
        $output .= "<section><h3>Devoirs à faire</h3>";
        $tafs = array();
        $todayDT = new DateTime();
        $today = $todayDT->format('Y-m-d');

        $tomorrowDT = new DateTime('tomorrow');
        $tomorrow = $tomorrowDT->format('Y-m-d');

        foreach ($cdt->CahierDeTextes as $cahier) {
            foreach ($cahier->TravailAFaire as $taf) {
                $date = (string)$taf->PourLe;
                $matiere = (string)$cahier->Matiere;
                $d = new DateTime($date);
                if ($d <= new DateTime('yesterday')) {
                    continue;
                }
                $oTaf = new StdClass();
                $oTaf->aFaire = strip_tags($taf->Descriptif);
                $oTaf->lien = $taf->SiteInternet ? $taf->SiteInternet : null;
                $oTaf->pj = $taf->PieceJointe ? (string)$taf->PieceJointe : null;

                if (!array_key_exists($date, $tafs)) {
                    $tafs[$date] = array();
                }
                if (!array_key_exists($matiere, $tafs[$date])) {
                    $tafs[$date][$matiere] = array();
                }
                $tafs[$date][$matiere][] = $oTaf;
            }
        }
        ksort($tafs);

        date_default_timezone_set('Europe/Paris');
// --- La setlocale() fonctionnne pour strftime mais pas pour DateTime->format()
        setlocale(LC_TIME, 'fr_FR.utf8', 'fra');
        foreach ($tafs as $key => $mat) {
            $output .= "<dl><dt class='target-time'>";
            if ($key == $today) {
                $output .= "Pour aujourd'hui";
            } elseif ($key == $tomorrow) {
                $output .= "Pour demain :";
            } else {
                $d = new DateTime($key);
                $output .= "Pour le " . strftime("%A %e %B", $d->getTimestamp());
            }
            $output .= "</dt>";
            $output .= "<dd>";
            foreach ($mat as $key2 => $arr) {
                $output .= "<dl>";
                $output .= "<dt>" . $key2 . "</dt>";
                $output .= "<dd><ul class='list-unstyled'>";
                foreach ($arr as $obj) {
                    $output .= "<li>" . $obj->aFaire;
                    if ($obj->lien) {
                        $output .= " <a href='$obj->lien'>$obj->lien</a>";
                    }
                    if ($obj->pj) {
                        $names = explode("/", $obj->pj);
                        $name = $names[count($names) - 1];
                        $output .= " <a href='" . PRONOTE_URL . $obj->pj . "'>$name</a>";
                    }
                    $output .= "</li>";
                }
                $output .= "</ul></dd>";
                $output .= "</dl>";
            }
            $output .= "</dd>";
            $output .= "</dl>";
        }
        $output .= "</section>";
        $output .= "</div></div>";

        return $output;
    }
}


interface WidgetInterface
{
    public function getWidgetContent($xml);
}

class WidgetFactory
{
    public static function getWidget($profil)
    {
        switch ($profil) {
            case "National_1":
                $widget = new StudentWidget();
                break;
            case "National_2":
                $widget = new ParentWidget();
                break;
        }

        return $widget;
    }
}

