#!/bin/bash
set -e
. fonctions.sh
clear

# Définition du chemin d'installation
cd ..
ROOT_DIR=`pwd`

# INSTALLATION EPORTAIL
Echo ""
Echo "============================================================================="
EchoRouge "INSTALATION EPORTAIL"
Echo "" 

Ret=`QuestionOuiNon "Souhaitez-vous lancer l'installation de ePortail" "oui"`
if [ "${Ret}" == "0" ] ;then
    exit 0;
fi

# GENERATION DU FICHIER DE CONFIGURATION
echo ""
EchoVert "GENERATION DU FICHIER DE CONFIGURATION"
if [ -f ${ROOT_DIR}/include/config.php ] ;then
    Ret=`QuestionOuiNon "Le fichier de configuration existe déjà souhaitez-vous l'écraser ? " "non"`
    if [ "${Ret}" == "1" ] ;then
        rm -rf ${ROOT_DIR}/include/config.php
        rm -rf ${ROOT_DIR}/include/ldap.php
    fi
fi

if [ ! -f ${ROOT_DIR}/include/config.php ] ;then
    host=`QuestionMandatory "Domaine Web (ex: scribe.ac-test.fr) ?" ""`
    localdirectory=${ROOT_DIR}
    alias=`QuestionMandatory "Alias du portail (ex: eportail) ?" "eportail"`
    protocol=`QuestionMandatory "http ou https ?" "https"`
    urlbase=${protocol}://${host}/${alias}
    title=`QuestionMandatory "Titre de votre portail ?" "ePortail"`
    sstitle=`Question "Sous Titre de votre portail ?" ""`
    
    dbhost=`QuestionMandatory "Host de la base de donnée ?" "localhost"`
    dbname=`QuestionMandatory "Nom de la base de donnée ?" "eportail"`
    dblogin=`QuestionMandatory "Utilisateur de la base de donnée ?" "eportail"`
    dbpassword=`QuestionMandatory "Password de l'utilisateur de la base de donnée ?" ""`
    dbprefixe="env_"
   
    proxyurl=`Question "URL de votre proxy si vous en avez un ?" ""`
    proxyport=`Question "Port de votre proxy si vous en avez un ?" ""`
    
    echo ""
    echo "Test de connexion à la base"
    Ret=`mysql -u${dblogin} -p${dbpassword} -h ${dbhost} -e 'use '${dbname}`
    echo "OK"
    
    echo ""
    echo "Récapitulatif"
    echo "host = " ${host}
    echo "urlbase = " ${urlbase}
    echo "localdirectory = " ${localdirectory}
    echo "alias = " ${alias}
    echo "title = " ${title}
    echo "sstitle = " ${sstitle}
    echo "dbhost = " ${dbhost}
    echo "dbname = " ${dbname}
    echo "dblogin = " ${dblogin}
    echo "dbpassword = " ${dbpassword}
    echo "dbprefixe = " ${dbprefixe}
    echo "proxyurl = " ${proxyurl}
    echo "proxyport = " ${proxyport}
    
    Ret=`QuestionOuiNon "Confirmez-vous l'écriture du fichier de configuration ? " "oui"`
    if [ "${Ret}" == "0" ] ;then
        exit 0;
    fi    

    cat <<EOT >> ${ROOT_DIR}/include/config.php
<?
\$config=Array();


/* Serveur */
\$config['fginstalled']                  = true;
\$config['host']                         = '${host}';
\$config['urlbase']                      = '${urlbase}';
\$config['localdirectory']               = '${localdirectory}';
\$config['alias']                        = '${alias}';


/* Database */
\$config['dbhost']                      = '${dbhost}';
\$config['dbname']                      = '${dbname}';
\$config['dblogin']                     = '${dblogin}';
\$config['dbpassword']                  = '${dbpassword}';
\$config['dbprefixe']                   = '${dbprefixe}';

/* Proxy */
\$config['proxyurl']                    = '${proxyurl}';
\$config['proxyport']                   = '${proxyport}';

/* Connexion */
\$config['modeAuthentification']        = 'MYSQL';                      // Mode Authentification = CAS ou LDAP ou MYSQL
\$config['hideSSOProfil']               = 'false';                      // Si Authentification SSO cacher le profilage SSO
\$config['hideLDAPProfil']              = 'false';                      // Si Authentification LDAP cacher le profilage LDAP
\$config['modePrivate']                 = 'false';                      // Mode privé
\$config['modeRemember']                = 'true';                       // Activation de l'auto login via sauvegarde de session

/* Inscription */
\$config['modeRegistration']            = 'false';                      // Activer l'inscription en ligne
\$config['modeRegistrationConfirm']     = 'admin';                      // Validation de l'inscription direct email ou via validation admin
\$config['modeRegistrationExterne']     = '';                           // Si module d'inscription externe mettre url du module
\$config['modeProfilExterne']           = '';                           // Si module d'inscription externe mettre url du module
\$config['modeAvatarExterne']           = '';                           // Si module d'inscription externe mettre url du module

/* Module eduBridge */
\$config['modeEduBridge']               = 'false';                      // Desactivation du module  

/* Variables Globales */
\$config['protocol']                    = '${protocol}';                // https / http / nothing
\$config['theme']                       = '';                           // Nom du theme si vide theme par défaut
\$config['title']                       = '${title}';                   // Titre du site
\$config['sstitle']                     = '${sstitle}';                 // Sous-Titre du site
\$config['locallogo']                   = '';                           // Logo personnalisé
\$config['localheader']                 = '';                           // Bannière personnalisé
\$config['modeCustomize']               = 'true';                       // Personnalisable par les utilisateur
\$config['modeShared']                  = 'true';                       // Partage des pages

/* Configuration locale */
if(file_exists(\$config["localdirectory"]."/local/config/config.php")) {
    include(\$config["localdirectory"]."/local/config/config.php");
}

\$_SERVER["DOCUMENT_ROOT"] = \$config["localdirectory"]."/";
?>
EOT


cat <<EOT >> ${ROOT_DIR}/include/ldap.php
<?

\$config['LDAPMode']                    = '';   // Si associé à EOLE

\$config['activerLDAPModif']            = true;
\$config['activerLDAP']                 = false;

\$config['LDAPserver']                  = '';
\$config['LDAPport']                    = '';

\$config['LDAPreaderdn'] 				= '';
\$config['LDAPreaderpw']                = '';

\$config['LDAPwriterdn']                = '';
\$config['LDAPwriterpw']                = '';

\$config['LDAPracine']                  = '';
\$config['LDAPorganisation']            = '';
\$config['LDAPfilterauth']              = 'uid=#login#';
\$config['LDAPfirstname']               = 'givenname';
\$config['LDAPlastname']                = 'sn';
\$config['LDAPemail']                   = 'mail';


if(file_exists(\$config['localdirectory']."/local/config/ldap.php")) {
	include("local/config/ldap.php");
}
?>
EOT

fi



# Installation base de données
echo ""
EchoVert "INSTALLATION / MISE A JOUR DE LA BASE DE DONNEES"
dbhost=`grep "dbhost" "include/config.php" | awk -F "'" '{print $4}'`
dblogin=`grep "dblogin" "include/config.php" | awk -F "'" '{print $4}'`
dbpassword=`grep "dbpassword" "include/config.php" | awk -F "'" '{print $4}'`
dbname=`grep "dbname" "include/config.php" | awk -F "'" '{print $4}'`
dbprefixe=`grep "dbprefixe" "include/config.php" | awk -F "'" '{print $4}'`

Ret=$(mysql -u${dblogin} -p${dbpassword} -h ${dbhost} -D ${dbname} --batch --skip-column-names -e "SHOW TABLES")
if [ -z "$Ret" ]; then
    echo "Création des Tables"
    mysql -u${dblogin} -p${dbpassword} -h ${dbhost} -D ${dbname} < install/eportail-create-0.sql
    fgpassadmin=1
fi

echo "Modifications de Structures"
mysql -u${dblogin} -p${dbpassword} -h ${dbhost} -D ${dbname} < install/eportail-update-0.sql

echo "Initialisation des Données"
mysql -u${dblogin} -p${dbpassword} -h ${dbhost} -D ${dbname} < install/eportail-update-1.sql


# Installation base de données
echo ""
EchoVert "PASSWORD ADMIN"

if [ -z "$fgpassadmin" ]; then
    Ret=`QuestionOuiNon "Souhaitez-vous mettre à jour le password de l'utilisateur admin ? " "non"`
else
    Ret=1    
fi

if [ "$Ret" == 1 ]; then
    pwdadmin=`QuestionMandatory "Password de l'utilisateur de la base de donnée ?" ""`
    echo "UPDATE "${dbprefixe}"user SET user_password=MD5('${pwdadmin}') WHERE user_login='admin'"
    echo "-u${dblogin} -p${dbpassword} -h ${dbhost} -D ${dbname}"
    mysql -u${dblogin} -p${dbpassword} -h ${dbhost} -D ${dbname}  --batch --skip-column-names -e "UPDATE ${dbprefixe}user SET user_password=MD5('${pwdadmin}') WHERE user_login='admin'"
fi


# attribution des permissions
echo ""
EchoVert "ATTRIBUTION DES PERMISSIONS"
syuser=`QuestionMandatory "Utilisateur system ?" "root"`
sygroup=`QuestionMandatory "Groupe system ?" "www-data"`

/bin/chown -R ${syuser}:${sygroup} ${ROOT_DIR}
/bin/chmod -R 640 ${ROOT_DIR}
/bin/chmod -R ug+X ${ROOT_DIR}
/bin/chmod -R 775 ${ROOT_DIR}/local
/bin/chmod -R 775 ${ROOT_DIR}/include

/bin/chmod +x ${ROOT_DIR}/install/install.sh

echo OK
Echo "============================================================================="
echo ""

