<?php

/*== AFFICHAGE ============================================================================================================================*/

class Colors {
    private $foreground_colors = array();
    private $background_colors = array();

    public function __construct() {
        // Set up shell colors
        $this->foreground_colors['black'] = '0;30';
        $this->foreground_colors['dark_gray'] = '1;30';
        $this->foreground_colors['blue'] = '0;34';
        $this->foreground_colors['light_blue'] = '1;34';
        $this->foreground_colors['green'] = '0;32';
        $this->foreground_colors['light_green'] = '1;32';
        $this->foreground_colors['cyan'] = '0;36';
        $this->foreground_colors['light_cyan'] = '1;36';
        $this->foreground_colors['red'] = '0;31';
        $this->foreground_colors['light_red'] = '1;31';
        $this->foreground_colors['purple'] = '0;35';
        $this->foreground_colors['light_purple'] = '1;35';
        $this->foreground_colors['brown'] = '0;33';
        $this->foreground_colors['yellow'] = '1;33';
        $this->foreground_colors['light_gray'] = '0;37';
        $this->foreground_colors['white'] = '1;37';

        $this->background_colors['black'] = '40';
        $this->background_colors['red'] = '41';
        $this->background_colors['green'] = '42';
        $this->background_colors['yellow'] = '43';
        $this->background_colors['blue'] = '44';
        $this->background_colors['magenta'] = '45';
        $this->background_colors['cyan'] = '46';
        $this->background_colors['light_gray'] = '47';
    }

    // Returns colored string
    public function getColoredString($string, $foreground_color = null, $background_color = null) {
        $colored_string = "";

        // Check if given foreground color found
        if (isset($this->foreground_colors[$foreground_color])) {
            $colored_string .= "\033[" . $this->foreground_colors[$foreground_color] . "m";
        }
        // Check if given background color found
        if (isset($this->background_colors[$background_color])) {
            $colored_string .= "\033[" . $this->background_colors[$background_color] . "m";
        }

        // Add string and end coloring
        $colored_string .=  $string . "\033[0m";

        return $colored_string;
    }

    // Returns all foreground color names
    public function getForegroundColors() {
        return array_keys($this->foreground_colors);
    }

    // Returns all background color names
    public function getBackgroundColors() {
        return array_keys($this->background_colors);
    }
}

function AfficheTitre($label) {
    
    global $colors;
    if($_SESSION['user_login']!="UserCron")
        echo "<br><br><h1>$label</h1>";
    else
        echo "\n".$colors->getColoredString(strtoupper($label), "purple", "yellow") . "\n";
}

function AfficheLigne($label) {
    echo $label;
    if($_SESSION['user_login']!="UserCron") echo "<br>"; else echo "\n";
}

function AfficheLigneOK($label) {
    global $colors;
    if($_SESSION['user_login']!="UserCron")
        echo "<span style='color:green'>$label</span><br>";
    else
        echo $colors->getColoredString($label, "green") . "\n";
}

function AfficheLigneKO($label) {
    global $colors;
    if($_SESSION['user_login']!="UserCron")
        echo "<span style='color:red'>$label</span><br>";
    else
        echo $colors->getColoredString($label, "red") . "\n";
}

function AfficheLigneRAS($label) {
    global $colors;
    if($_SESSION['user_login']!="UserCron")
        echo "<span style='color:blue'>$label</span><br>";
    else
        echo $colors->getColoredString($label, "blue") . "\n";
}

function AfficheLigneGras($label) {
    $BBlack='\033[1;30m';
    if($_SESSION['user_login']!="UserCron")
        echo "<strong>$label</strong><br>";
    else
        echo $BBlack.$label." \n";
}   

function AfficheLigneSouligne($label) {
    if($_SESSION['user_login']!="UserCron") echo "<em>$label</em><br>"; else echo "* ".$label." \n";
}    

$colors = new Colors();

function replaceAccent($str, $encoding='utf-8')
{
    // transformer les caractères accentués en entités HTML
    $str = htmlentities($str, ENT_NOQUOTES, $encoding);
 
    // remplacer les entités HTML pour avoir juste le premier caractères non accentués
    // Exemple : "&ecute;" => "e", "&Ecute;" => "E", "à" => "a" ...
    $str = preg_replace('#&([A-za-z])(?:acute|grave|cedil|circ|orn|ring|slash|th|tilde|uml);#', '\1', $str);
 
    // Remplacer les ligatures tel que : , Æ ...
    // Exemple "œ" => "oe"
    $str = preg_replace('#&([A-za-z]{2})(?:lig);#', '\1', $str);
    // Supprimer tout le reste
    $str = preg_replace('#&[^;]+;#', '', $str);
 
    return $str;
}
 

/*== LISTEGROUPES =========================================================================================================================*/
/*  - Liste des différents groupes présents dans l'annuaire
    - $tbtype = tableau de type de groupe si vide tout les types          
    - Exemple d'utilisation
        $tbgroup=listeGroupes();
        foreach($tbgroup as $group) {
            AfficheLigne($group["type"]." = ".$group["id"]);
        }
*/
        
function listeGroupes($tbtype=array()) {
    // Récupère en variable globale la configuration de posh-profil
    global $config;
        
    if(count($tbtype)==0)
        $tbtype=array("Base","Niveau","Classe","Matiere","Option","Groupe","Service","Equipe");
        
    // Tentative de connexion à l'annuaire LDAP
    $ds = ldap_connect ( $config['LDAPserver'], $config['LDAPport'] );
    if (!$ds) {
        AfficheLigne("Erreur : impossible de se connecter à l'annuaire LDAP");
        die();
    }

    ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
    ldap_set_option($ds, LDAP_OPT_REFERRALS, 0);
    if($config['LDAPusetls']) ldap_start_tls($ds);

    $r = ldap_bind($ds,$config['LDAPreaderdn'], $config['LDAPreaderpw']);   
    if (!$r) {
        AfficheLigne("Erreur authentification : impossible de se connecter à l'annuaire LDAP");
        die();
    }

    $grp = array();
    
    foreach($tbtype as $type) {
        switch($type) {
            case "Base" :
                $lg = array();
                $lg["type"]     = $type;

                $lg["id"]       = "tout";
                $lg["label"]    = "tout le monde";
                $lg["gid"]      = "-1";
                array_push ($grp , $lg);
                                
                $lg["id"]       = "enseignant";
                $lg["label"]    = "enseignant";
                $lg["gid"]      = "10001";
                array_push ($grp , $lg);
                                
                $lg["id"]       = "eleve";
                $lg["label"]    = "eleve";
                $lg["gid"]      = "10002";
                array_push ($grp , $lg);                

                $lg["id"]       = "administratif";
                $lg["label"]    = "administratif";
                $lg["gid"]      = "10000";
                array_push ($grp , $lg);                 

                $lg["id"]       = "responsable";
                $lg["label"]    = "responsable";
                $lg["gid"]      = "0";
                array_push ($grp , $lg);                 
            break;
            
            case "Niveau" :
            case "Classe" :
            case "Matiere" :
            case "Option" :
            case "Groupe" :
            case "Service" :
            case "Equipe" :
                $res = ldap_search($ds,$config['LDAPracine'],"type=$type");
                for ($entryID=ldap_first_entry($ds,$res) ; $entryID!=false ; $entryID=ldap_next_entry($ds,$entryID)) {
                    $cn         = ldap_get_values($ds,$entryID,'cn');
                    $label      = ldap_get_values($ds,$entryID,'description');
                    $gid        = ldap_get_values($ds,$entryID,'gidNumber');
                
                    $lg = array();
                    $lg["type"]     = $type;
                    $lg["id"]       = $cn[0];
                    $lg["label"]    = $label[0];
                    $lg["gid"]      = $gid[0];
                    array_push ($grp , $lg);
                }
            break;
            

        }
    }

    // Fermeture ldap
    ldap_close($ds);

    // Retourne le résultat
    return($grp);               
}

/*== FRMUSER ===============================================================================================================================*/
/*  - Formate le l'entrée annuaire d'un utilisateur */

function frmUser($ds,$entryID) {
    global $config;
   
    @$dn            = ldap_get_dn($ds, $entryID);
    @$uid           = ldap_get_values($ds,$entryID,'uid');
    @$cn            = ldap_get_values($ds,$entryID,'cn');
    @$nom           = ldap_get_values($ds,$entryID,'sn');
    @$prenom        = ldap_get_values($ds,$entryID,'givenName');

    @$civilite      = ldap_get_values($ds,$entryID,'personalTitle');
    @$sexe          = ldap_get_values($ds,$entryID,'ENTPersonSexe');
    @$mail          = ldap_get_values($ds,$entryID,'mail');
    @$profil        = ldap_get_values($ds,$entryID,'ENTPersonProfils');
    @$typeadmin     = ldap_get_values($ds,$entryID,'typeadmin');
    @$eleves        = ldap_get_values($ds,$entryID,'eleve');
    @$ine           = ldap_get_values($ds,$entryID,'Ine');

    // Forcer le profil profil pour les administratif au profil prof
    if($profil[0]=="administratif"&&($typeadmin[0]==0||$typeadmin[0]==2))
        $profil[0]="enseignant";
            
    $tbuser=array(
        "dn"=>$dn,
        "uid"=>$uid[0],
        "cn"=>$cn[0],
        "nom"=>$nom[0],
        "prenom"=>$prenom[0],
        "nom"=>$nom[0],
        "civilite"=>$civilite[0],
        "sexe"=>$sexe[0],
        "mail"=>$mail[0],
        "profil"=>$profil[0],
        "typeadmin"=>$typeadmin[0],
        "idprenomnom"=>strtolower(replaceAccent($prenom[0].$nom[0]))
    );

    if($profil[0]=="responsable")
    {
        $tbenfants=array();
        foreach($eleves as $eleve) {
            $res = ldap_search($ds,$config['LDAPracine'],"(&(uid=".$eleve.")(ENTPersonProfils=eleve)(objectclass=inetOrgPerson)(!(description=Computer)))");
            for ($entryID=ldap_first_entry($ds,$res) ; $entryID!=false ; $entryID=ldap_next_entry($ds,$entryID)) {
                $tbeleves=array_push($tbenfants,frmUser($ds,$entryID));
            } 
        }
        $tbuser["enfants"]=$tbenfants;
    }

    if($profil[0]=="eleve")
        $tbuser["ine"]=$ine[0];

    return $tbuser;
}

/*== LISTEUTILISATEURS =====================================================================================================================*/
/*  - Lister les utilisateurs d'un groupe présent dans l'annuaire LDAP
    - Type de groupe
    - Id du groupe
    - Profil des utlisteurs à retourner si vide tout type de profil rattaché au groupe
    
*/

function listeUtilisateurs($type,$id,$tbprofil=array(),$withresp=true) {

    // Récupère en variable globale la configuration de posh-profil
    global $config;

    if(count($tbprofil)==0)
        $tbprofil=array("enseignant","eleve","administratif","responsable");
    
    // Tentative de connexion à l'annuaire LDAP
    $ds = ldap_connect ( $config['LDAPserver'], $config['LDAPport'] );
    if (!$ds) {
        AfficheLigne("Erreur : impossible de se connecter à l'annuaire LDAP");
        die();
    }
    
    ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
    ldap_set_option($ds, LDAP_OPT_REFERRALS, 0);
    if($config['LDAPusetls']) ldap_start_tls($ds);

    $r = ldap_bind($ds,$config['LDAPreaderdn'], $config['LDAPreaderpw']);   
    if (!$r) {
        AfficheLigne("Erreur authentification : impossible de se connecter à l'annuaire LDAP");
        die();
    }
    
    // Listage des groupes dans un tableau
    $grp = array();

    switch($type) {
        case "Base":
            switch($id) {
                // Lister l'ensemble des utilisateurs     
                case "tout":
                    $res = ldap_search($ds,$config['LDAPracine'],"(&(uid=*)(objectclass=inetOrgPerson)(!(description=Computer)))");
                    for ($entryID=ldap_first_entry($ds,$res) ; $entryID!=false ; $entryID=ldap_next_entry($ds,$entryID)) {
                        $tbuser=frmUser($ds,$entryID);
                        

                        if(in_array($tbuser["profil"],$tbprofil))
                            $grp[$tbuser["uid"]]=$tbuser;
                    }                    
                break;
                
                // Liste l'ensemble des eleve / administratif / responsable
                case "eleve":
                case "administratif":
                case "responsable":
                    $res = ldap_search($ds,$config['LDAPracine'],"(&(uid=*)(ENTPersonProfils=$id)(objectclass=inetOrgPerson)(!(description=Computer)))");
                    for ($entryID=ldap_first_entry($ds,$res) ; $entryID!=false ; $entryID=ldap_next_entry($ds,$entryID)) {
                        $tbuser=frmUser($ds,$entryID);

                        if(in_array($tbuser["profil"],$tbprofil)&&$tbuser["profil"]==$id)
                            $grp[$tbuser["uid"]]=$tbuser;
                    }                    
                break;

                // Liste l'ensemble des enseignants 
                case "enseignant":
                    // Les enseignants
                    $res = ldap_search($ds,$config['LDAPracine'],"(&(uid=*)(ENTPersonProfils=$id)(objectclass=inetOrgPerson)(!(description=Computer)))");
                    for ($entryID=ldap_first_entry($ds,$res) ; $entryID!=false ; $entryID=ldap_next_entry($ds,$entryID)) {
                        $tbuser=frmUser($ds,$entryID);

                        // On ajoute l'utilisateur s'il fait partie des profils recherchés
                        if(in_array($tbuser["profil"],$tbprofil))
                            $grp[$tbuser["uid"]]=$tbuser;
                    }

                    // Adminstratif avec le flag enseignant
                    $res = ldap_search($ds,$config['LDAPracine'],"(&(uid=*)(ENTPersonProfils=administratif)(objectclass=inetOrgPerson)(typeadmin=0)(!(description=Computer)))");
                    for ($entryID=ldap_first_entry($ds,$res) ; $entryID!=false ; $entryID=ldap_next_entry($ds,$entryID)) {
                        $tbuser=frmUser($ds,$entryID);

                        // On ajoute l'utilisateur s'il fait partie des profils recherchés
                        if(in_array($tbuser["profil"],$tbprofil))
                            $grp[$tbuser["uid"]]=$tbuser;
                    }

                    // Adminstratif avec le flag enseignant et administrateur de classe
                    $res = ldap_search($ds,$config['LDAPracine'],"(&(uid=*)(ENTPersonProfils=administratif)(objectclass=inetOrgPerson)(typeadmin=2)(!(description=Computer)))");
                    for ($entryID=ldap_first_entry($ds,$res) ; $entryID!=false ; $entryID=ldap_next_entry($ds,$entryID)) {
                        $tbuser=frmUser($ds,$entryID);

                        // On ajoute l'utilisateur s'il fait partie des profils recherchés
                        if(in_array($tbuser["profil"],$tbprofil))
                            $grp[$tbuser["uid"]]=$tbuser;
                    }                    

                break;
            }
        break;
        
        case "Niveau" :
            $res = ldap_search($ds,$config['LDAPracine'],"(&(type=$type)(cn=$id))");
            for ($entryID=ldap_first_entry($ds,$res) ; $entryID!=false ; $entryID=ldap_next_entry($ds,$entryID)) {
                @$members    = ldap_get_values($ds,$entryID,'memberUid');
                foreach( (array) $members as $member) {
                    $res2 = ldap_search($ds,$config['LDAPracine'],"(&(uid=$member)(objectclass=inetOrgPerson)(!(description=Computer)))");
                    for ($entryID2=ldap_first_entry($ds,$res2) ; $entryID2!=false ; $entryID2=ldap_next_entry($ds,$entryID2)) {
                        $tbuser=frmUser($ds,$entryID2);
                        
                        // On ajoute l'utilisateur s'il fait partie des profils recherchés
                        if(in_array($tbuser["profil"],$tbprofil))
                            $grp[$tbuser["uid"]]=$tbuser;
                        
                        // Si profil eleves et que l'on recherche aussi les profils responsable
                        if($tbuser["profil"]=="eleve" && in_array("responsable",$tbprofil) && $withresp) {
                            $res3 = ldap_search($ds,$config['LDAPracine'],"(&(ENTPersonProfils=responsable)(eleve=".$member."))");
                            for ($entryID3=ldap_first_entry($ds,$res3) ; $entryID3!=false ; $entryID3=ldap_next_entry($ds,$entryID3)) {
                                $tbuser=frmUser($ds,$entryID3);
                                $grp[$tbuser["uid"]]=$tbuser;
                            }
                        }
                    }
                }   
                
                // Si on recherche aussi les Professeurs
                if(in_array("enseignant",$tbprofil)) {
                    // Pour toutes les classes du niveau
                    $res3 = ldap_search($ds,$config['LDAPracine'],"(&(type=Classe)(niveau=$id))");
                    for ($entryID3=ldap_first_entry($ds,$res3) ; $entryID3!=false ; $entryID3=ldap_next_entry($ds,$entryID3)) {
                        
                        // Pour toutes l'equipe pédagogique de la classe
                        $classe=ldap_get_values($ds,$entryID3,'cn');
                        $res4 = ldap_search($ds,$config['LDAPracine'],"(&(type=Equipe)(cn=profs-".$classe[0]."))");
                        for ($entryID4=ldap_first_entry($ds,$res4) ; $entryID4!=false ; $entryID4=ldap_next_entry($ds,$entryID4)) {
                            @$enseignants = ldap_get_values($ds,$entryID4,'memberUid');
                            foreach((array) $enseignants as $enseignant) {
                                $res5 = ldap_search($ds,$config['LDAPracine'],"(&(ENTPersonProfils=*)(uid=".$enseignant."))");
                                for ($entryID5=ldap_first_entry($ds,$res5) ; $entryID5!=false ; $entryID5=ldap_next_entry($ds,$entryID5)) {
                                    $tbuser=frmUser($ds,$entryID5);
                                    $grp[$tbuser["uid"]]=$tbuser;
                                }                                
                            }
                        }

                        // Pour tout les administratifs avec gestion de classe
                        $res4 = ldap_search($ds,$config['LDAPracine'],"(&(ENTPersonProfils=Administratif)(divcod=".$classe[0]."))");
                        for ($entryID4=ldap_first_entry($ds,$res4) ; $entryID4!=false ; $entryID4=ldap_next_entry($ds,$entryID4)) {
                            $tbuser=frmUser($ds,$entryID4);
                            $grp[$tbuser["uid"]]=$tbuser;
                        }
                    }
                }
            }
        break;
        
        case "Classe" :
        case "Option" :
            $res = ldap_search($ds,$config['LDAPracine'],"(&(type=$type)(cn=$id))");
            for ($entryID=ldap_first_entry($ds,$res) ; $entryID!=false ; $entryID=ldap_next_entry($ds,$entryID)) {
                @$members    = ldap_get_values($ds,$entryID,'memberUid');
                foreach( (array) $members as $member) {
                    $res2 = ldap_search($ds,$config['LDAPracine'],"(&(uid=$member)(objectclass=inetOrgPerson)(!(description=Computer)))");
                    for ($entryID2=ldap_first_entry($ds,$res2) ; $entryID2!=false ; $entryID2=ldap_next_entry($ds,$entryID2)) {
                        $tbuser=frmUser($ds,$entryID2);
                        
                        // On ajoute l'utilisateur s'il fait partie des profils recherchés
                        if(in_array($tbuser["profil"],$tbprofil))
                            $grp[$tbuser["uid"]]=$tbuser;
                        
                        // Si profil eleves et que l'on recherche aussi les profils responsable
                        if($tbuser["profil"]=="eleve" && in_array("responsable",$tbprofil) && $withresp) {
                            $res3 = ldap_search($ds,$config['LDAPracine'],"(&(ENTPersonProfils=responsable)(eleve=".$member."))");
                            for ($entryID3=ldap_first_entry($ds,$res3) ; $entryID3!=false ; $entryID3=ldap_next_entry($ds,$entryID3)) {
                                $tbuser=frmUser($ds,$entryID3);
                                $grp[$tbuser["uid"]]=$tbuser;
                            }
                        }
                    }
                }   
                
                // Si on recherche aussi les Professeurs
                if(in_array("enseignant",$tbprofil)) {
                    // Pour toutes l'equipe pédagogique de la classe
                    @$classe=ldap_get_values($ds,$entryID3,'cn');
                    $res4 = ldap_search($ds,$config['LDAPracine'],"(&(type=Equipe)(cn=profs-".$id."))");
                    for ($entryID4=ldap_first_entry($ds,$res4) ; $entryID4!=false ; $entryID4=ldap_next_entry($ds,$entryID4)) {
                        @$enseignants = ldap_get_values($ds,$entryID4,'memberUid');
                        foreach( (array) $enseignants as $enseignant) {
                            $res5 = ldap_search($ds,$config['LDAPracine'],"(&(ENTPersonProfils=*)(uid=".$enseignant."))");
                            for ($entryID5=ldap_first_entry($ds,$res5) ; $entryID5!=false ; $entryID5=ldap_next_entry($ds,$entryID5)) {
                                $tbuser=frmUser($ds,$entryID5);
                                $grp[$tbuser["uid"]]=$tbuser;
                            }                                
                        }
                    }

                    //Pour tout les administratifs avec gestion de classe
                    $res4 = ldap_search($ds,$config['LDAPracine'],"(&(ENTPersonProfils=Administratif)(divcod=".$id."))");
                    for ($entryID4=ldap_first_entry($ds,$res4) ; $entryID4!=false ; $entryID4=ldap_next_entry($ds,$entryID4)) {
                        $tbuser=frmUser($ds,$entryID4);
                        $grp[$tbuser["uid"]]=$tbuser;
                    }                                
                }
            }
        break;   
        
        case "Matiere" :
        case "Groupe" :
        case "Service" :
        case "Equipe" :        
            $res = ldap_search($ds,$config['LDAPracine'],"(&(type=$type)(cn=$id))");
            for ($entryID=ldap_first_entry($ds,$res) ; $entryID!=false ; $entryID=ldap_next_entry($ds,$entryID)) {
                @$members    = ldap_get_values($ds,$entryID,'memberUid');
                foreach( (array) $members as $member) {
                    $res2 = ldap_search($ds,$config['LDAPracine'],"(&(uid=$member)(objectclass=inetOrgPerson)(!(description=Computer)))");
                    for ($entryID2=ldap_first_entry($ds,$res2) ; $entryID2!=false ; $entryID2=ldap_next_entry($ds,$entryID2)) {
                        $tbuser=frmUser($ds,$entryID2);
                        
                        // On ajoute l'utilisateur s'il fait partie des profils recherchés
                        if(in_array($tbuser["profil"],$tbprofil))
                            $grp[$tbuser["uid"]]=$tbuser;
                        
                        // Si profil eleves et que l'on recherche aussi les profils responsable
                        if($tbuser["profil"]=="eleve" && in_array("responsable",$tbprofil) && $withresp) {
                            $res3 = ldap_search($ds,$config['LDAPracine'],"(&(ENTPersonProfils=responsable)(eleve=".$member."))");
                            for ($entryID3=ldap_first_entry($ds,$res3) ; $entryID3!=false ; $entryID3=ldap_next_entry($ds,$entryID3)) {
                                $tbuser=frmUser($ds,$entryID3);
                                $grp[$tbuser["uid"]]=$tbuser;
                            }
                        }
                    }
                }  
            }

            // Sur les equipes de profs on recherche les administrateurs de classes
            if($type=="Equipe") {
                $classe=explode("-",$id);

                //Pour tout les administratifs avec gestion de classe
                $res = ldap_search($ds,$config['LDAPracine'],"(&(ENTPersonProfils=Administratif)(divcod=".$classe[1]."))");
                for ($entryID=ldap_first_entry($ds,$res) ; $entryID!=false ; $entryID=ldap_next_entry($ds,$entryID)) {
                    $tbuser=frmUser($ds,$entryID);
                    if(in_array($tbuser["profil"],$tbprofil))
                        $grp[$tbuser["uid"]]=$tbuser;
                }  
            }
        break;
    }

    // Fermeture ldap
    ldap_close($ds);

    // Retourne le résultat
    return($grp);           
}

/*== TYPEGROUPE ============================================================================================================================*/
/*  - Retourne un tableau id et type de groupe associé à gidnumber  
   
*/
function typeGroupe($gidNumber) {
    // Récupère en variable globale la configuration de posh-profil
    global $config;
    $grp = array();

    // Cas Tout le monde
    if($gidNumber==-1) {
        $grp["type"]    = "Base";
        $grp["id"]      = "tout";
    }
    elseif($gidNumber==0) {
        $grp["type"]    = "Base";
        $grp["id"]      = "responsable";
    }
    elseif($gidNumber==10000) {
        $grp["type"]    = "Base";
        $grp["id"]      = "administratif";
    }
    elseif($gidNumber==10001) {
        $grp["type"]    = "Base";
        $grp["id"]      = "enseignant";
    }
    elseif($gidNumber==10002) {
        $grp["type"]    = "Base";
        $grp["id"]      = "eleve";
    }
    else {
        // Tentative de connexion à l'annuaire LDAP
        $ds = ldap_connect ( $config['LDAPserver'], $config['LDAPport'] );
        if (!$ds) {
            AfficheLigne("Erreur : impossible de se connecter à l'annuaire LDAP");
            die();
        }
        
        ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
        ldap_set_option($ds, LDAP_OPT_REFERRALS, 0);
        if($config['LDAPusetls']) ldap_start_tls($ds);

        $r = ldap_bind($ds,$config['LDAPreaderdn'], $config['LDAPreaderpw']);   
        if (!$r) {
            AfficheLigne("Erreur authentification : impossible de se connecter à l'annuaire LDAP");
            die();
        } 

        $res = ldap_search($ds,$config['LDAPracine'],"(&(gidNumber=".$gidNumber.")(type=*))");
        for ($entryID=ldap_first_entry($ds,$res);$entryID!=false;$entryID=ldap_next_entry($ds,$entryID))
        {
            @$type          = ldap_get_values($ds,$entryID,'type');
            @$id            = ldap_get_values($ds,$entryID,'cn');

            $grp["type"]    = $type[0];
            $grp["id"]      = $id[0];
        }

        // Fermeture ldap
        ldap_close($ds);
    }

    return $grp;
}

/*== FINDUSERLDAP ==========================================================================================================================*/

function findUsersLDAP($key,$value) {
    global $config;
    $users = array();

    // Tentative de connexion à l'annuaire LDAP
    $ds = ldap_connect ( $config['LDAPserver'], $config['LDAPport'] );
    if (!$ds) {
        AfficheLigne("Erreur : impossible de se connecter à l'annuaire LDAP");
        die();
    }
    
    ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
    ldap_set_option($ds, LDAP_OPT_REFERRALS, 0);
    if($config['LDAPusetls']) ldap_start_tls($ds);

    $r = ldap_bind($ds,$config['LDAPreaderdn'], $config['LDAPreaderpw']);   
    if (!$r) {
        AfficheLigne("Erreur authentification : impossible de se connecter à l'annuaire LDAP");
        die();
    } 
        
    $res2 = ldap_search($ds,$config['LDAPracine'],"(&($key=$value)(objectclass=inetOrgPerson)(!(description=Computer)))");
    for ($entryID2=ldap_first_entry($ds,$res2) ; $entryID2!=false ; $entryID2=ldap_next_entry($ds,$entryID2)) {
        $tbuser=frmUser($ds,$entryID2);
        array_push($users,$tbuser);
    }
    return($users);
}

?>
