<?php

namespace EPortail\Events\Subscribers;

use EPortail\Events\FrontAfterLoginEvent;

use EPortail\Events\FrontBeforeHeaderEvent;
use EPortail\Events\FrontAfterHeaderEvent;

use EPortail\Events\FrontBeforeFooterEvent;
use EPortail\Events\FrontAfterFooterEvent;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\Form\Exception\ErrorMappingException;

class EportailSubscriber implements EventSubscriberInterface {

    public static function getSubscribedEvents() {
        return array(
            // Header
            FrontBeforeHeaderEvent::NAME => array(
                array('FrontBeforeHeaderEvent', 0),
            ),

            FrontAfterHeaderEvent::NAME => array(
                array('FrontAfterHeaderEvent', 0),
            ),

            // Footer
            FrontBeforeFooterEvent::NAME => array(
                array('FrontBeforeFooterEvent', 0)
            ),

            FrontAfterFooterEvent::NAME => array(
                array('FrontAfterFooterEvent', 0)
            )
        );
    }

    public function getPluginEvent($eventname) {
        $tbevent=array();

        // On recherche l'ensemble des plugin avec l'évenement de disponible dans sa configuration
        foreach($_SESSION["plugins"] as $pluginname => $plugin) {
            if(array_key_exists($eventname,$plugin["events"])) {
                $event=array(
                    "order"=>$plugin["events"][$eventname],
                    "name"=>$pluginname,
                    "class"=>$plugin["class"]
                    );

                array_push($tbevent,$event);
            }
        }

        // Trier le tableau par order / name
        $indice=array();
        $libelle=array();
        foreach ($tbevent as $key => $rowd) {
        $indice[$key] = $rowd[0];
        $libelle[$key] = $rowd[1];
        }
        array_multisort($indice, SORT_ASC, $libelle, SORT_ASC, $tbevent);        

        // On retour le tableau d'évènement de plugin
        return $tbevent;
    }

    // HEADER
    public function FrontBeforeHeaderEvent() {
        // On recherche l'ensemble des plugin avec l'évenement de disponible dans sa configuration
        $tbevent=$this->getPluginEvent("FrontBeforeHeaderEvent");

        // Pour chaque plugin disposant de l'évenement on execute le code associé dans sa class
        foreach($tbevent as $event) {
            $event["class"]->FrontBeforeHeaderEvent();
        }
        
    }

    public function FrontAfterHeaderEvent() {
        // On recherche l'ensemble des plugin avec l'évenement de disponible dans sa configuration
        $tbevent=$this->getPluginEvent("FrontAfterHeaderEvent");

        // Pour chaque plugin disposant de l'évenement on execute le code associé dans sa class
        foreach($tbevent as $event) {
            $event["class"]->FrontAfterHeaderEvent();
        }
        
    }

    # FOOTER
    public function FrontBeforeFooterEvent() {
        // On recherche l'ensemble des plugin avec l'évenement de disponible dans sa configuration
        $tbevent=$this->getPluginEvent("FrontBeforeFooterEvent");

        // Pour chaque plugin disposant de l'évenement on execute le code associé dans sa class
        foreach($tbevent as $event) {
            $event["class"]->FrontBeforeFooterEvent();
        }
    }

    public function FrontAfterFooterEvent() {
        // On recherche l'ensemble des plugin avec l'évenement de disponible dans sa configuration
        $tbevent=$this->getPluginEvent("FrontAfterFooterEvent");

        // Pour chaque plugin disposant de l'évenement on execute le code associé dans sa class
        foreach($tbevent as $event) {
            $event["class"]->FrontAfterFooterEvent();
        }
    }


    public function forceChangePwd() {
        echo '<link rel="stylesheet" href="/eportail/plugins/force-change-password/css/screen.css">
        <script src="/eportail/plugins/force-change-password/js/functions.js"></script>
        <script src="/eportail/plugins/force-change-password/js/script.js"></script>';

        require_once 'plugins/force-change-password/form.php';
    }

    public function loadBeforeFooter() {
        echo "<script>
        var e_sample = {
                openUrlInFrame : function(event){
                        event.preventDefault();
                        MakeFrameObj(1,'ok-ff','https://clg-etab25.ac-besancon.fr/eportail/plugins/config-mire-sso/index.php');
                    }
            };
        </script>";
    }

    public function changePwd() {
    
    }

    public function addIcon() {
        if($_SESSION['user_profil']<=2){
        echo "<a title='Configuration de la mire SSO' href='/eportail/plugins/config-mire-sso/index.php' onclick='return e_sample.openUrlInFrame(event)'><i class='fa fa-wrench fa-fw'><span>Mire SSO</span></i></a>";
        }
    }

    public function afterConnect(FrontAfterLoginEvent $event) {
//       var_dump($event->getUser());
//       var_dump($event->getRow());
    }
}
