<?php
@session_start("pronote");
$levelpage = 50;
include("include/permission.php");

require_once 'CAS-1.3.1/eoleCAS.php';
require_once 'configCAS/cas.inc.php';
require_once 'include/config.php';
require_once 'include/pronote.php';


define('PRONOTE_URL', $config['pronoteurl']);
$proxy = null;
if ($config['proxyurl'] != '') {
    $proxy = sprintf('%s:%s', $config['proxyurl'], $config['proxyport']);
}

if (__CAS_DEBUG) {
    EolephpCAS::setDebug('/var/log/phpcas/phpcas-eportail.log');
}
eolephpCAS::proxy(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, true);
if ($config["modeEduBridge"] == 'true') {
    eolephpCAS::allowProxyChain(new CAS_ProxyChain(array($config["urlEduBridge"])));
}
if (__CAS_LOGOUT) {
    if (method_exists(eolephpCAS, 'eolelogoutRequests')) {
        eolephpCAS::eolelogoutRequests(false);
    }
}
if (__CAS_VALIDER_CA) {
    EolephpCAS::setCasServerCACert(__CAS_CA_LOCATION); // verification par rapport a la CA
} else {
    if (method_exists("EolephpCAS", "setNoCasServerValidation")) {
        EolephpCAS::setNoCasServerValidation();
    }
}
if (!eolephpCAS::isAuthenticated()) {
    eolephpCAS::forceAuthentication();
}
ini_set('display_errors', 'on');
?>
<html>
<head>
    <link rel="stylesheet" href="style/fonts/font-awesome-4.2.0/css/font-awesome.css" type="text/css">
    <link rel="stylesheet" href="style/pronote_widget.css" type="text/css">
</head>
<body>
<?php
$pgt = $_SESSION['phpCAS']['pgt'];
$profil = $_SESSION['phpCAS']['attributes']['infos']['ENTPersonProfils'][0];
$pronoteProxy = new CasProxyPronote(sprintf('https://%s:%s', __CAS_SERVER, __CAS_PORT), sprintf("%sdonneesUtilisateur", PRONOTE_URL), $proxy);
$xml = $pronoteProxy->getPronoteInfos($pgt);
if (!$xml) {
    echo "<h2>Une erreur est survenue lors de la récupération du flux pronote</h2>";
} else {
    $widget = WidgetFactory::getWidget($profil);
    if ($widget instanceof WidgetInterface) {
        echo $widget->getWidgetContent($xml);
    }
}
?>
</body>
