<?php
use Jasny\SSO\NotAttachedException;
use Jasny\SSO\Exception as SsoException;

//require_once __DIR__ . '/../../../../vendor/autoload.php';
require_once '/var/www/html/eportail/sso/ssoclass/autoload.php';
require_once 'config.php';


if (isset($_GET['sso_error'])) {
    header("Location: error.php?sso_error=" . $_GET['sso_error'], true, 307);
    exit;
}

$broker = new Jasny\SSO\Broker($SSO_SERVER, $SSO_BROKER_ID, $SSO_BROKER_SECRET);
$broker->attach(true);

try {
    $user = $broker->getUserInfo();
} catch (NotAttachedException $e) {
    if(isset($_GET["service"]))
        header('Location: '.$_GET['service']);
    else
        header('Location: '.$_SERVER['REQUEST_URI']);
        
    exit;
} catch (SsoException $e) {
    header("Location: error.php?sso_error=" . $e->getMessage(), true, 307);
}

if (!$user) {
    if(isset($_GET["service"]))
        header("Location: login.php?service=".$_GET["service"], true, 307);
    else
        header("Location: login.php", true, 307);
    exit;
}
?>
<!doctype html>
<html>
    <head>
        <title><?= $broker->broker ?> (Single Sign-On demo)</title>
        <link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css" rel="stylesheet">
    </head>
    <body>
        <div class="container">
            <h1><?= $broker->broker ?> <small>(Single Sign-On demo)</small></h1>
            <h3>Logged in</h3>

            <pre><?= json_encode($user, JSON_PRETTY_PRINT); ?></pre>

            <a id="logout" class="btn btn-default" href="login.php?logout=1">Logout</a>
        </div>
    </body>
</html>

