<?php

use Jasny\ValidationResult;
use Jasny\SSO;

/**
 * Example SSO server.
 * 
 * Normally you'd fetch the broker info and user info from a database, rather then declaring them in the code.
 */
class MySSOServer extends SSO\Server
{
    /**
     * Registered brokers
     * @var array
     */
    private static $brokers = [
        'eportail' => ['secret'=>'poutaya']
    ];

    /**
     * System users
     * @var array
     */
    public static $users = array (
        'jackie' => [
            'fullname' => 'Jackie Black',
            'email' => 'jackie.black@example.com',
            'password' => '$2y$10$lVUeiphXLAm4pz6l7lF9i.6IelAqRxV4gCBu8GBGhCpaRb6o0qzUO' // jackie123
        ],
        'john' => [
            'fullname' => 'John Doe',
            'email' => 'john.doe@example.com',
            'password' => '$2y$10$RU85KDMhbh8pDhpvzL6C5.kD3qWpzXARZBzJ5oJ2mFoW7Ren.apC2' // john123
        ],
    );

    /**
     * Get the API secret of a broker and other info
     *
     * @param string $brokerId
     * @return array
     */
    protected function getBrokerInfo($brokerId)
    {
        return isset(self::$brokers[$brokerId]) ? self::$brokers[$brokerId] : null;
    }

    /**
     * Authenticate using user credentials
     *
     * @param string $username
     * @param string $password
     * @return ValidationResult
     */
    protected function authenticate($username, $password)
    {
        include("/var/www/html/eportail/include/config.php");
        include("/var/www/html/eportail/include/mysql.php");
        
        if (!isset($username)) {
            return ValidationResult::error("username isn't set");
        }
        
        if (!isset($password)) {
            return ValidationResult::error("password isn't set");
        } 

		$query=$bdd01->prepare("SELECT * FROM ".$config["dbprefixe"]."user WHERE user_login=? AND user_password=md5(?)");
		$query->execute(array($username,$password));
		if(!$row=$query->fetch()) {
            return ValidationResult::error("Invalid credentials");
        }
        
        /*
        if (!isset(self::$users[$username]) || !password_verify($password, self::$users[$username]['password'])) {
            return ValidationResult::error("Invalid credentials");
        }
        */
        
        return ValidationResult::success();
    }


    /**
     * Get the user information
     *
     * @return array
     */
    protected function getUserInfo($username)
    {
        include("/var/www/html/eportail/include/config.php");
        include("/var/www/html/eportail/include/mysql.php");

		$query=$bdd01->prepare("SELECT * FROM ".$config["dbprefixe"]."user WHERE user_login=?");
		$query->execute(array($username));
		if($row=$query->fetch()) {
            $user=array (
                $row["user_login"] => [
                    'login' => $row["user_login"],
                    'lastname' => $row["user_lastname"],
                    'firstname' => $row["user_firstname"],
                    'email' => $row["user_email"]
                ]);
        }
        
        /*
        if (!isset(self::$users[$username])) return null;
        $user = compact('username') + self::$users[$username];
        unset($user['password']);
        */
        
        return $user;
    }
}
