<style>
body{ padding:10px; max-width: 350px; margin: auto; overflow:hidden; }
#clockdate { margin:10px 0px 10px 0px;}
</style>
<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="width:100%;" viewBox="0 0 512 512" onload="s(evt)" preserveAspectRatio="xMidYMid meet">
	<title>Horloge analogique SVG</title>
	<desc>Affiche l’heure en Temps universel coordonné (UTC).</desc>
	<defs>
		<!-- Hour clockhand -->
		<polygon id="p1" points="252.5,156 252.5,256 252.5,286 259.5,286 259.5,256 259.5,156"></polygon>
		<!-- Minute clockhand -->
		<polygon id="p2" points="253.5,141 253.5,256 253.5,301 258.5,301 258.5,256 258.5,141"></polygon>
		<!-- Second clockhand -->
		<polygon id="p3" points="258,271 257,271 257,256 257,126 255,126 255,256 255,271 254,271 252,321 260,321"></polygon>
		<!-- Linear gradient 1 -->
		<linearGradient id="f1" gradientUnits="userSpaceOnUse" x1="2.2783" y1="511.3906" x2="2.2783" y2="510.3906" gradientTransform="matrix(444.416 0 0 -444.416 -756.208 227305.7031)">
			<stop offset="0" stop-color="#FFFFFF"></stop>
			<stop offset="1" stop-color="#FFFFFF" stop-opacity="0.4"></stop>
		</linearGradient>
		<!-- Linear gradient 2 -->
		<linearGradient id="f2" gradientUnits="userSpaceOnUse" x1="2.1045" y1="511.3457" x2="2.6799" y2="510.349" gradientTransform="matrix(416.552 0 0 -416.5325 -666.0963 212992.0938)">
			<stop offset="0" stop-color="#FFFFFF"></stop>
			<stop offset="1" stop-color="#FFFFFF" stop-opacity="0.25"></stop>
		</linearGradient>
		<!-- Drop shadow -->
		<filter id="f3" x="-20%" y="-20%" width="150%" height="150%">
			<feGaussianBlur in="SourceAlpha" stdDeviation="7" result="out1"></feGaussianBlur>
			<feOffset in="out1" dx="-5" dy="5" result="out2"></feOffset>
			<feMerge>
				<feMergeNode in="out2"></feMergeNode>
				<feMergeNode in="SourceGraphic"></feMergeNode>
			</feMerge>
		</filter>
		<!-- Gaussian blur 1 -->
		<filter id="f4">
			<feGaussianBlur in="SourceGraphic" stdDeviation="0.75"></feGaussianBlur>
		</filter>
		<!-- Gaussian blur 2 -->
		<filter id="f5">
			<feGaussianBlur in="SourceGraphic" stdDeviation="1"></feGaussianBlur>
		</filter>
		<!-- Straight drop shadow -->
		<filter id="f6" x="-100%" y="-100%" width="400%" height="400%">
			<feGaussianBlur in="SourceAlpha" stdDeviation="2" result="out1"></feGaussianBlur>
			<feOffset in="out1" dx="-2" dy="2" result="out2"></feOffset>
			<feMerge>
				<feMergeNode in="out2"></feMergeNode>
				<feMergeNode in="SourceGraphic"></feMergeNode>
			</feMerge>
		</filter>
		<!-- Radial gradient -->
		<radialGradient id="f7" cx="258.25" cy="253.75" r="3" gradientUnits="userSpaceOnUse">
			<stop offset="0" stop-color="#FFFFFF" stop-opacity="0.8"></stop>
			<stop offset="1" stop-color="#000000"></stop>
		</radialGradient>

		<script type="text/javascript">

				function s(e) {
					var d = new Date();
					var s = d.getSeconds();
					var m = d.getMinutes() + s / 60;
					var h = d.getHours() + m / 60;

					var svg = e.target.ownerDocument;
					svg.getElementById("sec").setAttribute("transform", "rotate(" + (s * 6) + ", 256, 256)");
					svg.getElementById("sec2").setAttribute("transform", "rotate(" + (s * 6) + ", 253, 259)");
					svg.getElementById("min").setAttribute("transform", "rotate(" + (m * 6) + ", 256, 256)");
					svg.getElementById("min2").setAttribute("transform", "rotate(" + (m * 6) + ", 254, 258)");
					svg.getElementById("hour").setAttribute("transform", "rotate(" + (h * 30) + ", 256, 256)");
					svg.getElementById("hour2").setAttribute("transform", "rotate(" + (h * 30) + ", 255, 257)");
					
					
          //var decalage = dDate.getTimezoneOffset()/60;
          var newdate = new Date(d.getUTCFullYear(),d.getUTCMonth(),d.getUTCDate(),d.getUTCHours(),d.getUTCMinutes(),d.getUTCSeconds(),d.getUTCMilliseconds());
          var dParis = new Date(newdate);
          
          dParis.setHours(dParis.getHours() + 1);
          
          var dMontreal = new Date(newdate);
          dMontreal.setHours(dMontreal.getHours() -5);
    
      document.getElementById("oUTCSanFrancisco").innerHTML = newdate.toString();
      document.getElementById("oUTCParis").innerHTML = dParis.toString();
      document.getElementById("oUTCMontreal").innerHTML = dMontreal.toString();
      

				}
		
		</script>
	</defs>
	<circle fill="#E6F1DD" cx="256" cy="256" r="215.04"></circle>
	<path filter="url(#f3)" d="M256,10.24C120.271,10.24,10.24,120.271,10.24,256c0,135.729,110.031,245.76,245.76,245.76
		c135.729,0,245.76-110.031,245.76-245.76C501.76,120.271,391.729,10.24,256,10.24z M256,471.04
		c-118.763,0-215.04-96.276-215.04-215.04c0-118.763,96.277-215.04,215.04-215.04c118.764,0,215.04,96.277,215.04,215.04
		C471.04,374.764,374.764,471.04,256,471.04z"></path>
	<path opacity="0.5" fill="url(#f1)" filter="url(#f4)" d="M256,35.84c120.46,0,218.112,97.652,218.112,218.112
		c0,120.459-97.652,218.112-218.112,218.112S37.888,374.411,37.888,253.952C37.888,133.492,135.54,35.84,256,35.84
		c-122.722,0-222.208,99.486-222.208,222.208c0,122.724,99.486,222.208,222.208,222.208c122.724,0,222.208-99.484,222.208-222.208
		C478.208,135.326,378.724,35.84,256,35.84z"></path>
	<path opacity="0.75" fill="url(#f2)" filter="url(#f5)" d="M254.976,12.288c-67.562,0-128.697,27.498-172.84,71.903
		c44.062-43.805,104.775-70.879,171.816-70.879c134.599,0,243.712,109.113,243.712,243.711c0,67.031-27.067,127.733-70.859,171.797
		C471.2,384.677,498.689,323.55,498.689,256C498.688,121.401,389.573,12.288,254.976,12.288z"></path>
	<path fill="none" stroke="#000000" stroke-width="0.5" stroke-miterlimit="10" d="M173.297,437.792l-2.04,4.487 M211.854,455.793
		l1.058-4.79 M191.196,450.134l1.564-4.689 M137.297,416.566l-2.974,4.025 M89.375,374.943l4.104-2.936 M102.746,391.648l3.735-3.313
		 M121.187,403.292l-3.359,3.673 M233.025,459.357l0.556-4.931 M68.263,337.68l4.599-2.006 M60.717,317.62l4.82-1.522
		 M390.644,108.555l3.531-3.861 M405.353,123.472l3.904-3.461 M422.628,136.714l-4.267,3.05 M439.016,176.039l4.727-2.061
		 M446.364,195.594l4.921-1.557 M320.806,61.525l-1.667,5 M300.148,55.864l-1.131,5.116 M374.542,95.314l3.137-4.249 M278.977,52.301
		l-0.594,5.267 M316.302,446.398l1.491,4.715 M340.746,69.379l-2.169,4.773 M454.451,278.23l5.079,0.574 M416.708,374.511
		l4.057,2.996 M372.203,418.383l2.913,4.072 M403.453,390.635l3.685,3.367 M388.519,405.359l3.304,3.725 M335.881,439.049
		l1.972,4.521 M454.736,236.503l5.125-0.498 M455.966,299.977l-4.917-1.086 M450.306,320.634l-4.796-1.6 M442.451,340.574
		l-4.568-2.076 M456.625,214.78l-5.004,1.024 M66.593,192.657l-4.896-1.633 M52.473,232.854l5.117,0.578 M55.378,296.878l4.933-1.009
		 M52.142,275.652l5.087-0.494 M56.038,211.681l4.988,1.101 M195.8,65.57l-1.59-5.025 M216.002,60.337l-1.05-5.132 M176.246,72.896
		l-2.095-4.806 M236.177,51.969l0.513,5.274 M91.237,134.151l4.219,3.115 M136.886,89.203l3.072,4.297 M69.551,171.084l4.692,2.133
		 M108.717,121.176l-3.852-3.521 M120.183,102.574l3.471,3.916 M296.068,451.648l0.98,4.805 M275.824,459.688l-0.48-4.938"></path>
	<path d="M256.008,56.314l-2.52-5.14l5.12,0.04L256.008,56.314z M250.32,460.762l5.12,0.04l-2.52-5.141L250.32,460.762z
		 M361.9,80.655l-4.416-2.595l-0.388,5.712L361.9,80.655z M435.371,157.077l-2.526-4.454l-3.188,4.752L435.371,157.077z
		 M460.762,261.68l0.04-5.119l-5.14,2.521L460.762,261.68z M431.376,361.848l2.596-4.416l-5.711-0.387L431.376,361.848z
		 M354.869,435.4l4.454-2.524l-4.753-3.191L354.869,435.4z M157.278,76.512l-4.454,2.525l4.752,3.19L157.278,76.512z M80.775,149.899
		l-2.594,4.414l5.711,0.387L80.775,149.899z M51.214,253.392l-0.04,5.12l5.14-2.52L51.214,253.392z M76.48,354.666l2.525,4.455
		l3.192-4.754L76.48,354.666z M149.953,431.256l4.415,2.594l0.387-5.711L149.953,431.256z"></path>
	<path d="M256,50.688c-113.391,0-205.312,91.92-205.312,205.312c0,113.391,91.921,205.313,205.312,205.313
		c113.391,0,205.313-91.923,205.313-205.313C461.313,142.608,369.391,50.688,256,50.688z M256,461.056
		C142.75,461.056,50.944,369.25,50.944,256C50.944,142.751,142.75,50.944,256,50.944c113.249,0,205.056,91.807,205.056,205.056
		C461.056,369.25,369.249,461.056,256,461.056z"></path>
	<path d="M256,56.32C145.719,56.32,56.32,145.719,56.32,256c0,110.279,89.399,199.68,199.68,199.68
		c110.279,0,199.68-89.4,199.68-199.68C455.68,145.719,366.279,56.32,256,56.32z M256,455.424
		c-110.139,0-199.424-89.283-199.424-199.424c0-110.138,89.285-199.424,199.424-199.424c110.14,0,199.424,89.286,199.424,199.424
		C455.424,366.141,366.14,455.424,256,455.424z"></path>
	
	<path d="M350.393,87.04v47.923c0,0.717,0.159,1.267,0.48,1.65c0.464,0.538,1.031,0.807,1.703,0.807h4.656v2.88h-17.279v-2.88h3.984
		c0.832,0,1.445-0.313,1.848-0.941c0.398-0.626,0.601-1.465,0.601-2.515v-36.21c0-0.742-0.185-1.369-0.553-1.882
		c-0.367-0.512-0.839-0.768-1.416-0.768h-5.327v-2.649c2.499-0.512,4.526-1.196,6.081-2.054c1.556-0.857,2.925-1.978,4.111-3.36
		L350.393,87.04L350.393,87.04z"></path>
	<path d="M403.909,194.33c-0.733,1.51,2.886,2.265,10.863,2.265c1.194,0,2.049-0.499,2.56-1.497s1.093-3.763,1.747-8.294h1.656
		l-0.779,15.937h-21.493v-2.074l6.983-12.711c3.889-6.758,6.225-11.008,7.009-12.749c1.12-2.482,1.937-4.882,2.448-7.2
		c0.512-2.316,0.768-4.422,0.768-6.316c0-3.148-0.543-5.625-1.632-7.43c-1.089-1.805-2.6-2.708-4.536-2.708
		c-2.176,0-3.952,0.833-5.328,2.497s-2.063,3.43-2.063,5.299c0,0.64,0.104,1.127,0.313,1.459c0.192,0.333,0.608,0.627,1.248,0.883
		c1.616,0.615,2.424,2.125,2.424,4.531c0,1.306-0.271,2.388-0.814,3.245c-0.543,0.858-1.239,1.286-2.088,1.286
		c-0.978,0-1.832-0.723-2.567-2.17c-0.736-1.446-1.104-3.334-1.104-5.664c0-2.611,0.42-4.985,1.26-7.123
		c0.84-2.137,2.106-3.891,3.804-5.261c1.696-1.369,3.521-2.054,5.473-2.054c1.938,0,3.732,0.666,5.391,1.997
		c1.653,1.331,2.897,3.078,3.73,5.242c0.832,2.164,1.248,4.525,1.248,7.085c0,1.767-0.208,3.559-0.623,5.376
		c-0.415,1.818-1.021,3.521-1.819,5.107c-1.374,2.74-2.788,5.082-4.242,7.028l-6.327,8.524
		C405.813,190.988,404.646,192.819,403.909,194.33z"></path>
	<path d="M437.641,254.214c2.287,0.896,4.072,2.38,5.354,4.454c1.633,2.637,2.449,5.902,2.449,9.793c0,4.403-0.979,7.936-2.93,10.6
		c-2.225,3.07-5.12,4.607-8.688,4.607c-2.146,0-3.989-0.563-5.532-1.689c-1.543-1.125-2.7-2.648-3.468-4.568
		c-0.771-1.921-1.152-4.082-1.152-6.49c0-1.941,0.296-3.479,0.889-4.605s1.338-1.688,2.231-1.688c0.816,0,1.473,0.429,1.968,1.286
		c0.496,0.857,0.745,2.029,0.745,3.516c0,0.945-0.128,1.746-0.385,2.398c-0.256,0.654-0.704,1.262-1.344,1.824
		c-0.688,0.588-1.032,1.15-1.032,1.688c0,0.77,0.243,1.633,0.729,2.592c0.489,0.961,1.209,1.729,2.16,2.305
		c0.951,0.576,2.155,0.865,3.611,0.865c2.512,0,4.373-0.992,5.58-2.978c1.208-1.983,1.813-5.164,1.813-9.541
		c0-4.582-0.517-7.84-1.549-9.772c-1.031-1.933-2.563-2.898-4.596-2.898c-0.543,0-1.226,0.103-2.039,0.307
		c-0.656,0.154-1.129,0.23-1.416,0.23c-0.48,0-0.854-0.16-1.116-0.48c-0.265-0.32-0.396-0.723-0.396-1.209
		c0-0.538,0.124-0.954,0.371-1.249c0.246-0.293,0.65-0.441,1.213-0.441l1.318,0.077l1.151,0.077c2.032,0,3.561-0.831,4.585-2.492
		c1.023-1.661,1.536-4.229,1.536-7.705c0-4.267-0.489-7.302-1.465-9.104c-0.978-1.801-2.434-2.703-4.368-2.703
		c-1.775,0-3.192,0.511-4.248,1.532c-1.056,1.022-1.584,1.966-1.584,2.834c0,0.562,0.305,1.315,0.912,2.26
		c0.864,1.277,1.297,2.604,1.297,3.983c0,1.046-0.239,1.927-0.72,2.643c-0.481,0.716-1.098,1.072-1.851,1.072
		c-0.8,0-1.452-0.487-1.956-1.459s-0.755-2.33-0.755-4.07c0-2.714,0.607-5.12,1.823-7.219c1.729-2.969,4.2-4.455,7.416-4.455
		c3.009,0,5.407,1.293,7.199,3.878c1.792,2.586,2.688,5.786,2.688,9.6c0,2.74-0.482,5.108-1.452,7.104
		C441.676,250.912,440.008,252.678,437.641,254.214z"></path>
	<path d="M403.872,312.32h1.56v36.326h5.521v3.265h-5.521v8.18c0,0.718,0.178,1.293,0.528,1.729c0.512,0.589,1.104,0.882,1.775,0.882
		h2.04v2.881h-13.32v-2.881h2.472c0.833,0,1.444-0.281,1.836-0.847c0.395-0.563,0.588-1.381,0.588-2.457v-7.487h-13.582v-3.681
		L403.872,312.32z M401.352,322.666l-11.592,25.979h11.592V322.666z"></path>
	<path d="M330.336,373.76c4.048,1.484,7.354,2.229,9.913,2.229c1.199,0,2.327-0.188,3.384-0.56c1.058-0.369,1.851-0.799,2.376-1.285
		c0.272-0.229,0.448-0.347,0.528-0.347c0.159,0,0.239,0.192,0.239,0.577c0,0.896-0.36,2.079-1.08,3.553
		c-0.722,1.471-1.7,2.644-2.94,3.514c-1.239,0.871-2.667,1.307-4.285,1.307c-1.872,0-4.104-0.461-6.693-1.383l-0.783,14.67
		c1.216-0.975,2.375-1.703,3.478-2.188c1.104-0.488,2.151-0.73,3.144-0.73c3.136,0,5.77,1.664,7.904,4.992
		c2.136,3.328,3.201,7.437,3.201,12.326c0,5.428-1.135,9.894-3.405,13.4c-2.272,3.507-5.219,5.26-8.832,5.26
		c-2.771,0-5.021-1.26-6.759-3.779c-1.734-2.522-2.604-5.523-2.604-9.006c0-2.101,0.276-3.72,0.828-4.856
		c0.552-1.14,1.26-1.71,2.124-1.71c0.848,0,1.54,0.455,2.075,1.363c0.534,0.91,0.804,2.093,0.804,3.553
		c0,1.102-0.132,1.958-0.396,2.572c-0.265,0.615-0.748,1.129-1.45,1.535c-0.705,0.438-1.058,0.938-1.058,1.498
		c0,0.819,0.239,1.724,0.72,2.708s1.204,1.792,2.174,2.417c0.968,0.629,2.073,0.942,3.321,0.942c2.449,0,4.316-1.217,5.604-3.648
		c1.288-2.433,1.933-6.388,1.933-11.864c0-4.992-0.68-8.641-2.04-10.944c-1.357-2.304-3.096-3.456-5.208-3.456
		c-0.96,0-1.92,0.281-2.881,0.844c-0.96,0.564-1.92,1.409-2.88,2.535c-0.111,1.792-0.313,2.989-0.601,3.592
		c-0.287,0.603-0.656,0.902-1.104,0.902c-0.32,0-0.576-0.18-0.768-0.538c-0.193-0.358-0.288-0.856-0.288-1.497
		c0-1.127,0.327-2.24,0.982-3.342c0.192-0.332,0.327-0.627,0.407-0.883l0.559-11.288C330.202,382.285,330.32,377.959,330.336,373.76z"></path>
	<path d="M249.58,419.174c1.248-2.662,2.56-4.568,3.936-5.721c1.376-1.153,2.888-1.729,4.537-1.729c2.656,0,4.885,1.438,6.684,4.318
		c1.801,2.881,2.699,6.522,2.699,10.925c0,5.3-1.063,9.703-3.189,13.21s-4.762,5.263-7.896,5.263c-2.208,0-4.176-0.94-5.904-2.822
		c-1.729-1.883-3.14-4.82-4.236-8.813c-1.097-3.993-1.644-8.651-1.644-13.978c0-5.761,0.672-10.981,2.016-15.668
		c1.345-4.685,3.06-8.197,5.148-10.539c2.088-2.345,4.268-3.517,6.542-3.517c2.336,0,4.318,1.024,5.953,3.071
		c1.357,1.664,2.037,3.661,2.037,5.99c0,1.563-0.299,2.842-0.898,3.841c-0.602,0.998-1.332,1.498-2.195,1.498
		c-0.8,0-1.484-0.422-2.053-1.27c-0.568-0.844-0.854-1.842-0.854-2.993c0-0.769,0.192-1.64,0.576-2.611
		c0.354-0.896,0.529-1.603,0.529-2.112c0-0.716-0.219-1.306-0.648-1.767c-0.574-0.589-1.367-0.884-2.376-0.884
		c-1.552,0-2.967,0.781-4.248,2.343c-1.28,1.563-2.364,4.243-3.252,8.045c-0.888,3.802-1.333,8.07-1.333,12.808
		C249.508,416.756,249.532,417.792,249.58,419.174z M256.732,415.488c-2,0-3.637,1.158-4.908,3.477
		c-1.272,2.316-1.908,5.573-1.908,9.771c0,4.557,0.616,8.04,1.848,10.443c1.232,2.407,2.8,3.608,4.704,3.608
		c1.89,0,3.408-1.138,4.562-3.417c1.15-2.278,1.729-5.685,1.729-10.216c0-4.813-0.532-8.296-1.597-10.444
		C260.098,416.564,258.621,415.488,256.732,415.488z"></path>
	<path d="M164.936,373.779c1.568,0.641,3.265,0.961,5.088,0.961h14.928v1.768c-2.192,6.17-3.832,11.385-4.92,15.646
		c-1.089,4.263-1.912,8.34-2.472,12.229c-0.56,3.895-0.928,8.426-1.104,13.596c-0.16,4.273-0.312,6.916-0.456,7.929
		c-0.145,1.012-0.436,1.793-0.875,2.343s-1.012,0.825-1.716,0.825c-0.8,0-1.424-0.437-1.872-1.307
		c-0.448-0.867-0.672-2.238-0.672-4.107c0-1.663,0.184-3.743,0.552-6.239c0.368-2.497,1.208-6.229,2.52-11.195
		c1.744-6.654,3.256-11.891,4.537-15.705l3.312-9.752h-13.009c-0.961,0-1.676,0.537-2.148,1.611
		c-0.472,1.076-1.037,4.289-1.692,9.639h-1.729L164.936,373.779z"></path>
	<path d="M116.804,335.41c2.56,1.477,4.408,3.412,5.544,5.807c1.135,2.395,1.704,5.279,1.704,8.66c0,4.121-0.824,7.717-2.472,10.789
		c-2.128,3.969-5.16,5.953-9.096,5.953c-3.473,0-6.216-1.338-8.232-4.014c-2.016-2.672-3.024-6.008-3.024-10.002
		c0-2.994,0.58-5.609,1.74-7.852c1.16-2.238,3.164-4.141,6.012-5.7c-4.208-2.896-6.312-7.364-6.312-13.407
		c0-3.916,0.948-7.289,2.843-10.119c1.896-2.828,4.3-4.242,7.212-4.242c2,0,3.739,0.551,5.22,1.65
		c1.48,1.102,2.608,2.601,3.384,4.496c0.776,1.896,1.164,3.879,1.164,5.951C122.492,328.2,120.597,332.208,116.804,335.41z
		 M110.78,340.125c-2.272,1.537-3.848,3.266-4.728,5.186c-0.88,1.92-1.32,4.273-1.32,7.063c0,3.634,0.667,6.456,2.004,8.466
		c1.336,2.008,3.26,3.014,5.772,3.014c2.656,0,4.72-1.006,6.192-3.016c1.472-2.009,2.208-4.665,2.208-7.967
		c0-2.995-0.636-5.262-1.908-6.797C117.729,344.538,114.988,342.557,110.78,340.125z M114.956,334.412
		c1.681-1.536,2.808-3.055,3.385-4.553c0.576-1.5,0.864-3.465,0.864-5.897c0-3.202-0.568-5.674-1.704-7.416
		c-1.136-1.741-2.784-2.612-4.944-2.612c-2.096,0-3.729,0.813-4.896,2.44c-1.168,1.627-1.752,3.748-1.752,6.36
		c0,2.59,0.507,4.65,1.522,6.188C108.444,330.46,110.954,332.29,114.956,334.412z"></path>
	<path d="M84.368,255.021c-1.04,2.508-2.256,4.397-3.648,5.665c-1.392,1.268-2.952,1.9-4.68,1.9c-2.4,0-4.58-1.346-6.54-4.033
		c-1.96-2.687-2.94-6.643-2.94-11.865c0-5.095,1.084-9.427,3.252-12.999c2.168-3.571,4.757-5.356,7.764-5.356
		c3.312,0,6.072,2.202,8.28,6.605s3.312,10.586,3.312,18.547c0,6.605-0.612,12.179-1.836,16.723s-2.844,7.924-4.86,10.138
		c-2.017,2.215-4.289,3.32-6.816,3.32c-2.448,0-4.364-0.863-5.748-2.592c-1.384-1.727-2.076-3.795-2.076-6.201
		c0-1.588,0.285-2.867,0.855-3.84c0.571-0.973,1.29-1.46,2.156-1.46c0.789,0,1.454,0.423,2.001,1.268
		c0.546,0.845,0.819,1.856,0.819,3.033c0,0.845-0.253,1.78-0.759,2.804c-0.31,0.639-0.465,1.189-0.465,1.65
		c0,0.716,0.264,1.338,0.792,1.861s1.376,0.787,2.543,0.787c1.664,0,3.128-0.734,4.392-2.207s2.288-3.893,3.072-7.259
		c0.785-3.364,1.176-7.726,1.176-13.075L84.368,255.021z M77.648,231.097c-1.792,0-3.265,1.197-4.417,3.59
		c-1.152,2.394-1.729,5.997-1.729,10.81c0,4.403,0.577,7.686,1.729,9.85c1.152,2.163,2.656,3.245,4.512,3.245
		c1.84,0,3.388-1.164,4.644-3.495c1.257-2.329,1.884-5.593,1.884-9.792c0-4.352-0.652-7.808-1.956-10.368
		C81.012,232.378,79.456,231.097,77.648,231.097z"></path>
	<path d="M108.063,148.941v47.923c0,0.717,0.16,1.267,0.48,1.65c0.464,0.538,1.032,0.807,1.704,0.807h4.656v2.88H97.622v-2.88h3.984
		c0.833,0,1.448-0.313,1.848-0.941c0.4-0.626,0.6-1.465,0.6-2.515v-36.211c0-0.742-0.184-1.369-0.552-1.882
		c-0.368-0.512-0.84-0.768-1.417-0.768h-5.328v-2.649c2.5-0.512,4.527-1.196,6.082-2.054c1.556-0.857,2.924-1.978,4.111-3.36H108.063
		L108.063,148.941z M131.338,147.942c3.12,0,5.72,1.946,7.8,5.837c2.576,4.787,3.864,12.045,3.864,21.773
		c0,9.037-1.121,15.916-3.36,20.64c-2.241,4.723-4.944,7.084-8.112,7.084c-3.056,0-5.608-1.983-7.656-5.953
		c-2.56-4.992-3.84-12.198-3.84-21.619c0-8.96,1.208-16.089,3.624-21.389C125.594,150.067,128.154,147.942,131.338,147.942z
		 M131.482,150.707c-2.113,0-3.76,1.62-4.944,4.858c-1.184,3.239-1.776,9.953-1.776,20.141c0,9.959,0.612,16.602,1.836,19.929
		c1.224,3.328,2.868,4.992,4.932,4.992c2.08,0,3.68-1.536,4.801-4.608c1.328-3.661,1.992-10.342,1.992-20.044
		c0-10.035-0.624-16.755-1.872-20.161C135.203,152.41,133.545,150.707,131.482,150.707z"></path>
	<path d="M171.782,87.04v47.923c0,0.717,0.16,1.267,0.48,1.65c0.464,0.538,1.032,0.807,1.704,0.807h4.656v2.88h-17.28v-2.88h3.984
		c0.833,0,1.448-0.313,1.849-0.941c0.4-0.626,0.6-1.465,0.6-2.515v-36.21c0-0.742-0.185-1.369-0.552-1.882
		c-0.368-0.512-0.839-0.768-1.416-0.768h-5.328v-2.649c2.5-0.512,4.527-1.196,6.082-2.054c1.556-0.857,2.925-1.978,4.111-3.36
		L171.782,87.04L171.782,87.04z M195.322,87.04v47.923c0,0.717,0.16,1.267,0.48,1.65c0.464,0.538,1.032,0.807,1.704,0.807h4.656v2.88
		h-17.28v-2.88h3.984c0.833,0,1.448-0.313,1.848-0.941c0.4-0.626,0.6-1.465,0.6-2.515v-36.21c0-0.742-0.184-1.369-0.552-1.882
		c-0.368-0.512-0.84-0.768-1.416-0.768h-5.328v-2.649c2.5-0.512,4.526-1.196,6.082-2.054c1.555-0.857,2.923-1.978,4.11-3.36
		L195.322,87.04L195.322,87.04z"></path>
	<path d="M246.59,67.559v47.923c0,0.717,0.16,1.267,0.48,1.651c0.464,0.538,1.032,0.807,1.704,0.807h4.656v2.88h-17.28v-2.88h3.984
		c0.833,0,1.448-0.313,1.849-0.941c0.4-0.626,0.6-1.465,0.6-2.515V78.272c0-0.742-0.185-1.369-0.552-1.882
		c-0.368-0.512-0.839-0.768-1.416-0.768h-5.328v-2.649c2.5-0.512,4.528-1.196,6.082-2.054c1.556-0.857,2.925-1.977,4.112-3.359
		L246.59,67.559L246.59,67.559z"></path>
	<path d="M264.889,112.41c-0.734,1.51,2.885,2.265,10.861,2.265c1.195,0,2.05-0.499,2.561-1.497c0.51-0.999,1.094-3.763,1.748-8.294
		h1.655l-0.78,15.937h-21.492v-2.074l6.984-12.711c3.889-6.758,6.225-11.008,7.008-12.749c1.121-2.482,1.938-4.883,2.448-7.2
		c0.513-2.316,0.769-4.422,0.769-6.316c0-3.148-0.543-5.626-1.633-7.43c-1.088-1.804-2.6-2.708-4.535-2.708
		c-2.176,0-3.949,0.833-5.326,2.497s-2.064,3.431-2.064,5.299c0,0.64,0.105,1.127,0.313,1.459c0.193,0.333,0.607,0.628,1.248,0.884
		c1.615,0.614,2.425,2.125,2.425,4.531c0,1.306-0.271,2.388-0.816,3.245c-0.543,0.858-1.237,1.286-2.088,1.286
		c-0.976,0-1.832-0.723-2.565-2.17c-0.736-1.446-1.104-3.334-1.104-5.664c0-2.611,0.42-4.985,1.261-7.123
		c0.84-2.137,2.107-3.891,3.805-5.261c1.695-1.369,3.521-2.054,5.473-2.054c1.938,0,3.732,0.666,5.391,1.997
		c1.653,1.332,2.897,3.078,3.73,5.242c0.833,2.164,1.248,4.525,1.248,7.085c0,1.767-0.208,3.559-0.624,5.376
		c-0.415,1.817-1.021,3.521-1.82,5.106c-1.375,2.74-2.789,5.083-4.241,7.028l-6.328,8.525
		C266.79,109.068,265.623,110.899,264.889,112.41z"></path>
	<g id="hour" transform="rotate(452.225, 256, 256)">
		<use xlink:href="#p1" transform="rotate(1.04362 256 256)">
			<animateTransform attributeName="transform" type="rotate" dur="43200s" values="0, 256, 256; 360, 256, 256" repeatCount="indefinite"></animateTransform>
		</use>
	</g>
	<g id="hour2" transform="rotate(452.225, 255, 257)">
		<use filter="url(#f5)" opacity="0.5" x="-1" y="1" xlink:href="#p1" transform="rotate(1.04362 255 257)">
			<animateTransform attributeName="transform" type="rotate" dur="43200s" values="0, 255, 257; 360, 255, 257" repeatCount="indefinite"></animateTransform>
		</use>
	</g>
	<g id="min" transform="rotate(26.700000000000003, 256, 256)">
		<use xlink:href="#p2" transform="rotate(12.5234 256 256)">
			<animateTransform attributeName="transform" type="rotate" dur="3600s" values="0, 256, 256; 360, 256, 256" repeatCount="indefinite"></animateTransform>
		</use>
	</g>
	<g id="min2" transform="rotate(26.700000000000003, 254, 258)">
		<use filter="url(#f5)" opacity="0.5" x="-2" y="2" xlink:href="#p2" transform="rotate(12.5234 254 258)">
			<animateTransform attributeName="transform" type="rotate" dur="3600s" values="0, 254, 258; 360, 254, 258" repeatCount="indefinite"></animateTransform>
		</use>
	</g>
	<g id="sec" transform="rotate(162, 256, 256)">
		<use xlink:href="#p3" transform="rotate(31.4044 256 256)">
			<animateTransform attributeName="transform" type="rotate" dur="60s" values="0, 256, 256; 360, 256, 256" repeatCount="indefinite"></animateTransform>
		</use>
	</g>
	<g id="sec2" transform="rotate(162, 253, 259)">
		<use filter="url(#f5)" opacity="0.5" x="-3" y="3" xlink:href="#p3" transform="rotate(31.4044 253 259)">
			<animateTransform attributeName="transform" type="rotate" dur="60s" values="0, 253, 259; 360, 253, 259" repeatCount="indefinite"></animateTransform>
		</use>
	</g>
	<circle fill="url(#f7)" filter="url(#f6)" cx="256" cy="256" r="7.5"></circle>
</svg>

<div id="clockdate"></div>

<script type="text/javascript">
    $(document).ready(function() {
		// Create two variable with the names of the months and days in an array
		var monthNames = [ "Janvier", "Février", "Mars", "Avril", "Mai", "Juin", "Juillet", "Août", "Septembre", "Octobre", "Novembre", "Décembre" ]; 
		var dayNames= ["Dimanche","Lundi","Mardi","Mercredi","Jeudi","Vendredi","Samedi"]

		// Create a newDate() object
		var newDate = new Date();
		// Extract the current date from Date object
		newDate.setDate(newDate.getDate());
		// Output the day, date, month and year    
		$('#clockdate').html(dayNames[newDate.getDay()] + " " + newDate.getDate() + ' ' + monthNames[newDate.getMonth()] + ' ' + newDate.getFullYear());
	});
</script>