SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET character_set_client = utf8;

DROP PROCEDURE IF EXISTS DelWidget;
DELIMITER |
CREATE PROCEDURE DelWidget(_idwidget INT(11))
BEGIN
    DECLARE v_finished INTEGER DEFAULT 0;
    DECLARE v_panel_widget_id INTEGER(11) DEFAULT 0;
    
    DEClARE panel_widget_cursor CURSOR FOR SELECT panel_widget_id FROM env_panel_widget WHERE panel_widget_widget=_idwidget;
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_finished = 1;
    
    OPEN panel_widget_cursor;
    
    get_panel_widget: LOOP
        FETCH panel_widget_cursor INTO v_panel_widget_id;
        IF v_finished = 1 THEN 
            LEAVE get_panel_widget;
        END IF;
         
	    DELETE FROM env_panel_widget_carousel WHERE panel_widget_carousel_widget=v_panel_widget_id;
	    DELETE FROM env_panel_widget_bookmark WHERE panel_widget_bookmark_widget=v_panel_widget_id;
	    DELETE FROM env_panel_widget WHERE panel_widget_id=v_panel_widget_id;
    END LOOP get_panel_widget;
 
    CLOSE panel_widget_cursor;	
    
    DELETE FROM env_widget WHERE widget_id=_idwidget;  
END|
DELIMITER ;

DROP PROCEDURE IF EXISTS DelApplication;
DELIMITER |
CREATE PROCEDURE DelApplication(_idapplication INT(11))
BEGIN
	DELETE FROM env_application_profil WHERE application_profil_application=_idapplication;
	DELETE FROM env_application_sso_profil WHERE application_sso_profil_application=_idapplication;
	DELETE FROM env_application_ldap_profil WHERE application_ldap_profil_application=_idapplication;
	DELETE FROM env_application WHERE application_id=_idapplication;
END|
DELIMITER ;

-- Insertion des icones systèmes
INSERT IGNORE INTO `env_icon` (`icon_id`, `icon_url`) VALUES
(-1001, '00-envole001.jpg'),
(-1002, '00-envole002.jpg'),
(-1003, '00-envole003.jpg'),
(-1004, '00-envole004.png'),
(-1005, '00-envole005.png'),
(-1006, '00-envole006.png'),
(-1007, '00-envole007.png'),
(-1008, '00-envole008.png'),
(-1009, '00-envole009.png'),
(-1010, '00-envole010.png'),
(-1011, '00-envole011.png'),
(-1012, '00-envole012.png'),
(-1013, '00-envole013.png'),
(-1014, '00-envole014.png'),
(-1015, '00-envole015.png'),
(-1016, '00-envole016.png'),
(-1017, '00-envole017.png'),
(-1018, '00-envole018.png'),
(-1019, '00-envole019.png'),
(-1020, '00-envole020.png'),
(-1021, '00-envole021.png'),
(-1022, '00-envole022.png'),
(-1023, '00-envole023.png'),
(-1024, '00-envole024.png'),
(-1025, '00-envole025.png'),
(-1026, '00-envole026.png'),
(-1027, '00-envole027.png'),
(-1028, '00-envole028.png'),
(-1029, '00-envole029.png'),
(-1030, '00-envole030.png'),
(-1031, '00-envole031.png'),
(-1032, '00-envole032.png'),
(-1033, '00-envole033.png'),
(-1034, '00-envole034.png'),
(-1035, '00-envole035.png'),
(-1036, '00-envole036.png'),
(-1037, '00-envole037.jpg'),
(-1038, '00-envole038.jpg'),
(-1039, '00-envole039.jpg'),
(-1040, '00-envole040.jpg'),
(-1041, '00-envole041.png'),
(-1042, '00-envole042.png'),
(-1043, '00-envole043.jpg'),
(-1044, '00-envole044.png'),
(-1045, '00-envole045.png'),
(-1046, '00-envole046.png'),
(-1047, '00-envole047.png'),
(-1048, '00-envole048.png'),
(-1049, '00-envole049.png'),
(-1050, '00-envole050.png'),
(-1051, '00-envole051.png'),

(-500, '00-editeur.jpg'),
(-499, '00-rss.gif'),
(-498, '00-url.jpg'),
(-497, '00-owncloud.png'),
(-496, '00-phpmyadmin.png'),
(-495, '00-piwigo.png'),
(-494, '00-wordpress.png'),
(-493, '00-ead.png'),
(-492, '00-deviantart.png'),
(-491, '00-taskcalendar.png'),
(-490, '00-desktop.png'),
(-489, '00-dokuwiki.png'),
(-487, '00-roundcube.png'),
(-486, '00-ajaxplorer.png'),
(-485, '00-cdt.png'),
(-484, '00-cdc.png'),
(-483, '00-fluxbb.png'),
(-482, '00-gepi.png'),
(-481, '00-grr.png'),
(-480, '00-moodle.png'),
(-479, '00-spip.png'),
(-478, '00-taskfreak.png'),
(-477, '00-widget.jpg'),
(-476, '00-ethercalc.png'),
(-475, '00-carouseol.png'),
(-474, '00-opensondage.png'),
(-473, '00-etherpad.png'),
(-472, '00-bookmark.png'),
(-471, '00-mahara.png'),
(-470, '00-piwik.png'),
(-469, '00-evenement.png'),
(-468, '00-webcalendar.png'),
(-467, '00-balado.png'),
(-466, '00-econnect.png'),
(-465, '00-limesurvey.png'),
(-464, '00-fengoffice.png'),
(-463, '00-sacoche.png'),
(-462, '00-mindmaps.png'),
(-461, '00-eop.png'),
(-460, '00-eoe.png');

UPDATE env_icon SET icon_user=-1 WHERE icon_id<0 OR icon_user is null;

-- Insertion utilisateur système
INSERT IGNORE INTO `env_user` (`user_id`, `user_login`, `user_password`, `user_lastname`, `user_firstname`, `user_pseudo`, `user_avatar`, `user_email`, `user_profil`) VALUES
(-1, 'system', 'system', 'system', 'system', 'system', 'system.jpg', '', 1),
(1, 'admin', MD5('admin'), 'admin', 'admin', 'admin', 'admin.jpg', 'admin@mail.com', 1);

-- Insertion des type de groupe
INSERT IGNORE INTO  `env_group_type` (`group_type_id` ,`group_type_label`) VALUES
(1,  'amitié'),
(2,  'public'),
(3,  'privé'),
(4,  'vérrouillé');

-- Insertion ldap_community système
INSERT IGNORE INTO `env_ldap_community` (`ldap_community_id`, `ldap_community_label`, `ldap_community_filter`) VALUES
(-1, 'Tout le monde', '');


-- Insertion ldap_profil système
INSERT IGNORE INTO `env_ldap_profil` (`ldap_profil_id`, `ldap_profil_label`, `ldap_profil_filter`, `ldap_profil_share`, `ldap_profil_ldap_community`) VALUES
(-501, 'Tout le monde', '(uid=#login#)', 0, -1),
(-500, 'Administrateur', '(&(uid=admin)(uid=#login#))', 99, -1),
(-499, 'Elèves', '(&(uid=#login#)(ENTPersonProfils=eleve))', 0, -1),
(-498, 'Enseignants', '(&(uid=#login#)(ENTPersonProfils=enseignant))', 0, -1),
(-497, 'Responsables', '(&(uid=#login#)(ENTPersonProfils=responsable))', 0, -1),
(-496, 'Administratifs', '(&(uid=#login#)(ENTPersonProfils=administratif))', 0, -1);


-- Insertion sso_community système
INSERT IGNORE INTO `env_sso_community` (`sso_community_id`, `sso_community_label`) VALUES
(-1, 'Tout le monde');


-- Insertion des panel système
INSERT IGNORE INTO `env_panel` (`panel_id`, `panel_label`, `panel_url`, `panel_order`, `panel_user`, `panel_type`, `panel_template`, `panel_html`) VALUES
(-500, 'Envole', 'view/envole/index.php', 1, -1, 1, NULL, ''),
(-499, 'Applications', 'view/user/desktop.php', 2, -1, 2, NULL, ''),
(-498, 'Calendriers', 'view/user/calendar.php', 3, -1, 2, NULL, '');


-- Insertion des templates système
INSERT IGNORE INTO `env_panel_template` (`panel_template_id`, `panel_template_order`, `panel_template_icon`, `panel_template_html`) VALUES
(1, 1, 'colx04x04x04.png', '<div id="C1R1" class="col-md-4 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>  \r\n  \r\n<div id="C2R1" class="col-md-4 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>  \r\n  \r\n<div id="C3R1" class="col-md-4 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>'),
(2, 2, 'colx06x06.png', '<div id="C1R1" class="col-md-6 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>  \r\n\r\n<div id="C2R1" class="col-md-6 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>  \r\n'),
(3, 3, 'colx08x04.png', '<div id="C1R1" class="col-md-8 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>  \r\n\r\n<div id="C2R1" class="col-md-4 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>  \r\n'),
(4, 4, 'colx12x04x04x04.png', '<div id="C1R1" class="col-md-12 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>  \r\n\r\n<div id="C2R1" class="col-md-4 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>  \r\n\r\n<div id="C3R1" class="col-md-4 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>\r\n\r\n<div id="C4R1" class="col-md-4 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>  '),
(5, 5, 'colx12x06x06.png', '<div id="C1R1" class="col-md-12 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>  \r\n\r\n<div id="C2R1" class="col-md-6 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>  \r\n\r\n<div id="C3R1" class="col-md-6 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>  \r\n'),
(6, 6, 'colx03x06x03.png', '<div id="C1R1" class="col-md-3 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>  \r\n  \r\n<div id="C2R1" class="col-md-6 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>  \r\n  \r\n<div id="C3R1" class="col-md-3 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>'),
(7, 7, 'colx03x03x03x03.png', '<div id="C1R1" class="col-md-3 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>  \r\n  \r\n<div id="C2R1" class="col-md-3 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>  \r\n<div id="C3R1" class="col-md-3 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div> \r\n  \r\n<div id="C4R1" class="col-md-3 column">  \r\n<div width="100%">&nbsp;</div>\r\n</div>');

-- Insertion des profils base système
INSERT IGNORE INTO `env_profil` (`profil_id`, `profil_label`) VALUES
(1, 'administrateur'),
(2, 'moderateur'),
(50, 'utilisateur'),
(99, 'invite');

-- Insertion des profils de partable système
INSERT IGNORE INTO `env_profil_share` (`profil_share_id`, `profil_share_label`) VALUES
(0, 'personne'),
(10, 'profil'),
(20, 'communauté'),
(99, 'tout le monde');

-- Insertion mode d'insertion widget système
INSERT IGNORE INTO `env_widget_mode` (`widget_mode_id`, `widget_mode_name`) VALUES
(1, 'iFrame'),
(2, 'Div');


-- Insertion style de widget système
INSERT IGNORE INTO `env_widget_style` (`widget_style_id`, `widget_style_label`) VALUES
(1, 'Avec Bordure'),
(2, 'Sans Bordure'),
(3, 'Post-it');


-- Insertion tye de widget système
INSERT IGNORE INTO `env_widget_type` (`widget_type_id`, `widget_type_name`) VALUES
(1, 'Page Web'),
(2, 'Flux RSS'),
(3, 'Page Editeur'),
(4, 'Code'),
(5, 'Bureau'),
(6, 'Widget eportail'),
(7, 'Titre'),
(8, 'Caldav');

-- Insertion style de flux système
INSERT IGNORE INTO `env_flux_style` (`flux_style_id`, `flux_style_label`) VALUES
(1, 'Ligne'),
(2, 'Colonne');


-- Insertion type de panel système
INSERT IGNORE INTO `env_panel_type` (`panel_type_id`, `panel_type_name`) VALUES
(1, 'url'),
(2, 'application'),
(3, 'editeur'),
(4, 'widget');


-- Insertion type de panel système
INSERT IGNORE INTO `env_application_categorie` (`application_categorie_id`, `application_categorie_label`, `application_categorie_order`, `application_categorie_color`) VALUES
(-100, 'Applications', 1, '03C9A9'),
(-99, 'Administration', 2, '663399');
UPDATE `env_application_categorie` SET `application_categorie_label`='Administration' WHERE `application_categorie_id`=-99;


-- Insertion flux système
INSERT IGNORE INTO `env_flux` (`flux_id`, `flux_name`, `flux_type`, `flux_url`, `flux_order`, `flux_number`, `flux_color`, `flux_style`) VALUES
(-500, 'Envole', 0, 'http://dev-eole.ac-dijon.fr/projects/envole/news.atom?key=0c3837f9fcaf2704056f8915c92c9dfb3d27579c', 1, 5, '03C9A9',1);


-- Insertion des permissions moderateur système
INSERT IGNORE INTO `env_profil_moderation` (`profil_moderation_order`, `profil_moderation_label`, `profil_moderation_url`, `profil_moderation_fgperm`) VALUES
(1,	    'Console d\'Administration',    'admin/index.php',                 1),
(110,   'Configuration Générale',       'admin/config.php',                0),
(120,   'Configuration LDAP',           'admin/ldap.php',                  0),
(130,   'Configuration Style',          'admin/style.php',                 0),
(140,   'Configuration Icônes',         'admin/icon.php',                  1),
(210,   'SSO Attributs',                'admin/ssoattribut.php',           0),
(220,   'SSO Communauté',               'admin/ssocommunity.php',          0),
(230,   'SSO Profil',                   'admin/ssoprofil.php',             0),
(310,   'LDAP Communauté',              'admin/ldapcommunity.php',         0),
(320,   'LDAP Profil',                  'admin/ldapprofil.php',            0),
(410,   'Utilisateur Inscription',      'admin/inscription.php',           0),
(420,   'Gestion des Utilisateurs',     'admin/user.php',                  0),
(430,   'Gestion des Groupes',          'admin/group.php',                 0),
(510,   'Application Catégorie',        'admin/applicationcategorie.php',  1),
(520,   'Gestion des Applications',     'admin/application.php',           1),
(530,   'Application par Profils',      'admin/applicationprofil.php',     1),
(540,   'Applications par Groupe',      'admin/applicationgroup.php',      1),
(550,   'Application par Profils SSO',  'admin/applicationssoprofil.php',  1),
(560,   'Application par Profils LDAP', 'admin/applicationldapprofil.php', 1),
(610,   'Widget Catégorie',             'admin/widgetcategorie.php',       0),
(620,   'Gestion des Widgets',          'admin/widget.php',                0),
(710,   'Gestion des Pages Widget',     'admin/panelwidget.php',           0),
(720,   'Gestion des Pages Editeur',    'admin/paneleditor.php',           0),
(730,   'Gestion des Pages URL',        'admin/panelurl.php',              0),
(740,   'Page par Profils',             'admin/panelprofil.php',           0),
(750,   'Page par Groupe',              'admin/panelgroup.php',            0),
(760,   'Parge par Profils SSO',        'admin/panelssoprofil.php',        0),
(770,   'Page par Profils LDAP',        'admin/panelldapprofil.php',       0),
(810,   'Gestion des Flux',             'admin/flux.php',                  1),
(820,	'Gestion des Messages de Flux', 'admin/fluxmsg.php',               1),
(830,   'Flux par Profils',             'admin/fluxprofil.php',            1),
(840,   'Flux par Groupe',              'admin/fluxgroup.php',             1),
(850,   'Flux par Profils SSO',         'admin/fluxssoprofil.php',         1),
(860,   'Flux par Profils LDAP',        'admin/fluxldapprofil.php',        1),
(910,   'Gestion des Postit',           'admin/postit.php',                1),
(1010,  'Gestion des Calendriers',      'admin/calendar.php',              1),
(1020,  'Calendrier par Profils',       'admin/calendarprofil.php',        1),
(1030,  'Calendrier par Groupe',        'admin/calendargroup.php',         1),
(1040,  'Calendrier par Profils SSO',   'admin/calendarssoprofil.php',     1),
(1050,  'Calendrier par Profils LDAP',  'admin/calendarldapprofil.php',    1),
(100000,'Synchronisation',              'admin/synchro.php',               0);




-- Insertion widget système
INSERT IGNORE INTO `env_widget` (`widget_id`, `widget_name`, `widget_label`, `widget_icon`, `widget_url`, `widget_code`, `widget_adjust`, `widget_height`, `widget_style`, `widget_type`, `widget_mode`, `widget_categorie`, `widget_actif`) VALUES
(-500, 'Page Web', 'Afficher une page web', '-498', '', '', 0, 300, 1, 1, 1, 0, 1),
(-499, 'Flux RSS', 'Afficher le contenu d''un flux RSS provenant d''un autre site', '-499', '', '', 0, 300, 1, 2, 1, 0, 1),
(-498, 'Page Editeur', 'Votre propre texte à éditer', '-500', 'view/user/editor.php', '', 0, 635, 1, 3, 1, 0, 1),
(-497, 'Bureau', 'Votre Bureau', '-490', 'view/user/desktop.php', '', 0, 635, 1, 5, 1, 0, 1),
(-496, 'Carrousel', 'Carrousel', '-475', 'view/user/carousel.php', '', 0, 300, 1, 6, 1, 0, 1),
(-495, 'Favoris', 'Favoris', '-472', 'view/user/bookmark.php', '', 0, 300, 1, 6, 1, 0, 1),
(-494, 'Fichiers', 'Dépôt de fichier', '-486', 'view/user/file.php', '', 0, 635, 1, 6, 1, 0, 1),
(-493, 'Galerie', 'Galerie Images', '-475', 'view/user/galery.php', '', 0, 635, 1, 6, 1, 0, 1),
(-464, 'Flux Profils', 'Afficher de flux RSS en fonction de votre profil', '-499', 'view/user/flux.php', '', 0, 635, 1, 1, 1, 0, 1),
(-463, 'Titre', 'Un petit pavet Titre', '-1010', '', '', 0, 0, 1, 7, 1, 0, 1),
(-462, 'Postit Profils', 'Afficher de Postit en fonction de votre profil', '-1047', 'view/user/postit.php', '', 0, 635, 1, 1, 1, 0, 1),
(-461, 'Horloge', 'Horloge numérique', '-1048', 'view/user/clock.php', '', 0, 180, 1, 1, 1, 0, 1),
(-460, 'Chat', 'Salon de conversation', '-1033', 'lib/chat/chat.php', '', 0, 635, 1, 1, 1, 0, 0),
(-458, 'Calculatrice', 'Calculatrice numérique', '-1049', 'view/user/calculator.php', '', 0, 300, 1, 1, 1, 0, 1),
(-457, 'Tâches', 'Gestionnaire de tâches', '-1050', 'view/user/task.php', '', 0, 635, 1, 1, 1, 0, 1),
(-456, 'Calendriers', 'Mes Calendriers', '-1007', 'view/user/calendar.php', '', 0, 635, 1, 1, 1, 0, 1);

UPDATE `env_widget` SET `widget_name`='Carrousel' WHERE `widget_id`=-496;


-- Garder ce numéro pour le calendrier caldav (-459, 'Calendrier', 'Calendrier avec url caldav', '-468', 'view/user/caldav.php', '', 0, 300, 1, 8, 1, 0, 1);
-- Attention widget Envole à partir de -400
-- Attention application Envole à partir de -400



