<?php
	// No direct access to this file 
	define('IS_AJAX', isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest'); 
	if(!IS_AJAX) {die('Restricted access');}
	
	include("../../include/config.php");
	include("../../include/session.php");
	
    $function = $_POST['function'];
    $log = array();
    
    switch($function) {
    
		case('getState'):
			if(file_exists($config['localdirectory'].'/local/chat/chat.txt')){
				$lines = file($config['localdirectory'].'/local/chat/chat.txt');
			}
			$log['state'] = count($lines); 
		break;	
    	
		case('update'):
			$state = $_POST['state'];
			if(file_exists($config['localdirectory'].'/local/chat/chat.txt')){
				$lines = file($config['localdirectory'].'/local/chat/chat.txt');
			}
			
			$count = count($lines);
			
			// Si le fichier fait plus de 100 lignes on tronque les 80 premieres lignes
			if($count>100) {
				$X = 80; // Number of lines to remove

				$lines = file($config['localdirectory'].'/local/chat/chat.txt');
				$first_line = $lines[0];
				$lines = array_slice($lines, $X + 2);

				// Write to file
				$file = fopen($config['localdirectory'].'/local/chat/chat.txt', 'w');
				fwrite($file, implode('', $lines));
				fclose($file);			
				
				$lines = file($config['localdirectory'].'/local/chat/chat.txt');
				$count = count($lines);
				$state = 0;
			}
			
			if($state==0||$state>$count) {
				$state=$count-20;
			}
			
			if($state==$count){
				$log['state'] = $state;
				$log['text'] = false;
			}
			else{
				$text= array();
				$log['state'] = $state + count($lines) - $state;
				
				if(is_array($lines)) {
				    foreach ($lines as $line_num => $line)
				    {
					    if($line_num >= $state){
						    $text[] =  $line = str_replace("\n", "", $line);
					    }

				    }
				}
				
				$log['text'] = $text; 
			}
		break;
    	 
		case('send'):
			$nickname = htmlspecialchars(strip_tags($_POST['nickname']));
			$reg_exUrl = "/(http|https|ftp|ftps)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/";
			$message = htmlspecialchars(strip_tags($_POST['message']));
			if(($message) != "\n"){
				if(preg_match($reg_exUrl, $message, $url)) {
					$message = preg_replace($reg_exUrl, '<a href="'.$url[0].'" target="_blank">'.$url[0].'</a>', $message);
				} 

				if($_SESSION['user_avatar']=="")
					$imgurl="../../style/images/noavatar.png";
				else 
					$imgurl="../../local/images/avatar/".$_SESSION['user_avatar'];

				$now   = new DateTime;
				fwrite(fopen($config['localdirectory'].'/local/chat/chat.txt', 'a'), "<img src='$imgurl'><span class='ligne1'>".$nickname."</span><span class='ligne2'>le ".$now->format( 'd/m/Y' )." à ".$now->format( 'H:i' )."</span><span class='ligne3'>" . $message = str_replace("\n", " ", $message) . "</span>\n"); 
			}
		break;
    	
    }
    
    echo json_encode($log);

?>
