<?
header('Content-type: text/css'); 
include("../include/config.php");
if($config['theme']!="") @include("themes/".$config['theme']."/config.php");

if($config['maincolor']=="") $config['maincolor'] = '428BCA';

//== COLOR ================================================================================================================================
if($config["maincolor"]!="") {
    function adjustBrightness($hex, $steps) {
        // Steps should be between -255 and 255. Negative = darker, positive = lighter
        $steps = max(-255, min(255, $steps));

        // Normalize into a six character long hex string
        $hex = str_replace('#', '', $hex);
        if (strlen($hex) == 3) {
            $hex = str_repeat(substr($hex,0,1), 2).str_repeat(substr($hex,1,1), 2).str_repeat(substr($hex,2,1), 2);
        }

        // Split into three parts: R, G and B
        $color_parts = str_split($hex, 2);
        $return = '#';

        foreach ($color_parts as $color) {
            $color   = hexdec($color); // Convert to decimal
            $color   = max(0,min(255,$color + $steps)); // Adjust color
            $return .= str_pad(dechex($color), 2, '0', STR_PAD_LEFT); // Make two char hex code
        }

        return $return;
    }


    $maincolor="#".$config["maincolor"];
?>

h1, .h1, h2, .h2, h3, .h3, legend, .form-horizontal .control-label,a, #widgetadmin a, #myitemadd button, .pagination > li > a, .pagination > li > span, .sidebar .nav > li > a:hover, .sidebar .nav > li > a:focus,.rssRow .rssTitle, .rssRow .rssTitle a,.rssRow .rssDate,.ui-state-default, .ui-widget-content .ui-state-default, .ui-widget-header .ui-state-default { 
    color: <? echo $maincolor ?>; 
}

#bodylogin, .myavatarvide, table.dataTable thead .sorting, table.dataTable thead .sorting_asc, table.dataTable thead .sorting_desc, table.dataTable th, .WidgetClass1 .WidgetHeader,.WidgetClass2 .WidgetHeader, #navitem li, #navitem > li > a:hover, #navitem > li > a:focus, .modal-header, .btn-primary, #myitem a,#myitem #badge-delete, .pagination > .active > a,.bootstrap-switch .bootstrap-switch-handle-on.bootstrap-switch-primary, .bootstrap-switch .bootstrap-switch-handle-off.bootstrap-switch-primary {
	background-color: <? echo $maincolor ?>;
}

.btn-primary:hover,
.pagination > .active > a:hover,
.btn-primary:focus,
.btn-primary:active,
.btn-primary.active,
.open > .dropdown-toggle.btn-primary {
    background-color: <? echo adjustBrightness($maincolor,-50) ?>;
    border-color: <? echo adjustBrightness($maincolor,-50) ?>;
}

.form-control:focus,.bootstrap-switch.bootstrap-switch-focused {
  border-color: <? echo $maincolor ?>;
}
  
a:hover, .rssRow .rssTitle a:hover, a:focus, .pagination > li > a:hover {
  color: <? echo adjustBrightness($maincolor,-50) ?>;
}
  
.envole-carousel > .item {
	background-color: <? echo $maincolor ?> !important;
}

#header, .ui-widget-header {
	background-color: <? echo $maincolor ?> !important;
}
	
table.dataTable tbody tr td, table.dataTable thead tr th, .modal-header, legend, .btn-primary, #navitem li, .table-bordered, .pagination > .active > a,.rssRow .rssTitle, .rssRow {
	border-color: <? echo $maincolor ?>;
}

<?
}

//== FONT =================================================================================================================================

if($config["mainfont"]!="") {
    $mainfont=$config["mainfont"];
?>

@font-face {
    font-family: '<? echo $mainfont ?>';
    src: url('/<? echo $config["alias"] ?>/style/fonts/<? echo "$mainfont/$mainfont-"; ?>webfont.eot');
    src: url('/<? echo $config["alias"] ?>/style/fonts/<? echo "$mainfont/$mainfont-"; ?>webfont.eot?#iefix') format('embedded-opentype'),
         url('/<? echo $config["alias"] ?>/style/fonts/<? echo "$mainfont/$mainfont-"; ?>webfont.woff') format('woff'),
         url('/<? echo $config["alias"] ?>/style/fonts/<? echo "$mainfont/$mainfont-"; ?>webfont.ttf') format('truetype');
    font-weight: normal;
    font-style: normal;
}


h1, .h1, h2, .h2, h3, .h3, h4, .h4, legend, .WidgetHeader, #page-header-user-name  {
	font-family: <? echo $mainfont ?>;
}

<?
}
?>

