# copy-utils

> Utility functions for copying properties from one JavaScript object to another

## Install

```sh
$ npm install copy-utils
```

## Usage

```js
var utils = require('copy-utils')
```

## API

For all methods below, the first param is the source object from which to copy

### copy(src, dest) -> dest

Copies all properties from source to destination. Returns the destination object.

If no dest is specified, it will be asigned an empty object.

```js
utils.copy(src, dest)
var person = { name: 'john', age: 5}
var clone = {age: 1}
utils.copy(person, clone) // -> clone.age == 5, clone.name = 'john'
```

### copyIf(src, dest) -> dest

Copies all properties from source to destination, if the property does not exist into the destination (that is, if the destination has an undefined value in the corresponding key)