describe('Find', function(){

    var should = require('should')

    var find = require('../index').findIndex

    it('should find in an array', function(){
        var obj = {
            name: 'three'
        }

        var found = find(function(it){
            return it.name == 'three'
        }, [2, obj, 4])

        found
            .should
            .equal(1)
    })

    it('should be curried', function(){
        var findFirst = find(function(obj, i, arr){
            if (i == 0){
                return obj
            }
        })

        findFirst([4,5,6])
            .should
            .equal(0)

        findFirst([14,5,6])
            .should
            .equal(0)
    })
})