'use strict'

var STR_UNDEFINED = 'undefined'

/**
 * Copies all properties named in the list, from source to destination
 *
 *      copyList({name: 'jon',age:5, year: 2006}, {}, ['name','age'])
 *      // => {name: 'jon', age: 5}
 *
 * @param {Object} source
 * @param {Object} destination
 * @param {Array} list the array with the names of the properties to copy
 *
 * @return {Object} destination
 */
module.exports = function(source, destination, list){
    if (arguments.length < 3){
        list = destination
        destination = null
    }

    destination = destination || {}
    list        = list || Object.keys(source)

    var i   = 0
    var len = list.length
    var propName

    for ( ; i < len; i++ ){
        propName = list[i]

        if ( typeof source[propName] !== STR_UNDEFINED ) {
            destination[list[i]] = source[list[i]]
        }
    }

    return destination
}