// Generated by CoffeeScript 1.7.1
var Parser, stream, util;

stream = require('stream');

util = require('util');

module.exports = function() {
  var callback, called, chunks, data, options, parser;
  if (arguments.length === 3) {
    data = arguments[0];
    options = arguments[1];
    callback = arguments[2];
  } else if (arguments.length === 2) {
    if (typeof arguments[0] === 'string') {
      data = arguments[0];
    } else {
      options = arguments[0];
    }
    if (typeof arguments[1] === 'function') {
      callback = arguments[1];
    } else {
      options = arguments[1];
    }
  } else if (arguments.length === 1) {
    if (typeof arguments[0] === 'function') {
      callback = arguments[0];
    } else {
      options = arguments[0];
    }
  }
  if (options == null) {
    options = {};
  }
  parser = new Parser(options);
  if (data) {
    process.nextTick(function() {
      parser.write(data);
      return parser.end();
    });
  }
  if (callback) {
    called = false;
    chunks = options.objname ? {} : [];
    parser.on('readable', function() {
      var chunk, _results;
      _results = [];
      while (chunk = parser.read()) {
        if (options.objname) {
          _results.push(chunks[chunk[0]] = chunk[1]);
        } else {
          _results.push(chunks.push(chunk));
        }
      }
      return _results;
    });
    parser.on('error', function(err) {
      called = true;
      return callback(err);
    });
    parser.on('end', function() {
      if (!called) {
        return callback(null, chunks);
      }
    });
  }
  return parser;
};

Parser = function(options) {
  var _base, _base1, _base10, _base11, _base2, _base3, _base4, _base5, _base6, _base7, _base8, _base9;
  if (options == null) {
    options = {};
  }
  options.objectMode = true;
  stream.Transform.call(this, options);
  this.options = options;
  if ((_base = this.options).rowDelimiter == null) {
    _base.rowDelimiter = null;
  }
  if ((_base1 = this.options).delimiter == null) {
    _base1.delimiter = ',';
  }
  if ((_base2 = this.options).quote == null) {
    _base2.quote = '"';
  }
  if ((_base3 = this.options).escape == null) {
    _base3.escape = '"';
  }
  if ((_base4 = this.options).columns == null) {
    _base4.columns = null;
  }
  if ((_base5 = this.options).comment == null) {
    _base5.comment = '';
  }
  if ((_base6 = this.options).objname == null) {
    _base6.objname = false;
  }
  if ((_base7 = this.options).trim == null) {
    _base7.trim = false;
  }
  if ((_base8 = this.options).ltrim == null) {
    _base8.ltrim = false;
  }
  if ((_base9 = this.options).rtrim == null) {
    _base9.rtrim = false;
  }
  if ((_base10 = this.options).auto_parse == null) {
    _base10.auto_parse = false;
  }
  if ((_base11 = this.options).skip_empty_lines == null) {
    _base11.skip_empty_lines = false;
  }
  this.lines = 0;
  this.buf = '';
  this.quoting = false;
  this.commenting = false;
  this.field = '';
  this.lastC = '';
  this.nextChar = null;
  this.closingQuote = 0;
  this.line = [];
  this.chunks = [];
  this.floatRegexp = /^(\-|\+)?([0-9]+(\.[0-9]+)?|Infinity)$/;
  return this;
};

util.inherits(Parser, stream.Transform);

module.exports.Parser = Parser;

Parser.prototype._transform = function(chunk, encoding, callback) {
  var err;
  if (chunk instanceof Buffer) {
    chunk = chunk.toString();
  }
  try {
    this.__write(chunk, false);
    return callback();
  } catch (_error) {
    err = _error;
    return this.emit('error', err);
  }
};

Parser.prototype._flush = function(callback) {
  var err;
  try {
    this.__write('', true);
    if (this.quoting) {
      this.emit('error', new Error("Quoted field not terminated at line " + (this.lines + 1)));
      return;
    }
    if (this.field || this.lastC === this.options.delimiter || this.lastC === this.options.quote) {
      if (this.options.trim || this.options.rtrim) {
        this.field = this.field.trimRight();
      }
      this.line.push(this.field);
      this.field = '';
    }
    if (this.line.length > 0) {
      this.__push(this.line);
    }
    return callback();
  } catch (_error) {
    err = _error;
    return this.emit('error', err);
  }
};

Parser.prototype.__push = function(line) {
  var field, i, lineAsColumns, _i, _len;
  if (this.options.columns === true) {
    this.options.columns = line;
    return;
  } else if (typeof this.options.columns === 'function') {
    this.options.columns = this.options.columns(line);
    return;
  }
  if (this.options.columns != null) {
    lineAsColumns = {};
    for (i = _i = 0, _len = line.length; _i < _len; i = ++_i) {
      field = line[i];
      lineAsColumns[this.options.columns[i]] = field;
    }
    if (this.options.objname) {
      return this.push([lineAsColumns[this.options.objname], lineAsColumns]);
    } else {
      return this.push(lineAsColumns);
    }
  } else {
    return this.push(line);
  }
};

Parser.prototype.__write = function(chars, end, callback) {
  var areNextCharsRowDelimiters, char, delimLength, escapeIsQuote, i, isDelimiter, isEscape, isQuote, isRowDelimiter, l, ltrim, nextCharPos, rowDelimiter, rtrim, wasCommenting, _results;
  ltrim = this.options.trim || this.options.ltrim;
  rtrim = this.options.trim || this.options.rtrim;
  chars = this.buf + chars;
  l = chars.length;
  delimLength = this.options.rowDelimiter ? this.options.rowDelimiter.length : 0;
  i = 0;
  if (this.lines === 0 && 0xFEFF === chars.charCodeAt(0)) {
    i++;
  }
  while (i < l) {
    if ((i + delimLength >= l && chars.substr(i, this.options.rowDelimiter.length) !== this.options.rowDelimiter) && !end) {
      break;
    }
    if ((i + this.options.escape.length >= l && chars.substr(i, this.options.escape.length) === this.options.escape) && !end) {
      break;
    }
    char = this.nextChar ? this.nextChar : chars.charAt(i);
    this.lastC = char;
    this.nextChar = chars.charAt(i + 1);
    if (this.options.rowDelimiter == null) {
      if ((this.field === '') && (char === '\n' || char === '\r')) {
        rowDelimiter = char;
        nextCharPos = i + 1;
      } else if (this.nextChar === '\n' || this.nextChar === '\r') {
        rowDelimiter = this.nextChar;
        nextCharPos = i + 2;
      }
      if (rowDelimiter) {
        if (rowDelimiter === '\r' && chars.charAt(nextCharPos) === '\n') {
          rowDelimiter += '\n';
        }
        this.options.rowDelimiter = rowDelimiter;
        delimLength = this.options.rowDelimiter.length;
      }
    }
    if (char === this.options.escape) {
      escapeIsQuote = this.options.escape === this.options.quote;
      isEscape = this.nextChar === this.options.escape;
      isQuote = this.nextChar === this.options.quote;
      if (!(escapeIsQuote && !this.field && !this.quoting) && (isEscape || isQuote)) {
        i++;
        char = this.nextChar;
        this.nextChar = chars.charAt(i + 1);
        this.field += char;
        i++;
        continue;
      }
    }
    if (char === this.options.quote) {
      if (this.quoting) {
        areNextCharsRowDelimiters = this.options.rowDelimiter && chars.substr(i + 1, this.options.rowDelimiter.length) === this.options.rowDelimiter;
        if (!this.options.relax && this.nextChar && !areNextCharsRowDelimiters && this.nextChar !== this.options.delimiter && this.nextChar !== this.options.comment) {
          throw new Error("Invalid closing quote at line " + (this.lines + 1) + "; found " + (JSON.stringify(this.nextChar)) + " instead of delimiter " + (JSON.stringify(this.options.delimiter)));
        }
        this.quoting = false;
        this.closingQuote = i;
        i++;
        continue;
      } else if (!this.field) {
        this.quoting = true;
        i++;
        continue;
      } else if (this.field && !this.options.relax) {
        throw new Error("Invalid opening quote at line " + (this.lines + 1));
      }
    }
    isDelimiter = char === this.options.delimiter;
    isRowDelimiter = this.options.rowDelimiter && chars.substr(i, this.options.rowDelimiter.length) === this.options.rowDelimiter;
    if (!this.commenting && !this.quoting && char === this.options.comment) {
      this.commenting = true;
    } else if (this.commenting && isRowDelimiter) {
      wasCommenting = true;
      this.commenting = false;
    }
    if (!this.commenting && !this.quoting && (isDelimiter || isRowDelimiter)) {
      if (isRowDelimiter && this.line.length === 0 && this.field === '') {
        if (wasCommenting || this.options.skip_empty_lines) {
          i += this.options.rowDelimiter.length;
          this.nextChar = chars.charAt(i);
          continue;
        }
      }
      if (rtrim) {
        if (this.closingQuote) {
          this.field = this.field.substr(0, this.closingQuote);
        } else {
          this.field = this.field.trimRight();
        }
      }
      if (this.options.auto_parse && this.floatRegexp.test(this.field)) {
        this.line.push(parseFloat(this.field));
      } else {
        this.line.push(this.field);
      }
      this.closingQuote = 0;
      this.field = '';
      if (isRowDelimiter) {
        this.__push(this.line);
        this.lines++;
        this.line = [];
        i += this.options.rowDelimiter.length;
        this.nextChar = chars.charAt(i);
        continue;
      }
    } else if (!this.commenting && !this.quoting && (char === ' ' || char === '\t')) {
      if (!(ltrim && !this.field)) {
        this.field += char;
      }
    } else if (!this.commenting) {
      this.field += char;
    }
    i++;
  }
  this.buf = '';
  _results = [];
  while (i < l) {
    this.buf += chars.charAt(i);
    _results.push(i++);
  }
  return _results;
};
