describe('Once', function(){

    var once = require('../index').once

    it('should only run once', function(){

        var counter = 0

        var inc = once(function(){
            counter++
        })

        counter
            .should
            .equal(0)

        inc()

        counter
            .should
            .equal(1)

        inc()
        inc()
        inc()

        counter
            .should
            .equal(1)
    })

    it('should return same result', function(){
        var arr = [{}, {}, {}]
        var counter = 0

        var get = once(function(){
            counter++
            return arr[counter]
        })

        get()
            .should
            .equal(arr[1])

        get()
            .should
            .equal(arr[1])
    })

    it('should be called with all args', function(){
        var args = [1,2,3]

        var res = once(function(){
            return arguments
        })

        res.apply(this, args)
            .should
            .eql(args)
    })

})