/*! jquery.pep.js // Brian Gonzalez - @brianmgonzalez // v0.4.2 // 2013-06-26 */
(function(t,e,i){"use strict";var s="pep",o=e.document,n={debug:false,activeClass:"pep-active",multiplier:1,velocityMultiplier:1.9,shouldPreventDefault:true,stopEvents:"",hardwareAccelerate:true,useCSSTranslation:true,disableSelect:true,cssEaseString:"cubic-bezier(0.190, 1.000, 0.220, 1.000)",cssEaseDuration:750,shouldEase:true,droppable:false,droppableActiveClass:"pep-dpa",overlapFunction:false,constrainTo:false,removeMargins:true,axis:null,forceNonCSS3Movement:false,drag:function(){},start:function(){},stop:function(){},rest:function(){}};function a(i,s){this.el=i;this.$el=t(i);this.options=t.extend({},n,s);this.$document=t(this.$el[0].ownerDocument);this.$window=t(e);this._defaults=n;this._name="Pep";this.moveTrigger=this.isTouch()?"touchmove":"mousemove";this.startTrigger=this.isTouch()?"touchstart":"mousedown";this.stopTrigger=this.isTouch()?"touchend":"mouseup";this.stopEvents=[this.stopTrigger,this.options.stopEvents].join(" ");this.$container=this.options.constrainTo&&this.options.constrainTo==="parent"?this.$el.parent():this.$document;this.CSSEaseHash=this.getCSSEaseHash();this.scale=1;this.disabled=false;this.resetVelocityQueue();this.init()}a.prototype.init=function(){var t=this;if(this.options.debug)this.buildDebugDiv();if(this.options.disableSelect)this.disableSelect();this.positionParent();this.placeObject();this.ev={};this.pos={};this.subscribe()};a.prototype.subscribe=function(){var t=this;this.$el.bind(this.startTrigger,function(e){t.handleStart(e)});this.$document.bind(this.stopEvents,function(e){t.handleStop(e)});this.$document.bind(this.moveTrigger,function(e){t.moveEvent=e})};a.prototype.handleStart=function(e){var i=this;if(this.isValidMoveEvent(e)&&!this.disabled){this.log({type:"event",event:e.type});if(this.options.hardwareAccelerate&&!this.hardwareAccelerated){this.hardwareAccelerate();this.hardwareAccelerated=true}this.options.start(e,this);clearTimeout(this.restTimeout);this.$el.addClass(this.options.activeClass);this.removeCSSEasing();this.ev.x=this.isTouch()?e.originalEvent.pageX:e.pageX;this.ev.y=this.isTouch()?e.originalEvent.pageY:e.pageY;this.moveEvent=e;this.active=true;if(this.options.shouldPreventDefault)e.preventDefault();(function s(){if(!i.active)return;i.handleMove();i.requestAnimationFrame(s)})(t,i)}};a.prototype.handleMove=function(){var t=this.moveEvent;if(typeof t==="undefined")return;var e=this.isTouch()?t.originalEvent.touches[0].pageX:t.pageX;var i=this.isTouch()?t.originalEvent.touches[0].pageY:t.pageY;this.addToLIFO({time:t.timeStamp,x:e,y:i});var s,o;if(t.type===this.startTrigger){s=0;o=0}else{s=e-this.ev.x;o=i-this.ev.y}this.dx=s;this.dy=o;this.ev.x=e;this.ev.y=i;if(s===0&&o===0){this.log({type:"event",event:"** stopped **"});return}if(this.options.droppable){this.calculateActiveDropRegions()}var n=this.options.drag(t,this);if(n===false){this.resetVelocityQueue();return}this.log({type:"event",event:t.type});this.log({type:"event-coords",x:this.ev.x,y:this.ev.y});this.log({type:"velocity"});var a=this.handleConstraint(s,o);if(!this.shouldUseCSSTranslation()){var r=s>=0?"+="+Math.abs(s/this.scale)*this.options.multiplier:"-="+Math.abs(s/this.scale)*this.options.multiplier;var p=o>=0?"+="+Math.abs(o/this.scale)*this.options.multiplier:"-="+Math.abs(o/this.scale)*this.options.multiplier;if(this.options.constrainTo){r=a.x!==false?a.x:r;p=a.y!==false?a.y:p}this.moveTo(r,p)}else{s=s/this.scale*this.options.multiplier;o=o/this.scale*this.options.multiplier;if(this.options.constrainTo){s=a.x===false?s:0;o=a.y===false?o:0}this.moveToUsingTransforms(s,o)}};a.prototype.handleStop=function(t){if(!this.active)return;this.log({type:"event",event:t.type});this.active=false;if(this.options.droppable){this.calculateActiveDropRegions()}if(this.options.shouldEase)this.ease(t);this.options.stop(t,this);this.resetVelocityQueue()};a.prototype.resetVelocityQueue=function(){this.velocityQueue=new Array(5)};a.prototype.moveTo=function(t,e,i){i=i===false||typeof i==="undefined"?false:true;if(this.options.axis==="x"){e="+=0"}else if(this.options.axis==="y"){t="+=0"}var s=300;this.log({type:"delta",x:t,y:e});if(i){this.$el.animate({top:e,left:t},s,"easeOutCirc",{queue:false})}else{this.$el.stop(true,false).css({top:e,left:t})}};a.prototype.moveToUsingTransforms=function(t,e){if(this.options.axis==="x"){e=0}else if(this.options.axis==="y"){t=0}this.cssX=this.cssX?this.cssX+t:t;this.cssY=this.cssY?this.cssY+e:e;this.log({type:"delta",x:t,y:e});this.translation="translate("+this.cssX+"px, "+this.cssY+"px)";this.$el.css({"-webkit-transform":this.translation,"-moz-transform":this.translation,"-ms-transform":this.translation,"-o-transform":this.translation,transform:this.translation})};a.prototype.addToLIFO=function(t){var e=this.velocityQueue;e=e.slice(1,e.length);e.push(t);this.velocityQueue=e};a.prototype.ease=function(t){var e=this.$el.position();var i=this.velocity();var s=this.dt;var o=i.x/this.scale*this.options.multiplier;var n=i.y/this.scale*this.options.multiplier;var a=this.handleConstraint(o,n);if(this.cssAnimationsSupported())this.$el.css(this.getCSSEaseHash());var r=i.x>0?"+="+o:"-="+Math.abs(o);var p=i.y>0?"+="+n:"-="+Math.abs(n);if(this.options.constrainTo){r=a.x!==false?a.x:r;p=a.y!==false?a.y:p}var h=!this.cssAnimationsSupported()||this.options.forceNonCSS3Movement;this.moveTo(r,p,h);var l=this;this.restTimeout=setTimeout(function(){if(l.options.droppable){l.calculateActiveDropRegions()}l.options.rest(t,l);l.$el.removeClass(l.options.activeClass)},this.options.cssEaseDuration)};a.prototype.velocity=function(){var t=0;var e=0;for(var i=0;i<this.velocityQueue.length-1;i++){if(this.velocityQueue[i]){t+=this.velocityQueue[i+1].x-this.velocityQueue[i].x;e+=this.velocityQueue[i+1].y-this.velocityQueue[i].y;this.dt=this.velocityQueue[i+1].time-this.velocityQueue[i].time}}return{x:t*this.options.velocityMultiplier,y:e*this.options.velocityMultiplier}};a.prototype.requestAnimationFrame=function(t){return e.requestAnimationFrame&&e.requestAnimationFrame(t)||e.webkitRequestAnimationFrame&&e.webkitRequestAnimationFrame(t)||e.mozRequestAnimationFrame&&e.mozRequestAnimationFrame(t)||e.oRequestAnimationFrame&&e.mozRequestAnimationFrame(t)||e.msRequestAnimationFrame&&e.msRequestAnimationFrame(t)||e.setTimeout(t,1e3/60)};a.prototype.positionParent=function(){if(!this.options.constrainTo||this.parentPositioned)return;this.parentPositioned=true;if(this.options.constrainTo==="parent"){this.$container.css({position:"relative"})}else{this.$container.css({position:"static"})}};a.prototype.placeObject=function(){if(this.objectPlaced)return;this.objectPlaced=true;this.offset=this.options.constrainTo==="parent"||this.hasNonBodyRelative()?this.$el.position():this.$el.offset();if(this.options.removeMargins)this.$el.css({margin:0});this.$el.css({position:"absolute",top:this.offset.top,left:this.offset.left})};a.prototype.hasNonBodyRelative=function(){return this.$el.parents().filter(function(){var e=t(this);return e.is("body")||e.css("position")==="relative"}).length>1};a.prototype.setScale=function(t){this.scale=t};a.prototype.setMultiplier=function(t){this.options.multiplier=t};a.prototype.removeCSSEasing=function(){if(this.cssAnimationsSupported())this.$el.css(this.getCSSEaseHash(true))};a.prototype.disableSelect=function(){this.$el.css({"-webkit-touch-callout":"none","-webkit-user-select":"none","-khtml-user-select":"none","-moz-user-select":"none","-ms-user-select":"none","user-select":"none"})};a.prototype.handleConstraint=function(t,e){var i=this.$el.position();this.pos.x=i.left;this.pos.y=i.top;this.log({type:"pos-coords",x:this.pos.x,y:this.pos.y});var s=this.$container.width()-this.$el.outerWidth();var o=this.$container.height()-this.$el.outerHeight();var n={x:false,y:false};if(this.pos.x+t>s)n.x=s;if(this.pos.x+t<0)n.x=0;if(this.pos.y+e>o)n.y=o;if(this.pos.y+e<0)n.y=0;return n};a.prototype.getCSSEaseHash=function(t){if(typeof t==="undefined")t=false;var e;if(t){e=""}else if(this.CSSEaseHash){return this.CSSEaseHash}else{e=["all",this.options.cssEaseDuration+"ms",this.options.cssEaseString].join(" ")}return{"-webkit-transition":e,"-moz-transition":e,"-ms-transition":e,"-o-transition":e,transition:e}};a.prototype.calculateActiveDropRegions=function(){var e=this;this.activeDropRegions=[];t.each(t(this.options.droppable),function(i,s){var o=t(s);if(e.isOverlapping(o,e.$el)){o.addClass(e.options.droppableActiveClass);e.activeDropRegions.push(o)}else{o.removeClass(e.options.droppableActiveClass)}})};a.prototype.isOverlapping=function(t,e){if(this.options.overlapFunction){return this.options.overlapFunction(t,e)}var i=t[0].getBoundingClientRect();var s=e[0].getBoundingClientRect();return!(i.right<s.left||i.left>s.right||i.bottom<s.top||i.top>s.bottom)};a.prototype.isTouch=function(t){if(typeof Modernizr!=="undefined")return Modernizr.touch;if("ontouchstart"in e||e.DocumentTouch&&o instanceof DocumentTouch){return true}else{return false}};a.prototype.isValidMoveEvent=function(t){if(!this.isTouch()||this.isTouch()&&t.originalEvent.hasOwnProperty("touches")&&t.originalEvent.touches.length===1){return true}else{return false}};a.prototype.shouldUseCSSTranslation=function(){if(typeof this.useCSSTranslation!=="undefined")return this.useCSSTranslation;var t=false;if(!this.options.useCSSTranslation||typeof Modernizr!=="undefined"&&!Modernizr.csstransforms){t=false}else{t=true}this.useCSSTranslation=t;return t};a.prototype.cssAnimationsSupported=function(){if(typeof this.cssAnimationsSupport!=="undefined"){return this.cssAnimationsSupport}if(typeof Modernizr!=="undefined"&&Modernizr.cssanimations){this.cssAnimationsSupport=true;return true}var t=false,e=o.createElement("div"),s="animation",n="",a="Webkit Moz O ms Khtml".split(" "),r="";if(e.style.animationName){t=true}if(t===false){for(var p=0;p<a.length;p++){if(e.style[a[p]+"AnimationName"]!==i){r=a[p];s=r+"Animation";n="-"+r.toLowerCase()+"-";t=true;break}}}this.cssAnimationsSupport=t;return t};a.prototype.hardwareAccelerate=function(){this.$el.css({"-webkit-transform":"translateZ(0)",transform:"translateZ(0)","-webkit-perspective":1e3,perspective:1e3,"-webkit-backface-visibility":"hidden","backface-visibility":"hidden"})};a.prototype.getMovementValues=function(){return{ev:this.ev,pos:this.pos,velocity:this.velocity()}};a.prototype.buildDebugDiv=function(){var e;if(t("#pep-debug").length===0){e=t("<div></div>");e.attr("id","pep-debug").append("<div style='font-weight:bold; background: red; color: white;'>DEBUG MODE</div>").append("<div id='pep-debug-event'>no event</div>").append("<div id='pep-debug-ev-coords'>event coords: <span class='pep-x'>-</span>, <span class='pep-y'>-</span></div>").append("<div id='pep-debug-pos-coords'>position coords: <span class='pep-x'>-</span>, <span class='pep-y'>-</span></div>").append("<div id='pep-debug-velocity'>velocity: <span class='pep-x'>-</span>, <span class='pep-y'>-</span></div>").append("<div id='pep-debug-delta'>&Delta; movement: <span class='pep-x'>-</span>, <span class='pep-y'>-</span></div>").css({position:"fixed",bottom:5,right:5,zIndex:99999,textAlign:"right",fontFamily:"Arial, sans",fontSize:10,border:"1px solid #DDD",padding:"3px",background:"white",color:"#333"})}var i=this;setTimeout(function(){i.debugElements={$event:t("#pep-debug-event"),$velocityX:t("#pep-debug-velocity .pep-x"),$velocityY:t("#pep-debug-velocity .pep-y"),$dX:t("#pep-debug-delta .pep-x"),$dY:t("#pep-debug-delta .pep-y"),$evCoordsX:t("#pep-debug-ev-coords .pep-x"),$evCoordsY:t("#pep-debug-ev-coords .pep-y"),$posCoordsX:t("#pep-debug-pos-coords .pep-x"),$posCoordsY:t("#pep-debug-pos-coords .pep-y")}},0);t("body").append(e)};a.prototype.log=function(t){if(!this.options.debug)return;switch(t.type){case"event":this.debugElements.$event.text(t.event);break;case"pos-coords":this.debugElements.$posCoordsX.text(t.x);this.debugElements.$posCoordsY.text(t.y);break;case"event-coords":this.debugElements.$evCoordsX.text(t.x);this.debugElements.$evCoordsY.text(t.y);break;case"delta":this.debugElements.$dX.text(t.x);this.debugElements.$dY.text(t.y);break;case"velocity":var e=this.velocity();this.debugElements.$velocityX.text(Math.round(e.x));this.debugElements.$velocityY.text(Math.round(e.y));break}};a.prototype.toggle=function(t){if(typeof t==="undefined"){this.disabled=!this.disabled}else{this.disabled=!t}};t.fn[s]=function(e){return this.each(function(){if(!t.data(this,"plugin_"+s)){var i=new a(this,e);t.data(this,"plugin_"+s,i);t.pep.peps.push(i)}})};t.pep={};t.pep.peps=[];t.pep.toggleAll=function(e){t.each(this.peps,function(t,i){i.toggle(e)})}})(jQuery,window);