<!DOCTYPE html>
<?php
	// Inclure les scripts d'authentification CAS
	include_once('authCAS.php');
?>
<html ng-app="etherhome">
	<head>
		<!-- Déclarations diverses -->
		<title>Etherhome</title>
		<meta charset="utf-8" />
		<meta name="description" content="Etherhome">
		<meta name="keywords" content="Etherpad, ethercalc, scrumblr, envole, eole">

		<!-- Feuille de style de notre application -->
		<link rel='stylesheet' href='assets/css/style-orig.css' />
		<!-- Feuille de stylle provenant de http://getbootstrap.com/ permet de reduire le temps de travail sur le CSS adapté aux mobiles -->
		<link rel='stylesheet' href='assets/libs/bootstrap/css/bootstrap-orig.min.css' />

		<!-- Chargement d'angularJS et ses modules -->
		<script type="text/javascript" src="assets/libs/angularJS/angular.min.js"></script>
		<script type="text/javascript" src="assets/libs/angularJS/angular-route.min.js"></script>

		<!-- Chargement de scripts pour la gestion de l'affichage dynamique via zepto.js -->
		<script type="text/javascript" src="assets/libs/zepto.min.js"></script>
		<script type="text/javascript" src="assets/js/presentation.js"></script>

		<!-- Chargement de l'application -->
		<script type="text/javascript" src="etherhome.module.js"></script>
		<script type="text/javascript" src="etherhome.routes.js"></script>
		<script type="text/javascript" src="etherhome.controller.js"></script>

		<!-- Chargement des services, factories et directives communs à tout les modules -->
		<script type="text/javascript" src="communs/survConnex/survConnex.factory.js"></script>
		<script type="text/javascript" src="communs/profileUser/profileUser.factory.js"></script>
		<script type="text/javascript" src="communs/confServeur/confServeur.factory.js"></script>
		<script type="text/javascript" src="communs/menu/menu.directive.js"></script>

		<!-- Chargement du module etherpad -->
		<script type="text/javascript" src="modules/etherpad/etherpad.module.js"></script>
		<script type="text/javascript" src="modules/etherpad/etherpad.routes.js"></script>
		<script type="text/javascript" src="modules/etherpad/etherpad.controller.js"></script>
		<script type="text/javascript" src="modules/etherpad/etherpadAdmin.controller.js"></script>
		<script type="text/javascript" src="modules/etherpad/etherpad.factory.js"></script>

		<!-- Chargement du module ethercalc -->
		<script type="text/javascript" src="modules/ethercalc/ethercalc.module.js" ></script>
		<script type="text/javascript" src="modules/ethercalc/ethercalc.routes.js"></script>
		<script type="text/javascript" src="modules/ethercalc/ethercalc.controller.js"></script>
		<script type="text/javascript" src="modules/ethercalc/ethercalcAdmin.controller.js"></script>
		<script type="text/javascript" src="modules/ethercalc/ethercalc.factory.js"></script>

		<!-- Chargement du module scrumblr -->
		<script type="text/javascript" src="modules/scrumblr/scrumblr.module.js" ></script>
		<script type="text/javascript" src="modules/scrumblr/scrumblr.routes.js"></script>
		<script type="text/javascript" src="modules/scrumblr/scrumblr.controller.js"></script>
		<script type="text/javascript" src="modules/scrumblr/scrumblrAdmin.controller.js"></script>
		<script type="text/javascript" src="modules/scrumblr/scrumblr.factory.js"></script>

		<!-- Chargement du module de délégations -->
		<script type="text/javascript" src="modules/delegations/delegations.module.js" ></script>
		<script type="text/javascript" src="modules/delegations/delegations.routes.js"></script>
		<script type="text/javascript" src="modules/delegations/delegations.controller.js"></script>
		<script type="text/javascript" src="modules/delegations/delegations.factory.js"></script>

		<?php
		// Sonde piwik Envole
		if(file_exists('/var/www/html/sondepiwik/envoleTrackeur.js.php')) {
		    include "/var/www/html/sondepiwik/envoleProfil.php";     
		    echo "<script src='/sondepiwik/envoleTrackeur.js.php?appli=etherhome&profil=".$profil."'></script>";
		}
		elseif(file_exists('/var/www/html/piwik/envoleTrackeur.js.php')) {     
		    include "/var/www/html/piwik/envoleProfil.php";     
		    echo "<script src='/piwik/envoleTrackeur.js.php?appli=etherhome&amp;profil=".$profil."'></script>"; 
		}
		?>
	</head>

	<body>
		<!-- Container principal. Le controleur de surveillance porte sur toute l'application -->
		<div class="container" ng-controller="indexCtrl"> 
			<!-- Affichage du login de l'utilisateur connecté. Uniquement si l'auth est OK -->
			<div ng-hide="deco"> 
				<div>
					Bonjour {{profile.user}}
					<span ng-show="profile.admin && !profile.superadmin"> (admin)</span>
					<span ng-show="profile.superadmin"> (superadmin)</span>
					&nbsp;&nbsp;
					<a href="decoCAS.php">
						<img src="assets/img/deco-orig.png" alt="deconnexion" title="Se deconnecter" />
					</a>
				</div>
				<div class="alert alert-danger" role="alert" ng-show="deconnexion.erreur" ng-bind="deconnexion.erreur"></div>
			</div>

			<!-- Entete de l'appli -->
			<div class="entete">
				<h2>Etherhome</h2>
				<p>Gestion de la suite libre de travail collaboratif</p>
			</div>

			<!-- Logo de l'académie -->
			<div class="logo" ><img src="assets/img/logo.png" title="Logo Acad&eacute;mie" alt="Logo Acad&eacute;mie"></div>

			<!-- En cas de déconnexion par le serveur, on affiche le message d'alerte -->
			<div ng-show="deco" class="alert alert-danger" role="alert">
				Vous êtes déconnecté du serveur.... : Actualisez votre page dans le navigateur pour vous reconnecter
			</div>

			<div class="alert alert-warning" ng-show="!conf.charge || !profile.charge">
				<h1>Demarrage de l'application</h1>
				<div ng-show="!conf.charge && !conf.erreur" class="avert">Chargement configuration en cours ...</div>
				<div ng-show="!profile.charge && !profile.erreur" class="avert">Chargement profil utilsateur en cours ...</div>
			</div>

			<!-- Remontées d'erreurs provenant des modules de configuration et de profil -->
			<div class="alert alert-danger" role="alert" ng-show="profile.erreur" ng-bind="profile.erreur"></div>
			<div class="alert alert-danger" role="alert" ng-show="conf.erreur" ng-bind="conf.erreur"></div>

			<!-- En cas de déconnexion par le serveur ou de chargement non effectué de la configuration ou du profil, l'application est fermée : évite les saisies si l'auth est KO -->
			<div ng-if="!deco && conf.charge && profile.charge" ng-view></div>
		</div> <!-- class="container" -->
	</body>
</html>
