<?php
	//--> Vérifie l'authentification
	include_once('../../authCAS.php');

	//--> Configuration etherhome
	require_once('../../config.inc.php');

	//--> Calcul du profil de l'utilsateur
	include_once("../../profile.inc.php");

	//--> Tableau de sortie de la réponse
	$response = array();

	//--> On sort en JSON
	header('Content-type: application/json');

	//--> On vérifie les droits d'accès de l'utilisateur avant d'autoriser le script à s'exécuter
	$profil = getProfil($host, $userSQL, $passSQL, $database, $portSQL, $admin2);
	if (!$profil["superadmin"]) stopErreur("Vous n'avez pas les droits pour executer ce script");

	// On récupère les paramètres de la demande par l'application
	$params = json_decode(file_get_contents("php://input"));
	$uid = $params->uid;
	
	//--> Vérifications de format avant création
	if  (!preg_match('/^[A-Za-z0-9\-\.]+$/', $uid) ) stopErreur("l'uid transmis invalide (uniquement, chiffres , lettres sans accents et . ou -");

	//--> Ouverture d'une connexion sur la DB etherhome
	$mysqli = new mysqli($host, $userSQL, $passSQL, $database, $portSQL);
	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL : (" . $mysqli->connect_errno . ") -> " . $mysqli->connect_error);

	//--> Vérifie l'existance
	$result = $mysqli->query ("SELECT * FROM delegations WHERE uid='" . addslashes($uid) . "'");
	if ($result == false) stopErreur("Erreur requête SQL query : (" . $mysqli->errno .") -> " . $mysqli->error);
	// Il doit exister dans la base etherhome
	if ($result->num_rows!=0)
	{ 
		// Préparation de la commande d'insertion
		$query = "DELETE FROM delegations WHERE uid=?";
		$stmt = $mysqli->prepare($query);
		// Chargement des données
		$stmt->bind_param("s", $v1);
		$v1 = $uid;
		// Exécute la requête
		if (!$stmt->execute())  stopErreur("Erreur requête SQL execute : (" . $mysqli->errno .") -> " . $mysqli->error);
		// On retourne l'id de pad si la création dans la base etherhome s'est bien passée
		$row['state'] = "success";
		$row['text'] = "Le délégation pour '$uid' a été supprimée";
	}
	// Si il n'existait pas
	else
	{ 
		$row['state'] = "warning";
		$row['text'] = "La délégation pour '$uid' n'existe pas.";
	}

	//--> Fermeture de la connexion
	$result->close();
	$mysqli->close();

	//--> Retourne le résultat
	echo json_encode($row, true);

	//--> Fonction de retour d'erreur
	function stopErreur($message)
	{	
		// Les erreurs SQL seront remontées à l'application via cette réponse JSON : voir au début de la vue : <div class="alert alert-{{msg.state}}" ng-show="msg.text" role="alert">{{msg.text}}</div>'
		$row['state'] = "danger";
		$row['text'] = $message;
		echo json_encode($row, true);
		// On sort ici
		exit;
	}

?>
