//--> Contrôleur de gestion des calcs : relatif à la page ....... (voir routage)
angular.module('delegations').controller("delegationsCtrl",function($scope, methodesDelegations) {
	// Remarque : le controleur est relu à chaque nouvelle arrivée sur le module

	//--> Liste des délégations
	$scope.getListDeleg = function() {
		// La lecture de la liste étant asynchrone (ajax), il faut spécifier une fonction de retour (callback)
		methodesDelegations.listeDeleg(function(data) { 
			$scope.listeDeleg = data;
		});
	};

	//--> Vérifier si l'uid est conforme
	$scope.testUid = function() {
		// Ne doit contenir que des chiffres et lettres, . ou -
		var regexp = /^[A-Za-z0-9\-\.]+$/;
		return !regexp.test($scope.ajout.uid);
	};

	//--> Ajout d'une délégation
	$scope.ajoutDeleg = function() {
		methodesDelegations.ajoutDeleg($scope.ajout.uid, function(data) { 
			// Init des affichages d'ajout et suppression
			$scope.ajDeleg = {"state": "", "text": ""};
			$scope.delDeleg = {"state": "", "text": ""};
			// Récupération réponse
			$scope.ajDeleg = data;
			// Init du formulaire de création
			$scope.ajout = {"uid": ""};
			// Relecture
			$scope.getListDeleg();
		});
	};

	//--> Suppression d'une délégation
	$scope.supprDeleg = function(uid) {
		// Suppression sur confirmation
		var r = confirm("Êtes vous sûr de vouloir supprimer cette délégation ?");
		if (r) {
			methodesDelegations.suppressionDeleg(uid, function(data) { 
				// Init des affichages d'ajout et suppression
				$scope.ajDeleg = {"state": "", "text": ""};
				$scope.delDeleg = {"state": "", "text": ""};
				// Récupération réponse
				$scope.delDeleg = data;
				// Relecture
				$scope.getListDeleg();

			});
		}
	};

	//--> Chargement au démarrage du contôleur :
	// Uniquement chargé si on est superadmin
	if ($scope.profile.superadmin) {
		// Init des affichages d'ajout et suppression
		$scope.ajDeleg = {"state": "", "text": ""};
		$scope.delDeleg = {"state": "", "text": ""};
		// Init du formulaire de création
		$scope.ajout = {"uid": ""};
		// Lecture au démarrage
		$scope.getListDeleg();
	}
});
