//--> Contrôleur de gestion des calcs : relatif à la page ....... (voir routage)
angular.module('ethercalc').controller("ethercalcAdminCtrl",function($scope, methodesEthercalc) {
	// Remarque : le controleur est relu à chaque nouvelle arrivée sur le module

	//--> Getter de la liste des calcs pour '<tr ng-repeat="calc in listeAllCalcs">'
	$scope.getListAllCalcs = function() {
		// Envoi de la requête de la liste de tout les calcs
		methodesEthercalc.listCalcsDansEthercalc(function(data) {
			$scope.listAllCalcs = data;
		});
	};

	//--> Fonction de vérification de saisie du nom d'utilisateur
	$scope.testUid = function(uid) {
		// si indefinie, on bloque ici
		if (angular.isUndefined(uid)) return true;
		// Ne doit contenir que des chiffres et lettres
		var regexp = /^[A-Za-z0-9\-\.]+$/;
		return !regexp.test(uid);
	};

	//--> Fonction appelée par le bouton supprimer un calcs : '<button class="btn btn-danger btn-xs" ng-click="deleteCalc(calc.nom);">Supprimer</button>'
	$scope.deleteCalc = function(calcID) {
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.adminCalc = {};
		// Suppression sur confirmation
		var r = confirm("Êtes vous sûr de vouloir supprimer ce calc ?");
		if (r) {
			// Envoi de la requête de supression dans l'API ethercalc qui va réaliser la suppression réelle du calcs
			methodesEthercalc.deleteCalcDansEthercalc($scope.conf.ethercalcAPI, calcID, function(data, status) {
				if (status == 201) {
					// Si c'est ok, alors demander d'effacer dans la base de données interne d'etherhome
					methodesEthercalc.deleteCalc(calcID, function(data) {
						$scope.adminCalc = data;
						// Charger la liste de tout les calcs dans ethercalc
						$scope.getListAllCalcs();
					});
				}
				// Si la suppression par l'API Ethercalc échoue, on va retourner le message
				else {
					// Cas d'un message d'erreur interne retourné par l'API ethercalc
					if (angular.isUndefined(data.state)) $scope.adminCalc = {"state": "danger", "text" : "Erreur suppression du calc par ethercalc (status=" + status + " ; data=" + data + ")"};
					// Cas de l'erreur AJAX pure, traitement du .error(....) on a directement un message formaté
					else $scope.adminCalc = data;
				}
			});
		}
	};

	//--> Méthode appelée pour changer l'utilisateur d'un calc
	$scope.userCalc = function (calcID, proprietaire) {
		// Envoi de la requête de la liste de tout les calcs
		methodesEthercalc.modifieUtilCalc(calcID, proprietaire, function(data) {
			$scope.adminCalc = data;
		});
	};

	//--> Chargement au démarrage du contôleur :
	// uniquement chargé si le module est activé et mode admin
	if ($scope.conf.ethercalcActif && $scope.profile.admin) {
		// Lister l'intégralité des calcs dans le ficiher JSON d'ethercalc
		$scope.getListAllCalcs();
	}
});
