<?php
	// Vérifie l'authentification
	include_once('../../authCAS.php');

	// Configuration etherhome
	require_once('../../config.inc.php');

	// Tableau de sortie de la réponse
	$response = array();

	// On sort en JSON
	header('Content-type: application/json');

	// On récupère l'uid du propriétaire et on vérifie sa validité
	$uid = $_SESSION['login'];

	// On récupère les paramètres de la demande par l'application
	$params = json_decode(file_get_contents("php://input"));
	$id = $params->id;
	
	// Vérification format de l'uid et de l'identifiant de pad
	if  (! (preg_match('/^[A-Za-z0-9\-\.]+$/', $uid) && preg_match("/^[0-9]+$/", $id)) ) stopErreur("Erreur de formatage de l'uid ou de l'id de pad");

	// Ouverture d'une connexion sur la DB etherhome
	$mysqli = new mysqli($host, $userSQL, $passSQL, $database, $portSQL);
	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL : (" . $mysqli->connect_errno . ") -> " . $mysqli->connect_error);

	// Vérifie si l'entrée existe bien
	// Requête à la base de données
	$result = $mysqli->query ("SELECT * FROM favoris WHERE id='$id' AND uid='" . addslashes($uid) . "' AND appli='etherpad'");
	if ($result == false)  stopErreur("Erreur requête SQL select : (" . $mysqli->errno .") -> " . $mysqli->error);

	// Si trouvé
	if ($result->num_rows!=0)
	{
		// Préparation de la commande de suppression
		$query = "DELETE FROM favoris WHERE id=? AND uid=? AND appli='etherpad'";
		$stmt = $mysqli->prepare($query);
		// Chargement des données
		$stmt->bind_param("ss", $v1, $v2);
		$v1 = $id;
		$v2 = $uid;
		// Exécute la requête
		if (!$stmt->execute()) stopErreur("Erreur requête SQL select : (" . $mysqli->errno .") -> " . $mysqli->error);
		// Fermeture de la requête
		$stmt->close();

		// Réponse à afficher dans l'application
		$response['state'] = "success";
		$response['text'] = "Favoris supprimé avec succès";
	} 
	else 
	{
		$response['state'] = "warning";
		$response['text'] = "Impossible de supprimer, le favoris n'existe pas";
	}

	// Fermeture du statement
	$result->close();

	// Fermer connexion SQL
	$mysqli->close();

	// On renvoie la réponse au format JSON
	echo json_encode($response, true);

	// Fonction de retour d'erreur
	function stopErreur($message)
	{	
		// Les erreurs SQL seront remontées à l'application via cette réponse JSON : voir au début de la vue : <div class="alert alert-{{ajDelFavPad.state}}" ng-show="ajDelFavPad.text" role="alert">{{ajDelFavPad.text}}</div>'
		$row['state'] = "danger";
		$row['text'] = $message;
		echo json_encode($row, true);
		// On sort ici
		exit;
	}
?>
