//--> Contrôleur de gestion des pads : relatif à la page .......(voir routage)
angular.module('etherpad').controller("etherpadAdminCtrl",function($scope, methodesEtherpad) {
	// Remarque : le controleur est relu à chaque nouvelle arrivée sur le module

	//--> Getter de la liste des pads pour '<tr ng-repeat="pad in listeAllPads">'
	$scope.getListAllPads = function() {
		// Envoi de la requête de la liste de tout les pads
		methodesEtherpad.listPadsDansEtherpad(function(data) {
			$scope.listAllPads = data;
		});
	};

	//--> Getter de la liste des vieux pads pour '<tr ng-repeat="pad in listeAllPads">'
	$scope.getListOldsPads = function(dateStart, dateEnd) {
		$scope.adminPad = {};
		$scope.dateStart = dateStart;
		$scope.dateEnd = dateEnd;
		if(dateEnd < dateStart){
			$scope.adminPad = {"state": "danger", "text" : 'La date de fin doit supérieure à la date de début'};
			return;
		}

		$scope.dataLoading = true;

		// Envoi de la requête de la liste de tout les pads
		methodesEtherpad.listOldsPadsDansEtherpad(Date.parse(dateStart), Date.parse(dateEnd), function(data) {
			$scope.listAllPads = data;
			$scope.listOldsPads = data;
			$scope.deleOldsPads = true;
			$scope.dataLoading = false;
		});
	};

	//--> Fonction de vérification de saisie du nom d'utilisateur
	$scope.testUid = function(uid) {
		// si indefinie, on bloque ici
		if (angular.isUndefined(uid)) return true;
		// Ne doit contenir que des chiffres et lettres
		var regexp = /^[A-Za-z0-9\-\.]+$/;
		return !regexp.test(uid);
	};

	// Anomalie #22674
	// Admin-Pads la ligne du pad supprimé reste affiché
	$scope.removeRow = function(idx, data){
		var index = -1;		
		var tabs = data;
		for(var i = 0; i < tabs.length; i++) {
			if(tabs[i].key === idx) {
				index = i;
				break;
			}
		}

		data.splice(index, 1);		
	};

	//--> Fonction appelée par le bouton supprimer un pads : '<button class="btn btn-danger btn-xs" ng-click="deletePad(pad.key);">Supprimer</button>'
	$scope.deletePad = function(padID) {

		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.adminPad = {};
		// Suppression sur confirmation
		var r = confirm("Êtes vous sûr de vouloir supprimer ce pad ?");
		if (r) {
			// Charger la liste de tout les pads dans etherpad
			$scope.getListAllPads();

			// Envoi de la requête de supression dans l'API etherpad qui va réaliser la suppression réelle du pads
			methodesEtherpad.deletePadDansEtherpad($scope.conf.etherpadAPI, $scope.conf.apikey, padID, function(data) {
				if (data.message == "ok") {
					// Si c'est ok, alors demander d'effacer dans la base de données interne d'etherhome
					methodesEtherpad.deletePad(padID, function(data) {
						$scope.adminPad = data;

						// supprimer la ligne du pad supprimé
						$scope.removeRow(padID, $scope.listAllPads);
					});
				}
				// Si la suppression par l'API Etherpad échoue, on va retourner le message
				else {
					// Cas d'un message d'erreur interne retourné par l'API etherpad
					if (angular.isUndefined(data.state)) $scope.adminPad = {"state": "danger", "text" : "Erreur suppression du pad par etherpad (code=" + data.code + " ; message=" + data.message +" ; data=" + data.data + ")"};
					// Cas de l'erreur AJAX pure, traitement du .error(....) on a directement un message formaté
					else $scope.adminPad = data;
				}
			});
		}
	};

	// cocher / décocher tout
	$scope.checkAll = function () {
        if ($scope.selectAll) {
            $scope.selectAll = true;
        } else {
            $scope.selectAll = false;
        }
        
        angular.forEach($scope.listOldsPads, function (pad) {
            pad.selected = $scope.selectAll;
        });
    };

    // décocher la case tout cocher si on décoche un élémen
    $scope.clearSelectAll = function(pad){
    	if(pad == false){
    		angular.element(document.querySelector('#checkAll')).prop('checked',false);
    	}
    }

	// supprimer les vieux pads
	$scope.deleteOldsPads = function() {
		$scope.pads = [];	// va contenir les pads à supprimer

		angular.forEach($scope.listOldsPads, function(pad){
			if (pad.selected){
				$scope.pads.push(pad.key);
				pad.selected = $scope.selectAll;
			}
		});

		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.adminPad = {};

		if($scope.pads.length == 0){
			$scope.adminPad = {"state": "danger", "text" : 'Veuillez cocher un enregistrement à supprimer'};
			return;
		}

		// Suppression sur confirmation
		var r = confirm("Êtes vous sûr de vouloir supprimer ces pads ?");
		if (r) {
			// Si c'est ok, alors demander d'effacer dans la base de données interne d'etherhome
			methodesEtherpad.deleteOldsPads($scope.pads, function(data) {
				$scope.adminPad = data;
				$scope.getListOldsPads($scope.dateStart, $scope.dateEnd);
			});
		}
	};

	// on rafraichir les pads après la suppression des vieux pads
	// si case "Suppression des vieux pads" décochée
	$scope.refreshPads = function(isChecked){
		if(isChecked == false){
			$scope.getListAllPads();
			$scope.deleOldsPads = false;
		}
	}

	//--> Méthode appelée pour changer l'utilisateur d'un pad
	$scope.userPad = function (padID, proprietaire) {
		// Envoi de la requête de la liste de tout les pads
		methodesEtherpad.modifieUtilPad(padID, proprietaire, function(data) {
			$scope.adminPad = data;
		});
	};

	//--> Chargement au démarrage du contôleur :
	// uniquement chargé si mode admin
	if ($scope.profile.admin) {
		// Lister l'intégralité des pads dans la DB etherpad
		$scope.getListAllPads();
		// ......
		//......
	}

});
