<?php

	// Vérifie l'authentification
	include_once('../../authCAS.php');

	// Configuration etherhome
	require_once('../../config.inc.php');

	// Configuration accès db etherpad
	if(!file_exists('../../confSqlEtherpad.inc.php') ) stopErreur("Erreur de lecture confSqlEtherpad.inc.php : non trouvé");
	include_once('../../confSqlEtherpad.inc.php'); 
	if( !isset($hostSQLEtherpad) || !isset($databaseSQLEtherpad) || !isset($userSQLEtherpad) || !isset($passSQLEtherpad) || !isset($portSQLEtherpad) ) stopErreur("Erreur de lecture confSqlEtherpad.inc.php : incomplet");

	// On sort en JSON
	header('Content-type: application/json');

	$params = json_decode(file_get_contents("php://input"));

	// Tableau de sortie
	$myArray = array();
	$oldsPads = array();

	// Ouverture d'une connexion sur la DB etherpad
	try {
		$mysqliPad = new pdo('mysql:dbname='.$databaseSQLEtherpad.';host='.$hostSQLEtherpad, $userSQLEtherpad, $passSQLEtherpad);
		$mysqliPad->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	} catch (PDOException $e) {
		stopErreur('Erreur de connexion SQL etherpad');
	}

	// Requête à la base de données
	try {
		$result = $mysqliPad->prepare("SELECT `key`, value FROM `store` LIMIT 100");
		$result->execute();
	} catch (Exception $e) {
		stopErreur('Erreur requête SQL pads');
	}

	$myArray = $result->fetchAll();

	// Fermeture du statement
	$result->closeCursor();

	foreach ($myArray as $key => $value) {
		$timestamp = json_decode($value['value'], true)['timestamp'];
		// Récupérer la date de dernière modification
		if($timestamp >= $params->dateStart && $timestamp <= $params->dateEnd)
			array_push($oldsPads, array('lastEdited'=> json_decode($value['value'], true)['timestamp'], 'key'=> $value['key']));
	}

	// Retourne la liste en format JSON
	echo json_encode($oldsPads,true);

	// Arrêt en cas d'erreur
	function stopErreur($message)
	{
		// Les erreurs seront remontées à l'application via cette réponse JSON : voir au début de la vue : '<div class="erreur" ng-show="listPads.erreur!=''">{{listPads.erreur}}</div>'
		$row['erreur'] = $message;
		echo json_encode($row, true);
		// On sort ici
		exit;
	}

?>
