<?php
	// Vérifie l'authentification
	include_once('../../authCAS.php');

	// Configuration etherhome
	require_once('../../config.inc.php');

	// Tableau de sortie
	$myArray = array();

	// On sort en JSON
	header('Content-type: application/json');

	// On récupère l'uid du propriétaire et on vérifie sa validité
	$uid = $_SESSION['login'];
	if  (!preg_match('/^[A-Za-z0-9\-\.]+$/',$uid)) stopErreur("Erreur de formatage de l'uid");

	// Ouverture d'une connexion sur la DB etherhome
	$mysqli = new mysqli($host, $userSQL, $passSQL, $database, $portSQL);
	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL : (" . $mysqli->connect_errno . ") -> " . $mysqli->connect_error);

	// Requête à la base de données
	$result = $mysqli->query ("SELECT nom FROM elements WHERE uid='" . addslashes($uid) . "' AND appli='etherpad'");
	if ($result == false)  stopErreur("Erreur requête SQL : (" . $mysqli->errno .") -> " . $mysqli->error);

	// Charger le tableau en encodant en UTF8 chaque champs sinon la fonction json_encode part en vrille :-)
	while ($ligne = $result->fetch_array(MYSQLI_ASSOC))
	{
		foreach(array_keys($ligne) as $key) $ligne[$key] = utf8_encode($ligne[$key]);
		$ligne['lien'] = "https://$etherpadAPI/p/" . $ligne["nom"];
		array_push($myArray, $ligne);
	}

	// Fermeture du statement
	$result->close();

	// Fermer connexion SQL
	$mysqli->close();

	// Retourne la liste en format JSON
	echo json_encode($myArray, true);

	// Fonction de retour d'erreur
	function stopErreur($message)
	{
		// Les erreurs seront remontées à l'application via cette réponse JSON : voir au début de la vue : '<div class="erreur" ng-show="listPads.erreur">{{listPads.erreur}}</div>'
		$row['erreur'] = $message;
		echo json_encode($row, true);
		// On sort ici
		exit;
	}
?>
