<?php
	require_once('../../authCAS.php');
	require_once('../../config.inc.php');
	require_once 'functions.php';

	$response = array();

	header('Content-type: application/json');

	// On récupère les paramètres de la demande par l'application
	$params = json_decode(file_get_contents("php://input"));
	$id = $params->share->id;
	$appli = $params->share->appli;
	$shareType = $params->share->shareType;
	$shareWith = $params->share->shareWith;
	$uid = $params->share->uid;
	$url = (!empty($params->share->url)) ? $params->share->url : $params->share->lien;

	// Vérification format de l'uid et de l'identifiant de pad
	if(! preg_match("/^[0-9]+$/", $id) ) stopErreur("Erreur de formatage de l'id du partage");

	// Ouverture d'une connexion sur la DB etherhome
	$mysqli = new mysqli($host, $userSQL, $passSQL, $database, $portSQL);
	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL : (" . $mysqli->connect_errno . ") -> " . $mysqli->connect_error);

	// l'utilisateur annule le partage de son pad
	if(!empty($params->cancelShare) && isset($params->cancelShare)){
		$query = "DELETE FROM shares WHERE uid=? AND appli=? AND url=?";
		$stmt = $mysqli->prepare($query);
		$stmt->bind_param("sss", $_SESSION['login'], $appli, $url);
		if (!$stmt->execute()) stopErreur("Erreur requête SQL select : (" . $mysqli->errno .") -> " . $mysqli->error);
		$stmt->close();

		echo json_encode(array('state' => 'success', 'text' => 'Partage annulé avec succès'), true);
		return;
	}

	// Vérifie si l'entrée existe bien
	$result = $mysqli->query ("SELECT * FROM shares WHERE id='$id'");
	if ($result->num_rows != 0){
		while ($ligne = $result->fetch_array(MYSQLI_ASSOC)){
			if($ligne['shareType'] === '1'){	// si shareWith est un groupe
				$shareWith = getShareWith($uid, $ligne['shareWith']);
				$query = "INSERT INTO shares (uid, shareWith, shareType, url, appli) VALUES(?, ?, '2', ?, ?);";
				$stmt = $mysqli->prepare($query);
				$stmt->bind_param("ssss", $v1, $v2, $v3, $v4);
				$v1 = $uid;
				$v2 = $_SESSION['login'];
				$v3 = $url;
				$v4 = $appli;
				if (!$stmt->execute()) stopErreur("Erreur requête SQL select : (" . $mysqli->errno .") -> " . $mysqli->error);
				$stmt->close();
			}
			else{
				$query = "DELETE FROM shares WHERE id=?";
				$stmt = $mysqli->prepare($query);
				$stmt->bind_param("s", $id);
				if (!$stmt->execute()) stopErreur("Erreur requête SQL select : (" . $mysqli->errno .") -> " . $mysqli->error);
				$stmt->close();
				$response['state'] = 'success';
				$response['text'] = 'Partage supprimé avec succès';
			}
		}
	}
	else{
		$response['state'] = 'warning';
		$response['text'] = 'Impossible de supprimer, le partage n\'existe pas';
	}

	$result->close();
	$mysqli->close();

	echo json_encode($response, true);

	// Fonction de retour d'erreur
	function stopErreur($message)
	{	
		// Les erreurs SQL seront remontées à l'application via cette réponse JSON : voir au début de la vue : <div class="alert alert-{{ajDelFavPad.state}}" ng-show="ajDelFavPad.text" role="alert">{{ajDelFavPad.text}}</div>'
		$row['state'] = "danger";
		$row['text'] = $message;
		echo json_encode($row, true);
		// On sort ici
		exit;
	}
