<?php
// pour savoir si l'utilisateur fait partir d'un groupe
// renvoi le groupe sinon false
function getShareWith($uid, $group){
	$conn = ldap_connect('localhost');
	if(!$conn){
		die('Erreur de connection à l\'annuaire');
	}

	$bind = ldap_bind($conn);
	if(!$bind){
		die('Erreur d\'authentification');
	}

	$filter = '(&(objectClass=ENTGroupe)(cn='.$group.'))';

	$shareWith='';

	if($conn){
		$ldapsearch = ldap_search($conn, 'o=gouv,c=fr', $filter, array('memberUid'));
		if(!$ldapsearch){
			die('Erreur lors de la recherche');
		}

		$data = ldap_get_entries($conn,$ldapsearch);
		if(empty($data['count']) && $data['count']<=0){
			die('Pas d\'utilisateur ou de groupe trouvé');
		}

		for ($i=0; $i < $data['count']; $i++) {
			if(in_array($uid, $data[$i]['memberuid'])){
				$shareWith = $group;
			}
		}
	}

	return $shareWith;
}

// renvoi true si l'utilisateur faisant partir d'un groupe et a supprimé un partage de doc du groupe
/*
	utilisateur prof1 fait partir du groupe profs-6e
	prof1 à partager un doc avec le groupe profs-6e dont fait partir prof2 et prof3
	prof2 voit le partage
	prof3 voit le partage et à un moment décide de supprimer le partage

	etherpad 	https://clg-etab26.ac-besancon.fr/etherpad/p/dsd 	prof 	professeurs 	1
	etherpad 	https://clg-etab26.ac-besancon.fr/etherpad/p/dsd 	prof 	prof3 			2

	prof2 doit continuer de voir le partage mais pas prof3
*/
function getUsersUnshare($shareWith, $url, $mysqli){
	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL : (" . $mysqli->connect_errno . ") -> " . $mysqli->connect_error);

	$result = $mysqli->query ("SELECT shareWith FROM shares WHERE shareType='2' AND shareWith='$shareWith' AND url='$url'");
	if ($result == false)  stopErreur("Erreur requête SQL : (" . $mysqli->errno .") -> " . $mysqli->error);

	// Charger le tableau en encodant en UTF8 chaque champs sinon la fonction json_encode part en vrille :-)
	if($result->num_rows != 0){
		return true;
	}

	return false;
}