<?php
	// Vérifie l'authentification
	include_once('../../authCAS.php');

	// Configuration etherhome
	require_once('../../config.inc.php');

	// Tableau de sortie de la réponse
	$response = array();

	// On sort en JSON
	header('Content-type: application/json');

	// On vérifie les droits d'accès de l'utilisateur avant d'autoriser le script à s'exécuter
	if (!$ethercalcActif) stopErreur("Vous n'avez pas les droits pour executer ce script");

	// On récupère l'uid du propriétaire et on vérifie sa validité
	$uid = $_SESSION['login'];

	// On récupère les paramètres de la demande par l'application
	$params = json_decode(file_get_contents("php://input"));
	$favoriUrl = $params->favoriUrl;
	
	// Vérification format de l'uid et de l'identifiant de calc
	if  (! (preg_match('/^[A-Za-z0-9\-\.]+$/', $uid) && preg_match("/^https:\/\/$servAdress\/ethercalc\/[A-Za-z0-9\-\_]+$/", $favoriUrl)) ) stopErreur("Erreur de formatage de l'uid ou de l'adresse");

	// Ouverture d'une connexion sur la DB etherhome
	$mysqli = new mysqli($host, $userSQL, $passSQL, $database, $portSQL);
	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL : (" . $mysqli->connect_errno . ") -> " . $mysqli->connect_error);

	// Vérifie si l'entrée existe bien
	// Requête à la base de données
	$result = $mysqli->query ("SELECT * FROM favoris WHERE uid='" . addslashes($uid) . "' AND url='" . addslashes($favoriUrl) . "' AND appli='ethercalc'");
	if ($result == false)  stopErreur("Erreur requête SQL select : (" . $mysqli->errno .") -> " . $mysqli->error);

	// Si trouvé
	if ($result->num_rows==0)
	{
		// Préparation de la commande d'insertion
		$query = "INSERT INTO favoris (uid, url, appli) VALUES(?, ?, 'ethercalc');";
		$stmt = $mysqli->prepare($query);
		// Chargement des données
		$stmt->bind_param("ss", $v1, $v2);
		$v1 = $uid;
		$v2 = $favoriUrl;
		// Exécute la requête
		if (!$stmt->execute()) stopErreur("Erreur requête SQL select : (" . $mysqli->errno .") -> " . $mysqli->error);
		// Fermeture de la requête
		$stmt->close();

		// Réponse à afficher dans l'application
		$response['state'] = "success";
		$response['text'] = "Favoris ajouté avec succès";
	} 
	else 
	{
		$response['state'] = "warning";
		$response['text'] = "Insertion favoris impossible, l'adresse '" . $favoriUrl . "' éxiste déjà";
	}

	// Fermeture du statement
	$result->close();

	// Fermer connexion SQL
	$mysqli->close();

	// On renvoie la réponse au format JSON
	echo json_encode($response, true);

	// Fonction de retour d'erreur
	function stopErreur($message)
	{	
		// Les erreurs SQL seront remontées à l'application via cette réponse JSON : voir au début de la vue : <div class="alert alert-{{msg.state}}" ng-show="msg.text" role="alert">{{msg.text}}</div>'
		$row['state'] = "danger";
		$row['text'] = $message;
		echo json_encode($row, true);
		// On sort ici
		exit;
	}
?>
