<?php
	//--> Vérifie l'authentification
	include_once('../../authCAS.php');

	//--> Configuration etherhome
	require_once('../../config.inc.php');

	//--> Calcul du profil de l'utilsateur
	include_once("../../profile.inc.php");

	//--> Tableau de sortie de la réponse
	$response = array();

	//--> On sort en JSON
	header('Content-type: application/json');

	//--> On vérifie les droits d'accès de l'utilisateur avant d'autoriser le script à s'exécuter
	if (!$ethercalcActif) stopErreur("Vous n'avez pas les droits pour executer ce script");
	$profil = getProfil($host, $userSQL, $passSQL, $database, $portSQL, $admin2);
	if (!$profil["admin"]) stopErreur("Vous n'avez pas les droits pour executer ce script");

	// On récupère les paramètres de la demande par l'application
	$params = json_decode(file_get_contents("php://input"));
	$calcID = $params->calcID;
	$proprietaire = $params->proprietaire;
	
	//--> Vérifications de format avant modification
	//--> Vérifications de format avant modification
	if  (!preg_match('/^[A-Za-z0-9\-\.]+$/', $proprietaire)) stopErreur("identifiant propriétaire invalide");
	if  (!preg_match('/^[A-Za-z0-9\-\_]+$/', $calcID)) stopErreur("Identifiant de calc invalide");

	//--> Ouverture d'une connexion sur la DB etherhome
	$mysqli = new mysqli($host, $userSQL, $passSQL, $database, $portSQL);
	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL : (" . $mysqli->connect_errno . ") -> " . $mysqli->connect_error);

	//--> Vérifie l'existance
	$result = $mysqli->query ("SELECT nom FROM elements WHERE nom='" . addslashes($calcID) . "' AND appli='ethercalc'");
	if ($result == false) stopErreur("Erreur requête SQL query : (" . $mysqli->errno .") -> " . $mysqli->error);
	// Si il n'existe pas dans la base etherhome, on va créer une entrée
	if ($result->num_rows==0)
	{ 
		// Préparation de la commande d'insertion
		$query = "INSERT INTO elements (uid, nom, appli) VALUES(?, ?, 'ethercalc');";
		$stmt = $mysqli->prepare($query);
		// Chargement des données
		$stmt->bind_param("ss", $v1, $v2);
		$v1 = $proprietaire;
		$v2 = $calcID;
		// Exécute la requête
		if (!$stmt->execute()) stopErreur("Erreur requête SQL execute insert : (" . $mysqli->errno .") -> " . $mysqli->error);
	}
	// Sinon on va modifier le user existant
	else
	{ 
		// Préparation de la commande de mise à jour
		$query = "UPDATE elements set uid = ? WHERE nom=? AND appli='ethercalc';";
		$stmt = $mysqli->prepare($query);
		// Chargement des données
		$stmt->bind_param("ss", $v1, $v2);
		$v1 = $proprietaire;
		$v2 = $calcID;
		// Exécute la requête
		if (!$stmt->execute()) stopErreur("Erreur requête SQL execute update : (" . $mysqli->errno .") -> " . $mysqli->error);
	}
	// On retourne le resultat
	$row['state'] = "success";
	$row['text'] = "Le calc  '$calcID' a été attribué à l'utilisateur '$proprietaire'";

	// Fermeture de la connexion et de la requête
	$stmt->close();
	$mysqli->close();

	//--> Retourne le résultat
	echo json_encode($row, true);

	//--> Fonction de retour d'erreur
	function stopErreur($message)
	{	
		// Les erreurs SQL seront remontées à l'application via cette réponse JSON : voir au début de la vue : <div class="alert alert-{{msg.state}}" ng-show="msg.text" role="alert">{{msg.text}}</div>'
		$row['state'] = "danger";
		$row['text'] = $message;
		echo json_encode($row, true);
		// On sort ici
		exit;
	}

?>
