<?php
	// Vérifie l'authentification
	include_once('../../authCAS.php');

	// Configuration etherhome
	require_once('../../config.inc.php');

	//--> Calcul du profil de l'utilsateur
	include_once("../../profile.inc.php");

	// Tableau de sortie de la réponse
	$response = array();

	// Configuration accès db etherpad
	if(!file_exists('../../confSqlEtherpad.inc.php') ) stopErreur("Erreur de lecture confSqlEtherpad.inc.php : non trouvé");
	include_once('../../confSqlEtherpad.inc.php'); 
	if( !isset($hostSQLEtherpad) || !isset($databaseSQLEtherpad) || !isset($userSQLEtherpad) || !isset($passSQLEtherpad) || !isset($portSQLEtherpad) ) stopErreur("Erreur de lecture confSqlEtherpad.inc.php : incomplet");

	// On sort en JSON
	// header('Content-type: application/json');

	// On récupère l'uid du propriétaire et on vérifie sa validité
	$uid = $_SESSION['login'];

	// Lecture du profil de l'utilisateur
	$profil = getProfil($host, $userSQL, $passSQL, $database, $portSQL, $admin2);

	// On récupère les paramètres de la demande par l'application
	$params = json_decode(file_get_contents("php://input"));
	
	// Ouverture d'une connexion sur la DB etherpad
	try {
		$mysqliPad = new pdo('mysql:dbname='.$databaseSQLEtherpad.';host='.$hostSQLEtherpad, $userSQLEtherpad, $passSQLEtherpad);
		$mysqliPad->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	} catch (PDOException $e) {
		stopErreur('Erreur de connexion SQL etherpad');
	}

	// Requête à la base de données
	try {
		$sql = "DELETE FROM `etherpad`.`store` WHERE `store`.`key` = :key";
		$result = $mysqliPad->prepare($sql);
		foreach ($params->pads as $key => $value) {
			$result->bindParam(':key', $value);
			$result->execute();
		}
	} catch (Exception $e) {
		stopErreur('Erreur requête SQL pads');
	}

	// On renvoie la réponse au format JSON
	echo json_encode($response, true);

	// Fonction de retour d'erreur
	function stopErreur($message)
	{	
		// Les erreurs SQL seront remontées à l'application via cette réponse JSON : voir au début de la vue : <div class="alert alert-{{msg.state}}" ng-show="msg.text" role="alert">{{msg.text}}</div>'
		$row['state'] = "danger";
		$row['text'] = $message;
		echo json_encode($row, true);
		// On sort ici
		exit;
	}
?>
