<?php
	//--> Vérifie l'authentification
	include_once('../../authCAS.php');

	//--> Configuration etherhome
	require_once('../../config.inc.php');

	//--> Scrum de sortie de la réponse
	$response = array();

	//--> On sort en JSON
	header('Content-type: application/json');

	//--> On vérifie les droits d'accès de l'utilisateur avant d'autoriser le script à s'exécuter
	if (!$scrumblrActif) stopErreur("Vous n'avez pas les droits pour executer ce script");

	// On récupère les paramètres de la demande par l'application
	$params = json_decode(file_get_contents("php://input"));
	$tabID = $params->tabID;
	
	//--> Si pas transmis, on en génère un au hasard
	if (!$tabID){
		$chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
		$string_length = 10;
		$randomstring = '';
		for ($i = 0; $i < $string_length; $i++) {
			$rnum = floor(rand(1,100)/100 * strlen($chars));
			$randomstring .= substr($chars, $rnum, 1);
		}
		$tabID = $randomstring;
	}

	//--> Récupération de l'identifiant 
	$uid = $_SESSION['login'];

	//--> Vérifications de format avant création
	if  (!(preg_match('/^[A-Za-z0-9\-\.]+$/', $uid) && preg_match('/^[A-Za-z0-9\-\_]+$/', $tabID))) stopErreur("uid ou identifiant de scrum invalide");

	//--> Ouverture d'une connexion sur la DB etherhome
	$mysqli = new mysqli($host, $userSQL, $passSQL, $database, $portSQL);
	if ($mysqli->connect_error) stopErreur("Erreur de connexion SQL : (" . $mysqli->connect_errno . ") -> " . $mysqli->connect_error);

	//--> Vérifie l'existence
	$result = $mysqli->query ("SELECT nom FROM elements WHERE nom='" . addslashes($tabID) . "' AND appli='scrumblr'");
	if ($result == false) stopErreur("Erreur requête SQL query : (" . $mysqli->errno .") -> " . $mysqli->error);
	// Il ne doit pas exister dans la base etherhome
	if ($result->num_rows==0)
	{ 
		// Préparation de la commande d'insertion
		$query = "INSERT INTO elements (uid, nom, appli) VALUES(?, ?, 'scrumblr');";
		$stmt = $mysqli->prepare($query);
		// Chargement des données
		$stmt->bind_param("ss", $v1, $v2);
		$v1 = $uid;
		$v2 = $tabID;
		// Exécute la requête
		if (!$stmt->execute())  stopErreur("Erreur requête SQL execute : (" . $mysqli->errno .") -> " . $mysqli->error);
		$stmt->close();
		// On retourne l'id de scrum si la création dans la base etherhome s'est bien passée
		$row['state'] = "success";
		$row['text'] = "Le scrum '$tabID' a été ajouté avec succès";
		$row['create'] = $tabID;
	}
	// Retourne le champs vide si il existait déjà dans la base etherhome
	else
	{ 
		$row['state'] = "warning";
		$row['text'] = "Le scrum '$tabID' existe déjà dans votre liste de scrums.";
		$row['create'] = "";
	}

	//--> Fermeture de la connexion
	$result->close();
	$mysqli->close();

	//--> Retourne le résultat
	echo json_encode($row, true);

	//--> Fonction de retour d'erreur
	function stopErreur($message)
	{	
		// Les erreurs SQL seront remontées à l'application via cette réponse JSON : voir au début de la vue : <div class="alert alert-{{msg.state}}" ng-show="msg.text" role="alert">{{msg.text}}</div>'
		$row['state'] = "danger";
		$row['text'] = $message;
		echo json_encode($row, true);
		// On sort ici
		exit;
	}

?>
