//--> Contrôleur de gestion des scrum : relatif à la page ....... (voir routage)
angular.module('scrumblr').controller("scrumblrCtrl",function($scope, $window, methodesScrumblr, $location) {
	// Remarque : le controleur est relu à chaque nouvelle arrivée sur le module

	$scope.appli = $location.path().split('/')[1];

	//--> Fonction de vérification de saisie du nom du scrum, invalidant le bouton de submit ('ng-disabled="testNomTab()"') tant que la saisie ne réponds pas à cette regex
	$scope.testNomTab = function(){
		return methodesScrumblr.verifNomTab($scope.ajout.tabID);
	};

	//--> Getter de la liste des scrums appartenant à l'utilisateur pour '<tr ng-repeat="tab in listeTabs">'
	$scope.getListTabs = function() {
		// La lecture de la liste des scrums étant asynchrone (ajax), il faut spécifier une fonction de retour (callback)
		methodesScrumblr.listTabs(function(data) {
			$scope.listeTabs = data;
		});
	};

	//--> Récupère la liste de tous les scrums dans scrumblr (quel que soit l'utilisateur)
	$scope.getListAllTabs = function(){
		// La lecture de la liste des scrums étant asynchrone (ajax), il faut spécifier une fonction de retour (callback)
		methodesScrumblr.listTabsDansScrumblr(function(data) {
			$scope.listAllTabs = data;
		});
	};

	//--> Méthode appelée pour la création d'un scrum
	$scope.addTab = function() {
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.ajTab = {};
		$scope.delTab = {};
		$scope.ajDelFavTab = {};
		// On ne peux fonctionner que si la liste de tous les scrums est bien dsponible
		if (angular.isDefined($scope.listAllTabs.erreur)) $scope.ajTab = {"state": "danger", "text": "Impossible car liste des scrums indisponible."};
		else {
			// Si le champ n'existe pas, on le créé vide
			if (angular.isUndefined($scope.ajout.tabID)) $scope.ajout = {"tabID" : ""};
			// On va déjà vérifier qu'il n'existe pas dans scrumblr si ce n'est pas vide
			var exist = false;
			if ($scope.ajout.tabID != "") {
				for (var i=0 ; i<$scope.listAllTabs.length ; i++) if ($scope.listAllTabs[i].key == $scope.ajout.tabID) exist=true;
			}
			// Si il existe, on le signale
			if (exist) { 
				$scope.ajTab = {"state": "warning", "text": "Ce scrum existe déjà dans l'application scrumblr"};
				questionAjoutFavoris();			
			}
			// Sinon, on demande la création au service de création dans la base etherhome
			else {
				// On va demander au service concerné d'ajouter le scrum dans la base etherhome et nous fournir l'id calculé (si tabID était vide)
				methodesScrumblr.createTab($scope.ajout.tabID, function(data) {
					// Récupère les données
					$scope.ajTab = data;
					// Si le scrum existe déjà pour l'utilisateur, on va demander un passage en favoris
					if ($scope.ajTab.state == "warning") questionAjoutFavoris();			
					// Si le resultat est valide, on va tout recharger
					if ($scope.ajTab.state == "success") {
						// Et on ouvre le nouveau scrum, ce qui va avoir pour effet de le créer
						$window.open('https://' + $scope.conf.scrumblrAPI + '/' + $scope.ajTab.create, '_blank');
						// ReCharger la liste des scrums de l'utilisateur dans etherhome
						$scope.getListTabs();
						// ReCharger la liste de tous les scrums dans scrumblr
						$scope.getListAllTabs();
						// Recharger la liste des favoris des scrums
						$scope.getListFavorisTabs();
						// On retourne à la page de liste
						$scope.newDiv = false;
					}
				});
			}
		}
	};

	//--> Méthode privé permettant de demander si on veut mettre le scrum en favoris en cas d'echec ajout (existe déjà dans scrumblr) ou appartient à l'utilisateur
	var questionAjoutFavoris = function () {
		// On demande confirmation d'ajout
		if (confirm("Ce scrum existe déjà, voulez-vous le mettre en favoris ?")) {
			// Nettoyer l'affichage resultat des traitements précedent :
			$scope.ajTab = {};
			$scope.delTab = {};
			$scope.ajDelFavTab = {};
			// Envoi de la requête de supression : attention, le paramètre est passé avant la fonction de callback
			methodesScrumblr.addFavorisTab('https://' + $scope.conf.scrumblrAPI + '/' + $scope.ajout.tabID, function(data) {
				$scope.ajDelFavTab = data;
				// Recharger la liste des favoris des scrums
				$scope.getListFavorisTabs();
				// On retourne à la page de liste
				$scope.newDiv = false;
			});
		}
	};

	//--> Fonction appelée par le bouton supprimer un scrum : '<button class="btn btn-danger btn-xs" ng-click="deleteTab(tab.nom);">Supprimer</button>'
	$scope.deleteTab = function(tabID) {
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.ajTab = {};
		$scope.delTab = {};
		$scope.ajDelFavTab = {};
		// Suppression sur confirmation
		var r = confirm("Êtes vous sûr de vouloir supprimer ce scrum ?");
		if (r) {
			// Envoi de la requête de supression dans l'API scrumblr qui va réaliser la suppression réelle du scrum
			methodesScrumblr.deleteTabDansScrumblr($scope.conf.scrumblrAPI, tabID, function(data, status) {
				if (status == 200) {
					// Si c'est ok, alors demander d'effacer dans la base de données interne d'etherhome
					methodesScrumblr.deleteTab(tabID, function(data) {
						$scope.delTab = data;
						// Charger la liste des scrums de l'utilisateur dans etherhome
						$scope.getListTabs();
						// Charger la liste de tous les scrums dans scrumblr
						$scope.getListAllTabs();
						// Recharger la liste des favoris des scrums
						$scope.getListFavorisTabs();
						// Recharger la liste des partages des calcs
						$scope.getListShares();
					});
				}
				// Si la suppression par l'API scrumblr échoue, on va retourner le message
				else {
					$scope.delTab = {"state": "danger", "text" : "Erreur suppression du scrum par scrumblr"};
				}
			});
		}
	};

	//--> Fonction de test pour la saisie d'un nouveau favoris invalidant le bouton submit : <button type="submit" class="btn btn-success" ng-click='addFavoriTabs()' ng-disabled="testURLFavoriTabs()">Ajouter le favori</button>
	$scope.testURLFavoriTab = function() {
		// Créer la chaine d'expression régulière afin de lui adjoindre l'adresse du serveur
		var domain = "^https:\\/\\/" + $scope.conf.scrumblrAPI.replace(/\./g, "\\.").replace(/\//g , "\\/") + "\\/[A-Za-z0-9\\-\\_]+$";
		var regexp = new RegExp(domain);
		// Test de la chaine saisie avec l'expression régulière
		return !regexp.test($scope.favoriUrl);
	};

	//--> Getter de la liste des favoris des scrums pour '<tr ng-repeat="favori in listeFavorisTabs">'
	$scope.getListFavorisTabs = function(){
		// La lecture de la liste des scrums étant asynchrone (ajax), il faut spécifier une fonction de retour (callback)
		methodesScrumblr.listFavorisTabs(function(data) { 
			$scope.listeFavorisTabs = data;
		});
	};

	//--> Fonction appelée par le bouton ajouter un favoris de scrum
	$scope.addFavoriTab = function() {
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.ajTab = {};
		$scope.delTab = {};
		$scope.ajDelFavTab = {};
		// Envoi de la requête de supression : attention, le paramètre est passé avant la fonction de callback
		methodesScrumblr.addFavorisTab($scope.favoriUrl, function(data) {
			$scope.ajDelFavTab = data;
			// Recharger la liste des favoris des scrums
			$scope.getListFavorisTabs();
		});
	};

	//--> Fonction appelée par le bouton supprimer d'un favoris de scrum
	$scope.deleteFavoriTab = function(id) {
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.ajTab = {};
		$scope.delTab = {};
		$scope.ajDelFavTab = {};
		// Suppression sur confirmation
		var r = confirm("Êtes vous sûr de vouloir supprimer ce favori ?");
		if (r) {
			// Envoi de la requête de supression : attention, le paramètre est passé avant la fonction de callback
			methodesScrumblr.deleteFavorisTab(id, function(data) {
				$scope.ajDelFavTab = data;
				// Recharger la liste des favoris
				$scope.getListFavorisTabs();
			});
		}
	};

	//--> Changement de div 
	$scope.toggleNew = function () {
		$scope.newDiv =! $scope.newDiv;
	}

	// lister les partages
	// si uid, on liste les docs partagés par l'utilisateur
	$scope.getListShares = function(uid) {
		$scope.share = {};
		$scope.shareWithOther = false;
		if(typeof uid !== 'undefined'){
			$scope.shareWithOther = true;
			$scope.uid = uid;
		}
		methodesScrumblr.listShares(uid, $scope.appli, function(data) { 
			$scope.listShares = data;
		});
	};

	// lister les utilisateurs et groupes
	// on attend la fin de la frappe pour envoyer la requête au serveur
	var timeout = null;
	var textInput = document.getElementById('shareWith');
	$scope.getUsersGroups = function() {
		clearTimeout(timeout);

		timeout = setTimeout(function () {
			// Nettoyer l'affichage resultat des traitements précedent :
			$scope.usersGroups = {};
			$scope.share = {};

			if(textInput.value !== ''){
				methodesScrumblr.getUsersGroups(textInput.value, $scope.element.lien, $scope.appli, function(data) {
					if (data.state === 'success') {
						$scope.usersGroups = data;
					}
					else {
						$scope.usersGroups = {'state': 'danger', 'message' : 'Pas d\'utilisateur ou de groupe trouvé'};
					}
				});
			}
		}, 1000);
	};

	// partager un scrum
	$scope.shareScrum = function(share, shareWith, shareType) {
		$scope.share = {};
		// Suppression sur confirmation
		methodesScrumblr.shareScrum(share, $scope.appli, shareWith, shareType, function(data) {
			$scope.share = {'state': data.state, 'text': data.text };
			$scope.getUsersGroups();
		});
	};

	// supprimer un partage
	// si cancelSahre vaut true, le propriétaire annule le partage
	$scope.deleteShare = function(share, cancelShare){
		// Nettoyer l'affichage resultat des traitements précedent :
		$scope.ajShare = {};
		$scope.delShare = {};
		$scope.ajDelShare = {};

		var title = (typeof cancelShare !== 'undefined') ? 'annuler' : 'supprimer';
		// Suppression sur confirmation
		var r = confirm('Êtes vous sûr de vouloir ' + title + ' ce partage ?');
		if (r) {
			// Envoi de la requête de supression : attention, le paramètre est passé avant la fonction de callback
			methodesScrumblr.deleteShare(share, cancelShare, function(data) {
				$scope.ajDelShare = data;
				$scope.getListTabs();
				// Recharger la liste des partages
				$scope.getListShares($scope.uid);
			});
		}
	};

	//--> Chargement au démarrage du contôleur :
	// Uniquement chargé si le module est activé
	if ($scope.conf.scrumblrActif) {
		// Gestion de l'affichage au passage de la souris pour les étapes : le handlerTab est défini dans assets/js/presentation.js
		Zepto("#tabID").focusin(Zepto.proxy(handlerTab,Zepto("div.etap-step:first-child")));
		Zepto("div.etap-step").mouseenter(handlerTab);
		Zepto("div.etap-step").mouseleave(function(){Zepto(this).removeClass("active");});

		// Déclaration du formuliaire d'ajout vide
		$scope.ajout = {};
		// div affichée par défaut
		$scope.newDiv = false;

		// Charger la liste des scrums de l'utilisateur dans etherhome
		$scope.getListTabs();
		// Charger la liste de tous les scrums dans scrumblr
		$scope.getListAllTabs();
		// Charger la liste des favoris des scrums
		$scope.getListFavorisTabs();
		// Charger la liste des scrums partagés
		$scope.getListShares();
	}
});
