var moduleEtherpad = angular.module('etherpad',['ngRoute','ngCookies']);

moduleEtherpad.config(function($routeProvider){
	$routeProvider
		.when('/',{controller:"mainCtrl",templateUrl:'templates/info.html'})
		.when('/myPads',{controller:"listPadsCtrl",templateUrl:'templates/listPads.html'})
		.otherwise({redirectTo:'/'});
});

moduleEtherpad.run(function($http, $cookies){
	$http.defaults.headers.post['X-CSRFToken'] = $cookies.csrftoken;
});

moduleEtherpad.controller("mainCtrl",function($scope){
	Zepto("#padID").focusin(Zepto.proxy(handler,Zepto("div.etap-step:first-child")));
	Zepto("div.etap-step").mouseenter(handler);
	Zepto("div.etap-step").mouseleave(function(){Zepto(this).removeClass("active");});
	$scope.testNomPad = function(){
		var regexp = /^[A-Za-z0-9\-\_]*$/;
		return !regexp.test($scope.padID);
	};
});

moduleEtherpad.controller("listPadsCtrl",function($scope,$http){
	$scope.getListPads = function(){
		$http.get("ajax/listPads.php").success(function(data,status){
			$scope.listePads=data;
		});
	};
	$scope.deletePad = function(padID){
		var r = confirm("Êtes vous sûr de vouloir supprimer ce pad ?");
		if (r){
			var params = {"padID":padID};
			$http.post("ajax/deletePad.php",params).success(function(data,status){
				$scope.msg = data;
				$scope.getListPads();
			});
		}
	};
	$scope.getListPads();

	// Gestion des favoris
	$scope.getListFavoris = function(){
		$http.get("ajax/listFavoris.php").success(function(data,status){
			$scope.listeFavoris = data;
		});
	};
	$scope.addFavori = function(){
		var params = {"favoriUrl":$scope.favoriUrl};
		$http.post("ajax/addFavori.php",params).success(function(data,status){
			$scope.msg=data;
			$scope.getListFavoris();
		});
	};
	$scope.deleteFavori = function(favoriID){
		var r = confirm("Êtes vous sûr de vouloir supprimer ce favori ?");
		if (r){
			var params = {"favoriID":favoriID};
			$http.post("ajax/deleteFavori.php",params).success(function(data,status){
				$scope.msg = data;
				$scope.getListFavoris();
			});
		}
	};
	$scope.testURLFavori = function(){
		var regexp = /^https:\/\/scribe.ac-test.fr\/etherpad\/p\/[A-Za-z0-9\-\_]+$/;
		return !regexp.test($scope.favoriUrl);
	};
	$scope.getListFavoris();
});
